/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.taggedio.TaggedReader;
import inform.agent.ClientUpdateInfo;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;

public class DownloadRenewal
extends Request {
    public static final int TAG_RENEWAL_FOLDER = 1;
    public static final int TAG_RENEWAL_VERSION = 2;
    public static final int TAG_RENEWAL_SIZE = 3;
    public static final int TAG_RENEWAL_ABSENT = 4;

    public DownloadRenewal(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        String folder = null;
        int[] mmr = new int[]{0, 0, 0};
        int versionCount = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    folder = in.getAnsi();
                    break;
                }
                case 2: {
                    if (versionCount >= mmr.length) break;
                    mmr[versionCount++] = in.getInt();
                }
            }
        }
        if (folder == null) {
            this.sendError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043f\u0430\u043f\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439", null);
            return;
        }
        VersionInfo maxVersion = new VersionInfo(mmr[0], mmr[1], mmr[2]);
        if ("dictionaries".equals(folder)) {
            VersionInfo clientVersion = this.getClientVersion();
            if (clientVersion.lessThen(new VersionInfo(5L, 2L, 1115L))) {
                return;
            }
            byte[] dictionary = ClientUpdateInfo.getDictionaryRenewal(folder, maxVersion);
            if (dictionary != null && dictionary.length > 0) {
                try (ByteArrayInputStream stream = new ByteArrayInputStream(dictionary);){
                    int chunkSize;
                    byte[] chunk = new byte[1024];
                    while ((chunkSize = stream.read(chunk)) >= 0) {
                        if (chunkSize == 0) continue;
                        this.sendChunk(chunk, chunkSize);
                    }
                }
            }
            this.sendResult();
            return;
        }
        File maxFile = ClientUpdateInfo.getMaxRenewal(folder, maxVersion);
        if (maxFile != null && maxFile.canRead()) {
            try (FileInputStream stream = new FileInputStream(maxFile);){
                int chunkSize;
                byte[] chunk = new byte[1024];
                while ((chunkSize = stream.read(chunk)) >= 0) {
                    if (chunkSize == 0) continue;
                    this.sendChunk(chunk, chunkSize);
                }
            }
        }
        this.sendResult();
    }
}

