/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.replication.ReplicationChannel;
import java.io.IOException;
import java.sql.SQLException;
import java.util.zip.DeflaterOutputStream;

public class BlobChannel
extends ReplicationChannel
implements SendReadyResponse {
    public static final int BEGIN_CHUNK = 1;
    public static final int END_CHUNK = 2;
    private double replicaId = 0.0;
    private int maxChunkSize = 0;
    private final ByteArrayOutputStream chunk = new ByteArrayOutputStream();
    private final ByteArrayOutputStream compressedChunk = new ByteArrayOutputStream();
    private SendReadyTaggedWriter out = null;
    private int chunkCount = 0;
    private long dataSize = 0L;
    private long sendedSize = 0L;
    private TableDescriptor table = null;
    private DatabaseConnection connection = null;
    private PreparedStatement statement = null;
    private FieldDescriptor fieldReplicaId = null;
    private FieldDescriptor fieldChunkCount = null;

    public BlobChannel(double id, ServerSideHost ssHost) throws InformException {
        super(id, ssHost);
    }

    @Override
    public String getName() {
        return "\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 \u0431\u043b\u043e\u0431";
    }

    @Override
    public long getReplicaSize() {
        return this.sendedSize;
    }

    @Override
    public boolean setMaxChunkSize(int value) {
        this.maxChunkSize = value;
        return true;
    }

    @Override
    public SendReadyTaggedWriter connect(double replicaId) throws InformException, IOException, SQLException {
        Core.logger.info("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 BLOB");
        this.idle();
        this.replicaId = replicaId;
        this.table = TableDescriptor.get(this.outputTableId);
        FieldDescriptor pkField = this.table.getValidRecordIdField();
        this.fieldReplicaId = this.table.getValidFieldDescriptor(this.replicaIdFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 'ID \u0440\u0435\u043f\u043b\u0438\u043a\u0438'");
        FieldDescriptor fieldChunkContent = this.table.getValidFieldDescriptor(this.chunkContentFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0427\u0430\u0441\u0442\u044c \u0440\u0435\u043f\u043b\u0438\u043a\u0438'");
        this.fieldChunkCount = this.table.getValidFieldDescriptor(this.chunkCountFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0447\u0430\u0441\u0442\u0435\u0439'");
        FieldDescriptor fieldChunkNo = this.table.getValidFieldDescriptor(this.chunkNoFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u041d\u043e\u043c\u0435\u0440 \u0447\u0430\u0441\u0442\u0438'");
        FieldDescriptor fieldFlag = this.table.getValidFieldDescriptor(this.chunkFlagFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0424\u043b\u0430\u0433 \u0447\u0430\u0441\u0442\u0438'");
        DatabaseDescriptor database = this.table.getDatabaseDescriptor();
        this.idle();
        this.connection = database.connect(this.ssHost, "BlobChanel:connect");
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("insert into ").append(this.table).append(" (").append(pkField).append(',').append(this.fieldReplicaId).append(',').append(fieldChunkNo).append(',').append(fieldChunkContent).append(',').append(fieldFlag).append(") values (?,?,?,?,?)");
        this.statement = this.connection.prepareStatement(sql.toString());
        this.out = new SendReadyTaggedWriter(this.chunk, this);
        this.idle();
        return this.out;
    }

    @Override
    public boolean isValid() {
        if (this.outputTableId == 0.0) {
            return false;
        }
        TableDescriptor tableDescriptor = null;
        try {
            tableDescriptor = TableDescriptor.getIfExists(this.outputTableId);
        }
        catch (InformException e) {
            Core.logger.error(null, e);
            return false;
        }
        if (tableDescriptor == null) {
            return false;
        }
        if (tableDescriptor.getFieldDescriptor(this.replicaIdFieldId) == null) {
            return false;
        }
        if (tableDescriptor.getFieldDescriptor(this.chunkContentFieldId) == null) {
            return false;
        }
        if (tableDescriptor.getFieldDescriptor(this.chunkCountFieldId) == null) {
            return false;
        }
        if (tableDescriptor.getFieldDescriptor(this.chunkNoFieldId) == null) {
            return false;
        }
        return tableDescriptor.getFieldDescriptor(this.chunkFlagFieldId) != null;
    }

    @Override
    protected void flush() throws Exception {
    }

    @Override
    protected void finish() throws Exception {
        this.notifyReadyToSend();
    }

    @Override
    protected void rollback(ReplicationChannel.Readme readme, byte[] info, int infoSize) throws InformException, IOException, SQLException {
        this.idle();
    }

    @Override
    protected void commit() throws InformException, IOException, SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ready(ReplicationChannel.Readme readme, byte[] info, int infoSize) throws InformException, IOException, SQLException {
        this.idle();
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("update ").append(this.table).append(" set ").append(this.fieldChunkCount).append("=? where ").append(this.fieldReplicaId).append("=?");
        try (PreparedStatement update = this.connection.prepareStatement(sql.toString());){
            this.idle();
            update.setInt(1, this.chunkCount);
            update.setDouble(2, this.replicaId);
            update.executeUpdate(this.ssContext);
            this.idle();
        }
        this.connection.commit();
        this.idle();
    }

    @Override
    public int getOperationCode() {
        return 5;
    }

    @Override
    protected int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    public void close() {
        this.idle();
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.idle();
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.idle();
    }

    @Override
    public boolean getWriteInfo(ReplicationChannel.WriteInfo info) {
        if (info.chunkCount == this.chunkCount) {
            return false;
        }
        info.chunkCount = this.chunkCount;
        info.dataSize = this.dataSize;
        info.sendedSize = this.sendedSize;
        return true;
    }

    @Override
    public long getTransferSize() {
        if (this.out != null) {
            return this.dataSize + this.out.getInputSize();
        }
        return this.dataSize;
    }

    @Override
    public void notifyReadyToSend() throws Exception {
        this.idle();
        if (this.out == null) {
            return;
        }
        if (this.out.getInputSize() == 0L) {
            return;
        }
        this.out.flush();
        if (this.chunk.size() == 0) {
            return;
        }
        this.dataSize += this.out.getInputSize();
        this.writeChunk();
        this.chunk.reset();
        this.out.reset(this.chunk);
        this.idle();
    }

    private void executeInsert(byte[] blob, int offset, int blobSize, int flag) throws InformException, SQLException {
        this.sendedSize += (long)blobSize;
        Core.logger.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0447\u0430\u0441\u0442\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438(\u043d\u043e\u043c\u0435\u0440 {}, \u0440\u0430\u0437\u043c\u0435\u0440 {}, \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e {})", this.chunkCount, blobSize, this.sendedSize);
        this.statement.setDouble(1, Core.generateId());
        this.statement.setDouble(2, this.replicaId);
        this.statement.setInt(3, this.chunkCount);
        byte[] blobData = new byte[blobSize];
        System.arraycopy(blob, offset, blobData, 0, blobSize);
        this.statement.setBlob(4, blobData);
        this.statement.setInt(5, flag);
        this.statement.executeUpdate(this.ssContext);
    }

    private void writeChunk() throws InformException, SQLException, IOException {
        this.idle();
        this.compressedChunk.reset();
        DeflaterOutputStream compressor = new DeflaterOutputStream(this.compressedChunk);
        compressor.write(this.chunk.internalBuffer(), 0, this.chunk.size());
        compressor.close();
        ByteArrayOutputStream buffer = this.compressedChunk;
        if (this.maxChunkSize > 1 && this.maxChunkSize < buffer.size()) {
            int size = buffer.size();
            int count = size / this.maxChunkSize;
            int rest = size % this.maxChunkSize;
            if (rest != 0) {
                ++count;
            }
            int lastNo = count - 1;
            int offset = 0;
            byte[] blob = buffer.internalBuffer();
            for (int i = 0; i < count; ++i) {
                int s = this.maxChunkSize;
                if (s > size) {
                    s = size;
                }
                int flag = 0;
                if (i == 0) {
                    flag |= 1;
                }
                if (i == lastNo) {
                    flag |= 2;
                }
                ++this.chunkCount;
                this.executeInsert(blob, offset, s, flag);
                offset += s;
                size -= s;
            }
        } else {
            ++this.chunkCount;
            this.executeInsert(buffer.internalBuffer(), 0, buffer.size(), 3);
        }
        this.idle();
    }
}

