/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.exchange.ExchangeNode;
import inform.agent.exchange.ExchangeSettings;
import inform.agent.exchange.ImportNodesTree;
import inform.agent.exchange.PexImportProcess;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.replication.ReceivingTable;
import inform.agent.replication.ReplicationApplyEngine;
import inform.agent.replication.ReplicationException;
import inform.agent.replication.ScriptReplica;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.SSContext;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptReplicationsPack
extends SmartScriptableObject {
    public final SSContext ssContext;
    private final ServerSideHost ssHost;

    public ScriptReplicationsPack(Scriptable scope, ServerSideHost ssHost) {
        this.setParentScope(scope);
        this.ssHost = ssHost;
        this.ssContext = null;
    }

    @SmartScriptableObject.FunctionTag
    public ScriptReplica createReplica() {
        return new ScriptReplica(this, this.ssHost, this.ssContext);
    }

    private boolean isValidPex(ZipFile zFile) {
        ZipEntry pexInfoEntry = zFile.getEntry(".PexInfo");
        ZipEntry treeFoldersEntry = zFile.getEntry(".TreeFolders");
        return pexInfoEntry != null && treeFoldersEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadPexResult loadPexInternal(String pexPath, File pexFile, long pexSize, LoadPexParams params) throws Throwable {
        if (pexPath.isEmpty()) {
            throw new InformException("\u041d\u0435\u0442 \u0444\u0430\u0439\u043b\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 pex.");
        }
        double exportID = 0.0;
        double auditRecordID = 0.0;
        String warnings = "";
        try (ZipFile zFile = null;){
            zFile = new ZipFile(pexPath, Charset.forName("CP866"));
            if (!this.isValidPex(zFile)) {
                throw new InformException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 pex.");
            }
            ExchangeSettings settings = new ExchangeSettings();
            if (params.skipConflictNodes) {
                settings.jsSkipConflictNodes = true;
            }
            if (params.detailedAudit) {
                settings.dataAuditAction = ExchangeSettings.DataAuditType.datAudit;
                settings.detailedAudit = true;
            }
            ImportNodesTree importBuilder = new ImportNodesTree(settings);
            importBuilder.loadNodesFromPex(zFile, this.ssHost);
            settings.logAndCheckSettings();
            PexImportProcess process = new PexImportProcess(this.ssContext, this.ssHost, importBuilder, settings, 0.0);
            process.beforeExecute(zFile, pexFile != null ? pexPath : "", params.mark);
            process.doExecute(zFile, pexSize);
            exportID = process.getExportID();
            auditRecordID = process.getAuditRecordId();
            warnings = process.getWarnings();
        }
        return new LoadPexResult(exportID, auditRecordID, warnings);
    }

    @SmartScriptableObject.FunctionTag
    public LoadPexResult loadPex(Object arg1, Object arg2) throws IOException, Throwable {
        LoadPexResult result = null;
        if (arg1 == null) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c null-\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        LoadPexParams params = new LoadPexParams();
        if (arg1 instanceof BinaryObject) {
            BinaryObject binObj = (BinaryObject)arg1;
            File file = File.createTempFile("pex", "temp");
            String path = file.getPath();
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(binObj.toByteArray());
            fos.flush();
            fos.close();
            if (arg2 instanceof String || arg2 instanceof ConsString) {
                params.mark = arg2.toString();
            } else if (arg2 instanceof ScriptableObject) {
                params = this.loadPexParseOptions((ScriptableObject)arg2);
            }
            result = this.loadPexInternal(path, null, binObj.getSize(), params);
            file.delete();
        } else if (arg1 instanceof String || arg1 instanceof ConsString) {
            String filePath = Core.mountfs.resolvePath(arg1.toString());
            if (filePath.isEmpty()) {
                throw new InformException("\u041f\u0443\u0441\u0442\u043e\u0439 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c.");
            }
            File file = new File(filePath);
            if (arg2 instanceof ScriptableObject) {
                params = this.loadPexParseOptions((ScriptableObject)arg2);
            }
            params.mark = null;
            result = this.loadPexInternal(filePath, file, file.length(), params);
        }
        return result;
    }

    private LoadPexParams loadPexParseOptions(ScriptableObject options) {
        Object param;
        LoadPexParams params = new LoadPexParams();
        if (options.has("auditNameFile", null) && ((param = options.get("auditNameFile", null)) instanceof String || param instanceof ConsString)) {
            params.mark = param.toString();
        }
        if (options.has("skipConflictNodes", null) && ((Boolean)(param = options.get("skipConflictNodes", null))).booleanValue()) {
            params.skipConflictNodes = true;
        }
        if (options.has("detailedAudit", null) && ((Boolean)(param = options.get("detailedAudit", null))).booleanValue()) {
            params.detailedAudit = true;
        }
        return params;
    }

    private void collectPexNodes(ExchangeNode node, ArrayList<String> list) {
        if (node == null || node.nodeRecord() == null) {
            return;
        }
        list.add(NumberConverter.doubleToString(node.nodeRecord().getId()));
        for (int i = 0; i < node.children().size(); ++i) {
            this.collectPexNodes((ExchangeNode)node.children().get(i), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decomposePexIntoNodesInternal(String pexPath, ArrayList<String> list) throws Throwable {
        if (pexPath.isEmpty()) {
            throw new InformException("\u041d\u0435\u0442 \u0444\u0430\u0439\u043b\u0430 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 pex.");
        }
        try (ZipFile zFile = null;){
            zFile = new ZipFile(pexPath, Charset.forName("CP866"));
            if (!this.isValidPex(zFile)) {
                throw new InformException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 pex.");
            }
            ExchangeSettings settings = new ExchangeSettings();
            ImportNodesTree importBuilder = new ImportNodesTree(settings);
            importBuilder.loadNodesFromPex(zFile, this.ssHost);
            for (int i = 0; i < importBuilder.rootNodes().size(); ++i) {
                this.collectPexNodes((ExchangeNode)importBuilder.rootNodes().get(i), list);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object decomposePexIntoNodes(Object arg1) throws IOException, Throwable {
        if (arg1 == null) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c null-\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (arg1 instanceof BinaryObject) {
            BinaryObject binObj = (BinaryObject)arg1;
            File file = File.createTempFile("pex", "temp");
            String path = file.getPath();
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(binObj.toByteArray());
            fos.flush();
            fos.close();
            this.decomposePexIntoNodesInternal(path, list);
            file.delete();
        } else if (arg1 instanceof String || arg1 instanceof ConsString) {
            String filePath = Core.mountfs.resolvePath(arg1.toString());
            if (filePath.isEmpty()) {
                throw new InformException("\u041f\u0443\u0441\u0442\u043e\u0439 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c.");
            }
            this.decomposePexIntoNodesInternal(filePath, list);
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public void loadReplicationFile(String fileName) throws IOException, TaggedReaderException, SQLException {
        if (Ini.ReadonlyMode) {
            throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
        }
        String filePath = Core.mountfs.resolvePath(fileName);
        String msg = "\u0424\u0430\u0439\u043b '" + fileName + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u043e\u043c \u0440\u0435\u043f\u043b\u0438\u043a\u0438";
        double receivingId = 0.0;
        int chunkCount = 0;
        long replicaSize = 0L;
        String nodeMessage = null;
        File file = new File(filePath);
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry(".info");
            if (entry == null) {
                throw new InformException(msg);
            }
            try {
                InputStream inputStream = zip.getInputStream(entry);
                TaggedReader in = new TaggedReader(inputStream);
                while (in.next()) {
                    switch (in.getCurrentTag()) {
                        case 1: {
                            receivingId = in.getDouble();
                            break;
                        }
                        case 8: {
                            chunkCount = in.getInt();
                        }
                    }
                    if (receivingId == 0.0 || chunkCount == 0) continue;
                    break;
                }
            }
            catch (Throwable ex) {
                throw InformException.wrap(ex, msg);
            }
            ReceivingTable receivingTable = new ReceivingTable();
            Object receivingTitle = "";
            SqlParameter[] receivingFields = receivingTable.select(this.ssContext, receivingId);
            if (receivingFields != null) {
                SqlParameter field = receivingFields[1];
                if (field != null) {
                    receivingTitle = field.getString();
                }
                if (Strings.isVoid((String)receivingTitle)) {
                    receivingTitle = "[" + NumberConverter.doubleToString(receivingId) + "]";
                }
            } else {
                Node receiving = MtdEngine.getNode(receivingId);
                if (receiving == null || receiving.getType() != 23) {
                    MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", receivingId);
                }
                receivingTitle = receiving.getName();
            }
            nodeMessage = "[" + NumberConverter.doubleToString(receivingId) + "] " + (String)receivingTitle;
            long startTime = System.currentTimeMillis();
            Core.logger.info("--- \u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)nodeMessage);
            try (ReplicationApplyEngine applier = new ReplicationApplyEngine(this.ssContext, receivingId, this.ssHost, null);){
                for (int no = 1; no <= chunkCount; ++no) {
                    String entryName = "replica." + no;
                    entry = zip.getEntry(entryName);
                    if (entry == null) {
                        throw new InformException(msg);
                    }
                    InputStream input = zip.getInputStream(entry);
                    InflaterInputStream compression = new InflaterInputStream(input);
                    applier.process(new TaggedReader(compression));
                }
                applier.finalizeReplica(file.length(), file.getName());
                Core.logger.info("--- \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {} replicaId: {}", (Object)nodeMessage, (Object)NumberConverter.doubleToString(applier.getReplicaId()));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)(System.currentTimeMillis() - startTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446 {}", (Object)(applier.metadataTime - applier.startTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u043e\u0432 {}", (Object)(applier.dataTime - applier.metadataTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 {}", (Object)(applier.endTime - applier.dataTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)(applier.endTime - applier.startTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmartScriptableObject.FunctionTag
    public boolean loadReplicaFromTable(double replicaId, double receivingId) throws InformException, IOException, TaggedReaderException, SQLException {
        Node receiving = MtdEngine.getNode(receivingId);
        if (receiving == null || receiving.getType() != 23) {
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", receivingId);
        }
        byte[] receivingContent = receiving.getRealNode().getContent();
        Object nodeMessage = "[" + NumberConverter.doubleToString(receivingId) + "] " + receiving.getName();
        long startTime = System.currentTimeMillis();
        TaggedReader reader = new TaggedReader(receivingContent);
        double outputTableId = 0.0;
        int replicaIdFieldId = 0;
        int chunkNoFieldId = 0;
        int chunkCountFieldId = 0;
        int chunkContentFieldId = 0;
        int chunkFlagId = 0;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 31: {
                    TaggedReader in = reader.getSubStreamReader();
                    while (in.next()) {
                        switch (in.getCurrentTag()) {
                            case 1: {
                                outputTableId = in.getNodeID();
                                break;
                            }
                            case 2: {
                                replicaIdFieldId = in.getFieldID();
                                break;
                            }
                            case 3: {
                                chunkNoFieldId = in.getFieldID();
                                break;
                            }
                            case 4: {
                                chunkCountFieldId = in.getFieldID();
                                break;
                            }
                            case 5: {
                                chunkContentFieldId = in.getFieldID();
                                break;
                            }
                            case 6: {
                                chunkFlagId = in.getFieldID();
                            }
                        }
                    }
                    break;
                }
            }
        }
        TableDescriptor table = TableDescriptor.get(outputTableId);
        FieldDescriptor fieldReplicaId = table.getValidFieldDescriptor(replicaIdFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 'ID \u0440\u0435\u043f\u043b\u0438\u043a\u0438'");
        FieldDescriptor fieldChunkContent = table.getValidFieldDescriptor(chunkContentFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0427\u0430\u0441\u0442\u044c \u0440\u0435\u043f\u043b\u0438\u043a\u0438'");
        FieldDescriptor fieldChunkCount = table.getValidFieldDescriptor(chunkCountFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0447\u0430\u0441\u0442\u0435\u0439'");
        FieldDescriptor fieldChunkNo = table.getValidFieldDescriptor(chunkNoFieldId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u041d\u043e\u043c\u0435\u0440 \u0447\u0430\u0441\u0442\u0438'");
        FieldDescriptor fieldFlag = table.getValidFieldDescriptor(chunkFlagId, "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 '\u0424\u043b\u0430\u0433 \u0447\u0430\u0441\u0442\u0438'");
        DatabaseDescriptor database = table.getDatabaseDescriptor();
        try (DatabaseConnection connection = database.connect(this.ssHost, "ScriptReplicationsPack::loadReplicaFromTable");){
            int chunkCount = 0;
            SqlStringBuilder countSql = new SqlStringBuilder();
            countSql.append("select count(*) from ").append(table).append(" where ").append(fieldReplicaId).append("=?");
            try (PreparedStatement countStatement = connection.prepareStatement(countSql.toString());){
                countStatement.setDouble(1, replicaId);
                try (ResultSet resultSet = countStatement.executeQuery(this.ssContext);){
                    if (resultSet.next()) {
                        chunkCount = resultSet.getInt(1);
                    }
                }
            }
            if (chunkCount == 0) {
                boolean resultSet = false;
                return resultSet;
            }
            SqlStringBuilder sql = new SqlStringBuilder();
            sql.append("select T.").append(fieldChunkNo).append(",T.").append(fieldChunkCount).append(" from ").append(table).append(" T where T.").append(fieldReplicaId).append("=?").append(" order by T.").append(fieldChunkNo);
            try (PreparedStatement checkStatement = connection.prepareStatement(sql.toString());){
                checkStatement.setDouble(1, replicaId);
                try (ResultSet resultSet = checkStatement.executeQuery(this.ssContext);){
                    int no;
                    int chunkNo = 0;
                    while (resultSet.next()) {
                        boolean bl;
                        no = resultSet.getInt(1);
                        if (resultSet.wasNull()) {
                            bl = false;
                            return bl;
                        }
                        if (no != ++chunkNo) {
                            bl = false;
                            return bl;
                        }
                        int loadedCount = resultSet.getInt(2);
                        if (resultSet.wasNull()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        if (chunkCount == loadedCount) continue;
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (chunkNo != chunkCount) {
                        no = 0;
                        return no != 0;
                    }
                }
            }
            long replicaSize = 0L;
            Core.logger.info("--- \u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", nodeMessage);
            try (ReplicationApplyEngine applier = new ReplicationApplyEngine(this.ssContext, receivingId, this.ssHost, null);){
                sql = new SqlStringBuilder();
                sql.append("select T.").append(fieldFlag).append(", T.").append(fieldChunkContent).append(" from ").append(table).append(" T where ").append(fieldReplicaId).append("=?").append(" order by ").append(fieldChunkNo);
                try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
                    statement.setDouble(1, replicaId);
                    try (ResultSet resultSet = statement.executeQuery(this.ssContext);){
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        while (resultSet.next()) {
                            int flag = resultSet.getInt(1);
                            if ((flag & 3) == 3) {
                                BlobStream input = resultSet.getBlobStream(2);
                                replicaSize += input.length();
                                InflaterInputStream compression = new InflaterInputStream(input);
                                applier.process(new TaggedReader(compression));
                                continue;
                            }
                            if ((flag & 1) != 0 && out.size() != 0) {
                                throw new ReplicationException("\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0431\u0435\u0437 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439").detail((String)nodeMessage);
                            }
                            byte[] bytes = resultSet.getBlobBytes(2);
                            if (bytes != null) {
                                replicaSize += (long)bytes.length;
                            }
                            out.write(bytes);
                            if ((flag & 2) == 0) continue;
                            out.flush();
                            ByteArrayInputStream in = new ByteArrayInputStream(out.internalBuffer(), 0, out.size());
                            out.reset();
                            InflaterInputStream compression = new InflaterInputStream(in);
                            applier.process(new TaggedReader(compression));
                        }
                        if (out.size() != 0) {
                            throw new ReplicationException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e\u0449\u0430\u044f \u0447\u0430\u0441\u0442\u044c \u0440\u0435\u043f\u043b\u0438\u043a\u0438").detail((String)nodeMessage);
                        }
                    }
                }
                applier.finalizeReplica(replicaSize, null);
                Core.logger.info("--- \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {} replicaId: {}", nodeMessage, (Object)NumberConverter.doubleToString(applier.getReplicaId()));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)(System.currentTimeMillis() - startTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446 {}", (Object)(applier.metadataTime - applier.startTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u043e\u0432 {}", (Object)(applier.dataTime - applier.metadataTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 {}", (Object)(applier.endTime - applier.dataTime));
                Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)(applier.endTime - applier.startTime));
            }
        }
        return true;
    }

    @SmartScriptableObject.FunctionTag
    public void revokePex(double replicaId) throws SQLException, IOException, InformException, InterruptedException {
        MetadataNodeReader.revokeReplica(this.ssContext, replicaId, this.ssHost.getNodeID(), this.ssHost.getSessionID());
    }

    @Override
    public String getClassName() {
        return "Replications";
    }

    public class LoadPexResult
    extends SmartScriptableObject {
        private double _replicaID;
        private double _auditRecordID;
        private String _warnings;

        public LoadPexResult(double replicaID, double auditRecordID, String warnings) {
            this._replicaID = replicaID;
            this._auditRecordID = auditRecordID;
            this._warnings = warnings;
        }

        @Override
        public String getClassName() {
            return "LoadPexResult";
        }

        public String toString() {
            return this.getClassName();
        }

        @SmartScriptableObject.PropertyTag
        public double getReplicaID() {
            return this._replicaID;
        }

        @SmartScriptableObject.PropertyTag
        public double getLogRecordID() {
            return this._auditRecordID;
        }

        @SmartScriptableObject.PropertyTag
        public String getWarnings() {
            return this._warnings;
        }
    }

    private class LoadPexParams {
        public String mark = null;
        public boolean skipConflictNodes = false;
        public boolean detailedAudit = false;

        private LoadPexParams() {
        }
    }
}

