/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.sched.Sched;
import java.io.IOException;

public class GetSchedInfoRequest
extends Request {
    private static final int TAG_SCHED_INFO_GET_JOB_STATE = 1;
    private static final int TAG_SCHED_INFO_GET_JOB_PLAN_FOR_COUNT = 4;
    private static final int TAG_SCHED_INFO_GET_JOB_RUN = 5;
    private static final int TAG_SCHED_INFO_GET_JOB_STOP = 6;
    static final int TAG_SCHED_INFO_JOB = 1;
    static final int TAG_SCHED_INFO_JOB_DISABLED = 1;
    static final int JOB_DISABLED_BLOCKED = 1;
    static final int JOB_DISABLED_SETUP = 2;
    static final int JOB_DISABLED_DENIED = 3;
    static final int TAG_SCHED_INFO_RUN_STATE = 2;
    static final int TAG_SCHED_INFO_JOB_RUN_TIME = 3;
    static final int TAG_SCHED_INFO_JOB_RUN_DURATION = 4;
    static final int TAG_SCHED_INFO_LAST_RUN_STATE = 5;
    static final int TAG_SCHED_INFO_JOB_PLAN_RUN_TIME = 6;
    static final int TAG_SCHED_INFO_JOB_WILLNOT_RUN = 7;
    static final int TAG_SCHED_INFO_JOB_RUN_NODE_ID = 8;
    private TaggedWriter out;

    public GetSchedInfoRequest(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    private void sendJobState(double nodeId, boolean force) throws IOException {
        if (nodeId == 0.0) {
            DoubleList jobs = new DoubleList(1);
            Sched.enumJobs(jobs);
            for (Cursor.Double c : jobs) {
                this.sendJobState(c.value, false);
            }
            return;
        }
        ByteArrayOutputStream stateContent = new ByteArrayOutputStream();
        TaggedWriter state = new TaggedWriter(stateContent);
        Sched.getInfo(this.ssContext, nodeId, state, force);
        state.flush();
        this.out.putDouble(1, nodeId);
        if (stateContent.size() == 0) {
            this.out.putEmpty(202);
        } else {
            this.out.putRaw(202, stateContent);
        }
    }

    private void sendSchedPlan(int count) throws IOException {
        double nodeId = this.getNodeID();
        ByteArrayOutputStream planContent = new ByteArrayOutputStream();
        TaggedWriter plan = new TaggedWriter(planContent);
        Sched.getPlan(nodeId, count, 3, plan);
        plan.flush();
        if (planContent.size() == 0) {
            return;
        }
        this.out.putDouble(1, nodeId);
        this.out.putRaw(202, planContent);
    }

    @Override
    public void execute() throws Throwable {
        double nodeId = this.getNodeID();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        this.out = new TaggedWriter(outContent);
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.sendJobState(nodeId, true);
                    break;
                }
                case 4: {
                    this.sendSchedPlan(reader.getInt());
                    break;
                }
                case 5: {
                    if (nodeId == 0.0) break;
                    Sched.explicitRun(nodeId);
                    break;
                }
                case 6: {
                    if (nodeId == 0.0) break;
                    Sched.explicitStop(nodeId);
                }
            }
        }
        this.out.flush();
        this.sendResult(outContent.internalBuffer(), outContent.size());
    }
}

