/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.DateTime;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.PhaThread;
import inform.agent.am.Telemeter;
import inform.agent.sched.Job;
import java.io.IOException;
import java.util.concurrent.Future;
import org.mozilla.javascript.Undefined;

public class JobLauncher
implements DoubleHash.Entry,
Runnable {
    public final int id = Telemeter.genId();
    private final double nodeId;
    private volatile Job job;
    private volatile Job runningJob;
    private volatile boolean isExplicit = false;
    private long runtime;
    private final Object futureMutex = new Object();
    private Future<?> future = null;
    private Thread thread;
    private int pulse;
    private boolean cancelThrowed;
    private int runCount = 0;

    public JobLauncher(double nodeId, long runtime, Job job) {
        this.nodeId = nodeId;
        this.job = job;
        this.runningJob = null;
        this.runtime = runtime;
    }

    public synchronized void setExplicit() {
        this.isExplicit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> getFuture() {
        Object object = this.futureMutex;
        synchronized (object) {
            return this.future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFuture(Future<?> future) {
        Object object = this.futureMutex;
        synchronized (object) {
            this.future = future;
            this.futureMutex.notifyAll();
        }
    }

    protected synchronized boolean canRun(long currentTime) {
        return this.runningJob == null && this.job != null && this.job.canRun(currentTime, this.runtime);
    }

    public synchronized boolean needRun() {
        if (this.isExplicit) {
            return this.runningJob == null && this.job != null && this.job.canExplicitRun();
        }
        return this.runningJob == null && this.job != null && this.job.needRun(this.runtime);
    }

    public synchronized boolean isObsolete(double contentTime, double attributeTime) {
        return this.job.isObsolete(contentTime, attributeTime);
    }

    public synchronized boolean isImportantTask() {
        return this.runningJob != null && this.runningJob.isImportantTask();
    }

    public synchronized void setJob(Job job) {
        this.job = job;
        this.isExplicit = false;
    }

    public synchronized boolean isRunning() {
        return this.runningJob != null;
    }

    private synchronized boolean beforeRun() {
        if (this.runningJob != null) {
            return false;
        }
        if (!this.needRun()) {
            return false;
        }
        this.runningJob = this.job;
        ++this.runCount;
        this.notifyAll();
        return this.runningJob != null;
    }

    private synchronized void afterRun() {
        this.runningJob = null;
        this.isExplicit = false;
        this.setFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.beforeRun()) {
            return;
        }
        try {
            assert (this.runningJob != null);
            Object object = this.futureMutex;
            synchronized (object) {
                while (this.future == null) {
                    this.futureMutex.wait();
                }
            }
            this.thread = Thread.currentThread();
            this.runningJob.run(this);
            this.runtime = System.currentTimeMillis();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.thread = null;
            this.afterRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRun(long timeout) throws InterruptedException {
        Object object = this.futureMutex;
        synchronized (object) {
            if (this.future != null) {
                this.futureMutex.wait(timeout);
            }
            return this.future == null;
        }
    }

    public synchronized boolean waitStart() throws InterruptedException {
        while (this.runCount == 0) {
            this.wait();
        }
        return this.runCount != 0;
    }

    @Override
    public double key() {
        return this.nodeId;
    }

    synchronized Job.RunInfo getJobRunInfo() {
        if (this.runningJob == null) {
            return null;
        }
        try {
            return this.runningJob.getRunInfo();
        }
        catch (IOException ex) {
            Core.logger.error(null, ex);
            return null;
        }
    }

    synchronized Job.RunInfo getJobLastRunInfo() {
        return this.job.getLastRunInfo();
    }

    synchronized double getRunNodeId() {
        return this.job.getRunNodeId();
    }

    synchronized void getSchedPlan(long runtime, int count, int tag, TaggedWriter out, boolean force) throws IOException {
        if (this.job == null) {
            return;
        }
        this.job.getSchedPlan(runtime, count, tag, out, force);
    }

    synchronized boolean isEnabled() {
        return this.job.isEnabled();
    }

    synchronized boolean isPlanned() {
        return this.job.getNextRunPlan(this.runtime) != 0.0;
    }

    public synchronized boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    public synchronized String lastError() {
        return this.job != null ? this.job.lastError : null;
    }

    public synchronized Object lastResult() {
        return this.job != null ? this.job.lastResult : Undefined.instance;
    }

    public synchronized Object lastScriptRequestState() {
        return this.job != null ? this.job.lastScriptRequestState : Undefined.instance;
    }

    public synchronized void idle() {
        if (!this.cancelThrowed) {
            if (this.isCancelled()) {
                this.cancelThrowed = true;
                throw new CancelRequestException();
            }
            ++this.pulse;
        }
    }

    void getStateLog(StringBuilder log) {
        if (this.job == null) {
            return;
        }
        log.append("\r\n* ").append(this.job.getLogInfo());
        if (!this.job.canRun(0L, System.currentTimeMillis())) {
            log.append(", cannot run(");
            this.job.getCannotRunLog(log);
            log.append(')');
            return;
        }
        if (this.isRunning()) {
            log.append(", running");
        } else {
            log.append(", stopped");
        }
        double nextRun = this.job.getNextRunPlan(this.runtime);
        if (nextRun == 0.0) {
            log.append(", unrunnable in future");
        } else {
            log.append(", will be run at ").append(DateTime.toString(nextRun));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gatherTelemetry(Telemeter.Gatherer gatherer) throws IOException {
        Job.RunInfo ri = this.getJobRunInfo();
        if (ri == null) {
            return;
        }
        if (ri.lastHangCallstackTime == 0L) {
            ri.lastHangCallstackTime = ri.runtime;
        }
        long time = gatherer.time();
        long duration = time - ri.runtime;
        Thread t = this.thread;
        if (t != null && time - ri.lastHangCallstackTime > 300000L) {
            StringBuilder tmp = new StringBuilder();
            PhaThread.dumpStackTrace(tmp, t);
            Core.logger.warn("Long job (id:{},time:{}) {}", this.id, duration, tmp);
            ri.lastHangCallstackTime = time;
        }
        gatherer.job(this.id, duration, this.pulse, this.isImportantTask(), this.future == null ? "PENDING" : "RUNNING", this.thread);
        if (this.runningJob != null && this.runningJob.isTimeoutExceed()) {
            Object object = this.futureMutex;
            synchronized (object) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
            }
        }
    }
}

