/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.DBLogin;
import inform.agent.db.PersonalSessionHelper;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.agent.sched.Job;
import inform.agent.sched.JobLauncher;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.mozilla.javascript.Scriptable;

public class JobSSSHost
implements ServerSideHost,
ScriptableHost,
LogContext {
    private final Security security;
    private Scriptable topLevelScope;
    private ByteArrayOutputStream requestState;
    private TaggedWriter requestStateWriter;
    private long runtime;
    private Constants constants = null;
    private final ArrayList<DBLogin> dbLogins;
    private final JobLauncher launcher;
    private final Job job;
    private ConnectionManager[] personalSessions = PersonalSessionHelper.init();
    private RequestStateTask currentRequestStateTask = new RequestStateTask(null);
    private final SSContext.JobContext ssContext;
    RequestStatistics.Value rqstat;
    private long hostId = Core.newHostID();

    public JobSSSHost(Security security, JobLauncher launcher, Job job) {
        this.launcher = launcher;
        this.security = security;
        this.job = job;
        this.requestState = new ByteArrayOutputStream();
        this.requestStateWriter = new TaggedWriter(this.requestState);
        this.runtime = System.currentTimeMillis();
        ArrayList<DBLogin> dbLogins = security.getDbLogins();
        if (dbLogins == null || dbLogins.isEmpty()) {
            this.dbLogins = null;
        } else {
            this.dbLogins = new ArrayList(dbLogins.size());
            for (DBLogin dbl : dbLogins) {
                this.dbLogins.add(new DBLogin(dbl));
            }
        }
        this.ssContext = new SSContext.JobContext(this);
    }

    @Override
    public String toLogString() {
        return "job(nodeId: " + NumberConverter.doubleToString(this.job.nodeId) + ")";
    }

    @Override
    public long getHostID() {
        return this.hostId;
    }

    @Override
    public double getUserID() {
        return this.security.id;
    }

    @Override
    public int getTimeZoneOffset() {
        return DateTime.serverZoneOffset();
    }

    @Override
    public double getEffectiveUserID() {
        return this.security.id;
    }

    @Override
    public void idle() {
        if (this.launcher != null) {
            this.launcher.idle();
        }
        if (this.job != null) {
            this.job.checkTimeout();
        }
    }

    @Override
    public synchronized void putRequestStateCaption(String caption) throws IOException {
        this.currentRequestStateTask.caption = caption;
    }

    @Override
    public synchronized void putRequestStateText(String msg) throws IOException {
        this.currentRequestStateTask.text = msg;
    }

    @Override
    public void putRequestStateResultText(String text) throws IOException {
    }

    @Override
    public synchronized void putRequestStateInstruction(String message) throws IOException {
        this.currentRequestStateTask.instruction = message;
    }

    @Override
    public synchronized void putRequestStateProgressMin(int min) throws IOException {
        this.currentRequestStateTask.progressMin = min;
    }

    @Override
    public synchronized void putRequestStateProgressMax(int max) throws IOException {
        this.currentRequestStateTask.progressMax = max;
    }

    @Override
    public synchronized void putRequestStateProgressPosition(int pos) throws IOException {
        this.currentRequestStateTask.progressPosition = pos;
    }

    @Override
    public synchronized void putRequestStateProgressVisible(boolean isVisible) throws IOException {
        this.currentRequestStateTask.progressVisible = isVisible;
    }

    @Override
    public synchronized void putRequestStateLog(String msg) throws IOException {
        this.requestStateWriter.putAnsi(3, msg);
    }

    @Override
    public synchronized void putRequestStateEnter() throws Exception {
        this.currentRequestStateTask = new RequestStateTask(this.currentRequestStateTask);
    }

    @Override
    public synchronized void putRequestStateLeave() throws Exception {
        this.currentRequestStateTask = this.currentRequestStateTask.previous == null ? new RequestStateTask(null) : this.currentRequestStateTask.previous;
    }

    @Override
    public synchronized void writeLog(String msg) throws IOException {
        this.requestStateWriter.putAnsi(9, msg);
    }

    @Override
    public synchronized void writeLogLine(String msg) throws IOException {
        this.requestStateWriter.putAnsi(10, msg);
    }

    @Override
    public void setTopLevelScope(Scriptable topLevelScope) {
        this.topLevelScope = topLevelScope;
    }

    @Override
    public Scriptable getTopLevelScope() {
        return this.topLevelScope;
    }

    @Override
    public Constants getConstants() {
        return this.constants;
    }

    @Override
    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    @Override
    public SSContext getRootContext() {
        return this.ssContext;
    }

    @Override
    public boolean isCancelled() {
        if (this.launcher != null) {
            return this.launcher.isCancelled();
        }
        return false;
    }

    @Override
    public String getCancelReason() {
        return null;
    }

    @Override
    public void sendTraceLabel(SSContext context, String text) {
    }

    public long getRuntime() {
        return this.runtime;
    }

    synchronized byte[] getRequestStateContent() throws IOException {
        this.requestStateWriter.flush();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(this.requestState.internalBuffer(), 0, this.requestState.size());
        TaggedWriter writer = new TaggedWriter(result);
        JobSSSHost.writeRequestStateTasks_R(this.currentRequestStateTask, writer);
        return result.toByteArray();
    }

    private static void writeRequestStateTasks_R(RequestStateTask task, TaggedWriter writer) throws IOException {
        if (task.previous != null) {
            JobSSSHost.writeRequestStateTasks_R(task.previous, writer);
            writer.putEmpty(11);
        }
        if (task.caption != null) {
            writer.putAnsi(1, task.caption);
        }
        if (task.instruction != null) {
            writer.putAnsi(8, task.instruction);
        }
        if (task.text != null) {
            writer.putAnsi(2, task.text);
        }
        if (task.progressVisible) {
            writer.putBool(7, true);
        }
        if (task.progressMin != Integer.MIN_VALUE) {
            writer.putInt32(4, task.progressMin);
        }
        if (task.progressMax != Integer.MIN_VALUE) {
            writer.putInt32(5, task.progressMax);
        }
        if (task.progressPosition != Integer.MIN_VALUE) {
            writer.putInt32(6, task.progressPosition);
        }
    }

    @Override
    public VersionInfo getClientVersion() {
        return null;
    }

    @Override
    public double getNodeID() {
        if (this.launcher != null) {
            return this.launcher.key();
        }
        return 0.0;
    }

    @Override
    public DatabaseDescriptor getDBLogin(DatabaseDescriptor db) throws SQLException {
        if (this.dbLogins == null) {
            return null;
        }
        for (DBLogin dbl : this.dbLogins) {
            if (dbl.getDatabaseId() != db.getNodeId()) continue;
            return dbl.adjust(db);
        }
        return null;
    }

    public void close() {
        PersonalSessionHelper.closeAll(this, this.personalSessions);
        if (this.dbLogins != null) {
            for (DBLogin dbl : this.dbLogins) {
                try {
                    dbl.close();
                }
                catch (SQLException ex) {
                    Core.logger.error(null, ex);
                }
            }
        }
    }

    public double getLoginRecordID() {
        return 0.0;
    }

    @Override
    public double getSessionID() {
        return 0.0;
    }

    @Override
    public void sendResult() throws Exception {
    }

    @Override
    public Client client() {
        return null;
    }

    @Override
    public Security security() {
        return this.security;
    }

    @Override
    public void appendToLog(String msg) throws Exception {
    }

    @Override
    public RequestStatistics.Value rqstat() {
        return this.rqstat;
    }

    @Override
    public SSContext getSSContext() {
        return this.ssContext;
    }

    @Override
    public void rqstat(RequestStatistics.Value value) {
        this.rqstat = value;
    }

    @Override
    public void contextMessage(LogContext.Builder out) {
        this.job.contextMessage(out);
    }

    @Override
    public void personalSessionCreated(ConnectionManager ps) {
        this.personalSessions = PersonalSessionHelper.add(this.personalSessions, ps);
    }

    @Override
    public void personalSessionClosed(ConnectionManager ps) {
        PersonalSessionHelper.remove(this.personalSessions, ps);
    }

    @Override
    public void standing(long time) {
    }

    private static class RequestStateTask {
        final RequestStateTask previous;
        String caption;
        String instruction;
        String text;
        boolean progressVisible;
        int progressMin;
        int progressMax;
        int progressPosition;

        RequestStateTask(RequestStateTask previous) {
            this.previous = previous;
        }
    }
}

