/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.schemes.ModificationCommand;
import inform.agent.schemes.NoSuchObjectException;
import inform.agent.schemes.ObjectChangedException;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeObject;
import java.util.Date;

class DeleteObjectCommand
extends ModificationCommand {
    DeleteObjectCommand() {
    }

    @Override
    public void run(Scheme scheme, Request request) throws NoSuchObjectException, ObjectChangedException, InformException {
        SchemeObject so = this.getLockedObject();
        assert (so != null);
        so.setDeleted(true);
        Core.logger.debug("Changing {} position, unlink", so.toString());
        so.setRevision(this.getSessionSchemeRevision());
        so.setLastModTime(DateTime.fromUnixTime(new Date().getTime()));
        so.setLastModUser(request.getUserID());
    }

    @Override
    boolean isModificationAllowed(Scheme scheme) {
        boolean allowed;
        SchemeObject so = this.getLockedObject();
        boolean bl = allowed = so != null;
        if (!allowed) {
            Core.logger.debug("Denial reason: object doesn't exist");
            return false;
        }
        boolean bl2 = allowed = allowed && so.getRevision() == this.getSubjectDescriptor().getRevision();
        if (!allowed) {
            Core.logger.debug("Denial reason: revisions mismatch, server {}, client {}", so.getRevision(), this.getSubjectDescriptor().getRevision());
        }
        return allowed;
    }
}

