/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.agent.schemes.Paragraph;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.Table;
import inform.agent.schemes.TableCell;
import inform.agent.schemes.TransformProps;
import inform.agent.scripts.spreadsheets.excel.ExcelWorkbookSheetCells;
import inform.agent.scripts.textutils.TextExtractor;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOleSize;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;

public class ExcelParser {
    private final double MAGIG_FONT_KOEF = 0.017746913580246913;
    private final double MAGIG_INDENT_KOEF = 333.3333333333333;
    private final SchemeEngine engine;

    public ExcelParser(SchemeEngine engine) {
        this.engine = engine;
    }

    public Table convertToTable(byte[] content, double sizeX, double sizeY) throws Exception {
        if (content == null || content.length == 0) {
            return null;
        }
        TextExtractor.DOCUMENT_FORMAT format = this.determineFormat(content);
        if (format == null) {
            return null;
        }
        switch (format) {
            case DOCUMENT_XLS: {
                try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                    Table table = this.constructTable((Workbook)new HSSFWorkbook((InputStream)is), sizeX, sizeY);
                    return table;
                }
            }
            case DOCUMENT_XLSX: {
                try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                    Table table = this.constructTable((Workbook)new XSSFWorkbook((InputStream)is), sizeX, sizeY);
                    return table;
                }
            }
        }
        return null;
    }

    private Table constructTable(Workbook book, double sizeX, double sizeY) throws Exception {
        if (book == null) {
            return null;
        }
        int activeSheetIndex = book.getActiveSheetIndex();
        if (activeSheetIndex >= 0 && activeSheetIndex < book.getNumberOfSheets()) {
            Sheet sheet = book.getSheetAt(activeSheetIndex);
            Table table = this.constructTable(book, sheet, sizeX, sizeY);
            return table;
        }
        return null;
    }

    private Table constructTable(Workbook book, Sheet sheet, double sizeX, double sizeY) {
        int i;
        int cnt;
        if (sheet == null) {
            return null;
        }
        Table table = new Table();
        table.Engine = this.engine;
        RangeCells usedCells = this.detectOleCells(book);
        if (usedCells == null) {
            usedCells = this.detectUsedCells(sheet);
        }
        if (usedCells == null) {
            return null;
        }
        double size = 0.0;
        for (int j = usedCells.firctColumn; j <= usedCells.lastColumn; ++j) {
            double v = sheet.getColumnWidth(j);
            table.widths.add(v);
            size += v;
        }
        double scaleX = 1.0;
        if (size > 0.0 && sizeX > 0.0) {
            scaleX = sizeX / size;
            cnt = table.widths.size();
            for (i = 0; i < cnt; ++i) {
                table.widths.set(i, scaleX * table.widths.get(i));
            }
        }
        for (i = usedCells.firstRow; i <= usedCells.lastRow; ++i) {
            ArrayList<TableCell> cells = new ArrayList<TableCell>();
            table.rows.add(cells);
            Row row = sheet.getRow(i);
            for (int j = usedCells.firctColumn; j <= usedCells.lastColumn; ++j) {
                TableCell cell = this.constructTableCell(book, sheet, i, j, scaleX);
                assert (cell != null);
                cells.add(cell);
            }
            table.heights.add(row == null ? (double)sheet.getDefaultRowHeight() : (double)row.getHeight());
        }
        size = 0.0;
        cnt = table.heights.size();
        for (i = 0; i < cnt; ++i) {
            size += table.heights.get(i);
        }
        if (size > 0.0 && sizeY > 0.0) {
            double scaleY = sizeY / size;
            int cnt2 = table.heights.size();
            for (int i2 = 0; i2 < cnt2; ++i2) {
                table.heights.set(i2, scaleY * table.heights.get(i2));
            }
        }
        return table;
    }

    private TableCell constructTableCell(Workbook book, Sheet sheet, int rowIndex, int colIndex, double scaleX) {
        CellStyle style;
        assert (sheet != null);
        Row row = sheet.getRow(rowIndex);
        String text = null;
        RichTextString rich = null;
        if (row != null) {
            Cell cell = row.getCell(colIndex);
            if (cell != null) {
                style = cell.getCellStyle();
                CellType type = cell.getCellType();
                block0 : switch (type) {
                    case NUMERIC: {
                        text = String.valueOf(cell.getNumericCellValue());
                        break;
                    }
                    case BOOLEAN: {
                        text = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case FORMULA: {
                        FormulaEvaluator evaluator = book.getCreationHelper().createFormulaEvaluator();
                        CellValue value = evaluator.evaluate(cell);
                        CellType type2 = value.getCellType();
                        switch (type2) {
                            case BOOLEAN: {
                                text = String.valueOf(value.getBooleanValue());
                                break block0;
                            }
                            case NUMERIC: {
                                text = String.valueOf(value.getNumberValue());
                                break block0;
                            }
                        }
                        text = value.getStringValue();
                        break;
                    }
                    default: {
                        text = cell.getStringCellValue();
                        rich = cell.getRichStringCellValue();
                        break;
                    }
                }
            } else {
                CellStyle columnStyle = sheet.getColumnStyle(colIndex);
                CellStyle rowStyle = row.getRowStyle();
                style = columnStyle == null ? rowStyle : (rowStyle == null ? columnStyle : (columnStyle.getIndex() < rowStyle.getIndex() ? rowStyle : columnStyle));
            }
        } else {
            style = sheet.getColumnStyle(colIndex);
        }
        TableCell result = this.constructTableCell(book, style, text, rich, scaleX);
        List mergedRegions = sheet.getMergedRegions();
        if (mergedRegions != null && !mergedRegions.isEmpty()) {
            for (CellRangeAddress r : mergedRegions) {
                if (r.getFirstRow() != rowIndex || r.getFirstColumn() != colIndex) continue;
                result.rowSpan = r.getLastRow() - rowIndex + 1;
                result.colSpan = r.getLastColumn() - colIndex + 1;
            }
        }
        return result;
    }

    private TableCell constructTableCell(Workbook book, CellStyle style, String text, RichTextString rich, double scaleX) {
        TableCell result = new TableCell();
        result.Engine = this.engine;
        result.Lines = new Paragraph.Lines();
        result.Lines.Engine = this.engine;
        result.BrushPattern = 0;
        if (style != null) {
            HorizontalAlignment align;
            Font font = book.getFontAt(style.getFontIndex());
            if (font != null) {
                result.Lines.FontName = font.getFontName();
                result.lfHeight = (double)font.getFontHeight() * 0.017746913580246913;
                result.Lines.FontStyle = this.getFontStyle(font);
            }
            if ((align = style.getAlignment()) == HorizontalAlignment.LEFT) {
                result.LeftMargin = scaleX * (double)style.getIndention() * 333.3333333333333;
            } else if (align == HorizontalAlignment.RIGHT) {
                result.RightMargin = scaleX * (double)style.getIndention() * 333.3333333333333;
            }
            result.Align = this.convertHorizontalAlignment(align);
            result.VertAlign = this.convertVerticalAlignment(style.getVerticalAlignment());
            short angle = style.getRotation();
            if (angle != 0) {
                if (result.TransProps == null) {
                    result.TransProps = new TransformProps();
                }
                result.TransProps.Angle = angle > 90 ? (double)(angle - 90) : (double)(-angle);
                if (result.TransProps.Angle < 0.0) {
                    result.TransProps.Angle += 360.0;
                }
            }
            Color fgColor = null;
            Color bgColor = null;
            Color fontColor = null;
            int fillPattern = -1;
            if (style instanceof XSSFCellStyle) {
                XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
                assert (font instanceof XSSFFont);
                XSSFFont xssfFont = (XSSFFont)font;
                fontColor = this.convertColor(xssfFont.getXSSFColor());
                fgColor = this.convertColor(xssfStyle.getFillForegroundColorColor());
                bgColor = this.convertColor(xssfStyle.getFillBackgroundColorColor());
                fillPattern = this.convertFillPattern(xssfStyle.getFillPattern());
            } else if (style instanceof HSSFCellStyle) {
                HSSFCellStyle hssfStyle = (HSSFCellStyle)style;
                assert (font instanceof HSSFFont);
                HSSFFont hssfFont = (HSSFFont)font;
                assert (book instanceof HSSFWorkbook);
                fontColor = this.convertColor(hssfFont.getHSSFColor((HSSFWorkbook)book));
                fgColor = this.convertColor(hssfStyle.getFillForegroundColorColor());
                bgColor = this.convertColor(hssfStyle.getFillBackgroundColorColor());
                if (hssfStyle.getFillBackgroundColor() >= 64 && Color.BLACK.equals(bgColor)) {
                    bgColor = null;
                }
                fillPattern = this.convertFillPattern(hssfStyle.getFillPattern());
            }
            result.Lines.FontColor = fontColor;
            result.BrushPattern = fillPattern;
            if (fgColor == null && fillPattern > 1) {
                result.bColor = bgColor == null ? Color.BLACK : bgColor;
                result.BkColor = Color.WHITE;
            } else {
                result.bColor = fgColor;
                Color color = result.BkColor = bgColor == null ? Color.WHITE : bgColor;
            }
        }
        if (text != null) {
            int richCount = 0;
            String richText = null;
            if (rich != null) {
                richCount = rich.numFormattingRuns();
                richText = rich.getString();
            }
            if (richCount > 0 && richText != null) {
                XSSFFont font;
                String textRun;
                RectTextLine curLine = new RectTextLine();
                curLine.Text = "";
                result.Lines.clear();
                result.Lines.add(curLine);
                if (rich instanceof XSSFRichTextString) {
                    XSSFRichTextString xssfRich = (XSSFRichTextString)rich;
                    for (int i = 0; i < richCount; ++i) {
                        int lenRun;
                        int idxRun = rich.getIndexOfFormattingRun(i);
                        textRun = richText.substring(idxRun, idxRun + (lenRun = xssfRich.getLengthOfFormattingRun(i)));
                        if (textRun == null) continue;
                        font = xssfRich.getFontAtIndex(idxRun);
                        String fontName = font.getFontName();
                        double fontHeight = (double)font.getFontHeight() * 0.017746913580246913;
                        byte fontStyle = this.getFontStyle((Font)font);
                        Color fontColor = this.convertColor(font.getXSSFColor());
                        String[] strArr = (String[])textRun.lines().toArray(String[]::new);
                        for (int j = 0; j < strArr.length; ++j) {
                            if (j > 0) {
                                curLine = new RectTextLine();
                                curLine.Text = "";
                                result.Lines.add(curLine);
                            }
                            RectTextLine.PartTextLine partLine = new RectTextLine.PartTextLine();
                            assert (curLine != null);
                            assert (curLine.Parts != null);
                            curLine.Parts.add(partLine);
                            partLine.fontBgColor = result.bColor;
                            partLine.fontColor = fontColor;
                            partLine.fontName = fontName;
                            partLine.fontStyle = fontStyle;
                            partLine.fontHeight = fontHeight;
                            partLine.text = strArr[j];
                            curLine.Text = curLine.Text + partLine.text;
                        }
                    }
                } else if (rich instanceof HSSFRichTextString) {
                    int idxNextRun;
                    int idxRun;
                    String textRun2;
                    HSSFRichTextString hssfRich = (HSSFRichTextString)rich;
                    if (rich.getIndexOfFormattingRun(0) > 0 && (textRun2 = richText.substring(idxRun = 0, idxNextRun = rich.getIndexOfFormattingRun(0))) != null) {
                        assert (book instanceof HSSFWorkbook);
                        HSSFWorkbook hssfBook = (HSSFWorkbook)book;
                        font = hssfBook.getFontAt((int)hssfRich.getFontAtIndex(idxRun - 1));
                        String fontName = font.getFontName();
                        double fontHeight = (double)font.getFontHeight() * 0.017746913580246913;
                        byte fontStyle = this.getFontStyle((Font)font);
                        Color fontColor = this.convertColor(font.getHSSFColor(hssfBook));
                        String[] strArr = (String[])textRun2.lines().toArray(String[]::new);
                        for (int j = 0; j < strArr.length; ++j) {
                            if (j > 0) {
                                curLine = new RectTextLine();
                                curLine.Text = "";
                                result.Lines.add(curLine);
                            }
                            RectTextLine.PartTextLine partLine = new RectTextLine.PartTextLine();
                            assert (curLine != null);
                            assert (curLine.Parts != null);
                            curLine.Parts.add(partLine);
                            partLine.fontColor = fontColor;
                            partLine.fontName = fontName;
                            partLine.fontStyle = fontStyle;
                            partLine.fontHeight = fontHeight;
                            partLine.text = strArr[j];
                            curLine.Text = curLine.Text + partLine.text;
                        }
                    }
                    for (int i = 0; i < richCount; ++i) {
                        int idxNextRun2;
                        int idxRun2 = rich.getIndexOfFormattingRun(i);
                        textRun = richText.substring(idxRun2, idxNextRun2 = i + 1 < richCount ? rich.getIndexOfFormattingRun(i + 1) : text.length());
                        if (textRun == null) continue;
                        assert (book instanceof HSSFWorkbook);
                        HSSFWorkbook hssfBook = (HSSFWorkbook)book;
                        HSSFFont font2 = hssfBook.getFontAt((int)hssfRich.getFontAtIndex(idxRun2));
                        String fontName = font2.getFontName();
                        double fontHeight = (double)font2.getFontHeight() * 0.017746913580246913;
                        byte fontStyle = this.getFontStyle((Font)font2);
                        Color fontColor = this.convertColor(font2.getHSSFColor(hssfBook));
                        String[] strArr = (String[])textRun.lines().toArray(String[]::new);
                        for (int j = 0; j < strArr.length; ++j) {
                            if (j > 0) {
                                curLine = new RectTextLine();
                                curLine.Text = "";
                                result.Lines.add(curLine);
                            }
                            RectTextLine.PartTextLine partLine = new RectTextLine.PartTextLine();
                            assert (curLine != null);
                            assert (curLine.Parts != null);
                            curLine.Parts.add(partLine);
                            partLine.fontColor = fontColor;
                            partLine.fontName = fontName;
                            partLine.fontStyle = fontStyle;
                            partLine.fontHeight = fontHeight;
                            partLine.text = strArr[j];
                            curLine.Text = curLine.Text + partLine.text;
                        }
                    }
                }
            } else {
                String[] strArr = (String[])text.lines().toArray(String[]::new);
                if (strArr.length > 1) {
                    result.Lines.clear();
                    for (String s : strArr) {
                        RectTextLine curLine = new RectTextLine();
                        result.Lines.add(curLine);
                        curLine.Text = s;
                    }
                } else {
                    result.setText(text);
                }
            }
        }
        return result;
    }

    private byte getFontStyle(Font font) {
        byte style = 0;
        if (font != null) {
            if (font.getBold()) {
                style = (byte)(style | 1);
            }
            if (font.getItalic()) {
                style = (byte)(style | 2);
            }
            if (font.getUnderline() > 0) {
                style = (byte)(style | 4);
            }
            if (font.getStrikeout()) {
                style = (byte)(style | 8);
            }
        }
        return style;
    }

    byte convertHorizontalAlignment(HorizontalAlignment value) {
        int res = 2;
        if (value != null) {
            switch (value) {
                case GENERAL: 
                case LEFT: {
                    res = 0;
                    break;
                }
                case RIGHT: {
                    res = 1;
                    break;
                }
                case JUSTIFY: {
                    res = 3;
                    break;
                }
            }
        }
        return (byte)res;
    }

    int convertVerticalAlignment(VerticalAlignment value) {
        int res = 2;
        if (value != null) {
            switch (value) {
                case TOP: {
                    res = 0;
                    break;
                }
                case BOTTOM: {
                    res = 1;
                    break;
                }
            }
        }
        return res;
    }

    private TextExtractor.DOCUMENT_FORMAT determineFormat(byte[] content) throws Exception {
        TextExtractor textExtractor = new TextExtractor(content);
        return textExtractor.getFormat();
    }

    private RangeCells detectOleCells(Workbook book) {
        if (book instanceof XSSFWorkbook) {
            CTWorkbook ctWorkbook = ((XSSFWorkbook)book).getCTWorkbook();
            if (ctWorkbook == null) {
                return null;
            }
            CTOleSize oleSize = ctWorkbook.getOleSize();
            if (oleSize == null) {
                return null;
            }
            String oleRef = oleSize.getRef();
            if (oleRef == null) {
                return null;
            }
            String[] refs = oleRef.split(":");
            if (refs == null || refs.length != 2) {
                return null;
            }
            ToIntFunction<String> FindStartNumber = s -> {
                if (s == null) {
                    return 0;
                }
                int idx = 0;
                for (char ch : s.toCharArray()) {
                    if (ch >= '0' && ch <= '9') break;
                    ++idx;
                }
                return idx;
            };
            int idx0 = FindStartNumber.applyAsInt(refs[0]);
            if (idx0 == 0 || refs[0] == null || idx0 >= refs[0].length()) {
                return null;
            }
            int idx1 = FindStartNumber.applyAsInt(refs[1]);
            if (idx1 == 0 || refs[1] == null || idx1 >= refs[1].length()) {
                return null;
            }
            RangeCells result = new RangeCells();
            result.firctColumn = ExcelWorkbookSheetCells.columnNameToIndex(refs[0].substring(0, idx0));
            result.firstRow = Integer.parseInt(refs[0].substring(idx0)) - 1;
            result.lastColumn = ExcelWorkbookSheetCells.columnNameToIndex(refs[1].substring(0, idx1));
            result.lastRow = Integer.parseInt(refs[1].substring(idx1)) - 1;
            return result;
        }
        return null;
    }

    private RangeCells detectUsedCells(Sheet sheet) {
        RangeCells result = new RangeCells();
        result.firstRow = sheet.getFirstRowNum();
        result.lastRow = sheet.getLastRowNum();
        Row r0 = sheet.getRow(result.firstRow);
        if (r0 != null) {
            result.firctColumn = r0.getFirstCellNum();
            result.lastColumn = r0.getLastCellNum();
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                short lastCellNum;
                Row row = (Row)rowIterator.next();
                short firstCellNum = row.getFirstCellNum();
                if (firstCellNum >= 0 && firstCellNum < result.firctColumn) {
                    result.firctColumn = firstCellNum;
                }
                if ((lastCellNum = row.getLastCellNum()) <= result.lastColumn) continue;
                result.lastColumn = lastCellNum;
            }
            --result.lastColumn;
        } else {
            result.firctColumn = 0;
            result.lastColumn = 0;
        }
        return result;
    }

    private Color convertColor(XSSFColor color) {
        if (color == null) {
            return null;
        }
        byte[] rgb = color.getRGB();
        if (rgb != null && rgb.length == 3) {
            return new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
        }
        return null;
    }

    private Color convertColor(HSSFColor color) {
        if (color == null) {
            return null;
        }
        short[] rgb = color.getTriplet();
        if (rgb != null && rgb.length == 3) {
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        return null;
    }

    private int convertFillPattern(FillPatternType type) {
        int res = 0;
        if (type != null) {
            switch (type) {
                case NO_FILL: {
                    res = 2;
                    break;
                }
                case SOLID_FOREGROUND: {
                    res = 1;
                    break;
                }
                case ALT_BARS: {
                    res = 10;
                    break;
                }
                case FINE_DOTS: {
                    res = 12;
                    break;
                }
                case SPARSE_DOTS: {
                    res = 13;
                    break;
                }
                case LESS_DOTS: {
                    res = 14;
                    break;
                }
                case LEAST_DOTS: {
                    res = 15;
                    break;
                }
                case THICK_HORZ_BANDS: {
                    res = 19;
                    break;
                }
                case THICK_VERT_BANDS: {
                    res = 24;
                    break;
                }
                case THICK_BACKWARD_DIAG: {
                    res = 34;
                    break;
                }
                case THICK_FORWARD_DIAG: {
                    res = 29;
                    break;
                }
                case BIG_SPOTS: {
                    res = 43;
                    break;
                }
                case BRICKS: {
                    res = 42;
                    break;
                }
                case THIN_HORZ_BANDS: {
                    res = 20;
                    break;
                }
                case THIN_VERT_BANDS: {
                    res = 25;
                    break;
                }
                case THIN_BACKWARD_DIAG: {
                    res = 35;
                    break;
                }
                case THIN_FORWARD_DIAG: {
                    res = 30;
                    break;
                }
                case SQUARES: {
                    res = 38;
                    break;
                }
                case DIAMONDS: {
                    res = 44;
                    break;
                }
            }
        }
        int result = --res;
        if (res >= 2 && res <= 7) {
            result = 9 - res;
        }
        if (res >= 68 && res < 76) {
            result = 10000 + res - 67;
        }
        if (res >= 76 && res <= 85) {
            result = 10010 + res - 75;
        }
        return result;
    }

    private static class RangeCells {
        int firstRow = -1;
        int lastRow = -1;
        int firctColumn = -1;
        int lastColumn = -1;

        private RangeCells() {
        }
    }
}

