/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TransformProps;
import inform.agent.schemes.VsdxReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;

public class Paragraph
extends Rectangle {
    public static String DEFAULT_FONTNAME = "Times New Roman";
    public static final int TAG_LINE_SPACING = 1;
    public static final int TAG_EXPORT_SIDE_X = 2;
    public static final int TAG_EXPORT_SIDE_Y = 3;
    public static final int TAG_TAB_STOP_POSITION = 4;
    public static final int TAG_LEFT_MARGIN = 5;
    public static final int TAG_RIGHT_MARGIN = 6;
    public static final int TAG_TOP_MARGIN = 7;
    public static final int TAG_BOTTOM_MARGIN = 8;
    public static final int TAG_TRANSPARENT_TEXT = 9;
    public static final int TAG_EXTRA_LINES_PRGPH_LINE_SPACING = 44;
    public static final int TAG_EXTRA_LINES_PRGPH_LEFT_INDENT = 45;
    public static final int TAG_EXTRA_LINES_PRGPH_RIGHT_INDENT = 46;
    public static final int TAG_EXTRA_LINES_PRGPH_FIRST_INDENT = 47;
    public static final int TAG_EXTRA_LINES_PRGPH_SPACE_BEFORE = 48;
    public static final int TAG_EXTRA_LINES_PRGPH_SPACE_AFTER = 49;
    public static final int TAG_EXTRA_LINES_PRGPH_ALIGN = 50;
    public static final int TAG_EXTRA_LINES_P_FONT_BG_COLOR = 51;
    public static final int TAG_EXTRA_LINES_P_SSSCRIPT = 52;
    public static final int TAG_EXTRA_LINES_P_TEXT = 53;
    public static final int TAG_EXTRA_LINES_P_FONT_NAME = 56;
    public static final int TAG_EXTRA_LINES_P_FONT_SIZE = 57;
    public static final int TAG_EXTRA_LINES_P_FONT_COLOR = 58;
    public static final int TAG_EXTRA_LINES_P_FONT_STYLE = 59;
    public static final int TAG_EXTRA_LINES_P_SIDES = 61;
    public byte Align = 0;
    public int VertAlign = 0;
    public double lfHeight = 0.0;
    public double WidthScale = 1.0;
    public boolean ShowBackground = false;
    public boolean AutoSize = true;
    public boolean AutoSizeWithAlign = true;
    public double LineSpacing = 1.0;
    public int TransparentText = 0;
    public double TabStopPosition = 15.0;
    public double LeftMargin;
    public double RightMargin;
    public double TopMargin;
    public double BottomMargin;
    public double exportSidesX = 0.0;
    public double exportSidesY = 0.0;
    public Lines Lines = null;
    public Color fontBgColor = null;
    public boolean isFontBgColorSetted = false;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);
    public static final double DEF_TAB_STOP_POSITION = 15.0;

    public boolean isPart() {
        if (this.Lines == null || this.Lines.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.Lines.size(); ++i) {
            RectTextLine line = (RectTextLine)this.Lines.get(i);
            if (line == null) continue;
            for (int j = 0; j < line.Parts.size(); ++j) {
                RectTextLine.PartTextLine part = line.Parts.get(j);
                if (part == null || Strings.isVoid(part.text)) continue;
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this.getText(null);
    }

    public String getText(String dlm) {
        if (this.Lines == null || this.Lines.isEmpty()) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.Lines.size(); ++i) {
            RectTextLine line;
            if (i > 0 && dlm != null) {
                buff.append(dlm);
            }
            if ((line = (RectTextLine)this.Lines.get(i)) == null) continue;
            buff.append(line.Text);
        }
        return buff.toString();
    }

    public void setText(String value) {
        if (this.Lines == null) {
            this.Lines = new Lines();
        }
        if (this.Lines.isEmpty()) {
            this.Lines.add(new RectTextLine());
        }
        if (this.Lines.size() == 1) {
            ((RectTextLine)this.Lines.get((int)0)).Text = value == null ? "" : value;
            this.Lines.applyFontToLines();
            this.freshSides();
        } else {
            this.setMText(value);
        }
    }

    private void setMText(String value) {
        Predicate<String> CheckEmpty = str -> {
            if (str != null) {
                char[] chars = str.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] == ';') continue;
                    return false;
                }
            }
            return true;
        };
        if (!CheckEmpty.test(value)) {
            if (this.Lines == null) {
                this.Lines = new Lines();
            } else {
                this.Lines.clear();
            }
            StringTokenizer st = new StringTokenizer(value, ";");
            while (st.hasMoreTokens()) {
                this.Lines.addLine(st.nextToken());
            }
            this.Lines.applyFontToLines();
            this.freshSides();
        }
    }

    public Font getFont() {
        return this.Lines == null || this.Engine == null ? null : this.Engine.getActualFont(this.Lines.FontName, this.Lines.FontStyle, this.Lines.FontColor, this.lfHeight, this.WidthScale);
    }

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        Paragraph shape = (Paragraph)Dest;
        shape.Align = this.Align;
        shape.lfHeight = this.lfHeight;
        shape.WidthScale = this.WidthScale;
        shape.ShowBackground = this.ShowBackground;
        shape.AutoSize = this.AutoSize;
        int ccount = this.Lines == null ? 0 : this.Lines.size();
        RectTextLine Child = null;
        RectTextLine tmpBG = null;
        shape.Lines = null;
        for (int i = 0; i < ccount; ++i) {
            Child = (RectTextLine)this.Lines.get(i);
            if (Child == null || (tmpBG = new RectTextLine()) == null) continue;
            Child.assign(tmpBG);
            if (shape.Lines == null) {
                shape.Lines = new Lines();
            }
            shape.Lines.add(tmpBG);
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        int tmpInt = 0;
        BaseGraphic tmpBG = null;
        byte[] tmpBytes = null;
        TaggedReader StreamReader = null;
        TaggedReader StreamReader1 = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 63: {
                    this.Align = reader.getByte();
                    break;
                }
                case 68: {
                    this.lfHeight = reader.getDouble();
                    break;
                }
                case 112: {
                    this.WidthScale = reader.getDouble();
                    break;
                }
                case 69: {
                    this.ShowBackground = reader.getBoolean();
                    break;
                }
                case 70: {
                    int idx = 0;
                    if (this.Lines == null) {
                        this.Lines = new Lines();
                    }
                    int count = this.Lines.size();
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 1: {
                                StreamReader1 = StreamReader.getStreamReader();
                                if (StreamReader1 == null) break;
                                while (StreamReader1.getNextTag() != 0) {
                                    switch (StreamReader1.getCurrentTag()) {
                                        case 2: {
                                            tmpBytes = StreamReader1.getRaw();
                                            tmpInt = LittleEndian.getInt(tmpBytes, 0);
                                            if (tmpInt != 222) break;
                                            if (idx > count - 1) {
                                                this.Lines.add(new RectTextLine());
                                                ++count;
                                            }
                                            if ((tmpBG = (BaseGraphic)this.Lines.get(idx)) != null) {
                                                ((RectTextLine)tmpBG).parentParagraph = this;
                                                tmpBG.parse(Parser2, StreamReader1);
                                            }
                                            ++idx;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
                case 143: {
                    this.AutoSize = false;
                    break;
                }
                case 144: {
                    this.VertAlign = reader.getInt();
                    break;
                }
                case 62: {
                    this.readTaggedSideses(reader);
                    break;
                }
                case 71: {
                    this.readTaggedLinesBounds(Parser2, reader);
                }
            }
        }
    }

    protected synchronized void readTaggedSideses(TaggedReader reader) throws IOException {
        if (this.Lines == null) {
            this.Lines = new Lines();
        }
        int count = this.Lines.size();
        int idx = 0;
        TaggedReader r = reader.getStreamReader();
        if (r == null) {
            return;
        }
        while (r.getNextTag() != 0) {
            switch (r.getCurrentTag()) {
                case 61: {
                    if (idx > count - 1) {
                        this.Lines.add(new RectTextLine());
                        ++count;
                    }
                    double[] data = LittleEndian.toDoubleArray(r.getRaw());
                    assert (data.length == 2);
                    ((Rectangle)this.Lines.get((int)idx)).SideX = data[0];
                    ((Rectangle)this.Lines.get((int)idx)).SideY = data[1];
                    ++idx;
                }
            }
        }
    }

    protected synchronized void readTaggedLinesBounds(SchemeParser parser, TaggedReader reader) throws IOException {
        if (this.Lines == null || this.Lines.isEmpty()) {
            return;
        }
        int count = this.Lines.size();
        int idx = 0;
        TaggedReader reader2 = reader.getStreamReader();
        if (reader2 != null) {
            while (reader2.getNextTag() != 0) {
                switch (reader2.getCurrentTag()) {
                    case 72: {
                        double[] tmpDArr = LittleEndian.toDoubleArray(reader2.getRaw());
                        if (tmpDArr == null) {
                            return;
                        }
                        ((Rectangle)this.Lines.get((int)idx)).Left = tmpDArr[0];
                        ((Rectangle)this.Lines.get((int)idx)).Top = tmpDArr[1];
                        ((Rectangle)this.Lines.get((int)idx)).Right = tmpDArr[2];
                        ((Rectangle)this.Lines.get((int)idx)).Bottom = tmpDArr[3];
                        if (++idx < count) break;
                        return;
                    }
                }
            }
        }
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        switch (tag) {
            case 8: {
                this.AutoSizeWithAlign = reader.getBoolean();
                break;
            }
            case 9: {
                TaggedReader subReader = reader.getStreamReader();
                if (subReader == null) break;
                while (subReader.getNextTag() != 0) {
                    switch (subReader.getCurrentTag()) {
                        case 2: {
                            this.exportSidesX = subReader.getDouble();
                            break;
                        }
                        case 3: {
                            this.exportSidesY = subReader.getDouble();
                            break;
                        }
                        case 1: {
                            this.LineSpacing = subReader.getDouble();
                            break;
                        }
                        case 4: {
                            this.TabStopPosition = subReader.getDouble();
                            break;
                        }
                        case 5: {
                            this.LeftMargin = subReader.getDouble();
                            break;
                        }
                        case 6: {
                            this.RightMargin = subReader.getDouble();
                            break;
                        }
                        case 7: {
                            this.TopMargin = subReader.getDouble();
                            break;
                        }
                        case 8: {
                            this.BottomMargin = subReader.getDouble();
                            break;
                        }
                        case 9: {
                            this.TransparentText = Byte.toUnsignedInt(subReader.getByte());
                        }
                    }
                }
                break;
            }
            default: {
                super.readExtraTagged(parser, reader, tag);
            }
        }
    }

    @Override
    protected void paint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (Engine2.tmpLayer == null || Engine2.tmpLayer.getConfigVisible(Engine2.getLayersConfig()) && Engine2.tmpLayer.ShowTexts) {
            super.paint(g2d, Engine2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (this.ShowBackground) {
            super.actualPaint(g2d, Engine2);
        }
        if (this.Lines != null) {
            Font font = null;
            double lfh = this.lfHeight;
            double x = 0.0;
            double y = 0.0;
            double mx = 0.0;
            double my = 0.0;
            int ccount = this.Lines.size();
            RectTextLine Child = null;
            for (int i = 0; i < ccount; ++i) {
                AffineTransform OldGTM;
                Child = (RectTextLine)this.Lines.get(i);
                if (Child == null) continue;
                if (i == 0 && lfh <= 0.0) {
                    lfh = 0.75 * Child.SideY;
                }
                if (font == null) {
                    font = Engine2.getActualFont(Child.FontName, Child.FontStyle, Child.FontColor, lfh, this.WidthScale);
                    g2d.setFont(font);
                }
                if (i == 0) {
                    FontMetrics fm = g2d.getFontMetrics(font);
                    int h = fm.getHeight();
                    int a = fm.getAscent();
                    int l = fm.getLeading();
                    double h1 = lfh * (double)(h - a) / (double)h;
                    mx = h1 * this.WidthScale;
                    my = -h1 - 0.5 * (Child.SideY - lfh * (double)(h - l) / (double)h);
                }
                switch (this.Align) {
                    case 0: {
                        x = -0.5 * (this.SideX - Child.SideX) + mx;
                        break;
                    }
                    case 1: {
                        x = 0.5 * (this.SideX - Child.SideX) + mx;
                        break;
                    }
                    case 2: {
                        x = mx;
                        break;
                    }
                }
                y = ((double)i + 0.5) * Child.SideY + my;
                if (Engine2.UseGTM) {
                    OldGTM = new AffineTransform();
                    OldGTM.setTransform(Engine2.GTM);
                    try {
                        Engine2.GTM.translate(x, y);
                        Child.actualPaint(g2d, Engine2);
                        continue;
                    }
                    finally {
                        Engine2.GTM.setTransform(OldGTM);
                    }
                }
                OldGTM = new AffineTransform();
                OldGTM.setTransform(g2d.getTransform());
                try {
                    g2d.translate(x, y);
                    Child.actualPaint(g2d, Engine2);
                    continue;
                }
                finally {
                    g2d.setTransform(OldGTM);
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.Align != 0) {
            writer.putInt08(63, this.Align);
        }
        if (this.lfHeight != 0.0) {
            writer.putDouble(68, this.lfHeight);
        }
        if (this.WidthScale != 1.0) {
            writer.putDouble(112, this.WidthScale);
        }
        if (this.ShowBackground) {
            writer.putBool(69, this.ShowBackground);
        }
        if (!this.AutoSize) {
            writer.putEmpty(143);
        }
        if (this.VertAlign != 0) {
            writer.putInt32(144, this.VertAlign);
        }
        this.writeTaggedSides(writer);
        this.writeTaggedBounds(writer);
        this.writeTaggedLines(writer, clipboard, simult);
        this.writeTaggedLinesBounds(writer);
    }

    synchronized void writeTaggedSides(TaggedWriter writer) throws IOException {
        int cnt;
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        int n = cnt = this.Lines == null ? 0 : this.Lines.size();
        if (cnt == 0) {
            SchemeUtils.writeDoubles(subWriter, 61, this.SideX, this.SideY);
        } else {
            for (int i = 0; i < cnt; ++i) {
                BaseGraphic bg = (BaseGraphic)this.Lines.get(i);
                if (!(bg instanceof RectTextLine)) continue;
                RectTextLine line = (RectTextLine)bg;
                SchemeUtils.writeDoubles(subWriter, 61, line.SideX, line.SideY);
            }
        }
        subWriter.flush();
        writer.putRaw(62, os);
    }

    synchronized void writeTaggedLines(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null || this.Lines == null || this.Lines.isEmpty()) {
            return;
        }
        BaseGraphic.ShapeClassInfo classInfo = new BaseGraphic.ShapeClassInfo();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        int count = this.Lines.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic line = (BaseGraphic)this.Lines.get(i);
            ByteArrayOutputStream os1 = new ByteArrayOutputStream();
            TaggedWriter w1 = new TaggedWriter(os1);
            classInfo.shapeType = 222;
            classInfo.version = line.getShapeClassInfo().version;
            SchemeUtils.writeShapeClassInfo(w1, classInfo);
            if (line instanceof RectTextLine) {
                ((RectTextLine)line).writeTaggedData_(w1, clipboard, simult, this);
            }
            w1.flush();
            w.putRaw(1, os1);
        }
        w.flush();
        writer.putRaw(70, os);
    }

    synchronized void writeTaggedLinesBounds(TaggedWriter writer) throws IOException {
        if (writer == null || this.Lines == null || this.Lines.isEmpty()) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        int count = this.Lines.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic line = (BaseGraphic)this.Lines.get(i);
            SchemeUtils.writeDoubles(w, 72, line.Left, line.Top, line.Right, line.Bottom);
        }
        w.flush();
        writer.putRaw(71, os);
    }

    @Override
    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        super.writeExtraTagged(writer);
        writer.putBool(8, this.AutoSizeWithAlign);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (!SchemeUtils.isEqual(this.LineSpacing, 1.0)) {
            w.putDouble(1, this.LineSpacing);
        }
        if (!SchemeUtils.isEqual(this.TabStopPosition, 15.0)) {
            w.putDouble(4, this.TabStopPosition);
        }
        if (!SchemeUtils.isEqual(this.LeftMargin, 0.0)) {
            w.putDouble(5, this.LeftMargin);
        }
        if (!SchemeUtils.isEqual(this.RightMargin, 0.0)) {
            w.putDouble(6, this.RightMargin);
        }
        if (!SchemeUtils.isEqual(this.TopMargin, 0.0)) {
            w.putDouble(7, this.TopMargin);
        }
        if (!SchemeUtils.isEqual(this.BottomMargin, 0.0)) {
            w.putDouble(8, this.BottomMargin);
        }
        if (!SchemeUtils.isEqual(this.TransparentText, 0.0)) {
            w.putInt08(9, (byte)this.TransparentText);
        }
        w.flush();
        if (os.size() > 0) {
            writer.putRaw(9, os);
        }
    }

    @Override
    public int shapeType() {
        return 223;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    public Color getFontColor() {
        RectTextLine child;
        if (this.Lines.size() > 0 && (child = (RectTextLine)this.Lines.get(0)) != null) {
            return child.FontColor;
        }
        return null;
    }

    public void freshSides() {
        int cnt;
        if (!this.AutoSize) {
            return;
        }
        double oldSideX = this.SideX;
        double oldSideY = this.SideY;
        this.SideX = 0.0;
        this.SideY = 0.0;
        int n = cnt = this.Lines == null ? 0 : this.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            BaseGraphic bg = (BaseGraphic)this.Lines.get(i);
            if (!(bg instanceof RectTextLine)) continue;
            RectTextLine line = (RectTextLine)bg;
            line.freshSides(this.lfHeight, this.WidthScale);
            if (this.SideX < line.SideX) {
                this.SideX = line.SideX;
            }
            this.SideY += line.SideY;
        }
        if (this.TransProps == null) {
            this.TransProps = new TransformProps();
        }
        this.TransProps.CenterX += (this.SideX - oldSideX) / 2.0;
        this.TransProps.CenterY += (this.SideY - oldSideY) / 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMLineText(BaseGraphic obj, List<String> strings, boolean needDivide, double maxWidth, boolean ignoreSemicolon, boolean doTransform) {
        if (obj instanceof Paragraph && strings != null) {
            int i;
            Paragraph par = (Paragraph)obj;
            if (obj.TransProps == null) {
                obj.TransProps = new TransformProps();
            }
            double lOldCenterX = obj.TransProps.CenterX;
            double lOldCenterY = obj.TransProps.CenterY;
            double lOldSidesX = par.SideX;
            double lOldSidesY = par.SideY;
            double lMaxWidth = maxWidth > 0.0 ? maxWidth : lOldSidesX;
            int lStrIdx = 0;
            if (par.Lines == null) {
                par.Lines = new Lines();
            }
            BaseGraphic.RealPoint lMaxSize = new BaseGraphic.RealPoint();
            Font font = par.getFont();
            for (i = 0; i < strings.size(); ++i) {
                if (lStrIdx >= par.Lines.size()) {
                    RectTextLine line = new RectTextLine();
                    line.Text = strings.get(i);
                    par.Lines.add(line);
                } else {
                    ((RectTextLine)par.Lines.get((int)i)).Text = strings.get(i);
                }
                ++lStrIdx;
                if (!needDivide) continue;
                ArrayList<String> lStrings = new ArrayList<String>();
                assert (font != null);
                Paragraph.divideText(strings.get(i), font, lMaxWidth, true, false, ignoreSemicolon, lStrings, lMaxSize);
                if (lStrings.size() <= 1) continue;
                --lStrIdx;
                int cntj = lStrings.size();
                for (int j = 0; j < cntj; ++j) {
                    if (lStrIdx >= par.Lines.size()) {
                        par.Lines.addLine(lStrings.get(j).trim());
                    } else {
                        ((RectTextLine)par.Lines.get((int)lStrIdx)).Text = lStrings.get(j).trim();
                    }
                    ++lStrIdx;
                }
            }
            par.Lines.applyFontToLines();
            if (!doTransform) {
                int cnt;
                int n = cnt = par.Lines == null ? 0 : par.Lines.size();
                for (i = 0; i < cnt; ++i) {
                    BaseGraphic bg = (BaseGraphic)par.Lines.get(i);
                    if (!(bg instanceof RectTextLine)) continue;
                    RectTextLine line = (RectTextLine)bg;
                    line.freshSides(par.lfHeight, par.WidthScale);
                }
                return;
            }
            par.freshSides();
            par.TransProps.CenterX = Math.abs(lOldSidesX) > FloatTolerance ? lOldCenterX * par.SideX / lOldSidesX : par.SideX / 2.0;
            par.TransProps.CenterY = Math.abs(lOldSidesY) > FloatTolerance ? lOldCenterY * par.SideY / lOldSidesY : par.SideY / 2.0;
            AffineTransform OldGTM = new AffineTransform();
            OldGTM.setTransform(par.Engine.GTM);
            double OldAngle = par.Engine.tmpAngle;
            try {
                par.Engine.GTM = SchemeEngine.GenTransform(par);
                par.genDistRadius(false);
            }
            finally {
                par.Engine.GTM.setTransform(OldGTM);
                par.Engine.tmpAngle = OldAngle;
            }
        }
    }

    public static void divideText(String text, Font textFont, double maxWidth, boolean divide, boolean ignoreLines, boolean ignoreSemicolon, List<String> strings, BaseGraphic.RealPoint maxSize) {
        if (textFont == null || text == null) {
            return;
        }
        assert (strings != null);
        assert (maxSize != null);
        BaseGraphic.RealPoint lSize = VsdxReader.calcTextSize(textFont, text);
        StringBuilder lCurrLine = new StringBuilder();
        StringBuilder lPrevLine = new StringBuilder();
        strings.clear();
        IntUnaryOperator addLineText = linesCount -> {
            String currLine = lCurrLine.toString();
            if (" ".equals(currLine)) {
                strings.add(currLine);
            } else {
                strings.add(currLine.trim());
            }
            BaseGraphic.RealPoint lSize1 = VsdxReader.calcTextSize(textFont, currLine);
            if (lSize1.X > maxSize.X) {
                maxSize.X = lSize1.X;
            }
            lPrevLine.setLength(0);
            lCurrLine.setLength(0);
            return linesCount + 1;
        };
        if (maxWidth > FloatTolerance && lSize.X > FloatTolerance) {
            if ((double)textFont.getSize2D() > FloatTolerance) {
                maxWidth += 0.5 * (double)textFont.getSize2D();
            }
            int lLinesCount = 0;
            maxSize.X = 0.0;
            maxSize.Y = 0.0;
            char[] textChars = text.toCharArray();
            for (int i = 0; i < textChars.length; ++i) {
                boolean isNewLine;
                boolean bl = isNewLine = !ignoreSemicolon && textChars[i] == ';';
                if (ignoreLines && isNewLine) {
                    textChars[i] = 32;
                    isNewLine = false;
                }
                if (isNewLine || (textChars[i] == ' ' || i == textChars.length + 1) && lCurrLine.length() > 0) {
                    lSize = VsdxReader.calcTextSize(textFont, lCurrLine.toString());
                    if (lCurrLine.length() == 0) {
                        lSize.X = 0.0;
                    }
                    if (lSize.X < maxWidth || !divide) {
                        lPrevLine.setLength(0);
                        lPrevLine.append((CharSequence)lCurrLine);
                        if (!isNewLine) {
                            lCurrLine.append(textChars[i]);
                        }
                    } else if (lPrevLine.length() > 0) {
                        String prevLine = lPrevLine.toString();
                        strings.add(prevLine.trim());
                        lSize = VsdxReader.calcTextSize(textFont, prevLine.trim());
                        if (lSize.X > maxSize.X) {
                            maxSize.X = lSize.X;
                        }
                        ++lLinesCount;
                        String curLine = lCurrLine.substring(prevLine.length());
                        lCurrLine.setLength(0);
                        lCurrLine.append(curLine);
                        lPrevLine.setLength(0);
                        lPrevLine.append(curLine);
                        if (!isNewLine) {
                            lCurrLine.append(textChars[i]);
                        }
                        lSize = VsdxReader.calcTextSize(textFont, lCurrLine.toString());
                        if (lSize.X > maxWidth) {
                            lLinesCount = addLineText.applyAsInt(lLinesCount);
                        }
                    } else if (!isNewLine) {
                        lCurrLine.append(textChars[i]);
                        lLinesCount = addLineText.applyAsInt(lLinesCount);
                    }
                } else if (!isNewLine) {
                    lCurrLine.append(textChars[i]);
                }
                if (isNewLine || i == textChars.length - 1 && lCurrLine.length() > 0) {
                    if (isNewLine && i == textChars.length - 1) {
                        lLinesCount = addLineText.applyAsInt(lLinesCount);
                    }
                    lLinesCount = addLineText.applyAsInt(lLinesCount);
                }
                maxSize.Y = (double)lLinesCount * lSize.Y;
            }
        }
    }

    public static void parseLines(Paragraph obj, double maxWidth) {
        if (obj == null || obj.Lines == null || obj.Lines.isEmpty()) {
            return;
        }
        ArrayList<RectTextLine> newLines = new ArrayList<RectTextLine>();
        ArrayList<RectTextLine.PartTextLine> newParts = new ArrayList<RectTextLine.PartTextLine>();
        int cnti = obj.Lines.size();
        for (int i = 0; i < cnti; ++i) {
            RectTextLine rtl = (RectTextLine)obj.Lines.get(i);
            if (rtl.Text == null) {
                RectTextLine.PartTextLine ptl = RectTextLine.PartTextLine.getDefaultPart();
                ptl.fontHeight = obj.lfHeight;
                rtl.Parts.add(ptl);
            }
            if (rtl.Parts.isEmpty()) {
                rtl.Parts.add(RectTextLine.PartTextLine.getParentCopy(rtl));
            }
            double width = 0.0;
            StringBuilder gen = new StringBuilder();
            Font font = null;
            int cntj = rtl.Parts.size();
            for (int j = 0; j < cntj; ++j) {
                RectTextLine.PartTextLine ptl = rtl.Parts.get(j);
                ptl.fontHeight = Math.round(ptl.fontHeight == 0.0 ? obj.lfHeight : ptl.fontHeight);
                String text = ptl.text;
                int lastSpace = -1;
                SchemeEngine engine = obj.getEngine();
                if (engine == null) {
                    throw new NullPointerException("obj.getEngine() return null");
                }
                font = engine.getActualFont(ptl.fontName, ptl.fontStyle, ptl.fontColor, ptl.fontHeight, 1.0);
                StringBuilder prevString = new StringBuilder();
                BaseGraphic.RealPoint prevRealPoint = new BaseGraphic.RealPoint();
                while (!text.isEmpty()) {
                    int spaceIndex = text.indexOf(32, lastSpace + 1);
                    if (spaceIndex < 0) {
                        spaceIndex = text.length();
                    }
                    String subString = text.substring(lastSpace + 1, spaceIndex);
                    BaseGraphic.RealPoint size = VsdxReader.calcTextSize(font, subString);
                    if ((width += size.X) >= maxWidth) {
                        boolean isEmpty = prevString.toString().isEmpty();
                        if (!isEmpty) {
                            RectTextLine.PartTextLine part = ptl.clone();
                            part.text = prevString.toString();
                            part.sides = prevRealPoint;
                            newParts.add(part);
                        }
                        BaseGraphic.RealPoint point = VsdxReader.calcTextSize(font, gen.toString());
                        RectTextLine newRtl = new RectTextLine();
                        newRtl.Text = gen.toString();
                        newRtl.SideX = point.X;
                        newRtl.SideY = point.Y;
                        newRtl.Parts.addAll(newParts);
                        newLines.add(newRtl);
                        if (lastSpace < 0) {
                            lastSpace = spaceIndex;
                        }
                        text = text.substring(lastSpace).trim();
                        lastSpace = -1;
                        prevRealPoint = new BaseGraphic.RealPoint();
                        newParts.clear();
                        prevString.setLength(0);
                        gen.setLength(0);
                        if (spaceIndex == subString.length()) {
                            RectTextLine.PartTextLine line = ptl.clone();
                            line.text = subString;
                            line.sides.X = size.X;
                            line.sides.Y = size.Y;
                            newParts.add(line);
                            gen.append(subString);
                            width = size.X;
                            continue;
                        }
                        width = 0.0;
                        continue;
                    }
                    if (spaceIndex == text.length()) {
                        RectTextLine.PartTextLine line = ptl.clone();
                        line.text = text;
                        line.sides.X = size.X;
                        line.sides.Y = size.Y;
                        newParts.add(line);
                        gen.append(subString);
                        text = "";
                        continue;
                    }
                    int countSpace = spaceIndex - subString.length() - lastSpace;
                    String spaces = lastSpace == -1 ? " " : " ".repeat(countSpace);
                    prevRealPoint.X += size.X;
                    prevString.append(subString).append(spaces);
                    gen.append(subString).append(spaces);
                    lastSpace = spaceIndex;
                }
            }
            if (newParts.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (RectTextLine.PartTextLine ptl : newParts) {
                sb.append(ptl.text).append(" ");
            }
            String text = sb.toString().trim();
            RectTextLine newRtl = new RectTextLine();
            newRtl.Text = text;
            newRtl.Parts.addAll(newParts);
            if (font != null) {
                BaseGraphic.RealPoint rp = VsdxReader.calcTextSize(font, text);
                newRtl.SideX = rp.X;
                newRtl.SideY = rp.Y;
            }
            newLines.add(newRtl);
            newParts.clear();
        }
        if (!newLines.isEmpty()) {
            obj.Lines.clear();
            obj.Lines.addAll(newLines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genDistRadius(boolean ignoreGP) {
        int cnt;
        super.genDistRadius(ignoreGP);
        BaseGraphic.RealPoint rpt = new BaseGraphic.RealPoint();
        rpt.X = 0.0;
        rpt.Y = -this.SideY / 2.0;
        int n = cnt = this.Lines == null ? 0 : this.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            AffineTransform OldGTM = new AffineTransform();
            OldGTM.setTransform(this.Engine.GTM);
            double OldAngle = this.Engine.tmpAngle;
            try {
                RectTextLine line = (RectTextLine)this.Lines.get(i);
                line.setEngine(this.Engine);
                rpt.X = this.SideX / 2.0 - line.SideX / 2.0;
                if (this.Align == 2) {
                    rpt.X = 0.0;
                } else if (this.Align == 0) {
                    rpt.X = -rpt.X;
                }
                rpt.Y += line.SideY / 2.0;
                this.Engine.GTM.translate(rpt.X, rpt.Y);
                rpt.Y += line.SideY / 2.0;
                line.genDistRadius(ignoreGP);
                continue;
            }
            finally {
                this.Engine.GTM.setTransform(OldGTM);
                this.Engine.tmpAngle = OldAngle;
            }
        }
    }

    public boolean containsParagraphLine() {
        for (BaseGraphic line : this.Lines) {
            RectTextLine rtl = (RectTextLine)line;
            if (rtl.paragraphLine == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsText() {
        for (BaseGraphic line : this.Lines) {
            RectTextLine rtl = (RectTextLine)line;
            if (rtl.Text == null || rtl.Text.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static class Lines
    extends ArrayList<BaseGraphic> {
        public String FontName = DEFAULT_FONTNAME;
        public int FontSize = 12;
        public Color FontColor = Color.BLACK;
        public byte FontStyle = 0;
        public byte FontCharSet = 0;
        public SchemeEngine Engine = null;

        public void applyFontToLine(BaseGraphic bg) {
            if (!(bg instanceof RectTextLine)) {
                return;
            }
            RectTextLine line = (RectTextLine)bg;
            line.FontName = this.FontName;
            line.FontSize = this.FontSize;
            line.FontColor = this.FontColor;
            line.FontStyle = this.FontStyle;
            line.FontCharSet = this.FontCharSet;
            line.setEngine(this.Engine);
            line.ID = Core.generateId();
        }

        public void applyFontToLines() {
            this.forEach((? super E bg) -> this.applyFontToLine((BaseGraphic)bg));
        }

        public RectTextLine addLine(String text) {
            RectTextLine line = new RectTextLine();
            this.applyFontToLine(line);
            line.Text = text;
            this.add(line);
            return line;
        }

        public RectTextLine addLine(int index, String text) {
            RectTextLine line = new RectTextLine();
            this.applyFontToLine(line);
            line.Text = text;
            this.add(index, line);
            return line;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

