/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.IOException;

public class Rectangle
extends BaseShape {
    public double SideX = 0.0;
    public double SideY = 0.0;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        Rectangle shape = (Rectangle)Dest;
        shape.SideX = this.SideX;
        shape.SideY = this.SideY;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        byte[] tmpBytes = null;
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 36: {
                    tmpBytes = reader.getRaw();
                    this.SideX = LittleEndian.getDouble(tmpBytes, 0);
                    if (this.SideX < 0.0) {
                        this.SideX = Math.abs(this.SideX);
                    }
                    this.SideY = LittleEndian.getDouble(tmpBytes, 8);
                    if (!(this.SideY < 0.0)) break;
                    this.SideY = Math.abs(this.SideY);
                }
            }
        }
    }

    public double[] getRectPoints() {
        double[] pts = new double[]{-0.5 * this.SideX, -0.5 * this.SideY, 0.5 * this.SideX, -0.5 * this.SideY, 0.5 * this.SideX, 0.5 * this.SideY, -0.5 * this.SideX, 0.5 * this.SideY};
        return pts;
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        double[] Pts = this.getRectPoints();
        int pcount = Pts.length / 2;
        if (Engine2.UseGTM) {
            Pts = Engine2.MulPoints(Pts);
        }
        if (Engine2.UseJavaShapes) {
            int idx = 0;
            Path2D.Double shape = new Path2D.Double();
            ((Path2D)shape).moveTo(Pts[0], Pts[1]);
            for (int i = 1; i < pcount; ++i) {
                idx = 2 * i;
                ((Path2D)shape).lineTo(Pts[idx], Pts[idx + 1]);
            }
            shape.closePath();
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fill(shape);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.draw(shape);
            }
        } else {
            int[] x = new int[pcount];
            int[] y = new int[pcount];
            int idx = 0;
            for (int i = 0; i < pcount; ++i) {
                idx = 2 * i;
                x[i] = (int)Math.round(Pts[idx]);
                y[i] = (int)Math.round(Pts[idx + 1]);
            }
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fillPolygon(x, y, pcount);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.drawPolygon(x, y, pcount);
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.SideX != 0.0 || this.SideY != 0.0) {
            SchemeUtils.writeDoubles(writer, 36, this.SideX, this.SideY);
        }
    }

    @Override
    public int shapeType() {
        return 214;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    protected void calcOrgAndAjust(int idxPoint, boolean ignoreGP) {
    }

    @Override
    protected int getVerticesCount() {
        return 8;
    }

    @Override
    protected double getVertexX(int index) {
        if (index < 0) {
            return 0.0;
        }
        if (index <= 3) {
            double[] points = this.getRectPoints();
            return points[index * 2];
        }
        switch (index) {
            case 4: {
                return 0.0;
            }
            case 5: {
                return this.SideX / 2.0;
            }
            case 6: {
                return 0.0;
            }
            case 7: {
                return -this.SideX / 2.0;
            }
        }
        return 0.0;
    }

    @Override
    protected double getVertexY(int index) {
        if (index < 0) {
            return 0.0;
        }
        if (index <= 3) {
            double[] points = this.getRectPoints();
            return points[index * 2 + 1];
        }
        switch (index) {
            case 4: {
                return -this.SideY / 2.0;
            }
            case 5: {
                return 0.0;
            }
            case 6: {
                return this.SideY / 2.0;
            }
            case 7: {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    protected void setVertex(int index, double x, double y) {
        if (index < this.getVerticesCount()) {
            double NewSidesX = 0.0;
            double NewSidesY = 0.0;
            if (index == 1 || index == 2 || index == 5) {
                NewSidesX = x - this.getVertexX(0);
            } else if (index == 0 || index == 3 || index == 7) {
                NewSidesX = this.getVertexX(1) - x;
            }
            if (index == 2 || index == 3 || index == 6) {
                NewSidesY = y - this.getVertexY(0);
            } else if (index == 0 || index == 1 || index == 4) {
                NewSidesY = this.getVertexY(2) - y;
            }
            this.SideX = NewSidesX;
            this.SideY = NewSidesY;
        }
    }
}

