/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BindingNode;
import inform.agent.schemes.DiagramTable;
import inform.agent.schemes.Guide;
import inform.agent.schemes.NoSuchObjectException;
import inform.agent.schemes.ObjectExistsException;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.PrimLibrary;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.SaveSchemeObjectCommand;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectFilter;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemePageNotes;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemesManager;
import inform.agent.scripts.SSContext;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Scheme {
    public final SSContext ssContext = null;
    private static final int MAX_SCHEME_MODIFICATORS = 100;
    private static final int MAX_BATCH_REQUESTS = 1000;
    private Semaphore lock = new Semaphore(100);
    public DoubleHash<SchemeObject> schemeObjects = new DoubleHash();
    public List<SchemeObject> SortShapes = new ArrayList<SchemeObject>();
    public List<SchemeObject> SortLayers = new ArrayList<SchemeObject>();
    private double firstObject;
    private double lastObject;
    private AtomicInteger revision = new AtomicInteger();
    private static final int MAX_SIZE_EMPTY_OBG = 200;
    private double schemeStartTime;
    private SchemeKeepSettings keepSettings = null;
    private SchemeKeepSettings keepSettingsOld = null;
    private SchemeKeepSettings libKeepSettings = null;
    private double schemeId = -1.0;
    protected long schemeSize = 0L;
    protected double schemeDate = 0.0;
    public Color BkColor = Color.WHITE;
    public DoubleHash<PrimLibrary> PrimLibraries = new DoubleHash();
    public DoubleHash<BindingNode> BindingNodes = new DoubleHash();
    private SchemePageLayout pageLayout = null;
    private SchemePageNotes pageNotes = null;
    public DoubleHash<SchemePage> Pages = new DoubleHash();
    public boolean Parsed = false;
    public boolean KeepSort = true;
    public boolean Sorted = false;
    public boolean BoundsCalculated = false;
    public double exportPageId = 0.0;
    public static double INVISIBLE_PAGE_ID = -2.0;
    private double SchemeLeft = 0.0;
    private double SchemeTop = 0.0;
    private double SchemeRight = 0.0;
    private double SchemeBottom = 0.0;
    private double SchemeWidth = 0.0;
    private double SchemeHeight = 0.0;
    int hitPrecision = 4;
    public boolean showGrid = true;
    double gridStepX = 1.0;
    double gridStepY = 1.0;
    String mapGridStepX = "005\u00b059'59.99\"";
    String mapGridStepY = "004\u00b000'00.00\"";
    byte primInsFlags = 1;
    double zoomingStep = 1.25;
    boolean snapToGrid = true;
    boolean snapToMapGrid = false;
    boolean snapToNearest = false;
    boolean showMapGrid = false;
    boolean showPrimInsDialog = true;
    byte schemeAlign = (byte)5;
    int units = 0;
    int undoRedoDeepnes = 50;
    double zoomSensivity = 110.0;
    int insMethod = 1;
    boolean drawArrows = true;
    double reperPrimId = 0.0;
    double viewForm = 0.0;
    String script = "";
    boolean transparentSelection = true;
    boolean solveConflicts = true;
    double dimStyleId = 0.0;
    boolean needBlink = true;
    boolean showShapeHint = true;
    boolean snapPoints = true;
    PrimLibrary internalLib;
    List<DiagramTable> diagTables;
    private HashMap<Double, ConnPointHashEntry> _connHashTable = new HashMap();
    private static final Comparator<SchemeObject> CMP = new Comparator<SchemeObject>(){

        @Override
        public int compare(SchemeObject o1, SchemeObject o2) {
            return o1.getOrder() - o2.getOrder();
        }
    };

    public long getSchemeSize() {
        return this.schemeSize;
    }

    public double getSchemeDate() {
        return this.schemeDate;
    }

    Scheme() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Scheme(ServerSideHost ssHost, InputStream schemeContentStream, double schemeId, SchemeKeepSettings newKeepSettings) throws IOException, TaggedReaderException, InformException, SQLException {
        this.schemeId = schemeId;
        int sig = this.getSignature(schemeContentStream);
        GZIPInputStream zipStream = sig == 35615 ? new GZIPInputStream(schemeContentStream) : null;
        TaggedReader schemeReader = new TaggedReader(zipStream != null ? zipStream : schemeContentStream);
        try {
            SchemeObject o = null;
            double prevObject = 0.0;
            int tag = schemeReader.getNextTag();
            if (tag == 0) {
                return;
            }
            if (tag != 150) {
                Core.logger.info("No scheme TAG_PHENIX_MTD_SIGNATURE, probably, wrong version of scheme");
            }
            boolean loadSeparatelyObjects = false;
            block19: do {
                tag = schemeReader.getNextTag();
                switch (tag) {
                    case 11: {
                        this.revision.set(schemeReader.getInt());
                        break;
                    }
                    case 18: {
                        TaggedReader exportSubReader = schemeReader.getSubStreamReader();
                        while (exportSubReader.next()) {
                            switch (exportSubReader.getCurrentTag()) {
                                case 1: {
                                    SchemesManager.loadFontsFromReader(exportSubReader.getSubStreamReader());
                                }
                            }
                        }
                        continue block19;
                    }
                    case 49: {
                        this.keepSettings = new SchemeKeepSettings(schemeReader.getSubStreamReader());
                        loadSeparatelyObjects = true;
                        break;
                    }
                    case 20: {
                        o = SchemeObject.readObject(schemeReader, this);
                        if (o.getPrecedingID() == 0.0 && o.getOrder() == 0) {
                            o.setPrecedingID(prevObject);
                        }
                        this.placeLast(o, false);
                        prevObject = o.getID();
                    }
                }
            } while (tag != 0);
            if (loadSeparatelyObjects) {
                this.loadSeparatelyObjects(ssHost, newKeepSettings);
            }
            this.clearSchemeObjsState();
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    Core.logger.warn("\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u0436\u0430\u0442\u043e\u0433\u043e \u0442\u0435\u0433\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u0442\u043e\u043a\u0430", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSchemeObjsState() {
        for (SchemeObject i : this.schemeObjects) {
            assert (i != null);
            SchemeObject schemeObject = i;
            synchronized (schemeObject) {
                if (!i.isDeleted()) {
                    i.setModified(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSeparatelyObjects(ServerSideHost ssHost, SchemeKeepSettings newKeepSettings) throws InformException, SQLException, IOException {
        if (this.keepSettings == null) {
            return;
        }
        try (DatabaseConnection conn = this.keepSettings.getTableDesc().getDatabaseDescriptor().connect(ssHost, "Scheme::loadSeparatelyObjects");){
            if (newKeepSettings != null) {
                if (newKeepSettings.getGeometryFieldDesc() == null) {
                    this.keepSettings.geometryFieldDesc = null;
                }
                if (newKeepSettings.getGeometryLrsFieldDesc() == null) {
                    this.keepSettings.geometryLrsFieldDesc = null;
                }
            }
            TableDescriptor tableDesc = this.keepSettings.getTableDesc();
            DatabaseDescriptor dbDesc = tableDesc.getDatabaseDescriptor();
            FieldDescriptor geom = this.keepSettings.getGeometryFieldDesc();
            FieldDescriptor glrs = this.keepSettings.getGeometryLrsFieldDesc();
            Object geomStr = this.keepSettings.getRevisionFieldDesc().getRawName();
            if (geom != null) {
                geomStr = (String)geomStr + "," + geom.getRawName();
            }
            if (glrs != null) {
                geomStr = (String)geomStr + "," + glrs.getRawName();
            }
            Object schemeStr = "";
            if (dbDesc.getScheme() != null) {
                schemeStr = dbDesc.getScheme() + ".";
            }
            String sql = String.format("SELECT %s, %s, %s, %s, %s, %s, %s, %s, %s FROM %s%s WHERE %s = %s", this.keepSettings.getPrimaryKeyFieldDesc().getRawName(), this.keepSettings.getShapeDataFieldDesc().getRawName(), this.keepSettings.getShapeIDFieldDesc().getRawName(), this.keepSettings.getShapeTypeFieldDesc().getRawName(), this.keepSettings.getLastModificationDateFieldDesc().getRawName(), this.keepSettings.getLastModificationAuthorFieldDesc().getRawName(), this.keepSettings.getShapeOrderFieldDesc().getRawName(), this.keepSettings.getLayerIDFieldDesc().getRawName(), geomStr, schemeStr, tableDesc.getRawName(), this.keepSettings.getSchemeIDFieldDesc().getRawName(), this.schemeId);
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                long t1 = System.currentTimeMillis();
                SchemeObject o = null;
                ArrayList<Double> ids = new ArrayList<Double>();
                try (ResultSet result = stmt.executeQuery(this.ssContext);){
                    while (result.next()) {
                        o = SchemeObject.readObjectFromTable(result, this);
                        ids.add(o.getID());
                        this.placeLast(o, false);
                    }
                }
                long t2 = System.currentTimeMillis();
                Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0438\u0433\u0443\u0440 ({}) \u0441\u0445\u0435\u043c\u044b {}: {}ms", ids.size(), NumberConverter.doubleToString(this.schemeId), t2 - t1);
            }
            conn.commit();
        }
    }

    void acquireForModification() throws InterruptedException {
        this.lock.acquire();
    }

    void releaseFromModification() {
        this.lock.release();
    }

    public double getFirstObject() {
        return this.firstObject;
    }

    public double getLastObject() {
        return this.lastObject;
    }

    void acquireForSaving() throws InterruptedException {
        Core.logger.debug("Available permissions for scheme modification: {}", this.lock.availablePermits());
        this.lock.acquire(100);
    }

    boolean tryAcquireForSaving() {
        return this.lock.tryAcquire(100);
    }

    void releaseFromSaving() {
        this.lock.release(100);
    }

    synchronized SchemeObject getObject(int type, double iD) throws NoSuchObjectException {
        SchemeObject i = this.schemeObjects.get(iD);
        if (i == null || i.isDeleted() || i.getType() != type && (!SchemeObjectsTypes.ObjTypeIsShape(type) || !SchemeObjectsTypes.ObjTypeIsShape(i.getType()))) {
            throw new NoSuchObjectException(type, iD);
        }
        return i;
    }

    synchronized SchemeObject getObjectSilent(int type, double iD) {
        SchemeObject i = this.schemeObjects.get(iD);
        if (i == null || i.isDeleted() || i.getType() != type && (!SchemeObjectsTypes.ObjTypeIsShape(type) || !SchemeObjectsTypes.ObjTypeIsShape(i.getType()))) {
            return null;
        }
        return i;
    }

    synchronized SchemeObject getObjectSilent(double objID) {
        SchemeObject i = this.schemeObjects.get(objID);
        return i == null || i.isDeleted() ? null : i;
    }

    synchronized SchemeObject getObjectSilent(double objID, boolean retDeleted) {
        SchemeObject i = this.schemeObjects.get(objID);
        return i == null || i.isDeleted() && !retDeleted ? null : i;
    }

    synchronized double GetStartTime() {
        return this.schemeStartTime;
    }

    synchronized void updateStartTime() {
        this.schemeStartTime = DateTime.fromUnixTime(new Date().getTime());
    }

    public void addEmtyObj(TaggedWriter writer) throws IOException {
        int EmptySize = (int)(System.currentTimeMillis() % 200L);
        byte[] EptyObj = new byte[EmptySize];
        for (int i = 0; i < EmptySize; ++i) {
            EptyObj[i] = (byte)i;
        }
        writer.putRaw(13, EptyObj);
    }

    synchronized void save(OutputStream output, SchemeObjectFilter filter, double schemeId) throws IOException, InformException, SQLException {
        this.save(output, filter, schemeId, null, null);
    }

    public synchronized void saveKeepSettings(TaggedWriter writer) throws IOException {
        if (writer == null || this.keepSettings == null) {
            return;
        }
        ByteArrayOutputStream subOut = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(subOut);
        this.keepSettings.store(subWriter);
        subWriter.flush();
        writer.putEmpty(49);
        writer.putRaw(202, subOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromSharedTable(ArrayList<Double> ids, DatabaseConnection conn, double schemeId, SchemeKeepSettings keepSettingsOld) throws SQLException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", keepSettingsOld.getTableDesc().getRawName(), keepSettingsOld.getShapeIDFieldDesc().getRawName(), keepSettingsOld.getSchemeIDFieldDesc().getRawName());
        PreparedStatement stmt = conn.prepareStatement(sql);
        int i = 0;
        int index = 0;
        try {
            for (Double id : ids) {
                if (i % 2 == 0) {
                    stmt.setDouble(1, id);
                    stmt.setDouble(2, schemeId);
                    stmt.addBatch();
                    if (++index > 1000) {
                        index = 0;
                        stmt.executeBatch(this.ssContext);
                    }
                }
                ++i;
            }
            stmt.executeBatch(this.ssContext);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveSchemeObjects(Request request, DatabaseConnection connection, double schemeId, TaggedWriter writer, SchemeObjectFilter filter, boolean OnlyAdd) throws IOException, InformException, SQLException {
        if (connection != null) {
            TableDataAudit audit = connection.getTableDataAudit();
            if (audit == null) {
                audit = new TableDataAudit(this.ssContext, connection, request == null ? 0.0 : request.getUserID(), request == null ? 0.0 : request.getEffectiveUserID(), 0.0, 0.0, request == null ? 0.0 : request.getSessionID());
            }
            audit.setBatchMode(true);
            TableDescriptor tableDesc = this.keepSettings.getTableDesc();
            ArrayList<Double> deleted = this.checkSharedShapesTable1(connection, schemeId);
            this.deleteFromSharedTable(deleted, connection, schemeId, this.keepSettings);
            if (deleted != null && deleted.size() > 0) {
                int i = 0;
                for (Double id : deleted) {
                    if (i % 2 != 0) {
                        audit.registrateModification(tableDesc, id, AuditModification.DELETE);
                    }
                    ++i;
                }
            }
            Iterator it = this.schemeObjects.iterator();
            FieldDescriptor geom = this.keepSettings.getGeometryFieldDesc();
            FieldDescriptor glrs = this.keepSettings.getGeometryLrsFieldDesc();
            StringBuilder addSQL = new StringBuilder("INSERT INTO ");
            addSQL.append(this.keepSettings.getTableDesc().getRawName()).append('(');
            addSQL.append(this.keepSettings.getPrimaryKeyFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getLastModificationAuthorFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getLastModificationDateFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getLayerIDFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getSchemeIDFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getShapeDataFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getShapeIDFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getShapeOrderFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getShapeTypeFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getRevisionFieldDesc().getRawName()).append(',');
            addSQL.append(this.keepSettings.getCaptionFieldDesc().getRawName());
            if (geom != null) {
                addSQL.append(',').append(geom.getRawName());
            }
            if (glrs != null) {
                addSQL.append(',').append(glrs.getRawName());
            }
            addSQL.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
            if (geom != null) {
                addSQL.append(", ?");
            }
            if (glrs != null) {
                addSQL.append(", ?");
            }
            addSQL.append(')');
            StringBuilder updateSQL = new StringBuilder("UPDATE ");
            updateSQL.append(this.keepSettings.getTableDesc().getRawName()).append(" SET ");
            updateSQL.append(this.keepSettings.getLastModificationAuthorFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getLastModificationDateFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getLayerIDFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getShapeDataFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getShapeOrderFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getShapeTypeFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getRevisionFieldDesc().getRawName()).append("=?, ");
            updateSQL.append(this.keepSettings.getCaptionFieldDesc().getRawName()).append("=?");
            if (geom != null) {
                updateSQL.append(',').append(geom.getRawName()).append("=?");
            }
            if (glrs != null) {
                updateSQL.append(',').append(glrs.getRawName()).append("=?");
            }
            updateSQL.append(" WHERE ");
            updateSQL.append(this.keepSettings.getSchemeIDFieldDesc().getRawName()).append("=?");
            updateSQL.append(" AND ");
            updateSQL.append(this.keepSettings.getShapeIDFieldDesc().getRawName()).append("=?");
            PreparedStatement addStmt = connection.prepareStatement(addSQL.toString());
            PreparedStatement updateStmt = connection.prepareStatement(updateSQL.toString());
            try {
                int addStmtCounter = 0;
                int updateStmtCounter = 0;
                while (it.hasNext()) {
                    SchemeObject i = (SchemeObject)it.next();
                    assert (i != null);
                    SchemeObject schemeObject = i;
                    synchronized (schemeObject) {
                        if (!i.isDeleted()) {
                            if (i.getType() >= 201 && i.getType() <= 235) {
                                if (OnlyAdd || i.getSaveCommand().equals((Object)SaveSchemeObjectCommand.ADD)) {
                                    i.addObjectToTable(connection, this.keepSettings, addStmt, schemeId);
                                    ++addStmtCounter;
                                    audit.registrateModification(tableDesc, i.getRecordID(), AuditModification.APPEND);
                                } else if (i.isModified()) {
                                    i.updateObjectAtTable(connection, this.keepSettings, updateStmt, schemeId);
                                    ++updateStmtCounter;
                                    audit.registrateModification(tableDesc, i.getRecordID(), AuditModification.MODIFY);
                                }
                                if (addStmtCounter > 1000) {
                                    addStmt.executeBatch(this.ssContext);
                                    addStmtCounter = 0;
                                }
                                if (updateStmtCounter > 1000) {
                                    updateStmt.executeBatch(this.ssContext);
                                    updateStmtCounter = 0;
                                }
                            } else if (filter.fits(i)) {
                                i.saveObject(writer);
                            }
                            i.setAdded(false);
                        }
                        i.setModified(false);
                    }
                }
                addStmt.executeBatch(this.ssContext);
                updateStmt.executeBatch(this.ssContext);
            }
            finally {
                addStmt.close();
                updateStmt.close();
            }
            audit.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save(OutputStream output, SchemeObjectFilter filter, double schemeId, Request request, DatabaseConnection connection) throws IOException, InformException, SQLException {
        GZIPOutputStream compressor = new GZIPOutputStream(output);
        TaggedWriter writer = new TaggedWriter(new BufferedOutputStream(compressor, 0x100000));
        writer.putEmpty(150);
        writer.putInt32(10, 1);
        writer.putInt32(11, this.revision.get());
        writer.putDouble(14, this.schemeStartTime);
        if (this.keepSettings != null) {
            this.saveKeepSettings(writer);
            this.saveSchemeObjects(request, connection, schemeId, writer, filter, this.keepSettingsOld == null);
        } else {
            for (SchemeObject i : this.schemeObjects) {
                assert (i != null);
                SchemeObject schemeObject = i;
                synchronized (schemeObject) {
                    if (!i.isDeleted() && filter.fits(i)) {
                        i.saveObject(writer);
                    }
                }
            }
        }
        this.addEmtyObj(writer);
        writer.flush();
        compressor.finish();
        if (this.keepSettings == null && this.keepSettingsOld != null) {
            TableDataAudit audit = connection.getTableDataAudit();
            if (audit == null) {
                audit = new TableDataAudit(this.ssContext, connection, request == null ? 0.0 : request.getUserID(), request == null ? 0.0 : request.getEffectiveUserID(), 0.0, 0.0, request == null ? 0.0 : request.getSessionID());
            }
            audit.setBatchMode(true);
            TableDescriptor tableDesc = this.keepSettingsOld.getTableDesc();
            ArrayList<Double> deleted = this.getAllSharedShapes(connection, schemeId, this.keepSettingsOld);
            this.deleteFromSharedTable(deleted, connection, schemeId, this.keepSettingsOld);
            if (deleted != null && deleted.size() > 0) {
                int i = 0;
                for (Double id : deleted) {
                    if (i % 2 != 0) {
                        audit.registrateModification(tableDesc, id, AuditModification.DELETE);
                    }
                    ++i;
                }
            }
            audit.flush();
            Core.logger.info("\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0445\u0435\u043c\u044b " + NumberConverter.doubleToString(schemeId) + " \u043d\u0430 \u0441\u043e\u0441\u0440\u0435\u0434\u043e\u0442\u043e\u0447\u0435\u043d\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435");
        } else if (this.keepSettings != null && this.keepSettingsOld == null) {
            Core.logger.info("\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0441\u0445\u0435\u043c\u044b " + NumberConverter.doubleToString(schemeId) + " \u043d\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logObjects() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("-");
        for (SchemeObject i : this.schemeObjects) {
            assert (i != null);
            SchemeObject schemeObject = i;
            synchronized (schemeObject) {
                if (i.isDeleted()) {
                    bldr.append(String.format("[%s]", NumberConverter.doubleToString(i.getID())));
                    bldr.append("-");
                }
            }
        }
        Core.logger.debug("first {}, last {}", NumberConverter.doubleToString(this.firstObject), NumberConverter.doubleToString(this.lastObject));
        Core.logger.debug(bldr.toString());
    }

    synchronized void saveAll(OutputStream output, SchemeObjectFilter filter, boolean SameStartTime) throws IOException, InformException, SQLException {
        this.saveAll(output, filter, SameStartTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAll(OutputStream output, SchemeObjectFilter filter, boolean SameStartTime, boolean saveDelObjs) throws IOException, InformException, SQLException {
        SchemeObject schemeObject;
        SchemeObject i;
        TaggedWriter writer = new TaggedWriter(output);
        writer.putEmpty(150);
        writer.putInt32(10, 1);
        writer.putInt32(11, this.revision.get());
        writer.putDouble(14, this.schemeStartTime);
        writer.putInt32(15, (int)this.schemeSize);
        writer.putDouble(17, this.schemeDate);
        if (this.keepSettings != null) {
            this.saveKeepSettings(writer);
        }
        int savedCount = 0;
        Iterator it = this.schemeObjects.iterator();
        while (it.hasNext()) {
            SchemeObject i2;
            SchemeObject schemeObject2 = i2 = (SchemeObject)it.next();
            synchronized (schemeObject2) {
                if (!i2.isDeleted()) {
                    if (filter != null && !filter.fits(i2)) {
                        continue;
                    }
                    Core.logger.debug("Saving object {} {}", i2, i2.isDeleted() ? ", deleted" : "");
                    i2.saveDescriptor(writer);
                    ++savedCount;
                }
            }
        }
        if (saveDelObjs) {
            Iterator it1 = this.schemeObjects.iterator();
            while (it1.hasNext()) {
                schemeObject = i = (SchemeObject)it1.next();
                synchronized (schemeObject) {
                    if (!i.isDeleted() || filter != null && !filter.fits(i)) {
                        continue;
                    }
                    Core.logger.debug("Saving object {} {}", i, i.isDeleted() ? ", deleted" : "");
                    i.saveDescriptor(writer);
                    ++savedCount;
                }
            }
        }
        if (!SameStartTime) {
            writer.putEmpty(40);
            Iterator it2 = this.schemeObjects.iterator();
            while (it2.hasNext()) {
                schemeObject = i = (SchemeObject)it2.next();
                synchronized (schemeObject) {
                    if (!i.isDeleted()) {
                        writer.putDouble(41, i.getID());
                    }
                }
            }
        }
        writer.flush();
        Core.logger.debug("Saved {} objects", savedCount);
    }

    synchronized void placeLast(SchemeObject schemeObj) throws NoSuchObjectException {
        this.placeLast(schemeObj, true);
    }

    synchronized void placeLast(SchemeObject schemeObj, boolean changeObj) throws NoSuchObjectException {
        this.schemeObjects.add(schemeObj);
        if (changeObj) {
            schemeObj.setModified(true);
        }
    }

    synchronized void placeUnlinked(SchemeObject so) throws ObjectExistsException {
        SchemeObject existing = this.getObjectSilent(so.getType(), so.getID());
        if (existing != null) {
            throw new ObjectExistsException(so.getType(), so.getID(), existing.getRevision());
        }
        this.schemeObjects.add(so);
    }

    synchronized void unlink(double objID) throws NoSuchObjectException {
        SchemeObject h = this.schemeObjects.get(objID);
        if (h == null) {
            throw new NoSuchObjectException(objID);
        }
        if (h.getPrecedingID() == 0.0 && h.getFollowingID() == 0.0) {
            assert (this.firstObject == objID && this.lastObject == objID);
            this.firstObject = 0.0;
            this.lastObject = 0.0;
        } else if (h.getPrecedingID() == 0.0 && h.getFollowingID() != 0.0) {
            if (this.firstObject != objID) {
                Core.logger.debug("Erroneous obj {}, first {}", NumberConverter.doubleToString(objID), NumberConverter.doubleToString(this.firstObject));
                this.logObjects();
            }
            assert (this.firstObject == objID);
            SchemeObject followingItem = this.schemeObjects.get(h.getFollowingID());
            if (followingItem == null) {
                throw new NoSuchObjectException(h.getFollowingID());
            }
            followingItem.setPrecedingID(0.0);
            this.firstObject = h.getFollowingID();
        } else if (h.getPrecedingID() != 0.0 && h.getFollowingID() == 0.0) {
            if (this.lastObject != objID) {
                Core.logger.debug("Erroneous obj {}, last {}", NumberConverter.doubleToString(objID), NumberConverter.doubleToString(this.lastObject));
                this.logObjects();
            }
            assert (this.lastObject == objID);
            SchemeObject precedingItem = this.schemeObjects.get(h.getPrecedingID());
            if (precedingItem == null) {
                throw new NoSuchObjectException(h.getPrecedingID());
            }
            precedingItem.setFollowingID(0.0);
            this.lastObject = h.getPrecedingID();
        } else {
            SchemeObject followingItem = this.schemeObjects.get(h.getFollowingID());
            if (followingItem == null) {
                throw new NoSuchObjectException(h.getFollowingID());
            }
            SchemeObject precedingItem = this.schemeObjects.get(h.getPrecedingID());
            if (precedingItem == null) {
                throw new NoSuchObjectException(h.getPrecedingID());
            }
            precedingItem.setFollowingID(h.getFollowingID());
            followingItem.setPrecedingID(h.getPrecedingID());
        }
        h.setPrecedingID(0.0);
        h.setFollowingID(0.0);
    }

    synchronized int getObjectsCount() {
        return this.schemeObjects.size();
    }

    AtomicInteger getRevision() {
        return this.revision;
    }

    int getSignature(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            throw new IOException("mark()/reset() not supported by input stream");
        }
        stream.mark(2);
        int lo = stream.read();
        int hi = stream.read();
        stream.reset();
        if (lo < 0 || hi < 0) {
            return -1;
        }
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    public SchemeKeepSettings getKeepSettings() {
        return this.keepSettings;
    }

    public void setKeepSettings(SchemeKeepSettings keepSettings) {
        this.keepSettings = keepSettings;
    }

    public SchemeKeepSettings getKeepSettingsOld() {
        return this.keepSettingsOld;
    }

    public void setKeepSettingsOld(SchemeKeepSettings keepSettings) {
        this.keepSettingsOld = keepSettings;
    }

    public SchemeKeepSettings getLibKeepSettings() {
        return this.libKeepSettings;
    }

    public void setLibKeepSettings(SchemeKeepSettings keepSettings) {
        this.libKeepSettings = keepSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ArrayList<Double> checkSharedShapesTable1(DatabaseConnection conn, double schemeID) throws InformException, SQLException {
        if (this.keepSettings == null) {
            return null;
        }
        TableDescriptor tableDesc = TableDescriptor.get(this.keepSettings.getTable());
        if (tableDesc.getRecordIdField() == null) {
            return null;
        }
        ArrayList<Double> deleted = new ArrayList<Double>();
        for (SchemeObject i : this.schemeObjects) {
            assert (i != null);
            SchemeObject schemeObject = i;
            synchronized (schemeObject) {
                if (!i.isDeleted()) {
                    if (i.isModified() && i.isAdded()) {
                        i.setSaveCommand(SaveSchemeObjectCommand.ADD);
                    } else {
                        i.setSaveCommand(SaveSchemeObjectCommand.MODIFY);
                    }
                }
            }
        }
        Iterator it1 = this.schemeObjects.iterator();
        while (it1.hasNext()) {
            SchemeObject i;
            SchemeObject schemeObject = i = (SchemeObject)it1.next();
            synchronized (schemeObject) {
                if (i.isModified() && i.isDeleted() && i.getType() >= 201 && i.getType() <= 235) {
                    deleted.add(i.getID());
                    deleted.add(i.getRecordID());
                }
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ArrayList<Double> getAllSharedShapes(DatabaseConnection conn, double schemeID, SchemeKeepSettings keepSettingsOld) throws InformException, SQLException {
        if (keepSettingsOld == null) {
            return null;
        }
        TableDescriptor tableDesc = TableDescriptor.get(keepSettingsOld.getTable());
        DatabaseDescriptor dbDesc = tableDesc.getDatabaseDescriptor();
        if (tableDesc.getRecordIdField() == null) {
            return null;
        }
        ArrayList<Double> DbIds = null;
        FieldDescriptor PrimaryKeyFieldDesc = tableDesc.getRecordIdField();
        FieldDescriptor shapeIDFieldDesc = tableDesc.getFieldDescriptor(keepSettingsOld.getShapeID());
        FieldDescriptor schemeIDFieldDesc = tableDesc.getFieldDescriptor(keepSettingsOld.getSchemeID());
        Object schemeStr = "";
        if (dbDesc.getScheme() != null) {
            schemeStr = dbDesc.getScheme() + ".";
        }
        String sql = String.format("SELECT %s, %s FROM %s%s WHERE %s = ? ", PrimaryKeyFieldDesc.getRawName(), shapeIDFieldDesc.getRawName(), schemeStr, tableDesc.getRawName(), schemeIDFieldDesc.getRawName());
        PreparedStatement stmt = conn.prepareStatement("actualSharedShapesState", sql);
        try {
            stmt.setQueryTimeout();
            stmt.setDouble(1, schemeID);
            try (ResultSet result = stmt.executeQuery(this.ssContext);){
                DbIds = new ArrayList<Double>();
                while (result.next()) {
                    DbIds.add(result.getDouble(2));
                    DbIds.add(result.getDouble(1));
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
        return DbIds;
    }

    public double getSchemeId() {
        return this.schemeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schemeOrdered() {
        boolean Res = false;
        for (SchemeObject i : this.schemeObjects) {
            assert (i != null);
            SchemeObject schemeObject = i;
            synchronized (schemeObject) {
                if (!i.isDeleted() && i.getOrder() != 0) {
                    Res = true;
                }
            }
        }
        return Res;
    }

    public void parse(ConnectionManager dbMgr, boolean exporting) throws IOException, TaggedReaderException, InformException, SQLException {
        if (this.Parsed) {
            return;
        }
        SchemeParser Parser2 = new SchemeParser();
        Parser2.parseProps(this.ssContext, dbMgr, this, exporting);
        this.Parsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sortObjects() throws IllegalAccessException, InstantiationException {
        if (!this.KeepSort || this.Sorted) {
            return;
        }
        this.SortShapes.clear();
        this.SortLayers.clear();
        Iterator it = this.schemeObjects.iterator();
        while (it.hasNext()) {
            SchemeObject i;
            SchemeObject schemeObject = i = (SchemeObject)it.next();
            synchronized (schemeObject) {
                if (!i.isDeleted()) {
                    if (SchemeObjectsTypes.ObjTypeIsShape(i.getType()) && i.BG != null) {
                        this.SortShapes.add(i);
                    } else if (SchemeObjectsTypes.ObjTypeIsLayer(i.getType()) && i.BG != null) {
                        this.SortLayers.add(i);
                    }
                }
            }
        }
        Collections.sort(this.SortShapes, CMP);
        Collections.sort(this.SortLayers, CMP);
        SchemeObject i1 = null;
        int j = 0;
        while (j < this.SortLayers.size()) {
            SchemeObject schemeObject = i1 = this.SortLayers.get(j);
            synchronized (schemeObject) {
                ((PhxLayer)i1.BG).SortIndex = j++;
            }
        }
        this.Sorted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sortObjectsWithConnPoints() throws IllegalAccessException, InstantiationException {
        SchemeObject schemeObject;
        SchemeObject i1;
        int j;
        if (!this.KeepSort || this.Sorted) {
            return;
        }
        this.SortShapes.clear();
        this.SortLayers.clear();
        Iterator it = this.schemeObjects.iterator();
        while (it.hasNext()) {
            SchemeObject i;
            SchemeObject schemeObject2 = i = (SchemeObject)it.next();
            synchronized (schemeObject2) {
                if (!i.isDeleted()) {
                    if (SchemeObjectsTypes.ObjTypeIsShape(i.getType()) && i.BG != null) {
                        this.SortShapes.add(i);
                    } else if (SchemeObjectsTypes.ObjTypeIsLayer(i.getType()) && i.BG != null) {
                        this.SortLayers.add(i);
                    }
                }
            }
        }
        Collections.sort(this.SortShapes, CMP);
        Collections.sort(this.SortLayers, CMP);
        for (j = 0; j < this.SortShapes.size(); ++j) {
            schemeObject = i1 = this.SortShapes.get(j);
            synchronized (schemeObject) {
                int count;
                if (i1.BG.GluePoints == null && i1.BG.DynamicGluePoint == null) {
                    continue;
                }
                int n = count = i1.BG.GluePoints == null ? 0 : i1.BG.GluePoints.size();
                if (count == 0 && i1.BG.DynamicGluePoint == null) {
                    continue;
                }
                for (int i = 0; i <= count; ++i) {
                    BaseGraphic.GluePoint xGP = null;
                    if (i < count && i1.BG.GluePoints != null) {
                        xGP = i1.BG.GluePoints.get(i);
                    } else if (i == count && i1.BG.DynamicGluePoint != null) {
                        xGP = i1.BG.DynamicGluePoint;
                    }
                    if (xGP == null || xGP.joinId == 0.0) continue;
                    ConnPointHashEntry xConnHashEntry = this._connHashTable.get(xGP.joinId);
                    if (xConnHashEntry == null) {
                        xConnHashEntry = new ConnPointHashEntry(i1.BG.shapeType(), j);
                        this._connHashTable.put(xGP.joinId, xConnHashEntry);
                        continue;
                    }
                    if (xConnHashEntry._shapeType != 210 && xConnHashEntry._shapeType != 212) continue;
                    Collections.swap(this.SortShapes, j, xConnHashEntry._shapeIndex);
                    xConnHashEntry._shapeIndex = j;
                }
                continue;
            }
        }
        j = 0;
        while (j < this.SortLayers.size()) {
            schemeObject = i1 = this.SortLayers.get(j);
            synchronized (schemeObject) {
                ((PhxLayer)i1.BG).SortIndex = j++;
            }
        }
        this.Sorted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void calcSchemeBounds() {
        if (this.BoundsCalculated) {
            return;
        }
        this.SchemeLeft = 0.0;
        this.SchemeTop = 0.0;
        this.SchemeRight = 0.0;
        this.SchemeBottom = 0.0;
        boolean First2 = true;
        Iterator it = this.schemeObjects.iterator();
        while (it.hasNext()) {
            SchemeObject i;
            SchemeObject schemeObject = i = (SchemeObject)it.next();
            synchronized (schemeObject) {
                if (!i.isDeleted() && SchemeObjectsTypes.ObjTypeIsShape(i.getType()) && i.BG != null) {
                    SchemeObject xLayerObj = this.layerById(i.BG.LayerID);
                    if (xLayerObj == null || !(xLayerObj.BG instanceof PhxLayer)) {
                        continue;
                    }
                    if (!((PhxLayer)xLayerObj.BG).Exportable) {
                        continue;
                    }
                    if (First2) {
                        this.SchemeLeft = i.BG.Left;
                        this.SchemeTop = i.BG.Top;
                        this.SchemeRight = i.BG.Right;
                        this.SchemeBottom = i.BG.Bottom;
                        First2 = false;
                    } else {
                        if (i.BG.Left < this.SchemeLeft) {
                            this.SchemeLeft = i.BG.Left;
                        }
                        if (i.BG.Top < this.SchemeTop) {
                            this.SchemeTop = i.BG.Top;
                        }
                        if (i.BG.Right > this.SchemeRight) {
                            this.SchemeRight = i.BG.Right;
                        }
                        if (i.BG.Bottom > this.SchemeBottom) {
                            this.SchemeBottom = i.BG.Bottom;
                        }
                    }
                }
            }
        }
        double pixSize0 = (this.SchemeRight - this.SchemeLeft) / 256.0;
        if (this.SchemeRight - this.SchemeLeft < this.SchemeBottom - this.SchemeTop) {
            pixSize0 = (this.SchemeBottom - this.SchemeTop) / 256.0;
        }
        this.SchemeBottom += pixSize0;
        this.SchemeRight += pixSize0;
        this.SchemeWidth = this.SchemeRight - this.SchemeLeft;
        this.SchemeHeight = this.SchemeBottom - this.SchemeTop;
        Iterator pit = this.Pages.iterator();
        while (pit.hasNext()) {
            this.calcPageBounds((SchemePage)pit.next());
        }
        this.BoundsCalculated = true;
    }

    private synchronized void calcPageBounds(SchemePage page) {
        if (page == null) {
            return;
        }
        page.SchemePageLeft = 0.0;
        page.SchemePageTop = 0.0;
        page.SchemePageRight = 0.0;
        page.SchemePageBottom = 0.0;
        int shapeCount = this.SortShapes.size();
        boolean First2 = true;
        if (shapeCount != 0) {
            Iterator<SchemeObject> iterator = this.SortShapes.iterator();
            while (iterator.hasNext()) {
                Paragraph p;
                SchemeObject xLayerObj;
                SchemeObject sortShape;
                SchemeObject xShapeObj = sortShape = iterator.next();
                if (xShapeObj.BG == null) continue;
                BaseGraphic xBG = xShapeObj.BG;
                if (xBG.Hidden || (xLayerObj = this.layerById(xBG.LayerID)) == null || !(xLayerObj.BG instanceof PhxLayer) || !((PhxLayer)xLayerObj.BG).Exportable || ((PhxLayer)xLayerObj.BG).PageId != page.getNormalizeId() || xBG instanceof Guide || xBG instanceof Paragraph && !(p = (Paragraph)xBG).containsText()) continue;
                if (First2) {
                    page.SchemePageLeft = xBG.Left;
                    page.SchemePageTop = xBG.Top;
                    page.SchemePageRight = xBG.Right;
                    page.SchemePageBottom = xBG.Bottom;
                    First2 = false;
                    continue;
                }
                page.SchemePageLeft = Math.min(xBG.Left, page.SchemePageLeft);
                page.SchemePageTop = Math.min(xBG.Top, page.SchemePageTop);
                page.SchemePageRight = Math.max(xBG.Right, page.SchemePageRight);
                page.SchemePageBottom = Math.max(xBG.Bottom, page.SchemePageBottom);
            }
        }
        page.SchemePageWidth = page.SchemePageRight - page.SchemePageLeft;
        page.SchemePageHeight = page.SchemePageBottom - page.SchemePageTop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double objIDByShapeID(double ID) {
        double res = 0.0;
        for (BindingNode node : this.BindingNodes) {
            assert (node != null);
            BindingNode bindingNode = node;
            synchronized (bindingNode) {
                res = node.getDBObject(ID);
                if (res != 0.0) {
                    break;
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Primitive primById(double primId) {
        if (primId <= 0.0) {
            return null;
        }
        Primitive prim = null;
        for (PrimLibrary lib : this.PrimLibraries) {
            if (lib == null) continue;
            PrimLibrary primLibrary = lib;
            synchronized (primLibrary) {
                prim = lib.Primitives.get(primId);
                if (prim != null) {
                    return prim;
                }
            }
        }
        return null;
    }

    public Primitive findPrimInLibsById(double primId, double libId) {
        if (primId <= 0.0) {
            return null;
        }
        Primitive prim = this.internalPrimById(primId);
        if (prim == null) {
            prim = this.primById(primId, libId);
        }
        if (prim == null) {
            prim = this.primById(primId);
        }
        return prim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Primitive internalPrimById(double primId) {
        if (primId <= 0.0) {
            return null;
        }
        if (this.internalLib == null) {
            return null;
        }
        PrimLibrary primLibrary = this.internalLib;
        synchronized (primLibrary) {
            return this.internalLib.Primitives.get(primId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Primitive primById(double primId, double libId) {
        if (primId <= 0.0 || libId <= 0.0) {
            return null;
        }
        PrimLibrary lib = this.PrimLibraries.get(libId);
        if (lib == null) {
            return null;
        }
        PrimLibrary primLibrary = lib;
        synchronized (primLibrary) {
            return lib.Primitives.get(primId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemeObject shapeByXY(double x, double y, boolean bindOnly, boolean ignoreTexts, String layersConfig) {
        SchemeObject res = null;
        if (this.KeepSort) {
            SchemeObject LayerObject = null;
            double OldLayerID = 0.0;
            boolean LayerVisible = false;
            SchemeObject i = null;
            for (int j = 0; j < this.SortShapes.size(); ++j) {
                SchemeObject schemeObject = i = this.SortShapes.get(j);
                synchronized (schemeObject) {
                    if (!(i.BG == null || ignoreTexts && SchemeObjectsTypes.ObjTypeIsText(i.getType()))) {
                        if (i.BG.LayerID != OldLayerID) {
                            OldLayerID = i.BG.LayerID;
                            LayerObject = this.schemeObjects.get(i.BG.LayerID);
                            if (LayerObject != null) {
                                SchemeObject schemeObject2 = LayerObject;
                                synchronized (schemeObject2) {
                                    LayerVisible = LayerObject.BG != null && ((PhxLayer)LayerObject.BG).getConfigVisible(layersConfig);
                                }
                            }
                        }
                        if (LayerVisible && x >= i.BG.Left && x <= i.BG.Right && y >= i.BG.Top && y <= i.BG.Bottom && (!bindOnly || this.objIDByShapeID(i.getID()) != 0.0)) {
                            res = i;
                            break;
                        }
                    }
                    continue;
                }
            }
        }
        return res;
    }

    public SchemeObject layerByIndex(int index) {
        SchemeObject res = null;
        if (this.KeepSort && index >= 0 && index < this.SortLayers.size()) {
            res = this.SortLayers.get(index);
        }
        return res;
    }

    public SchemeObject layerById(double layerId) {
        SchemeObject res = null;
        for (int i = 0; i < this.SortLayers.size(); ++i) {
            if (this.SortLayers.get(i).getID() != layerId) continue;
            return this.SortLayers.get(i);
        }
        return res;
    }

    public synchronized double getSchemeLeft() {
        return this.SchemeLeft;
    }

    public synchronized double getSchemeTop() {
        return this.SchemeTop;
    }

    public synchronized double getSchemeRight() {
        return this.SchemeRight;
    }

    public synchronized double getSchemeBottom() {
        return this.SchemeBottom;
    }

    public double getSchemeWidth() {
        return this.SchemeWidth;
    }

    public double getSchemeHeight() {
        return this.SchemeHeight;
    }

    public SchemePageLayout getPageLayout() {
        if (this.pageLayout == null) {
            this.pageLayout = new SchemePageLayout();
        }
        return this.pageLayout;
    }

    public SchemePageNotes getPageNotes() {
        if (this.pageNotes == null) {
            this.pageNotes = new SchemePageNotes();
        }
        return this.pageNotes;
    }

    public SchemePage getPageById(double id, boolean normalize) {
        if (normalize && id == 0.0) {
            id = SchemePage.DEF_PAGE_ID;
        }
        return this.Pages.get(id);
    }

    public SchemeObject createPropObject(int objType) throws IOException {
        SchemeObject obj = new SchemeObject(objType, objType);
        byte[] propParamsTrue = new byte[]{1};
        byte[] propParamsFalse = new byte[]{0};
        switch (objType) {
            case -1: {
                obj.setParams(LittleEndian.intToBinary(this.hitPrecision));
                break;
            }
            case -2: {
                obj.setParams(LittleEndian.doubleToBinary(this.gridStepX));
                break;
            }
            case -3: {
                obj.setParams(LittleEndian.doubleToBinary(this.gridStepY));
                break;
            }
            case -4: {
                obj.setParams(this.mapGridStepX == null ? null : this.mapGridStepX.getBytes(Charset.forName("UTF-8")));
                break;
            }
            case -5: {
                obj.setParams(this.mapGridStepY == null ? null : this.mapGridStepY.getBytes(Charset.forName("UTF-8")));
                break;
            }
            case -6: {
                obj.setParams(LittleEndian.intToBinary(this.hitPrecision));
                break;
            }
            case -21: {
                obj.setParams(new byte[]{this.primInsFlags});
                break;
            }
            case -7: {
                obj.setParams(LittleEndian.doubleToBinary(this.zoomingStep));
                break;
            }
            case -8: {
                obj.setParams(this.snapToGrid ? propParamsTrue : propParamsFalse);
                break;
            }
            case -9: {
                obj.setParams(this.snapToMapGrid ? propParamsTrue : propParamsFalse);
                break;
            }
            case -10: {
                obj.setParams(this.snapToNearest ? propParamsTrue : propParamsFalse);
                break;
            }
            case -11: {
                obj.setParams(this.showGrid ? propParamsTrue : propParamsFalse);
                break;
            }
            case -12: {
                obj.setParams(this.showMapGrid ? propParamsTrue : propParamsFalse);
                break;
            }
            case -13: {
                obj.setParams(this.showPrimInsDialog ? propParamsTrue : propParamsFalse);
                break;
            }
            case -22: {
                obj.setParams(new byte[]{this.schemeAlign});
                break;
            }
            case -23: {
                obj.setParams(LittleEndian.intToBinary(this.units));
                break;
            }
            case -14: {
                obj.setParams(LittleEndian.intToBinary(this.undoRedoDeepnes));
                break;
            }
            case -15: {
                obj.setParams(LittleEndian.doubleToBinary(this.zoomSensivity));
                break;
            }
            case -16: {
                obj.setParams(LittleEndian.intToBinary(this.BkColor.getBlue() << 16 | this.BkColor.getGreen() << 8 | this.BkColor.getRed()));
                break;
            }
            case -27: {
                obj.setParams(LittleEndian.intToBinary(this.insMethod));
                break;
            }
            case -18: {
                obj.setParams(this.drawArrows ? propParamsTrue : propParamsFalse);
                break;
            }
            case -19: {
                obj.setParams(LittleEndian.doubleToBinary(this.reperPrimId));
                break;
            }
            case -20: {
                obj.setParams(LittleEndian.doubleToBinary(this.viewForm));
                break;
            }
            case -31: {
                obj.setParams(this.needBlink ? propParamsTrue : propParamsFalse);
                break;
            }
            case -32: {
                obj.setParams(this.showShapeHint ? propParamsTrue : propParamsFalse);
                break;
            }
            case -33: {
                obj.setParams(this.snapPoints ? propParamsTrue : propParamsFalse);
                break;
            }
            case -24: {
                obj.setParams(this.script == null ? null : this.script.getBytes());
                break;
            }
            case -25: {
                obj.setParams(this.transparentSelection ? propParamsTrue : propParamsFalse);
                break;
            }
            case -26: {
                obj.setParams(this.solveConflicts ? propParamsTrue : propParamsFalse);
                break;
            }
            case -29: {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(os);
                writer.putDouble(151, 0.0);
                writer.putInt32(162, 0);
                writer.putInt32(163, 0);
                writer.putDouble(151, 0.0);
                writer.flush();
                obj.setParams(os.toByteArray());
                break;
            }
            case -28: {
                break;
            }
            case -30: {
                obj.setParams(LittleEndian.doubleToBinary(this.dimStyleId));
                break;
            }
            case -34: {
                SchemePageLayout pLayout = this.getPageLayout();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(os);
                pLayout.store(writer);
                writer.flush();
                obj.setParams(os.toByteArray());
                break;
            }
            default: {
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u0445\u0435\u043c\u044b: " + objType);
            }
        }
        return obj;
    }

    private static class ConnPointHashEntry {
        public int _shapeType;
        public int _shapeIndex;

        public ConnPointHashEntry(int shapeType, int shapeIndex) {
            this._shapeType = shapeType;
            this._shapeIndex = shapeIndex;
        }
    }
}

