/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.schemes.OdgReader;
import inform.agent.schemes.VisioOldFormatsConverter;
import inform.agent.schemes.VsdxReader;

public class SchemeImportRequest
extends Request {
    public static final int IMPORT_FORMAT_AVES = 0;
    public static final int IMPORT_FORMAT_VSDX = 1;
    public static final int IMPORT_FORMAT_AVELIB = 2;
    public static final int IMPORT_FORMAT_VSSX = 3;
    public static final int IMPORT_FORMAT_WMF = 4;
    public static final int IMPORT_FORMAT_VSD = 5;
    public static final int IMPORT_FORMAT_VSS = 7;
    public static final int IMPORT_FORMAT_ODG = 14;
    public static final int IMPORT_FORMAT_FODG = 16;

    public SchemeImportRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader reader = this.createRequestContentReader();
        byte[] content = null;
        int ext = 0;
        boolean importHiddenPaths = false;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 104: {
                    content = reader.getRaw();
                    break;
                }
                case 105: {
                    ext = reader.getInt();
                    break;
                }
                case 107: {
                    importHiddenPaths = reader.getBoolean();
                }
            }
        }
        byte[] result = null;
        switch (ext) {
            case 1: 
            case 5: {
                if (ext == 5) {
                    VisioOldFormatsConverter vsdToVsdxConverter = new VisioOldFormatsConverter(this);
                    content = vsdToVsdxConverter.convertOldVisioFormatToNew(content, VisioOldFormatsConverter.SaveFormat.VSDX);
                }
                VsdxReader converter = new VsdxReader();
                converter.setStateHost(this);
                converter.setUserId(this.rq.client.getEffectiveUserId());
                converter.setImportHiddenPaths(importHiddenPaths);
                if (ext == 5) {
                    converter.setImportFromOldFormat();
                }
                result = converter.importVsdx(content);
                break;
            }
            case 3: 
            case 7: {
                if (ext == 7) {
                    VisioOldFormatsConverter vssToVssxConverter = new VisioOldFormatsConverter(this);
                    content = vssToVssxConverter.convertOldVisioFormatToNew(content, VisioOldFormatsConverter.SaveFormat.VSSX);
                }
                VsdxReader converter = new VsdxReader();
                converter.setStateHost(this);
                converter.setUserId(this.rq.client.getEffectiveUserId());
                converter.setImportHiddenPaths(importHiddenPaths);
                if (ext == 7) {
                    converter.setImportFromOldFormat();
                }
                result = converter.importVssx(content);
                break;
            }
            case 4: {
                VsdxReader converter = new VsdxReader();
                converter.setStateHost(this);
                converter.setUserId(this.rq.client.getEffectiveUserId());
                result = converter.importWmf(content);
                break;
            }
            case 14: 
            case 16: {
                OdgReader odgReader = new OdgReader();
                odgReader.setStateHost(this);
                odgReader.setUserId(this.rq.client.getEffectiveUserId());
                result = odgReader.importOdg(content, ext == 16);
            }
        }
        if (result != null) {
            this.sendResult(result);
        } else {
            this.sendResult();
        }
    }
}

