/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.VersionInfo;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.schemes.AddObjectCommand;
import inform.agent.schemes.EndTransactionCommand;
import inform.agent.schemes.ModificationCommand;
import inform.agent.schemes.NoSuchObjectException;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemesManager;
import inform.agent.schemes.StartTransactionCommand;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

public class SchemeModificationRequest
extends Request {
    public SchemeModificationRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        boolean ClientShapesOrdered = false;
        if (this.rq != null && this.rq.client != null) {
            VersionInfo VInfo = this.rq.client.getVersion();
            boolean bl = ClientShapesOrdered = VInfo != null && VInfo.toNumber() >= 0x50000CCL;
        }
        if (!ClientShapesOrdered) {
            this.sendError("\u0414\u043b\u044f \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0441\u0445\u0435\u043c\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e \u043a\u043b\u0438\u0435\u043d\u0442\u0430", "");
            return;
        }
        if (this.getNodeID() > 0.0 && Ini.libraryMode) {
            return;
        }
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        TaggedWriter resultWriter = new TaggedWriter(resultStream);
        Scheme scheme = null;
        ConnectionManager dbMgr = new ConnectionManager(null, "rq:SchemeModificationRequest");
        try {
            boolean saved = false;
            try {
                SchemeKeepSettings NewKeepSettings = null;
                TaggedReader reqReader = this.createRequestContentReader();
                if (this.getNodeID() > 0.0) {
                    scheme = SchemesManager.getScheme(MtdEngine.getValidNode(this.getNodeID()).getRealNode(), dbMgr.getSSHost(), null);
                } else {
                    byte[] locationData = new byte[20];
                    reqReader.get(1, locationData, locationData.length);
                    double tableID = LittleEndian.getDouble(locationData, 0);
                    double recordID = LittleEndian.getDouble(locationData, 8);
                    int fieldID = LittleEndian.getInt(locationData, 16);
                    int dateFieldID = 0;
                    if (reqReader.getNextTag() == 49 && (NewKeepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader())) != null) {
                        dateFieldID = NewKeepSettings.getSchemeDate();
                    }
                    scheme = SchemesManager.getScheme(null, dbMgr, tableID, recordID, fieldID, dateFieldID, NewKeepSettings);
                }
                scheme.setKeepSettingsOld(scheme.getKeepSettings());
                if (NewKeepSettings != null) {
                    scheme.setKeepSettings(NewKeepSettings);
                } else {
                    scheme.setKeepSettings(null);
                }
                int clientRevision = reqReader.getInt(11);
                int schemeOldRevision = scheme.getRevision().getAndIncrement();
                int schemeNewRevision = schemeOldRevision + 1;
                resultWriter.putInt32(11, schemeNewRevision);
                if (scheme.getKeepSettings() != null) {
                    scheme.saveKeepSettings(resultWriter);
                }
                Core.logger.debug("Modifying scheme {} -> {}, client revision {}", new Object[]{schemeOldRevision, schemeNewRevision, clientRevision});
                scheme.acquireForModification();
                try {
                    LinkedList<ModificationCommand> modifications = new LinkedList<ModificationCommand>();
                    State state = State.NOT_IN_TRANSACTION;
                    int tag = reqReader.getNextTag();
                    block37: while (tag != 0) {
                        ModificationCommand cmd = ModificationCommand.createCommand(tag);
                        switch (state) {
                            case NOT_IN_TRANSACTION: {
                                SchemeObject so;
                                if (cmd instanceof StartTransactionCommand) {
                                    cmd.log();
                                    state = State.FORMING_TRANSACTION;
                                    tag = reqReader.getNextTag();
                                    break;
                                }
                                cmd.setSubjectDescriptor(SchemeObject.readDescriptor(reqReader, scheme));
                                cmd.log("Read");
                                boolean AddNewObj = false;
                                boolean CommandAllowed = false;
                                double AddObjID = 0.0;
                                if (cmd instanceof AddObjectCommand && (so = cmd.getSubjectDescriptor()) != null) {
                                    AddObjID = so.getID();
                                    AddNewObj = scheme.getObjectSilent(AddObjID) == null;
                                }
                                try {
                                    cmd.lockObject(scheme, this.getHostID());
                                    try {
                                        if (this.executeCommand(scheme, schemeNewRevision, cmd, resultWriter) && !(cmd instanceof StartTransactionCommand) && !(cmd instanceof EndTransactionCommand) && cmd.getLockedObject() != null) {
                                            resultWriter.putDouble(100, cmd.getLockedObject().getID());
                                            CommandAllowed = true;
                                        }
                                    }
                                    finally {
                                        try {
                                            cmd.unlockObject(scheme, this.getHostID());
                                        }
                                        catch (Throwable ex) {
                                            Core.logger.error(null, ex);
                                        }
                                    }
                                }
                                finally {
                                    if (AddNewObj && !CommandAllowed && (so = scheme.getObjectSilent(AddObjID)) != null) {
                                        so.setDeleted(true);
                                    }
                                }
                                tag = reqReader.getNextTag();
                                break;
                            }
                            case FORMING_TRANSACTION: {
                                if (cmd instanceof EndTransactionCommand) {
                                    cmd.log();
                                    state = State.IN_TRANSACTION;
                                    break;
                                }
                                cmd.setSubjectDescriptor(SchemeObject.readDescriptor(reqReader, scheme));
                                cmd.log("Read");
                                modifications.add(cmd);
                                tag = reqReader.getNextTag();
                                if (tag != 0) break;
                                throw new InformException("\u041d\u0435\u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u0430\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f");
                            }
                            case IN_TRANSACTION: {
                                SchemeObject so;
                                boolean TransactionAllowed = false;
                                ArrayList<Double> DbIds = new ArrayList<Double>();
                                for (ModificationCommand modificationCommand : modifications) {
                                    if (!(modificationCommand instanceof AddObjectCommand) || (so = modificationCommand.getSubjectDescriptor()) == null || scheme.getObjectSilent(so.getID()) != null) continue;
                                    DbIds.add(so.getID());
                                }
                                try {
                                    this.lockObjects(scheme, modifications);
                                    try {
                                        boolean allModificationsAllowed = true;
                                        for (ModificationCommand c : modifications) {
                                            if (allModificationsAllowed = allModificationsAllowed && c.isModificationAllowed(scheme)) continue;
                                            c.log("Transaction rollback due to");
                                            break;
                                        }
                                        if (allModificationsAllowed) {
                                            for (ModificationCommand c : modifications) {
                                                if (!this.executeCommand(scheme, schemeNewRevision, c, resultWriter) || c instanceof StartTransactionCommand || c instanceof EndTransactionCommand || c.getLockedObject() == null) continue;
                                                resultWriter.putDouble(100, c.getLockedObject().getID());
                                            }
                                            TransactionAllowed = true;
                                        }
                                    }
                                    finally {
                                        try {
                                            this.unlockObjects(scheme, modifications);
                                            modifications.clear();
                                        }
                                        catch (Throwable ex) {
                                            Core.logger.error(null, ex);
                                        }
                                    }
                                    tag = reqReader.getNextTag();
                                    state = State.NOT_IN_TRANSACTION;
                                    if (TransactionAllowed) break;
                                }
                                catch (Throwable throwable) {
                                    if (!TransactionAllowed) {
                                        for (int i = 0; i < DbIds.size(); ++i) {
                                            SchemeObject so2 = scheme.getObjectSilent((Double)DbIds.get(i));
                                            if (so2 == null) continue;
                                            so2.setDeleted(true);
                                        }
                                    }
                                    throw throwable;
                                }
                                for (int i = 0; i < DbIds.size(); ++i) {
                                    SchemeObject schemeObject = scheme.getObjectSilent((Double)DbIds.get(i));
                                    if (schemeObject == null) continue;
                                    schemeObject.setDeleted(true);
                                }
                                continue block37;
                            }
                        }
                    }
                }
                finally {
                    scheme.Parsed = false;
                    scheme.BoundsCalculated = false;
                    scheme.Sorted = false;
                    try {
                        scheme.releaseFromModification();
                        reqReader = null;
                    }
                    catch (Throwable ex) {
                        Core.logger.error(null, ex);
                    }
                }
                saved = SchemesManager.trySaveScheme(null, dbMgr, this, scheme);
            }
            finally {
                if (scheme != null) {
                    if (saved) {
                        scheme.setKeepSettingsOld(scheme.getKeepSettings());
                    } else {
                        scheme.setKeepSettings(scheme.getKeepSettingsOld());
                    }
                }
            }
        }
        finally {
            dbMgr.release();
        }
        resultWriter.flush();
        this.sendResult(resultStream.internalBuffer(), resultStream.size());
        scheme.logObjects();
    }

    private boolean executeCommand(Scheme scheme, int schemeNewRevision, ModificationCommand cmd, TaggedWriter result) throws InterruptedException {
        try {
            cmd.setSessionSchemeRevision(schemeNewRevision);
            if (cmd.isModificationAllowed(scheme)) {
                cmd.log("Executing");
                cmd.run(scheme, this);
                return true;
            }
            cmd.log("Not allowed");
            return false;
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            StringBuilder bldr = new StringBuilder(ex.getMessage());
            bldr.append("Stack trace:\n");
            bldr.append(writer.toString());
            Core.logger.debug("Modification command error {}", bldr.toString(), ex);
            return false;
        }
    }

    private void lockObjects(Scheme scheme, LinkedList<ModificationCommand> modifications) throws InterruptedException, NoSuchObjectException {
        try {
            for (ModificationCommand cmd : modifications) {
                cmd.lockObject(scheme, this.getHostID());
            }
        }
        catch (InterruptedException ex) {
            try {
                this.unlockObjects(scheme, modifications);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw ex;
        }
    }

    private void unlockObjects(Scheme scheme, LinkedList<ModificationCommand> modifications) {
        for (ModificationCommand cmd : modifications) {
            cmd.unlockObject(scheme, this.getHostID());
        }
    }

    private static enum State {
        NOT_IN_TRANSACTION,
        FORMING_TRANSACTION,
        IN_TRANSACTION,
        END;

    }
}

