/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemesManager;
import java.io.IOException;

public class SchemeOpenRequest
extends Request {
    public SchemeOpenRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] Content2;
        TaggedReader reqReader = this.createRequestContentReader();
        ConnectionManager dbMgr = new ConnectionManager(null, "rq:SchemeOpenRequest");
        try {
            this.putRequestStateText("\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0445\u0435\u043c\u044b");
            Content2 = this.openScheme(dbMgr, reqReader);
        }
        finally {
            dbMgr.release();
        }
        this.putRequestStateText("\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430");
        if (Content2 != null) {
            this.sendResult(Content2);
        } else {
            this.sendResult();
        }
    }

    private byte[] openScheme(ConnectionManager dbMgr, TaggedReader reqReader) throws InformException, IOException, TaggedReaderException, Exception {
        byte[] Content2 = null;
        Scheme scheme = null;
        boolean NeedParse = true;
        if (this.getNodeID() > 0.0) {
            if (!Ini.libraryMode) {
                scheme = SchemesManager.getScheme(MtdEngine.getValidNode(this.getNodeID()).getRealNode(), false, dbMgr.getSSHost(), null);
            }
            boolean bl = NeedParse = scheme != null && scheme.getRevision().get() > 0 && scheme.schemeOrdered();
            if (!NeedParse) {
                Content2 = SchemesManager.openScheme(this.getNodeID());
            }
        } else {
            byte[] locationData = new byte[20];
            reqReader.get(1, locationData, locationData.length);
            double tableID = LittleEndian.getDouble(locationData, 0);
            double recordID = LittleEndian.getDouble(locationData, 8);
            int fieldID = LittleEndian.getInt(locationData, 16);
            int dateFieldID = 0;
            SchemeKeepSettings NewKeepSettings = null;
            if (reqReader.getNextTag() == 49 && (NewKeepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader())) != null) {
                dateFieldID = NewKeepSettings.getSchemeDate();
            }
            boolean bl = NeedParse = (scheme = SchemesManager.getScheme(null, dbMgr, tableID, recordID, fieldID, dateFieldID, false, true, NewKeepSettings)) != null && scheme.getRevision().get() > 0 && scheme.schemeOrdered();
            if (!NeedParse) {
                Content2 = SchemesManager.openScheme(null, dbMgr, tableID, recordID, fieldID);
            }
        }
        if (NeedParse) {
            this.putRequestStateText("\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            scheme.saveAll(out, null, true, false);
            Content2 = out.toByteArray();
        }
        return Content2;
    }
}

