/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectFilter;
import inform.agent.schemes.SchemesManager;
import java.io.IOException;
import java.util.HashSet;

public class SchemeUpdatesRequest
extends Request {
    public SchemeUpdatesRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Scheme scheme;
        TaggedReader reqReader = this.createRequestContentReader();
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        ConnectionManager dbMgr = new ConnectionManager(null, "rq:SchemeUpdatesRequest");
        try {
            scheme = this.openScheme(dbMgr, reqReader);
        }
        finally {
            dbMgr.release();
        }
        int clientRevision = 0;
        boolean SameStartTime = false;
        HashSet<Integer> ignoredRevisions = new HashSet<Integer>();
        int tag = reqReader.getNextTag();
        while (tag != 0) {
            switch (tag) {
                case 11: {
                    clientRevision = reqReader.getInt();
                    break;
                }
                case 12: {
                    ignoredRevisions.add(reqReader.getInt());
                    break;
                }
                case 14: {
                    SameStartTime = reqReader.getDouble() == scheme.GetStartTime();
                }
            }
            tag = reqReader.getNextTag();
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("Update requested, client has revision ");
        bldr.append(clientRevision);
        bldr.append(", and wants to ignore revisions ");
        for (Integer ir : ignoredRevisions) {
            bldr.append(ir);
            bldr.append(" ");
        }
        Core.logger.debug(bldr.toString());
        scheme.acquireForSaving();
        try {
            scheme.saveAll(resultStream, new RevisionObjectsFilter(clientRevision, ignoredRevisions), SameStartTime);
        }
        finally {
            try {
                scheme.releaseFromSaving();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
        this.sendResult(resultStream.internalBuffer(), resultStream.size());
    }

    private Scheme openScheme(ConnectionManager dbMgr, TaggedReader reqReader) throws Exception, InformException, IOException, TaggedReaderException {
        Scheme scheme = null;
        if (this.getNodeID() > 0.0) {
            if (!Ini.libraryMode) {
                scheme = SchemesManager.getScheme(MtdEngine.getValidNode(this.getNodeID()).getRealNode(), dbMgr.getSSHost(), null);
            }
        } else {
            byte[] locationData = new byte[20];
            reqReader.get(1, locationData, locationData.length);
            double tableID = LittleEndian.getDouble(locationData, 0);
            double recordID = LittleEndian.getDouble(locationData, 8);
            int fieldID = LittleEndian.getInt(locationData, 16);
            int dateFieldID = 0;
            SchemeKeepSettings NewKeepSettings = null;
            if (reqReader.getNextTag() == 49 && (NewKeepSettings = new SchemeKeepSettings(reqReader.getSubStreamReader())) != null) {
                dateFieldID = NewKeepSettings.getSchemeDate();
            }
            scheme = SchemesManager.getScheme(null, dbMgr, tableID, recordID, fieldID, dateFieldID, NewKeepSettings);
        }
        return scheme;
    }

    private static class RevisionObjectsFilter
    implements SchemeObjectFilter {
        private int clientRevision;
        private HashSet<Integer> ignoredRevisions;

        public RevisionObjectsFilter(int clientRevision, HashSet<Integer> ignoredRevisions) {
            this.clientRevision = clientRevision;
            this.ignoredRevisions = ignoredRevisions;
        }

        @Override
        public boolean fits(SchemeObject object) {
            int objectRevision = object.getRevision();
            return objectRevision > this.clientRevision && !this.ignoredRevisions.contains(objectRevision);
        }
    }
}

