/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TableCell;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Table
extends GraphicBlock {
    public double SideX = 0.0;
    public double SideY = 0.0;
    public Color bColor = null;
    public Color BkColor = null;
    public double lWidth = -1.0;
    public int PenPattern = -1;
    public int BrushPattern = -1;
    public int Transparent = 0;
    public int TransparentBorder = 0;
    public Color pColor = null;
    public DoubleList widths = new DoubleList(2);
    public DoubleList heights = new DoubleList(2);
    public ArrayList<TableCell> row = null;
    public ArrayList<ArrayList<TableCell>> rows = new ArrayList();
    public static final int TAG_HEIGHT_ROW = 1;
    public static final int TAG_WIDTH_COLUMN = 2;
    public static final int TAG_CELL = 3;
    public static final int TAG_CELL_ROW_SPAN = 4;
    public static final int TAG_CELL_COL_SPAN = 5;
    public static final int TAG_CELL_TEXT = 6;
    public static final int TAG_CELL_COLOR = 7;
    public static final int TAG_CELL_BKCOLOR = 8;
    public static final int TAG_CELL_BRUSH_PATTERN = 9;
    public static final int TAG_CELL_ALIGN = 10;
    public static final int TAG_CELL_VERT_ALIGN = 11;
    public static final int TAG_CELL_FONT_NAME = 12;
    public static final int TAG_CELL_FONT_STYLE = 13;
    public static final int TAG_CELL_FONT_COLOR = 14;
    public static final int TAG_CELL_FONT_HEIGHT = 15;
    public static final int TAG_CELL_TEXT_ANGLE = 16;
    public static final int TAG_CELL_WIDTH_SCALE = 20;
    public static final int TAG_CELL_LINE_SPACING = 21;
    public static final int TAG_CELL_MULTI_STYLE_TEXT = 22;
    public static final int TAG_CELL_TRANSPARENT_TEXT = 23;
    public static final int TAG_CELL_SIMPLE_STYLE_TEXT = 24;
    public static final int TAG_CELL_LEFT_MARGIN = 25;
    public static final int TAG_CELL_RIGHT_MARGIN = 26;
    public static final int TAG_CELL_TOP_MARGIN = 27;
    public static final int TAG_CELL_BOTTOM_MARGIN = 28;
    public static final int TAG_CELL_SIDES = 29;
    public static final int TAG_CELL_EXPORT_SIDE_X = 30;
    public static final int TAG_CELL_EXPORT_SIDE_Y = 31;

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
    }

    private void parseAsBaseShape(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 30: {
                    this.bColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 31: {
                    this.pColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 32: {
                    this.BkColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 33: {
                    this.PenPattern = reader.getInt();
                    break;
                }
                case 34: {
                    this.BrushPattern = reader.getInt();
                    break;
                }
                case 35: {
                    this.lWidth = reader.getDouble();
                    break;
                }
                case 145: {
                    this.Transparent = Byte.toUnsignedInt(reader.getByte());
                    break;
                }
                case 146: {
                    this.TransparentBorder = Byte.toUnsignedInt(reader.getByte());
                }
            }
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            if (reader.getCurrentTag() != 3) continue;
            byte[] data = reader.getRaw();
            TaggedReader StreamReader = new TaggedReader(new ByteArrayInputStream(data), data.length);
            this.parseAsBaseShape(Parser2, StreamReader);
            StreamReader = new TaggedReader(new ByteArrayInputStream(data), data.length);
            super.parse(Parser2, StreamReader);
        }
    }

    private void applyTablePropertiesToCell(TableCell cell) {
        if (cell == null) {
            return;
        }
        cell.bColor = this.bColor;
        cell.pColor = this.pColor;
        cell.BkColor = this.BkColor;
        cell.PenPattern = this.PenPattern;
        cell.BrushPattern = this.BrushPattern;
        cell.lWidth = this.lWidth;
        cell.Transparent = this.Transparent;
        cell.TransparentBorder = this.TransparentBorder;
        cell.LayerID = this.LayerID;
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        Paragraph cell = null;
        if (tag == 5) {
            TaggedReader subReader = reader.getStreamReader();
            int cellCount = 0;
            boolean firstText = true;
            block11: while (subReader.getNextTag() != 0) {
                switch (subReader.getCurrentTag()) {
                    case 1: {
                        double dblBuff = subReader.getDouble();
                        this.heights.add(dblBuff);
                        continue block11;
                    }
                    case 2: {
                        double dblBuff = subReader.getDouble();
                        this.widths.add(dblBuff);
                        continue block11;
                    }
                    case 3: {
                        if (cell != null) {
                            ++cellCount;
                            if (Strings.isVoid(cell.getText())) {
                                ((TableCell)cell).Lines.addLine(" ");
                            }
                            ((TableCell)cell).Lines.applyFontToLines();
                            this.row.add((TableCell)cell);
                        }
                        cell = new TableCell();
                        firstText = true;
                        this.applyTablePropertiesToCell((TableCell)cell);
                        if (cellCount % this.widths.size() != 0) continue block11;
                        if (this.row != null) {
                            this.rows.add(this.row);
                        }
                        this.row = new ArrayList();
                        continue block11;
                    }
                    case 4: {
                        if (cell == null) continue block11;
                        ((TableCell)cell).rowSpan = subReader.getInt();
                        continue block11;
                    }
                    case 5: {
                        if (cell == null) continue block11;
                        ((TableCell)cell).colSpan = subReader.getInt();
                        continue block11;
                    }
                    case 6: {
                        if (cell == null) continue block11;
                        if (firstText) {
                            if (!((TableCell)cell).Lines.isEmpty()) {
                                ((TableCell)cell).Lines.remove(0);
                            }
                            firstText = false;
                        }
                        String str = subReader.getString();
                        ((TableCell)cell).Lines.addLine(str);
                        continue block11;
                    }
                    case 24: {
                        RectTextLine line;
                        if (cell == null) continue block11;
                        subReader.skip();
                        TaggedReader styleReader = subReader.getStreamReader(202);
                        while (styleReader.next()) {
                            line = (RectTextLine)((TableCell)cell).Lines.get(((TableCell)cell).Lines.size() - 1);
                            line.readExtraTaggedLines(styleReader, styleReader.getCurrentTag(), cell);
                        }
                        continue block11;
                    }
                    case 22: {
                        RectTextLine line;
                        if (cell == null) continue block11;
                        if (firstText) {
                            if (!((TableCell)cell).Lines.isEmpty()) {
                                ((TableCell)cell).Lines.remove(0);
                            }
                            firstText = false;
                        }
                        subReader.skip();
                        TaggedReader styleReader = subReader.getStreamReader(202);
                        while (styleReader.next()) {
                            line = ((TableCell)cell).Lines.addLine("");
                            line.readExtraTaggedLines(styleReader, styleReader.getCurrentTag(), cell);
                            if (!Strings.isVoid(line.Text)) continue;
                            line.Text = line.getPartsLineText();
                        }
                        continue block11;
                    }
                    case 29: {
                        if (cell == null || ((TableCell)cell).Lines.isEmpty()) continue block11;
                        RectTextLine line = (RectTextLine)((TableCell)cell).Lines.get(((TableCell)cell).Lines.size() - 1);
                        byte[] tmpBytes = subReader.getRaw();
                        line.SideX = LittleEndian.getDouble(tmpBytes, 0);
                        if (line.SideX < 0.0) {
                            line.SideX = Math.abs(line.SideX);
                        }
                        line.SideY = LittleEndian.getDouble(tmpBytes, 8);
                        if (!(line.SideY < 0.0)) continue block11;
                        line.SideY = Math.abs(line.SideY);
                        continue block11;
                    }
                }
                if (cell == null) continue;
                ((TableCell)cell).loadTag(parser, subReader);
            }
        } else {
            super.readExtraTagged(parser, reader, tag);
        }
        if (this.row != null) {
            if (cell != null) {
                if (Strings.isVoid(cell.getText())) {
                    ((TableCell)cell).Lines.addLine(" ");
                }
                ((TableCell)cell).Lines.applyFontToLines();
                this.row.add((TableCell)cell);
            }
            this.rows.add(this.row);
            this.row = null;
        }
        for (int r = 0; r < this.heights.size(); ++r) {
            for (int c = 0; c < this.widths.size(); ++c) {
                TableCell currentCell = this.getCell(r, c);
                if (currentCell == null || currentCell.colSpan <= 1 && currentCell.rowSpan <= 1) continue;
                for (int rr = r; rr < r + currentCell.rowSpan; ++rr) {
                    for (int cc = c; cc < c + currentCell.colSpan; ++cc) {
                        TableCell currentCell2;
                        if (rr == r && cc == c || (currentCell2 = this.getCell(rr, cc)) == null) continue;
                        currentCell2.spanning = true;
                    }
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(stream);
        SchemeUtils.writeColor(w, 31, this.pColor);
        if (this.PenPattern != -1) {
            w.putInt32(33, this.PenPattern);
        }
        if (this.lWidth != -1.0) {
            w.putDouble(35, this.lWidth);
        }
        super.writeTaggedDataAsShape(w, clipboard, simult);
        w.flush();
        if (stream.size() > 0) {
            writer.putRaw(3, stream);
        }
    }

    @Override
    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        int i;
        if (writer == null) {
            return;
        }
        super.writeExtraTagged(writer);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(stream);
        int cnt = this.heights.size();
        for (i = 0; i < cnt; ++i) {
            w.putDouble(1, this.heights.get(i));
        }
        cnt = this.widths.size();
        for (i = 0; i < cnt; ++i) {
            w.putDouble(2, this.widths.get(i));
        }
        for (ArrayList<TableCell> r : this.rows) {
            block3: for (TableCell cell : r) {
                w.putEmpty(3);
                if (cell.rowSpan > 1) {
                    w.putInt32(4, cell.rowSpan);
                }
                if (cell.colSpan > 1) {
                    w.putInt32(5, cell.colSpan);
                }
                int count = cell.Lines.size();
                cell.writeCellTaggedData(w);
                for (int i2 = 0; i2 < count; ++i2) {
                    RectTextLine rtl = (RectTextLine)cell.Lines.get(i2);
                    if (rtl.Parts.isEmpty()) {
                        boolean blank;
                        String str = rtl.Text;
                        boolean bl = blank = i2 == 0 && count == 1 && str.isBlank();
                        if (blank) continue block3;
                        w.putAnsi(6, str);
                        ByteArrayOutputStream subStream = new ByteArrayOutputStream();
                        TaggedWriter sw = new TaggedWriter(subStream);
                        rtl.writeExtraTaggedLine(sw, cell);
                        sw.flush();
                        if (subStream.size() <= 0) continue;
                        w.putRaw(24, subStream);
                        w.putRaw(202, subStream);
                        continue;
                    }
                    ByteArrayOutputStream subStream = new ByteArrayOutputStream();
                    TaggedWriter sw = new TaggedWriter(subStream);
                    rtl.writeExtraTaggedLine(sw, cell);
                    sw.flush();
                    if (subStream.size() <= 0) continue;
                    w.putRaw(22, subStream);
                    w.putRaw(202, subStream);
                }
            }
        }
        w.flush();
        if (stream.size() > 0) {
            writer.putRaw(5, stream);
        }
    }

    @Override
    protected void afterParse() {
        this.MinPtX = this.Left;
        this.MaxPtX = this.Right;
        this.MinPtY = this.Bottom;
        this.MaxPtY = this.Top;
        this.applySettings();
    }

    private void applySettings() {
        this.SideX = this.getSideX();
        this.SideY = this.getSideY();
        BaseGraphic.RealPoint nextPos = new BaseGraphic.RealPoint(0.0, 0.0);
        BaseGraphic.RealPoint prevPos = new BaseGraphic.RealPoint(0.0, 0.0);
        for (int r = 0; r < this.heights.size(); ++r) {
            double h = this.heights.get(r);
            nextPos.X = 0.0;
            nextPos.Y += h;
            prevPos.X = 0.0;
            for (int c = 0; c < this.widths.size(); ++c) {
                double w = this.widths.get(c);
                double wPart = 0.0;
                double hPart = 0.0;
                TableCell cell = this.getCell(r, c);
                if (cell != null && (cell.colSpan > 1 || cell.rowSpan > 1)) {
                    for (int rs = 1; rs < cell.rowSpan; ++rs) {
                        hPart += this.heights.get(r + rs);
                    }
                    for (int cs = 1; cs < cell.colSpan; ++cs) {
                        wPart += this.widths.get(c + cs);
                    }
                }
                BaseGraphic.RealRect rect = new BaseGraphic.RealRect();
                nextPos.X += w;
                rect.Left = prevPos.X;
                rect.Right = nextPos.X + wPart;
                rect.Top = prevPos.Y;
                rect.Bottom = nextPos.Y + hPart;
                if (cell != null) {
                    cell.Left = rect.Left;
                    cell.Right = rect.Right;
                    cell.Top = rect.Top;
                    cell.Bottom = rect.Bottom;
                    if (cell.TransProps.Angle == 90.0 || cell.TransProps.Angle == 270.0) {
                        cell.SideY = w + wPart;
                        cell.SideX = h + hPart;
                        if (cell.TransProps.Angle == 90.0) {
                            cell.OrgX = prevPos.X + w + wPart - 0.5 * this.SideX;
                            cell.OrgY = prevPos.Y - 0.5 * this.SideY;
                        } else {
                            cell.OrgX = prevPos.X - 0.5 * this.SideX;
                            cell.OrgY = prevPos.Y + h + hPart - 0.5 * this.SideY;
                        }
                    } else {
                        cell.SideX = w + wPart;
                        cell.SideY = h + hPart;
                        if (cell.TransProps.Angle == 180.0) {
                            cell.OrgX = prevPos.X + w + wPart - 0.5 * this.SideX;
                            cell.OrgY = prevPos.Y + h + hPart - 0.5 * this.SideY;
                        } else {
                            cell.OrgX = prevPos.X - 0.5 * this.SideX;
                            cell.OrgY = prevPos.Y - 0.5 * this.SideY;
                        }
                    }
                    cell.TransProps.CenterX = 0.5 * cell.SideX;
                    cell.TransProps.CenterY = 0.5 * cell.SideY;
                    if (this.Objects == null) {
                        this.Objects = new ArrayList();
                    }
                    if (!cell.spanning) {
                        this.Objects.add(cell);
                        cell.ParentGB = this;
                    }
                }
                prevPos.X += w;
            }
            prevPos.Y += h;
        }
    }

    private double getSideX() {
        double value = 0.0;
        int cnt = this.widths.size();
        for (int i = 0; i < cnt; ++i) {
            value += this.widths.get(i);
        }
        return value;
    }

    private double getSideY() {
        double value = 0.0;
        int cnt = this.heights.size();
        for (int i = 0; i < cnt; ++i) {
            value += this.heights.get(i);
        }
        return value;
    }

    private TableCell getCell(int r, int c) {
        if (this.rows.size() <= r || this.rows.get(r) == null) {
            return null;
        }
        if (this.rows.get(r).size() <= c) {
            return null;
        }
        return this.rows.get(r).get(c);
    }

    @Override
    public int shapeType() {
        return 233;
    }

    @Override
    protected int getVerticesCount() {
        return 8;
    }

    @Override
    protected double getVertexX(int index) {
        if (index < 0) {
            return 0.0;
        }
        if (index <= 3) {
            double[] points = this.getRectPoints();
            return points[index * 2];
        }
        switch (index) {
            case 4: 
            case 6: {
                return 0.0;
            }
            case 5: {
                return this.SideX / 2.0;
            }
            case 7: {
                return -this.SideX / 2.0;
            }
        }
        return 0.0;
    }

    @Override
    protected double getVertexY(int index) {
        if (index < 0) {
            return 0.0;
        }
        if (index <= 3) {
            double[] points = this.getRectPoints();
            return points[index * 2 + 1];
        }
        switch (index) {
            case 4: {
                return -this.SideY / 2.0;
            }
            case 5: 
            case 7: {
                return 0.0;
            }
            case 6: {
                return this.SideY / 2.0;
            }
        }
        return 0.0;
    }

    @Override
    protected void setVertex(int index, double x, double y) {
        if (index < this.getVerticesCount()) {
            this.SideX = 0.0;
            this.SideY = 0.0;
            if (index == 1 || index == 2 || index == 5) {
                this.SideX = x - this.getVertexX(0);
            } else if (index == 0 || index == 3 || index == 7) {
                this.SideX = this.getVertexX(1) - x;
            }
            if (index == 2 || index == 3 || index == 6) {
                this.SideY = y - this.getVertexY(0);
            } else if (index == 0 || index == 1 || index == 4) {
                this.SideY = this.getVertexY(2) - y;
            }
        }
    }

    public double[] getRectPoints() {
        double[] pts = new double[]{-0.5 * this.SideX, -0.5 * this.SideY, 0.5 * this.SideX, -0.5 * this.SideY, 0.5 * this.SideX, 0.5 * this.SideY, -0.5 * this.SideX, 0.5 * this.SideY};
        return pts;
    }
}

