/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.Strings;
import inform.adt.collections.DoubleDoubleMap;
import inform.adt.collections.DoubleIntegerMap;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Container;
import inform.agent.schemes.Dimension;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Guide;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.PrimParam;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemePageNotes;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import inform.agent.web.utils.ImageInfo;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOImage;

public class VsdxWriter {
    private static final double PAGE_WIDTH = 210.0;
    private static final double PAGE_HEIGHT = 297.0;
    private static final double MAX_SIZE = 2000.0;
    private final Scheme _scheme;
    private final SchemeEngine _engine;
    private ZipOutputStream _zipOutputStream = null;
    private SchemePage _currentPage = null;
    private double _schemeScale = 1.0;
    private double _scaleFloat = 1.0;
    private boolean _isHidden = false;
    private double _currentHeadingId = 0.0;
    private byte _currentHeadingEdge = 0;
    private static final double MIN_WIDTH_HEIGHT = 1.0E-5;
    private double _pageWidth = 8.26771653543307;
    private double _pageHeight = 11.69291338582677;
    private double _posPageX = 4.1207350731691;
    private double _posPageY = 5.8442697003757;
    private double _posPageXFirst = 4.1207350731691;
    private double _posPageYFirst = 5.8442697003757;
    private boolean _firstPosSetted = false;
    private int _fillGradientDir = 0;
    private double _fillGradientAngle = 0.0;
    private boolean _useMasterPart = false;
    private boolean _usePageMasterDefMode = false;
    private int _shapeCount = 6;
    private int _pageMasterDefID = 0;
    private int commentID = 1;
    private boolean _relationshipTestMode = false;
    PhxGraphicInsert _curInsert = null;
    GraphicBlock _primBlock = null;
    private int _pageLayerIndex = 0;
    private double _currentPageId = 0.0;
    private String _printSettingsStr = "";
    private String _pinXStrDef = "";
    private String _pinYStrDef = "";
    private String _widthStrDef = "";
    private String _heightStrDef = "";
    private String _beginXYEndXYDef = "";
    private StringBuilder _connectionsPart = new StringBuilder();
    private boolean _isConnection = false;
    private boolean _isDynamicLine = false;
    private final StringBuilder _docPropsCustomTemplate = new StringBuilder();
    private final StringBuilder _docPropsCoreTemplate = new StringBuilder();
    private final StringBuilder _docPropsAppTemplate = new StringBuilder();
    private final StringBuilder _contentTypesTemplate = new StringBuilder();
    private final StringBuilder _relsRelsTemplate = new StringBuilder();
    private final StringBuilder _visioCommentsTemplate = new StringBuilder();
    private final StringBuilder _visioWindowsTemplate = new StringBuilder();
    private final StringBuilder _visioDocumentTemplate = new StringBuilder();
    private final StringBuilder _visioRelsDocumentXmlRelsTemplate = new StringBuilder();
    private final StringBuilder _visioMastersMastersTemplate = new StringBuilder();
    private final StringBuilder _visioMastersMasterTemplate = new StringBuilder();
    private final StringBuilder _visioPagesPageTemplate = new StringBuilder();
    private final StringBuilder _visioMastersRelsMastersXmlRelsTemplate = new StringBuilder();
    private final StringBuilder _contentTypeMastersPart = new StringBuilder();
    private final StringBuilder _contentTypePagePart = new StringBuilder();
    private final StringBuilder _visioPagesPagesPart = new StringBuilder();
    private final StringBuilder _visioPagesRelsPagesXmlRelsPart = new StringBuilder();
    private final StringBuilder _visioRelsDocumentXmlRelsMastersPart = new StringBuilder();
    private final StringBuilder _visioMastersMastersPart = new StringBuilder();
    private final StringBuilder _visioMastersRelsMastersXmlRelsPart = new StringBuilder();
    private final StringBuilder _visioAuthorEntryPart = new StringBuilder();
    private final StringBuilder _visioCommentEntryPart = new StringBuilder();
    private StringBuilder _visioPagesPage1Part = new StringBuilder();
    private StringBuilder _visioPagesRelsPage1XmlRelsPart = new StringBuilder();
    private StringBuilder _visioMastersMasterPart = new StringBuilder();
    private StringBuilder _pageMasterDef = new StringBuilder();
    private final HashMap<Double, MasterHashEntry> _hashTable = new HashMap();
    private final List<String> authors = new ArrayList<String>();
    private final HashMap<Double, ConnPointHashEntry> _connHashTable = new HashMap();
    private final DoubleIntegerMap _relationshipHashTable = new DoubleIntegerMap();
    private final DoubleDoubleMap _pageIdHashTable = new DoubleDoubleMap();
    private final List<VSDXItem> _pageList = new ArrayList<VSDXItem>();
    private final List<VSDXItem> _pageXmlRelsList = new ArrayList<VSDXItem>();
    private final List<VSDXItem> _mediaList = new ArrayList<VSDXItem>();
    private final List<VSDXItem> _masterList = new ArrayList<VSDXItem>();
    private static final String SHAPE_MASTER_GROUP_FOOTER_TEMPLATE = "</Shapes></Shape>";
    private static final String BEGIN_ARROW_SIZE_TEMPLATE = "<Cell V=\"%d\" N=\"BeginArrowSize\"/>";
    private static final String END_ARROW_SIZE_TEMPLATE = "<Cell V=\"%d\" N=\"EndArrowSize\"/>";
    private static final String BEGIN_ARROW_TEMPLATE = "<Cell V=\"%d\" N=\"BeginArrow\"/>";
    private static final String END_ARROW_TEMPLATE = "<Cell V=\"%d\" N=\"EndArrow\"/>";
    private static final String DBL_CLICK_EVENT_TEMPLATE = "<Cell V=\"0\" N=\"EventDblClick\" F=\"OPENTEXTWIN()\"/>";
    private static final String HIDE_TEXT_TEMPLATE = "<Cell V=\"1\" N=\"HideText\"/>";
    private static final String TXTBGND_COLOR_TEMPLATE = "<Cell N=\"TextBkgnd\" V=\"%s\"/>";
    private static final int MASTER_BASE_INDEX = 0;
    private static final int MEDIA_BASE_INDEX = 100000;
    private static final double DEFAULT_PAGE_WIDTH = 8.26771653543307;
    private static final double DEFAULT_PAGE_HEIGHT = 11.69291338582677;
    private static final double DEFAULT_VIEW_CENTER_X = 4.1207350731691;
    private static final double DEFAULT_VIEW_CENTER_Y = 5.8442697003757;
    private static final double DYNAMIC_LINE_ID = -1000.0;
    private static final int ptArc = 0;
    private static final int ptSector = 1;
    private static final int ptChord = 2;
    private static final double DEFAULT_LINE_JUMP_FACTOR = 0.6667;
    private final int DEFAULT_LINE_JUMP_CODE = 5;
    private ServerSideHost stateHost;

    public VsdxWriter(Scheme scheme) {
        this._scheme = scheme;
        this._engine = new SchemeEngine(scheme);
        this._engine.InitTmpProps();
        this.fillAllTemplates();
    }

    private void fillAllTemplates() {
        this.fillDocPropsTemplates();
        this.fillContentTypesTemplate();
        this.fillRelsRelsTemplate();
        this.fillVisioCommentsTemplate();
        this.fillVisioWindowsTemplate();
        this.fillVisioDocumentTemplate();
        this.fillVisioRelsDocumentXmlRelsTemplate();
        this.fillVisioMastersRelsMastersXmlRelsTemplate();
        this.fillVisioMastersMastersTemplate();
        this.fillVisioMastersMasterTemplate();
        this.fillVisioPagesPageTemplate();
    }

    private static int pageFormatToVSDX(int format) {
        switch (format) {
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 11;
            }
        }
        return 0;
    }

    public void saveToStream(ConnectionManager dbMgr, OutputStream out) throws Exception {
        this._zipOutputStream = new ZipOutputStream(out);
        this._zipOutputStream.setMethod(8);
        this._scheme.parse(dbMgr, true);
        this._scheme.sortObjectsWithConnPoints();
        if (!this._scheme.SortLayers.isEmpty()) {
            this._scheme.calcSchemeBounds();
            double sw = this._scheme.getSchemeWidth();
            double sh = this._scheme.getSchemeHeight();
            if (sw > 2000.0 || sh > 2000.0) {
                this._schemeScale = sw > sh ? 2000.0 / sw : 2000.0 / sh;
            }
            if (this._scheme.getSchemeLeft() < 0.0 || this._scheme.getSchemeLeft() > 210.0) {
                this._posPageX = VsdxWriter.mmToInch(this._scheme.getSchemeLeft());
            }
            if (this._scheme.getSchemeBottom() < 0.0 || this._scheme.getSchemeBottom() > 297.0) {
                this._posPageY = VsdxWriter.mmToInch(297.0 - this._scheme.getSchemeBottom());
            }
        }
        this.prepareVSDXFile();
        this.writeScheme();
        this.finishVSDXFile();
    }

    private SchemeObject getCosmeticLayer() {
        for (int j = 0; j < this._scheme.SortLayers.size(); ++j) {
            SchemeObject i1 = this._scheme.SortLayers.get(j);
            if (!((PhxLayer)i1.BG).Cosmetic) continue;
            return i1;
        }
        return null;
    }

    private void writeScheme() throws Exception {
        this.fillPageIdHash();
        this._firstPosSetted = false;
        this._visioPagesPagesPart.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append("<Pages xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" ").append("xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ").append("xml:space=\"preserve\">");
        this._visioPagesRelsPagesXmlRelsPart.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
        if (this._scheme.Pages.empty()) {
            this.writePage(null);
        } else {
            int size = this._scheme.Pages.size();
            block0: for (int idx = 0; idx < size; ++idx) {
                for (SchemePage schemePage : this._scheme.Pages) {
                    if (idx != schemePage.getOrder()) continue;
                    this._currentPage = schemePage;
                    this.writePage(schemePage);
                    this.writePageNotes(schemePage);
                    continue block0;
                }
            }
        }
        this._visioPagesRelsPagesXmlRelsPart.append("</Relationships>");
        this._visioPagesPagesPart.append("</Pages>");
    }

    private void writePageNotes(SchemePage page) {
        SchemePageNotes pageNotes = page.pageNotes == null ? this._scheme.getPageNotes() : page.pageNotes;
        ArrayList<SchemePageNotes.SchemeNote> notes = pageNotes.getNotes();
        if (notes == null || notes.isEmpty()) {
            return;
        }
        this.processComments(notes, false);
    }

    private void processAuthors(List<SchemePageNotes.SchemeNote> notes) {
        notes.stream().filter(Objects::nonNull).filter(note -> note.userName != null && !note.userName.isEmpty()).filter(note -> !this.authors.contains(note.userName)).forEach(note -> {
            this.authors.add(note.userName);
            String initials = note.userName.substring(0, 1);
            String authorEntry = String.format(this.getPageAuthorTemplate(), note.userName, initials, note.userName, this.authors.size());
            this._visioAuthorEntryPart.append(authorEntry);
        });
    }

    private void processComments(List<SchemePageNotes.SchemeNote> notes, boolean isShape) {
        this.processAuthors(notes);
        for (SchemePageNotes.SchemeNote note : notes) {
            Object[] objectArray;
            String commentTemplate;
            String dateFormat = VsdxUtils.doubleToDateFormat(note.dateTime);
            int authorId = this.authors.indexOf(note.userName) + 1;
            String string = commentTemplate = isShape ? this.getShapeCommentTemplate() : this.getPageCommentTemplate();
            if (isShape) {
                Object[] objectArray2 = new Object[7];
                objectArray2[0] = authorId;
                objectArray2[1] = this._pageLayerIndex;
                objectArray2[2] = this._shapeCount;
                objectArray2[3] = dateFormat;
                objectArray2[4] = dateFormat;
                objectArray2[5] = this.commentID++;
                objectArray = objectArray2;
                objectArray2[6] = note.text;
            } else {
                Object[] objectArray3 = new Object[6];
                objectArray3[0] = authorId;
                objectArray3[1] = this._pageLayerIndex - 1;
                objectArray3[2] = dateFormat;
                objectArray3[3] = dateFormat;
                objectArray3[4] = this.commentID++;
                objectArray = objectArray3;
                objectArray3[5] = note.text;
            }
            Object[] templateArgs = objectArray;
            this._visioCommentEntryPart.append(String.format(commentTemplate, templateArgs));
        }
    }

    private void fillPageIdHash() {
        if (!this._scheme.Pages.empty()) {
            int pageLayerIndex = this._pageLayerIndex;
            int size = this._scheme.Pages.size();
            block0: for (int idx = 0; idx < size; ++idx) {
                for (SchemePage schemePage : this._scheme.Pages) {
                    if (idx != schemePage.getOrder()) continue;
                    Color BkColor = schemePage.BkColor;
                    boolean useBackgroundPage = BkColor != null && !BkColor.equals(Color.WHITE);
                    this._pageIdHashTable.put(schemePage.getNormalizeId(), pageLayerIndex);
                    ++pageLayerIndex;
                    if (!useBackgroundPage) continue block0;
                    ++pageLayerIndex;
                    continue block0;
                }
            }
        }
    }

    private double getPageScaleByPageLayout(SchemePageLayout pageLayout) {
        if (pageLayout == null || pageLayout.getScalePageType() == 0) {
            return 0.03937007874015748;
        }
        if (pageLayout.getScalePageType() == 1) {
            switch (pageLayout.getScalePage()) {
                case 0: {
                    return 3.9370078740157485E-5;
                }
                case 1: {
                    return 7.874015748031497E-5;
                }
                case 2: {
                    return 1.9685039370078743E-4;
                }
                case 3: {
                    return 3.9370078740157485E-4;
                }
                case 4: {
                    return 7.874015748031497E-4;
                }
                case 5: {
                    return 0.0015748031496062994;
                }
                case 6: {
                    return 0.0019685039370078744;
                }
                case 7: {
                    return 0.003937007874015749;
                }
                case 8: {
                    return 0.007874015748031498;
                }
                case 9: {
                    return 0.015748031496062995;
                }
                case 10: {
                    return 0.01968503937007874;
                }
                case 12: {
                    return 0.3937007874015748;
                }
                case 13: {
                    return 0.7874015748031497;
                }
                case 14: {
                    return 1.968503937007874;
                }
            }
            return 0.03937007874015748;
        }
        double scaleFloat = pageLayout.getScaleFloat();
        if (scaleFloat < 0.001) {
            scaleFloat = 0.001;
        }
        return 1.0 / scaleFloat / 25.4;
    }

    private void writePage(SchemePage page) throws Exception {
        int buffPageId;
        String backPage;
        VSDXItem xFileStream;
        boolean useBackgroundPage;
        this.putStateText(String.format("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 '%s'", page == null ? "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 1" : page.getCaption()));
        if (page != null) {
            double sw = page.SchemePageWidth;
            double sh = page.SchemePageHeight;
            this._schemeScale = 1.0;
            this._posPageX = 4.1207350731691;
            this._posPageY = 5.8442697003757;
            SchemePageLayout xPageLayoutSettings = page.pageLayout == null ? this._scheme.getPageLayout() : page.pageLayout;
            this._scaleFloat = xPageLayoutSettings.getScaleFloat();
            if (sw > 2000.0 || sh > 2000.0) {
                this._schemeScale = sw > sh ? 2000.0 / sw : 2000.0 / sh;
            }
            if (!xPageLayoutSettings.getActive()) {
                this._pageWidth = Math.max(8.26771653543307, VsdxWriter.mmToInch(sw));
                this._pageHeight = Math.max(11.69291338582677, VsdxWriter.mmToInch(sh));
                this._schemeScale /= 25.4;
            } else {
                page.calcPageDimensions(xPageLayoutSettings, this._schemeScale);
                this._pageWidth = VsdxWriter.mmToInch(page.getPageWidth());
                this._pageHeight = VsdxWriter.mmToInch(page.getPageHeight());
                this._schemeScale = this.getPageScaleByPageLayout(xPageLayoutSettings);
                this._printSettingsStr = xPageLayoutSettings.getFitOnPages() ? String.format(this.getPrintSettingsTemplate(), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getLeftField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getRightField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getTopField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getBottomField())), xPageLayoutSettings.getHPageCount(), xPageLayoutSettings.getVPageCount(), 2 - (xPageLayoutSettings.getPortrait() ? 1 : 0), VsdxWriter.pageFormatToVSDX(xPageLayoutSettings.getFormat())) : String.format(this.getPrintSettingsLiteTemplate(), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getLeftField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getRightField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getTopField())), this.getTrueFloatValStr(VsdxWriter.mmToInch(xPageLayoutSettings.getBottomField())), 2 - (xPageLayoutSettings.getPortrait() ? 1 : 0), VsdxWriter.pageFormatToVSDX(xPageLayoutSettings.getFormat()));
            }
            if (page.SchemePageLeft < 0.0 || page.SchemePageLeft > 210.0) {
                this._posPageX = VsdxWriter.mmToInch(page.SchemePageLeft);
            }
            if (page.SchemePageBottom < 0.0 || page.SchemePageBottom > 297.0) {
                this._posPageY = VsdxWriter.mmToInch(297.0 - page.SchemePageBottom);
            }
            if (!this._firstPosSetted) {
                this._posPageXFirst = this._posPageX;
                this._posPageYFirst = this._posPageY;
                this._firstPosSetted = true;
            }
        }
        Color BkColor = page == null ? this._scheme.BkColor : page.BkColor;
        boolean bl = useBackgroundPage = BkColor != null && !BkColor.equals(Color.WHITE);
        if (page != null && page.backPageId >= 0.0) {
            useBackgroundPage = false;
        }
        int xBGRelIndex = this._pageLayerIndex + 1;
        if (useBackgroundPage) {
            double bpw = this._scheme.getSchemeWidth();
            double bph = this._scheme.getSchemeHeight();
            xFileStream = this.addVsdxItem(this._pageList, "page", ".xml");
            this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/" + xFileStream._name));
            this._zipOutputStream.write(String.format(this.getVisioPagesPageBackgroundTemplate(), this.getTrueFloatValStr(0.0), this.getTrueFloatValStr(0.0), this.getTrueFloatValStr(bpw), this.getTrueFloatValStr(bph), this.getTrueFloatValStr(bpw * 0.5), this.getTrueFloatValStr(bph * 0.5), this.getColorCode(BkColor)).getBytes(StandardCharsets.UTF_8));
            this._contentTypePagePart.append(String.format("<Override ContentType=\"application/vnd.ms-visio.page+xml\" PartName=\"/visio/pages/page%d.xml\"/>", xBGRelIndex));
            this._visioPagesRelsPagesXmlRelsPart.append(String.format("<Relationship Id=\"rId%d\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/page\" Target=\"page%d.xml\"/>", xBGRelIndex, xBGRelIndex));
            this._visioPagesPagesPart.append(String.format(this.getPageBackgroundHeaderFooterTemplate(), this._pageLayerIndex, this.getTrueFloatValStr(-bpw * 0.5), this.getTrueFloatValStr(-bph * 0.5), this.getTrueFloatValStr(bpw), this.getTrueFloatValStr(bph), this._pageLayerIndex, this._printSettingsStr, this.getTrueFloatValStr(this._schemeScale), xBGRelIndex));
        }
        xFileStream = this.addVsdxItem(this._pageList, "page", ".xml");
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/" + xFileStream._name));
        this._zipOutputStream.write(this._visioPagesPageTemplate.toString().getBytes(StandardCharsets.UTF_8));
        int xRelIndex = useBackgroundPage ? this._pageLayerIndex + 2 : this._pageLayerIndex + 1;
        this._currentPageId = page == null ? 0.0 : page.getNormalizeId();
        this._contentTypePagePart.append(String.format("<Override ContentType=\"application/vnd.ms-visio.page+xml\" PartName=\"/visio/pages/page%d.xml\"/>", xRelIndex));
        this._visioPagesRelsPagesXmlRelsPart.append(String.format("<Relationship Id=\"rId%d\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/page\" Target=\"page%d.xml\"/>", xRelIndex, xRelIndex));
        String string = backPage = useBackgroundPage ? String.format(" BackPage=\"%d\"", this._pageLayerIndex) : "";
        if (page != null && page.backPageId >= 0.0 && (buffPageId = (int)this._pageIdHashTable.get(page.backPageId, -1.0)) != -1) {
            backPage = String.format(" BackPage=\"%d\"", buffPageId);
        }
        int lineJumpType = page == null ? 1 : page.LineJumpType;
        int lineJumpCode = 5;
        if (page != null && !page.LineJumpEnable) {
            lineJumpCode = 0;
        }
        if (lineJumpType == 0) {
            lineJumpType = 2;
        } else if (lineJumpType != 1) {
            ++lineJumpType;
        }
        double lineJumpSize = VsdxWriter.mmToInch((page == null ? VsdxPage.LINE_JUMP_DEF_SIZE : page.LineJumpSize) / 0.6667);
        Object[] objectArray = new Object[16];
        objectArray[0] = useBackgroundPage ? this._pageLayerIndex + 1 : this._pageLayerIndex;
        Object object = objectArray[1] = page == null ? "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 1" : VsdxWriter.correctText(page.getCaption());
        objectArray[2] = page == null ? 0 : (page.isBackPage ? 1 : 0);
        objectArray[3] = this.getTrueFloatValStr(this._posPageX);
        objectArray[4] = this.getTrueFloatValStr(this._posPageY);
        objectArray[5] = backPage;
        objectArray[6] = this.getTrueFloatValStr(this._pageWidth);
        objectArray[7] = this.getTrueFloatValStr(this._pageHeight);
        objectArray[8] = this.getTrueFloatValStr(this._schemeScale);
        objectArray[9] = this._printSettingsStr;
        objectArray[10] = lineJumpCode;
        objectArray[11] = lineJumpType;
        objectArray[12] = this.getTrueFloatValStr(0.6667);
        objectArray[13] = this.getTrueFloatValStr(0.6667);
        objectArray[14] = this.getTrueFloatValStr(lineJumpSize);
        objectArray[15] = this.getTrueFloatValStr(lineJumpSize);
        this._visioPagesPagesPart.append(String.format(this.getPageHeaderTemplate(), objectArray));
        this._visioPagesPagesPart.append("<Section N=\"Layer\">");
        int index = 0;
        this._visioPagesPage1Part = new StringBuilder();
        this._visioPagesRelsPage1XmlRelsPart = new StringBuilder();
        this.resetAllUsedMasterHashEntries();
        int layerCount = this._scheme.SortLayers.size();
        for (int i = 0; i < layerCount; ++i) {
            PhxLayer xLayer = (PhxLayer)this._scheme.SortLayers.get((int)i).BG;
            if (xLayer.PageId != this._currentPageId || !xLayer.Exportable) continue;
            this.writeLayer(xLayer, index);
            ++index;
        }
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0444\u0438\u0433\u0443\u0440\u044b");
        int shapeCount = this._scheme.SortShapes.size();
        if (shapeCount != 0) {
            SchemeObject xLayerObj;
            BaseGraphic xBG;
            SchemeObject xShapeObj;
            int i;
            this.putStateProgressMax(shapeCount);
            this._relationshipTestMode = true;
            this._relationshipHashTable.clear();
            for (i = 0; i < shapeCount; ++i) {
                xShapeObj = this._scheme.SortShapes.get(i);
                if (xShapeObj.BG == null) continue;
                xBG = xShapeObj.BG;
                xLayerObj = this._scheme.layerById(xBG.LayerID);
                if (xLayerObj == null || !(xLayerObj.BG instanceof PhxLayer) || page != null && ((PhxLayer)xLayerObj.BG).PageId != page.getNormalizeId()) continue;
                this.writeShape(xBG, 0, 0.0, 0.0, 1.0, 1.0);
            }
            this._shapeCount = 6;
            this._relationshipTestMode = false;
            for (i = 0; i < shapeCount; ++i) {
                xShapeObj = this._scheme.SortShapes.get(i);
                if (xShapeObj.BG == null) continue;
                xBG = xShapeObj.BG;
                xLayerObj = this._scheme.layerById(xBG.LayerID);
                if (xLayerObj == null || !(xLayerObj.BG instanceof PhxLayer) || page != null && ((PhxLayer)xLayerObj.BG).PageId != page.getNormalizeId()) continue;
                this.putStateProgressPosition(i + 1);
                this.writeShape(xBG, 0, 0.0, 0.0, 1.0, 1.0);
            }
        }
        this._zipOutputStream.write("   </Shapes>".getBytes(StandardCharsets.UTF_8));
        if (this._isConnection) {
            this._zipOutputStream.write(String.format("<Connects>%s</Connects>", this._connectionsPart.toString()).getBytes(StandardCharsets.UTF_8));
            this._connectionsPart = new StringBuilder();
            this._isConnection = false;
        }
        this._zipOutputStream.write("</PageContents>".getBytes(StandardCharsets.UTF_8));
        xFileStream = this.addVsdxItem(this._pageXmlRelsList, "page", ".xml.rels");
        xFileStream._bytes = String.format(this.getPageXmlRelsTemplate(), this._visioPagesRelsPage1XmlRelsPart.toString()).getBytes(StandardCharsets.UTF_8);
        this._visioPagesPagesPart.append("</Section>");
        this._visioPagesPagesPart.append(String.format(this.getPageFooterTemplate(), xRelIndex));
        if (useBackgroundPage) {
            ++this._pageLayerIndex;
        }
        ++this._pageLayerIndex;
    }

    private VSDXItem addVsdxItem(List<VSDXItem> items, String fileNamePreffix, String fileNameExt) {
        VSDXItem item = new VSDXItem();
        item._name = fileNamePreffix + (items.size() + 1) + fileNameExt;
        items.add(item);
        return item;
    }

    private void writeLayer(PhxLayer layer, int index) {
        Object xLayerCaption;
        Object object = xLayerCaption = layer.StringProps == null ? null : layer.StringProps.Caption;
        if (Strings.isVoid((String)xLayerCaption)) {
            xLayerCaption = "\u0421\u043b\u043e\u0439" + index;
        }
        xLayerCaption = VsdxWriter.correctText((String)xLayerCaption);
        this._visioPagesPagesPart.append(String.format(this.getPagesLayerTemplate(), index, xLayerCaption, layer.Visible ? 1 : 0, layer.Selectable ? 0 : 1, xLayerCaption));
    }

    private void writeShape(BaseGraphic graphic, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) throws Exception {
        ++this._shapeCount;
        ++this._pageMasterDefID;
        SchemeObject xObj = this._scheme.layerById(graphic.LayerID);
        if (xObj == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
            if (!this._relationshipTestMode) {
                Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0438\u0433\u0443\u0440\u044b: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439");
            }
            return;
        }
        PhxLayer xLayer = (PhxLayer)xObj.BG;
        if (!xLayer.Exportable) {
            return;
        }
        boolean oldIsHidden = this._isHidden;
        if (graphic.Hidden) {
            this._isHidden = true;
        }
        if (!(this._relationshipTestMode || this._useMasterPart || graphic.ParentGB == null || graphic.TransProps == null || SchemeObjectsTypes.ObjTypeIsText(graphic.shapeType()))) {
            boolean inInsert;
            boolean bl = inInsert = graphic.ParentGB.ParentGB != null && graphic.ParentGB.ParentGB.shapeType() == 207;
            if (inInsert || graphic.ParentGB.ParentGB == null) {
                double a;
                double parentScaleX = 1.0;
                double parentScaleY = 1.0;
                double d = a = graphic.TransProps == null ? 0.0 : graphic.TransProps.Angle;
                if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) <= 0.5) {
                    boolean vert;
                    BaseGraphic parent = inInsert ? graphic.ParentGB.ParentGB : graphic.ParentGB;
                    boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
                    if (!vert) {
                        if (graphic.FixScaleX && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleX;
                        }
                        if (graphic.FixScaleY && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleY;
                        }
                    } else {
                        if (graphic.FixScaleX && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleX;
                        }
                        if (graphic.FixScaleY && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleY;
                        }
                    }
                    graphic.TransProps.ScaleX /= parentScaleX;
                    graphic.TransProps.ScaleY /= parentScaleY;
                }
            }
        }
        if (graphic instanceof Polygon) {
            this.writePolygon((Polygon)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Region) {
            this.writeRegion((Region)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Spline) {
            this.writeSpline((Spline)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Polyline) {
            this.writePolyline((Polyline)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Pie) {
            this.writePie((Pie)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Ellipse) {
            this.writeEllipse((Ellipse)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Paragraph) {
            this.writeParagraph((Paragraph)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Image) {
            this.writeImage((Image)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Rectangle) {
            this.writeRectangle((Rectangle)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Container) {
            this.writeContainer((Container)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof PhxGraphicInsert) {
            this.writeGraphicInsert((PhxGraphicInsert)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof GraphicBlock) {
            this.writeGraphicBlock((GraphicBlock)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        } else if (graphic instanceof Guide) {
            this.writeGuide((Guide)graphic, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
        }
        if (!this._relationshipTestMode) {
            if (graphic.containsNotes()) {
                SchemePageNotes schemeNotes = graphic.getBgNotes();
                ArrayList<SchemePageNotes.SchemeNote> notes = schemeNotes.getNotes();
                this.processComments(notes, true);
            }
            if (this._visioPagesPage1Part.length() > 0) {
                this._zipOutputStream.write(this._visioPagesPage1Part.toString().getBytes(StandardCharsets.UTF_8));
                this._visioPagesPage1Part.setLength(0);
            }
        }
        this._isHidden = oldIsHidden;
    }

    private int getLayerIndex(BaseGraphic shape) {
        if (this._useMasterPart) {
            return 0;
        }
        int index = 0;
        for (int i = 0; i < this._scheme.SortLayers.size(); ++i) {
            PhxLayer xCurrLayer = (PhxLayer)this._scheme.SortLayers.get((int)i).BG;
            if (!xCurrLayer.Exportable || xCurrLayer.PageId != this._currentPageId) continue;
            if (Math.abs(shape.LayerID - xCurrLayer.ID) <= 1.0E-12) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private static int convertArrowTypeToVisioType(int arrowType) {
        switch (arrowType) {
            case 1: {
                return 14;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 13;
            }
            case 5: {
                return 1;
            }
            case 7: {
                return 10;
            }
            case 8: 
            case 32: {
                return 20;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 21;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 3;
            }
            case 17: {
                return 4;
            }
            case 19: {
                return 24;
            }
            case 20: {
                return 27;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 38;
            }
            case 24: {
                return 34;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 30;
            }
            case 27: {
                return 29;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 43;
            }
            case 30: {
                return 39;
            }
            case 31: {
                return 40;
            }
        }
        return 14;
    }

    private static boolean inRange(double value, double min, double max) {
        return value <= max && value >= min;
    }

    private static int convertArrowSizeToVisioSize(int arrowType, double size, double scaleFloat) {
        double buff;
        double TOL = 0.1;
        double visArrowSizeVerySmall = 0.25;
        double visArrowSizeSmall = 0.5;
        double visArrowSizeMedium = 0.75;
        double visArrowSizeLarge = 1.0;
        double visArrowSizeVeryLarge = 1.25;
        double visArrowSizeJumbo = 3.25;
        switch (arrowType) {
            case 16: 
            case 18: {
                buff = size / 2.0;
                break;
            }
            case 17: {
                buff = size / 1.65;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                buff = size / 1.2;
                break;
            }
            case 9: 
            case 19: 
            case 20: {
                buff = size / 1.5;
                break;
            }
            default: {
                buff = size / 3.0;
            }
        }
        if (VsdxWriter.inRange(buff /= scaleFloat, 0.0, visArrowSizeVerySmall + TOL)) {
            return 0;
        }
        if (VsdxWriter.inRange(buff, visArrowSizeVerySmall, visArrowSizeSmall + TOL)) {
            return 1;
        }
        if (VsdxWriter.inRange(buff, visArrowSizeSmall, visArrowSizeMedium + TOL)) {
            return 2;
        }
        if (VsdxWriter.inRange(buff, visArrowSizeMedium, visArrowSizeLarge + TOL)) {
            return 3;
        }
        if (VsdxWriter.inRange(buff, visArrowSizeLarge, visArrowSizeVeryLarge + TOL)) {
            return 4;
        }
        if (VsdxWriter.inRange(buff, visArrowSizeVeryLarge, visArrowSizeJumbo + TOL)) {
            return 5;
        }
        return 6;
    }

    private String getShapePropertySectionContent(PhxGraphicInsert graphic) {
        if (graphic == null || graphic.BlockParams.size() == 0) {
            return "";
        }
        StringBuilder propertySection = new StringBuilder();
        propertySection.append("<Section N='Property'>");
        for (int i = 0; i < graphic.BlockParams.size(); ++i) {
            PrimParam param = (PrimParam)graphic.BlockParams.get(i);
            propertySection.append(String.format("    <Row N='%s'>", VsdxWriter.replaceApostropheWithEntity(param.getName())));
            propertySection.append(String.format("        <Cell N='Value' V='%s' U='%s'/>", VsdxWriter.replaceApostropheWithEntity(param.getValue()), param.getVisioValueType()));
            propertySection.append("    </Row>");
        }
        propertySection.append("</Section>");
        return propertySection.toString();
    }

    private String getMasterPropertySectionContent(GraphicBlock block) {
        if (block == null || block.BlockParams.size() == 0) {
            return "";
        }
        StringBuilder propertySection = new StringBuilder();
        propertySection.append("<Section N='Property'>");
        for (int i = 0; i < block.BlockParams.size(); ++i) {
            PrimParam param = block.BlockParams.get(i);
            propertySection.append(String.format("    <Row N='%s'>", VsdxWriter.replaceApostropheWithEntity(param.getName())));
            propertySection.append(String.format("        <Cell N='Value' V='%s' U='%s'/>", VsdxWriter.replaceApostropheWithEntity(param.getValue()), param.getVisioValueType()));
            propertySection.append("        <Cell N='Prompt' V=''/>");
            propertySection.append(String.format("        <Cell N='Label' V='%s'/>", VsdxWriter.replaceApostropheWithEntity(param.getCaption())));
            propertySection.append(String.format("        <Cell N='Format' V='%s'/>", VsdxWriter.replaceApostropheWithEntity(String.join((CharSequence)";", param.getDict()))));
            propertySection.append("        <Cell N='SortKey' V=''/>");
            propertySection.append(String.format("        <Cell N='Type' V='%s'/>", param.getVisioParamType()));
            propertySection.append("        <Cell N='Invisible' V='0'/>");
            propertySection.append("        <Cell N='Verify' V='0'/>");
            propertySection.append("        <Cell N='DataLinked' V='0'/>");
            propertySection.append("        <Cell N='LangID' V='ru-Ru'/>");
            propertySection.append("        <Cell N='Calendar' V='0'/>");
            propertySection.append("    </Row>");
        }
        propertySection.append("</Section>");
        return propertySection.toString();
    }

    public static String replaceApostropheWithEntity(String textWithApostrophe) {
        return textWithApostrophe.replace("'", "&apos;");
    }

    private String getShapeRelationshipContent(BaseGraphic graphic) {
        if (graphic == null || graphic.ContainerID == 0.0 || !this._relationshipHashTable.contains(graphic.ContainerID)) {
            return "";
        }
        int shapeId = this._relationshipHashTable.get(graphic.ContainerID, -1);
        if (shapeId == -1) {
            return "";
        }
        SchemeObject obj = this._scheme.getObjectSilent(graphic.ContainerID);
        if (obj == null || obj.BG == null || obj.BG.shapeType() != 232) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (((Container)obj.BG).AsList) {
            result.append(String.format("<Cell V=\"0\" N=\"Relationships\" F=\"SUM(DEPENDSON(5,Sheet.%d!SheetRef()))\"/>", shapeId));
        } else {
            result.append(String.format("<Cell V=\"0\" N=\"Relationships\" F=\"SUM(DEPENDSON(4,Sheet.%d!SheetRef()))\"/>", shapeId));
        }
        result.append("<Cell V=\"1\" N=\"ObjType\"/>");
        return result.toString();
    }

    private String getContainerHeadingContent(byte headingEdge) {
        StringBuilder result = new StringBuilder();
        result.append("<Section N=\"User\">");
        result.append(" <Row N=\"msvStructureType\">");
        result.append("     <Cell V=\"Heading\" N=\"Value\" U=\"STR\"/>");
        result.append("     <Cell V=\"\" N=\"Prompt\"/>");
        result.append(" </Row>");
        result.append(" <Row N=\"msvSDContainerHeadingEdge\">");
        switch (headingEdge) {
            case 0: {
                result.append("     <Cell V=\"Right\" N=\"Value\" U=\"STR\"/>");
                break;
            }
            case 3: {
                result.append("     <Cell V=\"Top\" N=\"Value\" U=\"STR\"/>");
                break;
            }
            case 2: {
                result.append("     <Cell V=\"Bottom\" N=\"Value\" U=\"STR\"/>");
                break;
            }
            default: {
                result.append("     <Cell V=\"Left\" N=\"Value\" U=\"STR\"/>");
            }
        }
        result.append("     <Cell V=\"\" N=\"Prompt\"/>");
        result.append(" </Row>");
        result.append("</Section> ");
        return result.toString();
    }

    private String getArrowsContent(Polyline polyline) {
        double xLineWidth;
        StringBuilder result = new StringBuilder();
        if (!this._scheme.drawArrows) {
            return "";
        }
        if (polyline.lWidth == -1.0) {
            if (this._useMasterPart && this._primBlock != null) {
                SchemeObject xObj = this._scheme.layerById(this._primBlock.LayerID);
                if (xObj == null) {
                    xObj = this._scheme.layerById(this._curInsert.LayerID);
                }
                xLineWidth = ((PhxLayer)xObj.BG).lWidth;
            } else {
                xLineWidth = this._usePageMasterDefMode && this._curInsert != null ? ((PhxLayer)this._scheme.layerById((double)this._curInsert.LayerID).BG).lWidth : ((PhxLayer)this._scheme.layerById((double)polyline.LayerID).BG).lWidth;
            }
        } else {
            xLineWidth = polyline.lWidth;
        }
        if (polyline.StartVisArrowType != 0) {
            result.append(String.format(BEGIN_ARROW_TEMPLATE, VsdxWriter.convertArrowTypeToVisioType(polyline.StartVisArrowType)));
            result.append(String.format(BEGIN_ARROW_SIZE_TEMPLATE, VsdxWriter.convertArrowSizeToVisioSize(polyline.StartVisArrowType, polyline.StartVisArrowSize - 2.0 * xLineWidth, this._scaleFloat)));
        }
        if (polyline.EndVisArrowType != 0) {
            result.append(String.format(END_ARROW_TEMPLATE, VsdxWriter.convertArrowTypeToVisioType(polyline.EndVisArrowType)));
            result.append(String.format(END_ARROW_SIZE_TEMPLATE, VsdxWriter.convertArrowSizeToVisioSize(polyline.EndVisArrowType, polyline.EndVisArrowSize - 2.0 * xLineWidth, this._scaleFloat)));
        }
        return result.toString();
    }

    private void prepareDynamicLineMaster() {
        StringBuilder xRelationshipMasterTemplate = new StringBuilder();
        xRelationshipMasterTemplate.append("<Relationship Id=\"rId%d\"").append(" Type=\"http://schemas.microsoft.com/visio/2010/relationships/master\"").append(" Target=\"%s\"/>");
        StringBuilder xContentTypeMastersPartTemplate = new StringBuilder();
        xContentTypeMastersPartTemplate.append("<Override ContentType=\"application/vnd.ms-visio.masters+xml\"").append(" PartName=\"/visio/masters/masters.xml\"/>");
        StringBuilder xVisioRelsDocumentXmlRelsMasterPartTemplate = new StringBuilder();
        xVisioRelsDocumentXmlRelsMasterPartTemplate.append("<Relationship Id=\"rId4\"").append(" Type=\"http://schemas.microsoft.com/visio/2010/relationships/masters\"").append(" Target=\"masters/masters.xml\"/>");
        MasterHashEntry xMasterHashEntry = this._hashTable.get(-1000.0);
        if (xMasterHashEntry == null) {
            if (this._masterList.isEmpty()) {
                this._contentTypeMastersPart.append((CharSequence)xContentTypeMastersPartTemplate);
                this._visioRelsDocumentXmlRelsMastersPart.append((CharSequence)xVisioRelsDocumentXmlRelsMasterPartTemplate);
            }
            VSDXItem xFileStream = this.addVsdxItem(this._masterList, "master", ".xml");
            xFileStream._bytes = String.format(this._visioMastersMasterTemplate.toString(), this.getVisioMastersDynamicLineMasterTemplate()).getBytes(StandardCharsets.UTF_8);
            this._contentTypeMastersPart.append(String.format("<Override ContentType=\"application/vnd.ms-visio.master+xml\" PartName=\"/visio/masters/%s\"/>", xFileStream._name));
            int xRelIndex = 0 + this._masterList.size();
            this._visioMastersRelsMastersXmlRelsPart.append(String.format(xRelationshipMasterTemplate.toString(), xRelIndex, xFileStream._name));
            this._visioMastersMastersPart.append(this.getDynamicLineMastersXmlContent(xRelIndex));
            xMasterHashEntry = new MasterHashEntry(this._masterList.size(), 0, xRelIndex, xFileStream._name);
            this._hashTable.put(-1000.0, xMasterHashEntry);
        }
        if (!xMasterHashEntry._used) {
            this._visioPagesRelsPage1XmlRelsPart.append(String.format(xRelationshipMasterTemplate.toString(), xMasterHashEntry._relIndex, xMasterHashEntry._targetName));
            xMasterHashEntry._used = true;
        }
    }

    private String getDynamicLineMastersXmlContent(int relIdx) {
        StringBuilder template = new StringBuilder();
        template.append("<Master ID=\"%d\"").append(" NameU=\"Dynamic connector\"").append(" IsCustomNameU=\"1\"").append(" Name=\"\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043b\u0438\u043d\u0438\u044f\"").append(" IsCustomName=\"1\"").append(" Prompt=\"T\"").append(" AlignName=\"2\"").append(" MatchByName=\"1\"").append(" UniqueID=\"{002A9118-0000-0000-8E40-00608CF305B2}\"").append(" BaseID=\"{F7290A45-E3AD-11D2-AE4F-006008C9F5A9}\"").append(" PatternFlags=\"0\"").append(" Hidden=\"0\"").append(" MasterType=\"541\">").append("   <PageSheet TextStyle=\"0\" FillStyle=\"0\" LineStyle=\"0\">").append("       <Cell V=\"2\" N=\"PageWidth\"/>").append("       <Cell V=\"1\" N=\"PageHeight\"/>").append("       <Cell V=\"1\" N=\"PageScale\"/>").append("       <Cell V=\"1\" N=\"DrawingScale\"/>").append("       <Section N=\"Layer\">").append("           <Row IX=\"0\">").append("               <Cell N=\"Name\" V=\"\u0421\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043b\u0438\u043d\u0438\u044f\"/>").append("               <Cell V=\"255\" N=\"Color\"/>").append("               <Cell V=\"0\" N=\"Status\"/>").append("               <Cell V=\"1\" N=\"Visible\"/>").append("               <Cell V=\"1\" N=\"Print\"/>").append("               <Cell V=\"0\" N=\"Active\"/>").append("               <Cell V=\"0\" N=\"Lock\"/>").append("               <Cell V=\"1\" N=\"Snap\"/>").append("               <Cell V=\"1\" N=\"Glue\"/>").append("               <Cell N=\"NameUniv\" V=\"Connector\"/>").append("               <Cell V=\"0\" N=\"ColorTrans\"/>").append("           </Row>").append("       </Section>").append("   </PageSheet>").append("   <Rel r:id=\"rId%d\"/>").append("</Master>");
        return String.format(template.toString(), relIdx, relIdx);
    }

    private boolean getConnPointDef(BaseGraphic shape, int shapeId) {
        double angle;
        boolean isLine;
        int count;
        this._beginXYEndXYDef = "";
        if (shape.ParentGB instanceof GraphicBlock && !(shape.ParentGB instanceof PhxLayer)) {
            return false;
        }
        if (this._useMasterPart) {
            return false;
        }
        if (shape.GluePoints == null && shape.DynamicGluePoint == null) {
            return false;
        }
        int n = count = shape.GluePoints == null ? 0 : shape.GluePoints.size();
        if (count == 0 && shape.DynamicGluePoint == null) {
            return false;
        }
        boolean bl = isLine = shape.shapeType() == 210 || shape.shapeType() == 212;
        if (shapeId == -1) {
            shapeId = this._shapeCount;
        }
        double d = angle = shape.TransProps == null ? 0.0 : shape.TransProps.Angle;
        if (angle != 0.0) {
            shape.TransProps.Angle = 0.0;
        }
        AffineTransform xMatrix = SchemeEngine.GenTransform(shape);
        boolean isBegin = false;
        boolean isEnd = false;
        boolean isFreeLineBegin = false;
        String buf1 = null;
        String buf2 = null;
        String buf3 = null;
        String buf4 = null;
        String buf5 = null;
        String buf6 = null;
        String connStr1 = null;
        String connStr2 = null;
        double[] gpss = new double[2];
        ConnPointHashEntry xConnHashEntry2 = null;
        int connId = 1;
        for (int i = 0; i <= count; ++i) {
            double endY;
            double endX;
            double beginY;
            double beginX;
            BaseGraphic.GluePoint xGP = null;
            if (i < count && shape.GluePoints != null) {
                xGP = shape.GluePoints.get(i);
            } else if (i == count && shape.DynamicGluePoint != null) {
                xGP = shape.DynamicGluePoint;
            }
            if (xGP == null || xGP.joinId == 0.0 && !isLine) continue;
            gpss[0] = xGP.ptX;
            gpss[1] = xGP.ptY;
            double[] gpts = SchemeEngine.MulPointsTM(xMatrix, gpss);
            double x = VsdxWriter.mmToInch(gpts[0]);
            double y = -VsdxWriter.mmToInch(gpts[1]);
            ConnPointHashEntry xConnHashEntry = this._connHashTable.get(xGP.joinId);
            if (xConnHashEntry == null) {
                if (xGP.joinId != 0.0) {
                    xConnHashEntry = new ConnPointHashEntry(shapeId, i + 1);
                    this._connHashTable.put(xGP.joinId, xConnHashEntry);
                }
                if (!isLine) continue;
                if (!isFreeLineBegin) {
                    beginX = x;
                    beginY = y;
                    buf1 = String.format("<Cell V=\"%s\" N=\"BeginX\"/>", this.getTrueFloatValStr(beginX));
                    buf2 = String.format("<Cell V=\"%s\" N=\"BeginY\"/>", this.getTrueFloatValStr(beginY));
                    isFreeLineBegin = true;
                    continue;
                }
                endX = x;
                endY = y;
                buf3 = String.format("<Cell V=\"%s\" N=\"EndX\"/>", this.getTrueFloatValStr(endX));
                buf4 = String.format("<Cell V=\"%s\" N=\"EndY\"/>", this.getTrueFloatValStr(endY));
                continue;
            }
            xConnHashEntry2 = xConnHashEntry;
            connId = i + 1;
            if (!isBegin) {
                beginX = x;
                beginY = y;
                if (isLine) {
                    buf1 = String.format("<Cell V=\"%s\" N=\"BeginX\" F=\"_WALKGLUE(BegTrigger,EndTrigger,WalkPreference)\"/>", this.getTrueFloatValStr(beginX));
                    buf2 = String.format("<Cell V=\"%s\" N=\"BeginY\" F=\"_WALKGLUE(BegTrigger,EndTrigger,WalkPreference)\"/>", this.getTrueFloatValStr(beginY));
                } else {
                    buf1 = String.format("<Cell V=\"%s\" N=\"BeginX\" F=\"PAR(PNT(Sheet.%d!Connections.X%d,Sheet.%d!Connections.Y%d))\"/>", this.getTrueFloatValStr(beginX), xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId);
                    buf2 = String.format("<Cell V=\"%s\" N=\"BeginY\" F=\"PAR(PNT(Sheet.%d!Connections.X%d,Sheet.%d!Connections.Y%d))\"/>", this.getTrueFloatValStr(beginY), xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId);
                }
                buf5 = String.format("<Cell V=\"2\" N=\"BegTrigger\" F=\"_XFTRIGGER(Sheet.%d!EventXFMod)\"/>", xConnHashEntry2._shapeId);
                connStr1 = String.format("<Connect ToPart=\"%d\" ToCell=\"Connections.X%d\" ToSheet=\"%d\" FromPart=\"9\" FromCell=\"BeginX\" FromSheet=\"%d\"/>", 100 + xConnHashEntry2._connectionId - 1, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, shapeId);
                isBegin = true;
                continue;
            }
            endX = x;
            endY = y;
            if (isLine) {
                buf3 = String.format("<Cell V=\"%s\" N=\"EndX\" F=\"_WALKGLUE(EndTrigger,BegTrigger,WalkPreference)\"/>", this.getTrueFloatValStr(endX));
                buf4 = String.format("<Cell V=\"%s\" N=\"EndY\" F=\"_WALKGLUE(EndTrigger,BegTrigger,WalkPreference)\"/>", this.getTrueFloatValStr(endY));
            } else {
                buf3 = String.format("<Cell V=\"%s\" N=\"EndX\" F=\"PAR(PNT(Sheet.%d!Connections.X%d,Sheet.%d!Connections.Y%d))\"/>", this.getTrueFloatValStr(endX), xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId);
                buf4 = String.format("<Cell V=\"%s\" N=\"EndY\" F=\"PAR(PNT(Sheet.%d!Connections.X%d,Sheet.%d!Connections.Y%d))\"/>", this.getTrueFloatValStr(endY), xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId);
            }
            buf6 = String.format("<Cell V=\"2\" N=\"EndTrigger\" F=\"_XFTRIGGER(Sheet.%d!EventXFMod)\"/>", xConnHashEntry2._shapeId);
            connStr2 = String.format("<Connect ToPart=\"%d\" ToCell=\"Connections.X%d\" ToSheet=\"%d\" FromPart=\"12\" FromCell=\"EndX\" FromSheet=\"%d\"/>", 100 + xConnHashEntry2._connectionId - 1, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, shapeId);
            isEnd = true;
        }
        if (angle != 0.0) {
            shape.TransProps.Angle = angle;
        }
        if (xConnHashEntry2 == null) {
            if (isLine) {
                this.prepareDynamicLineMaster();
                this._isDynamicLine = true;
                StringBuilder buff = new StringBuilder();
                buff.append(buf1).append(buf2).append(buf3).append(buf4);
                this._beginXYEndXYDef = buff.toString();
            }
            return false;
        }
        this._pinXStrDef = "";
        this._pinYStrDef = "";
        this._widthStrDef = "";
        if (!(isLine && isBegin && isEnd)) {
            String xF;
            StringBuilder xFBuilder = new StringBuilder();
            xFBuilder.append(" F=\"").append("PNT(").append("PNTX(PAR(PNT(Sheet.%d!Connections.X%d, Sheet.%d!Connections.Y%d)))").append(" - ").append("PNTX(PAR(PNT(Connections.X%d, Connections.Y%d)))").append(" + PNTX(PAR(PNT(LocPinX, LocPinY)))").append(", ").append("PNTY(PAR(PNT(Sheet.%d!Connections.X%d, Sheet.%d!Connections.Y%d)))").append(" - ").append("PNTY(PAR(PNT(Connections.X%d, Connections.Y%d)))").append(" + PNTY(PAR(PNT(LocPinX, LocPinY)))").append(")\"");
            this._pinXStrDef = xF = String.format(xFBuilder.toString(), xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, connId, connId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, xConnHashEntry2._shapeId, xConnHashEntry2._connectionId, connId, connId);
            this._pinYStrDef = xF;
        } else {
            this.prepareDynamicLineMaster();
            this._isDynamicLine = true;
            this._isConnection = true;
            this._connectionsPart.append(connStr1);
            this._connectionsPart.append(connStr2);
            StringBuilder buff = new StringBuilder();
            buff.append(buf1).append(buf2).append(buf3).append(buf4).append(buf5).append(buf6);
            Polyline poly = (Polyline)shape;
            if (poly.ConnectorView == 2 || poly.ConnectorView == 3) {
                buff.append("<Cell V=\"3\" N=\"ConFixedCode\"/>");
                buff.append("<Cell V=\"1\" N=\"ShapeRouteStyle\"/>");
                buff.append("<Cell V=\"1\" N=\"ConLineRouteExt\"/>");
            } else if (shape.shapeType() == 212) {
                buff.append("<Cell V=\"3\" N=\"ConFixedCode\"/>");
                buff.append("<Cell V=\"1\" N=\"ShapeRouteStyle\"/>");
                buff.append("<Cell V=\"2\" N=\"ConLineRouteExt\"/>");
            } else {
                buff.append("<Cell V=\"0\" N=\"ConFixedCode\"/>");
                buff.append("<Cell V=\"16\" N=\"ShapeRouteStyle\"/>");
                buff.append("<Cell V=\"1\" N=\"ConLineRouteExt\"/>");
            }
            this._beginXYEndXYDef = buff.toString();
            this._widthStrDef = " F=\"GUARD(EndX-BeginX)\"";
            this._heightStrDef = " F=\"GUARD(EndY-BeginY)\"";
        }
        return true;
    }

    private String getGluePointsContent(BaseGraphic shape, double pinX, double pinY, double locPinX, double locPinY) {
        double angle;
        int count;
        StringBuilder result = new StringBuilder();
        if (shape.ParentGB instanceof GraphicBlock && !(shape.ParentGB instanceof PhxLayer)) {
            return result.toString();
        }
        if (shape.GluePoints == null && shape.DynamicGluePoint == null) {
            return result.toString();
        }
        int n = count = shape.GluePoints == null ? 0 : shape.GluePoints.size();
        if (count == 0 && shape.DynamicGluePoint == null) {
            return result.toString();
        }
        double d = angle = shape.TransProps == null ? 0.0 : shape.TransProps.Angle;
        if (angle != 0.0) {
            shape.TransProps.Angle = 0.0;
        }
        AffineTransform xMatrix = SchemeEngine.GenTransform(shape);
        double[] gpss = new double[2];
        result.append("<Section N=\"Connection\">");
        for (int i = 0; i <= count; ++i) {
            BaseGraphic.GluePoint xGP = null;
            if (i < count && shape.GluePoints != null) {
                xGP = shape.GluePoints.get(i);
            } else if (i == count && shape.DynamicGluePoint != null) {
                xGP = shape.DynamicGluePoint;
            }
            if (xGP == null) continue;
            gpss[0] = xGP.ptX;
            gpss[1] = xGP.ptY;
            double[] gpts = SchemeEngine.MulPointsTM(xMatrix, gpss);
            double x = VsdxWriter.mmToInch(gpts[0]) + locPinX - pinX;
            double y = -VsdxWriter.mmToInch(gpts[1]) + locPinY - pinY;
            String xXFStr = "";
            String xYFStr = "";
            if (locPinX > BaseGraphic.FloatTolerance && locPinY > BaseGraphic.FloatTolerance && !this._isDynamicLine) {
                xXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(x / (locPinX + locPinX)));
                xYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(y / (locPinY + locPinY)));
            }
            result.append(String.format(this.getGPTemplate(), i, this.getTrueFloatValStr(x), xXFStr, this.getTrueFloatValStr(y), xYFStr));
        }
        if (angle != 0.0) {
            shape.TransProps.Angle = angle;
        }
        result.append("</Section>");
        return result.toString();
    }

    private void writeAsPolygon(BaseShape shape, double[] pts, int[] counts, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff, double orgAngle) {
        double y;
        double x;
        int pCount;
        StringBuilder xCurrentPart;
        boolean xIsLine;
        int xLayerIndex = this.getLayerIndex(shape);
        ShapeStyle xShapeStyle = new ShapeStyle();
        this.fillShapeStyle(shape, xShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, orgAngle, pts);
        boolean bl = xIsLine = shape instanceof Polyline && !(shape instanceof Region) && !(shape instanceof Polygon);
        if (this._curInsert != null && this._usePageMasterDefMode) {
            this._pageMasterDef.append(String.format(this.getShapeMasterShapeBaseTemplate(), this._shapeCount, this._pageMasterDefID, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern, xShapeStyle.transparent, xShapeStyle.transparentBorder));
            if (xShapeStyle.fillGradientEnabled.equalsIgnoreCase("1")) {
                if (xIsLine) {
                    this._pageMasterDef.append(String.format(this.getShapeLineGradientPartTemplate(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
                } else {
                    this._pageMasterDef.append(String.format(this.getShapeFillGradientPartTempalte(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
                }
            }
            this._pageMasterDef.append("</Shape>");
            return;
        }
        Object xCustomTagsContent = "";
        if (xIsLine) {
            xCustomTagsContent = this.getArrowsContent((Polyline)shape);
        }
        xCustomTagsContent = (String)xCustomTagsContent + this._beginXYEndXYDef + this.getGluePointsContent(shape, xShapeStyle.pinXN, xShapeStyle.pinYN, xShapeStyle.locPinXN, xShapeStyle.locPinYN);
        if (this._useMasterPart) {
            xCurrentPart = this._visioMastersMasterPart;
            xLayerIndex = 0;
        } else {
            xCurrentPart = this._visioPagesPage1Part;
        }
        if (this._isDynamicLine) {
            MasterHashEntry xMasterHashEntry = this._hashTable.get(-1000.0);
            int xMasterID = xMasterHashEntry._masterId;
            xCurrentPart.append(String.format(this.getShapePageShapeDynamicLineTemplate(), this._shapeCount, xMasterID, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xLayerIndex, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern));
        } else {
            xCurrentPart.append(String.format(this.getShapePageShapeBaseTemplate(), this._shapeCount, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xShapeStyle.angle, xLayerIndex, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern, xShapeStyle.transparent, xShapeStyle.transparentBorder));
        }
        if (shape.emText()) {
            if (shape.EmbeddedText.Inscribe) {
                this.fillEmStyle(shape.EmbeddedText, xCurrentPart);
            } else {
                this.writeTextShape(shape, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
            }
        }
        if (xShapeStyle.fillGradientEnabled.equalsIgnoreCase("1")) {
            if (xIsLine) {
                xCurrentPart.append(String.format(this.getShapeLineGradientPartTemplate(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
            } else {
                xCurrentPart.append(String.format(this.getShapeFillGradientPartTempalte(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
            }
        }
        if (!this._useMasterPart) {
            xCurrentPart.append(this.getShapeRelationshipContent(shape));
        }
        xCurrentPart.append((String)xCustomTagsContent);
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            xCurrentPart.append("</Shape>");
            this._isDynamicLine = false;
            return;
        }
        double xWidth = xShapeStyle.widthN;
        double xHeight = xShapeStyle.heightN;
        int sectCount = counts != null ? counts.length : 1;
        int vCount = pCount;
        int counter = 0;
        double mx = 0.0;
        double my = 0.0;
        int rowIndex = 1;
        boolean isDynamicLineWithJump = false;
        if (this._isDynamicLine && shape instanceof Polyline) {
            Polyline polyline = (Polyline)shape;
            boolean bl2 = isDynamicLineWithJump = this._currentPage != null && this._currentPage.LineJumpEnable && polyline.PointsWithJump != null && polyline.Points != null && polyline.PointsWithJump != null && polyline.PointsWithJump.length > polyline.Points.length;
            if (isDynamicLineWithJump) {
                DoubleList points = new DoubleList(polyline.PointsWithJump.length);
                IntegerList segments = new IntegerList(3);
                if (this.getSegmentsWithJump(polyline, points, segments)) {
                    xCurrentPart.append(String.format(this.getShapePageShapeGeometryHeaderTemplate(), 0, xShapeStyle.noFill, this._isHidden ? 1 : 0));
                    double[] ptsJumps = points.toArray();
                    vCount = ptsJumps.length / 2;
                    int segmentIdx = 0;
                    int endSegment = segments.get(segmentIdx);
                    boolean isJump = false;
                    int rowIdx = 1;
                    for (int p = 0; p < vCount; ++p) {
                        if (p >= endSegment) {
                            assert (++segmentIdx >= 0 && segmentIdx < segments.size());
                            int cntSegment = segments.get(segmentIdx);
                            endSegment += cntSegment;
                            boolean bl3 = isJump = segmentIdx % 2 == 1;
                            if (isJump) {
                                int idx;
                                String s = this.createJumpRow(xShapeStyle, this._currentPage.LineJumpType, ptsJumps, p, cntSegment, rowIdx, xWidth, xHeight, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
                                if (s != null && !s.isEmpty()) {
                                    xCurrentPart.append(s);
                                    ++rowIdx;
                                }
                                if (this._currentPage.LineJumpType != 1 || (p += cntSegment - 1) + 1 >= vCount || !SchemeUtils.isEqual(ptsJumps[idx = p + p], ptsJumps[idx + 2]) || !SchemeUtils.isEqual(ptsJumps[idx + 1], ptsJumps[idx + 3])) continue;
                                ++p;
                                continue;
                            }
                        }
                        if (isJump) continue;
                        int idx = p + p;
                        x = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(ptsJumps[idx]) * parentWidthCoeff + parentWidth / 2.0;
                        y = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(ptsJumps[idx + 1]) * parentHeightCoeff + parentHeight / 2.0;
                        if (p == 0) {
                            xCurrentPart.append(String.format("<Row T=\"MoveTo\" IX=\"%d\">", rowIdx++));
                        } else {
                            xCurrentPart.append(String.format("<Row T=\"LineTo\" IX=\"%d\">", rowIdx++));
                        }
                        xCurrentPart.append(String.format("<Cell N=\"X\" V=\"%s\"/>", this.getTrueFloatValStr(x))).append(String.format("<Cell N=\"Y\" V=\"%s\"/>", this.getTrueFloatValStr(y))).append("</Row>");
                    }
                    xCurrentPart.append("</Section>");
                    counter += vCount;
                } else {
                    isDynamicLineWithJump = false;
                }
            }
        }
        if (!isDynamicLineWithJump) {
            for (int i = 0; i < sectCount; ++i) {
                if (sectCount > 1) {
                    vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
                }
                xCurrentPart.append(String.format(this.getShapePageShapeGeometryHeaderTemplate(), i, xShapeStyle.noFill, this._isHidden ? 1 : 0));
                if (shape instanceof Spline) {
                    if (vCount > 0 && (vCount - 4) % 3 == 0) {
                        int ns = (vCount - 1) / 3;
                        for (int k = 0; k < ns; ++k) {
                            int i0 = 2 * (counter + k * 3);
                            int i1 = i0 + 2;
                            int i2 = i0 + 4;
                            int i3 = i0 + 6;
                            if (k == 0) {
                                x = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(pts[i0]) * parentWidthCoeff + parentWidth / 2.0;
                                y = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(pts[i0 + 1]) * parentHeightCoeff + parentHeight / 2.0;
                                xCurrentPart.append(String.format("<Row T=\"RelMoveTo\" IX=\"%d\">", rowIndex));
                                if (xWidth > 1.0E-5) {
                                    x /= xWidth;
                                }
                                if (xHeight > 1.0E-5) {
                                    y /= xHeight;
                                }
                                xCurrentPart.append(String.format("<Cell N=\"X\" V=\"%s\"/>", this.getTrueFloatValStr(x))).append(String.format("<Cell N=\"Y\" V=\"%s\"/>", this.getTrueFloatValStr(y))).append("</Row>");
                                ++rowIndex;
                            }
                            double A = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(pts[i1]) * parentWidthCoeff + parentWidth / 2.0;
                            double B = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(pts[i1 + 1]) * parentHeightCoeff + parentHeight / 2.0;
                            if (xWidth > 1.0E-5) {
                                A /= xWidth;
                            }
                            if (xHeight > 1.0E-5) {
                                B /= xHeight;
                            }
                            double C = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(pts[i2]) * parentWidthCoeff + parentWidth / 2.0;
                            double D = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(pts[i2 + 1]) * parentHeightCoeff + parentHeight / 2.0;
                            if (xWidth > 1.0E-5) {
                                C /= xWidth;
                            }
                            if (xHeight > 1.0E-5) {
                                D /= xHeight;
                            }
                            x = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(pts[i3]) * parentWidthCoeff + parentWidth / 2.0;
                            y = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(pts[i3 + 1]) * parentHeightCoeff + parentHeight / 2.0;
                            if (xWidth > 1.0E-5) {
                                x /= xWidth;
                            }
                            if (xHeight > 1.0E-5) {
                                y /= xHeight;
                            }
                            xCurrentPart.append(String.format("<Row T=\"RelCubBezTo\" IX=\"%d\">", rowIndex));
                            xCurrentPart.append(String.format("<Cell N=\"X\" V=\"%s\"/>", this.getTrueFloatValStr(x))).append(String.format("<Cell N=\"Y\" V=\"%s\"/>", this.getTrueFloatValStr(y))).append(String.format("<Cell N=\"A\" V=\"%s\"/>", this.getTrueFloatValStr(A))).append(String.format("<Cell N=\"B\" V=\"%s\"/>", this.getTrueFloatValStr(B))).append(String.format("<Cell N=\"C\" V=\"%s\"/>", this.getTrueFloatValStr(C))).append(String.format("<Cell N=\"D\" V=\"%s\"/>", this.getTrueFloatValStr(D))).append("</Row>");
                            ++rowIndex;
                        }
                    }
                } else {
                    for (int j = 0; j <= vCount; ++j) {
                        if (j == vCount && xShapeStyle.noFill.equalsIgnoreCase("1")) continue;
                        int idx = 2 * (counter + j);
                        if (j == vCount) {
                            x = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(mx) * parentWidthCoeff + parentWidth / 2.0;
                            y = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(my) * parentHeightCoeff + parentHeight / 2.0;
                        } else {
                            x = -xShapeStyle.pinXN + xWidth / 2.0 - xShapeStyle.locPinXOffsetN + VsdxWriter.mmToInch(pts[idx]) * parentWidthCoeff + parentWidth / 2.0;
                            y = -xShapeStyle.pinYN + xHeight / 2.0 + xShapeStyle.locPinYOffsetN + VsdxWriter.mmToInch(pts[idx + 1]) * parentHeightCoeff + parentHeight / 2.0;
                        }
                        if (j == 0) {
                            mx = pts[2 * counter];
                            my = pts[2 * counter + 1];
                            if (!this._isDynamicLine) {
                                xCurrentPart.append(String.format("<Row T=\"RelMoveTo\" IX=\"%d\">", j + 1));
                            } else {
                                xCurrentPart.append(String.format("<Row T=\"MoveTo\" IX=\"%d\">", j + 1));
                            }
                        } else if (!this._isDynamicLine) {
                            xCurrentPart.append(String.format("<Row T=\"RelLineTo\" IX=\"%d\">", j + 1));
                        } else {
                            xCurrentPart.append(String.format("<Row T=\"LineTo\" IX=\"%d\">", j + 1));
                        }
                        if (xWidth > 1.0E-5 && !this._isDynamicLine) {
                            x /= xWidth;
                        }
                        if (xHeight > 1.0E-5 && !this._isDynamicLine) {
                            y /= xHeight;
                        }
                        xCurrentPart.append(String.format("<Cell N=\"X\" V=\"%s\"/>", this.getTrueFloatValStr(x))).append(String.format("<Cell N=\"Y\" V=\"%s\"/>", this.getTrueFloatValStr(y))).append("</Row>");
                    }
                }
                xCurrentPart.append("</Section>");
                counter += vCount;
            }
        }
        if (shape.emText() && shape.EmbeddedText.Inscribe) {
            this.addEm(shape.EmbeddedText, xCurrentPart);
        }
        xCurrentPart.append("</Shape>");
        this._isDynamicLine = false;
    }

    private String createJumpRow(ShapeStyle style, int jumpType, double[] points, int startPoint, int cntPoint, int rowIdx, double width, double height, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        if (height == 0.0 || width == 0.0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder func = new StringBuilder();
        switch (jumpType) {
            case 0: {
                sb.append(String.format("<Row T=\"MoveTo\" IX=\"%d\">", rowIdx));
                break;
            }
            case 1: {
                sb.append(String.format("<Row T=\"ArcTo\" IX=\"%d\">", rowIdx));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                sb.append(String.format("<Row T=\"PolylineTo\" IX=\"%d\">", rowIdx));
                func.append("POLYLINE(0, 0");
                if (cntPoint <= 1) {
                    return null;
                }
                for (int i = 0; i < cntPoint - 1; ++i) {
                    int idx = (startPoint + i) * 2;
                    double x = -style.pinXN + width / 2.0 - style.locPinXOffsetN + VsdxWriter.mmToInch(points[idx]) * parentWidthCoeff + parentWidth / 2.0;
                    double y = -style.pinYN + height / 2.0 + style.locPinYOffsetN + VsdxWriter.mmToInch(points[idx + 1]) * parentHeightCoeff + parentHeight / 2.0;
                    func.append(", ").append(this.getTrueFloatValStr(x / width)).append(", ").append(this.getTrueFloatValStr(y / height));
                }
                func.append(")");
                break;
            }
        }
        int idx = (jumpType == 1 ? startPoint + cntPoint : startPoint + cntPoint - 1) * 2;
        double x = -style.pinXN + width / 2.0 - style.locPinXOffsetN + VsdxWriter.mmToInch(points[idx]) * parentWidthCoeff + parentWidth / 2.0;
        double y = -style.pinYN + height / 2.0 + style.locPinYOffsetN + VsdxWriter.mmToInch(points[idx + 1]) * parentHeightCoeff + parentHeight / 2.0;
        sb.append(String.format("<Cell N=\"X\" V=\"%s\"/>", this.getTrueFloatValStr(x))).append(String.format("<Cell N=\"Y\" V=\"%s\"/>", this.getTrueFloatValStr(y)));
        String strFunc = func.toString();
        if (!strFunc.isEmpty()) {
            sb.append(String.format("<Cell N=\"A\" F=\"%s\"/>", strFunc));
        } else if (jumpType == 1) {
            idx = (startPoint - 1) * 2;
            assert (idx >= 0 && idx < points.length - 1);
            double x0 = -style.pinXN + width / 2.0 - style.locPinXOffsetN + VsdxWriter.mmToInch(points[idx]) * parentWidthCoeff + parentWidth / 2.0;
            double y0 = -style.pinYN + height / 2.0 + style.locPinYOffsetN + VsdxWriter.mmToInch(points[idx + 1]) * parentHeightCoeff + parentHeight / 2.0;
            double r = SchemeUtils.distance(x0, y0, x, y) / 2.0;
            if (x0 < x) {
                r = -r;
            } else if (x0 == x && y0 < y) {
                r = -r;
            }
            sb.append(String.format("<Cell N=\"A\" V=\"%s\"/>", this.getTrueFloatValStr(r)));
        }
        sb.append("</Row>");
        return sb.toString();
    }

    private boolean getSegmentsWithJump(Polyline line, DoubleList points, IntegerList segments) {
        int segmentJumpLen;
        assert (points != null);
        assert (segments != null);
        assert (line != null);
        points.clear();
        segments.clear();
        if (this._currentPage == null || line.Points == null || line.PointsWithJump == null) {
            return false;
        }
        if (this._currentPage.LineJumpType == 1) {
            int idx = 0;
            while (idx < line.PointsWithJump.length - 1) {
                double x = line.PointsWithJump[idx++];
                double y = line.PointsWithJump[idx++];
                points.add(x);
                points.add(-y);
            }
            for (int v : line.PointsCounts) {
                segments.add(v);
            }
            return true;
        }
        int segmentAfterJumpLen = 1;
        switch (this._currentPage.LineJumpType) {
            case 0: {
                segmentJumpLen = 1;
                break;
            }
            case 2: {
                segmentJumpLen = 3;
                break;
            }
            case 3: {
                segmentJumpLen = 2;
                break;
            }
            case 4: {
                segmentJumpLen = 3;
                break;
            }
            case 5: {
                segmentJumpLen = 4;
                break;
            }
            case 6: {
                segmentJumpLen = 5;
                break;
            }
            case 7: {
                segmentJumpLen = 6;
                break;
            }
            case 8: {
                segmentJumpLen = 7;
                break;
            }
            default: {
                return false;
            }
        }
        AffineTransform tm = SchemeEngine.GenTransform(line);
        double[] transformPoints = SchemeEngine.MulPointsTM(tm, line.Points);
        BaseGraphic.RealPoint p1 = new BaseGraphic.RealPoint();
        BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint();
        int i = 0;
        int j = 0;
        int segmentLen = 0;
        while (i < transformPoints.length - 1 && j < line.PointsWithJump.length - 1) {
            p1.X = transformPoints[i++];
            p1.Y = transformPoints[i++];
            p2.X = line.PointsWithJump[j++];
            p2.Y = line.PointsWithJump[j++];
            ++segmentLen;
            points.add(p2.X);
            points.add(-p2.Y);
            if (SchemeUtils.isEqual(p1, p2)) continue;
        }
        if (segmentLen == 1) {
            return false;
        }
        segments.add(segmentLen);
        assert (points.size() == segmentLen + segmentLen);
        double lastX = p2.X;
        double lastY = p2.Y;
        int idx = segmentLen + segmentLen;
        while (idx < line.PointsWithJump.length - 1) {
            double x = line.PointsWithJump[idx++];
            double y = line.PointsWithJump[idx++];
            if (SchemeUtils.isEqual(lastX, x) && SchemeUtils.isEqual(lastY, y)) continue;
            points.add(x);
            points.add(-y);
            lastX = x;
            lastY = y;
        }
        int totalPoints = points.size() / 2;
        int max = totalPoints - segmentJumpLen - segmentAfterJumpLen;
        for (i = segmentLen; i <= max; i += segmentAfterJumpLen) {
            segments.add(segmentJumpLen);
            i += segmentJumpLen;
            segments.add(segmentAfterJumpLen);
        }
        if (i < totalPoints) {
            segments.set(segments.size() - 1, totalPoints - i + segmentAfterJumpLen);
        }
        return segments.size() > 2;
    }

    private String getShapePageShapeDynamicLineTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" NameU=\"Dynamic connector\" Name=\"\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u043b\u0438\u043d\u0438\u044f\" Type=\"Shape\" Master=\"%d\">").append("   <Cell N=\"PinX\" V=\"%s\"%s/>").append("   <Cell N=\"PinY\" V=\"%s\"%s/>").append("   <Cell N=\"Width\" V=\"%s\"%s/>").append("   <Cell N=\"Height\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinY\" V=\"%s\"%s/>").append("   <Cell N=\"LayerMember\" V=\"%d\"/>").append("   <Cell N=\"FillForegnd\" V=\"%s\"/>").append("   <Cell N=\"FillBkgnd\" V=\"%s\"/>").append("   <Cell N=\"LineColor\" V=\"%s\"/>").append("   <Cell N=\"LineWeight\" V=\"%s\" U=\"MM\"/>").append("   <Cell N=\"LinePattern\" V=\"%s\"/>").append("   <Cell N=\"LineCap\" V=\"%d\"/>").append("   <Cell N=\"FillPattern\" V=\"%s\"/>");
        return template.toString();
    }

    private void writePolygon(Polygon polygon, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (polygon.ContainerID != 0.0) {
                this._relationshipHashTable.put(polygon.ID, this._shapeCount);
            }
            return;
        }
        double[] points = polygon.Points;
        double d = angle = polygon.TransProps == null ? 0.0 : polygon.TransProps.Angle;
        if (angle != 0.0) {
            polygon.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polygon), points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(polygon, pts, polygon.Counts, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            polygon.TransProps.Angle = angle;
        }
    }

    private void writeRegion(Region region, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (region.ContainerID != 0.0) {
                this._relationshipHashTable.put(region.ID, this._shapeCount);
            }
            return;
        }
        if (region.Points == null || region.Points.length <= 2) {
            return;
        }
        double d = angle = region.TransProps == null ? 0.0 : region.TransProps.Angle;
        if (angle != 0.0) {
            region.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(region), region.Points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(region, pts, region.Counts, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            region.TransProps.Angle = angle;
        }
    }

    private void writeSpline(Spline spline, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (spline.ContainerID != 0.0) {
                this._relationshipHashTable.put(spline.ID, this._shapeCount);
            }
            return;
        }
        double d = angle = spline.TransProps == null ? 0.0 : spline.TransProps.Angle;
        if (angle != 0.0) {
            spline.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(spline), spline.Points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(spline, pts, null, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            spline.TransProps.Angle = angle;
        }
    }

    private void writePolyline(Polyline polyline, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (polyline.ContainerID != 0.0) {
                this._relationshipHashTable.put(polyline.ID, this._shapeCount);
            }
            return;
        }
        double[] points = polyline.Points;
        double d = angle = polyline.TransProps == null ? 0.0 : polyline.TransProps.Angle;
        if (angle != 0.0) {
            polyline.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polyline), points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(polyline, pts, null, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            polyline.TransProps.Angle = angle;
        }
    }

    private void writePie(Pie pie, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (pie.ContainerID != 0.0) {
                this._relationshipHashTable.put(pie.ID, this._shapeCount);
            }
            return;
        }
        byte pieType = pie.PieType;
        double sideX = Math.abs(pie.SideX);
        double sideY = Math.abs(pie.SideY);
        double[] points = SchemeEngine.SidesToPie(sideX, sideY, pie.Slices + 1, pieType, -pie.EndAngle, -pie.StartAngle);
        double d = angle = pie.TransProps == null ? 0.0 : pie.TransProps.Angle;
        if (angle != 0.0) {
            pie.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(pie), points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(pie, pts, null, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            pie.TransProps.Angle = angle;
        }
    }

    private boolean isNeedWriteEllipseAsPolygon(Ellipse ellipse) {
        double skewX = ellipse.TransProps == null ? 0.0 : ellipse.TransProps.SkewX;
        double skewY = ellipse.TransProps == null ? 0.0 : ellipse.TransProps.SkewY;
        double scaleX = ellipse.TransProps == null ? 1.0 : ellipse.TransProps.ScaleX;
        double scaleY = ellipse.TransProps == null ? 1.0 : ellipse.TransProps.ScaleY;
        double cx = ellipse.TransProps == null ? 0.0 : ellipse.TransProps.CenterX;
        double cy = ellipse.TransProps == null ? 0.0 : ellipse.TransProps.CenterY;
        return scaleX != 1.0 || scaleY != 1.0 || skewX != 0.0 || skewY != 0.0 || cx != 0.0 || cy != 0.0;
    }

    private void writeEllipse(Ellipse ellipse, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        StringBuilder xCurrentPart;
        double angle;
        if (this._relationshipTestMode) {
            if (ellipse.ContainerID != 0.0) {
                this._relationshipHashTable.put(ellipse.ID, this._shapeCount);
            }
            return;
        }
        double[] points = SchemeEngine.SidesToEllipse(ellipse.SideX, ellipse.SideY, ellipse.Slices);
        double d = angle = ellipse.TransProps == null ? 0.0 : ellipse.TransProps.Angle;
        if (angle != 0.0) {
            ellipse.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(ellipse), points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        if (this.isNeedWriteEllipseAsPolygon(ellipse)) {
            this.writeAsPolygon(ellipse, pts, null, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
            if (angle != 0.0) {
                ellipse.TransProps.Angle = angle;
            }
            return;
        }
        int xLayerIndex = this.getLayerIndex(ellipse);
        ShapeStyle xShapeStyle = new ShapeStyle();
        this.fillShapeStyle(ellipse, xShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle, null);
        if (this._curInsert != null && this._usePageMasterDefMode) {
            this._pageMasterDef.append(String.format(this.getShapeMasterShapeBaseTemplate(), this._shapeCount, this._pageMasterDefID, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern, xShapeStyle.transparent, xShapeStyle.transparentBorder));
            if (xShapeStyle.fillGradientEnabled.equalsIgnoreCase("1")) {
                this._pageMasterDef.append(String.format(this.getShapeFillGradientPartTempalte(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
            }
            this._pageMasterDef.append(String.format(this.getEllipseGeomTemplate(), xShapeStyle.locPinX, xShapeStyle.locPinY, xShapeStyle.width, xShapeStyle.locPinY, xShapeStyle.locPinX, xShapeStyle.height));
            this._pageMasterDef.append("</Shape>");
            if (angle != 0.0) {
                ellipse.TransProps.Angle = angle;
            }
            return;
        }
        String xCustomTagsContent = this._beginXYEndXYDef + this.getGluePointsContent(ellipse, xShapeStyle.pinXN, xShapeStyle.pinYN, xShapeStyle.locPinXN, xShapeStyle.locPinYN);
        if (this._useMasterPart) {
            xCurrentPart = this._visioMastersMasterPart;
            xLayerIndex = 0;
        } else {
            xCurrentPart = this._visioPagesPage1Part;
        }
        xCurrentPart.append(String.format(this.getShapePageShapeBaseTemplate(), this._shapeCount, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xShapeStyle.angle, xLayerIndex, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern, xShapeStyle.transparent, xShapeStyle.transparentBorder));
        if (ellipse.emText()) {
            if (ellipse.EmbeddedText.Inscribe) {
                this.fillEmStyle(ellipse.EmbeddedText, xCurrentPart);
            } else {
                this.writeTextShape(ellipse, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
            }
        }
        if (xShapeStyle.fillGradientEnabled.equalsIgnoreCase("1")) {
            xCurrentPart.append(String.format(this.getShapeFillGradientPartTempalte(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
        }
        if (!this._useMasterPart) {
            xCurrentPart.append(this.getShapeRelationshipContent(ellipse));
        }
        xCurrentPart.append(xCustomTagsContent);
        xCurrentPart.append(String.format(this.getShapePageShapeGeometryHeaderTemplate(), 0, xShapeStyle.noFill, this._isHidden ? 1 : 0));
        xCurrentPart.append("<Row T=\"Ellipse\" IX=\"1\">").append(String.format("<Cell N=\"X\" V=\"%s\" F=\"Width*0.5\"/>", xShapeStyle.locPinX)).append(String.format("<Cell N=\"Y\" V=\"%s\" F=\"Height*0.5\"/>", xShapeStyle.locPinY)).append(String.format("<Cell N=\"A\" V=\"%s\" F=\"Width*1\" U=\"DL\"/>", xShapeStyle.width)).append(String.format("<Cell N=\"B\" V=\"%s\" F=\"Height*0.5\" U=\"DL\"/>", xShapeStyle.locPinY)).append(String.format("<Cell N=\"C\" V=\"%s\" F=\"Width*0.5\" U=\"DL\"/>", xShapeStyle.locPinX)).append(String.format("<Cell N=\"D\" V=\"%s\" F=\"Height*1\" U=\"DL\"/>", xShapeStyle.height)).append("</Row>").append("</Section>");
        if (ellipse.emText() && ellipse.EmbeddedText.Inscribe) {
            this.addEm(ellipse.EmbeddedText, xCurrentPart);
        }
        xCurrentPart.append("</Shape>");
        if (angle != 0.0) {
            ellipse.TransProps.Angle = angle;
        }
    }

    private static byte getVisioHAlign(byte align) {
        switch (align) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private static int getVisioVAlign(int align) {
        switch (align) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static String repairFontName(String fontName) {
        String result = fontName.trim().replaceAll(" Cyr", "");
        if (result.length() == 0 || result.equalsIgnoreCase("txt")) {
            result = "Arial";
        }
        return result;
    }

    private static String correctText(String text) {
        if (Strings.isVoid(text)) {
            return " ";
        }
        StringBuilder tmp = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    tmp.append("&quot;");
                    continue block7;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block7;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block7;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block7;
                }
                case '\u2028': {
                    tmp.append('\n');
                    continue block7;
                }
                default: {
                    tmp.append(c);
                }
            }
        }
        return tmp.toString();
    }

    private void writeParagraph(Paragraph paragraph, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        int i;
        StringBuilder xCurrentPart;
        if (this._relationshipTestMode) {
            if (paragraph.ContainerID != 0.0) {
                this._relationshipHashTable.put(paragraph.ID, this._shapeCount);
            }
            return;
        }
        double xSchemeScale = this._schemeScale * 25.4;
        if (this._useMasterPart) {
            xSchemeScale = 1.0;
        }
        if (paragraph.Lines == null || paragraph.Lines.isEmpty()) {
            return;
        }
        RectTextLine line = (RectTextLine)paragraph.Lines.get(0);
        if (line.FontName.equalsIgnoreCase("symbol")) {
            return;
        }
        int xLayerIndex = this.getLayerIndex(paragraph);
        ShapeStyle xShapeStyle = new ShapeStyle();
        String xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(paragraph.lfHeight < 1.0E-12 ? 2.0 * line.SideY / 3.0 / (double)paragraph.Lines.size() : paragraph.lfHeight) * xSchemeScale);
        double angle = paragraph.TransProps == null ? 0.0 : paragraph.TransProps.Angle;
        this.fillShapeStyle(paragraph, xShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle, null);
        if (!paragraph.ShowBackground) {
            xShapeStyle.fillPattern = "0";
            xShapeStyle.linePattern = "0";
        }
        if (this._useMasterPart) {
            xCurrentPart = this._visioMastersMasterPart;
            xLayerIndex = 0;
        } else {
            xCurrentPart = this._curInsert != null && this._usePageMasterDefMode ? this._pageMasterDef : this._visioPagesPage1Part;
        }
        xCurrentPart.append(String.format(this.getShapePageShapeBaseTemplate(), this._shapeCount, xShapeStyle.pinX, xShapeStyle.pinXFStr, xShapeStyle.pinY, xShapeStyle.pinYFStr, xShapeStyle.width, xShapeStyle.widthFStr, xShapeStyle.height, xShapeStyle.heightFStr, xShapeStyle.locPinX, xShapeStyle.locPinXFStr, xShapeStyle.locPinY, xShapeStyle.locPinYFStr, xShapeStyle.angle, xLayerIndex, xShapeStyle.color, xShapeStyle.bkColor, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, xShapeStyle.lineCap, xShapeStyle.fillPattern, xShapeStyle.transparent, xShapeStyle.transparentBorder));
        xCurrentPart.append(String.format(this.getMargnsTemplate(), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.LeftMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.RightMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.TopMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.BottomMargin) * xSchemeScale)));
        if (!this._useMasterPart) {
            if (!(paragraph instanceof Attribute) || !((Attribute)paragraph).Inscribe || !paragraph.AutoSize || paragraph.ParentGB == null || SchemeObjectsTypes.ObjTypeIsLayer(paragraph.ParentGB.shapeType())) {
                int visioVertAlign = this._currentHeadingId != 0.0 ? 1 : VsdxWriter.getVisioVAlign(paragraph.VertAlign);
                xCurrentPart.append(String.format("<Cell V=\"%d\" N=\"VerticalAlign\"/>", visioVertAlign));
            }
            xCurrentPart.append(this.getShapeRelationshipContent(paragraph));
        }
        if (this._isHidden) {
            xCurrentPart.append(HIDE_TEXT_TEMPLATE);
        }
        if (paragraph.isPart() && paragraph.isFontBgColorSetted && paragraph.fontBgColor != null) {
            xCurrentPart.append(String.format(TXTBGND_COLOR_TEMPLATE, this.getColorCode(paragraph.fontBgColor)));
        }
        if (!this._useMasterPart && !this._usePageMasterDefMode && parentId != 0) {
            xCurrentPart.append(DBL_CLICK_EVENT_TEMPLATE);
        }
        if (xShapeStyle.fillGradientEnabled.equalsIgnoreCase("1") && paragraph.ShowBackground) {
            xCurrentPart.append(String.format(this.getShapeFillGradientPartTempalte(), xShapeStyle.fillGradientDir, xShapeStyle.fillGradientAngle, xShapeStyle.colorRowIX0, xShapeStyle.colorRowIX1, xShapeStyle.stopPositionIX1, xShapeStyle.colorRowIX2));
        }
        xCurrentPart.append(String.format(this.getShapePageShapeGeometryHeaderTemplate(), 0, xShapeStyle.noFill, this._isHidden ? 1 : 0));
        xCurrentPart.append("<Row IX=\"1\" T=\"RelMoveTo\">").append(" <Cell V=\"0\" N=\"X\"/>").append(" <Cell V=\"0\" N=\"Y\"/>").append("</Row>").append("<Row IX=\"2\" T=\"RelLineTo\">").append(" <Cell V=\"1\" N=\"X\"/>").append(" <Cell V=\"0\" N=\"Y\"/>").append("</Row>").append("<Row IX=\"3\" T=\"RelLineTo\">").append(" <Cell V=\"1\" N=\"X\"/>").append(" <Cell V=\"1\" N=\"Y\"/>").append("</Row>").append("<Row IX=\"4\" T=\"RelLineTo\">").append(" <Cell V=\"0\" N=\"X\"/>").append(" <Cell V=\"1\" N=\"Y\"/>").append("</Row>").append("<Row IX=\"5\" T=\"RelLineTo\">").append(" <Cell V=\"0\" N=\"X\"/>").append(" <Cell V=\"0\" N=\"Y\"/>").append("</Row>");
        xCurrentPart.append("</Section>");
        if (!paragraph.isPart()) {
            String xFontName = VsdxWriter.repairFontName(line.FontName);
            Color fontColor = line.FontColor;
            String xFontColor = xShapeStyle.fontColor;
            int xBuffInt = 0;
            if ((line.FontStyle & 1) != 0) {
                xBuffInt |= 1;
            }
            if ((line.FontStyle & 2) != 0) {
                xBuffInt |= 2;
            }
            if ((line.FontStyle & 4) != 0) {
                xBuffInt |= 4;
            }
            String xFontStyle = String.valueOf(xBuffInt);
            String xFontStrikethru = "0";
            if ((line.FontStyle & 8) != 0) {
                xFontStrikethru = "1";
            }
            String xFontScale = this.getTrueFloatValStr(paragraph.WidthScale);
            xCurrentPart.append("<Section N=\"Tabs\"><Row IX=\"0\"/></Section>");
            xCurrentPart.append("<Section N=\"Character\">").append(String.format(this.getAttribChrSectnTemplate(), 0, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, 0, this.getTrueFloatValStr((double)paragraph.TransparentText / 255.0))).append("</Section>");
        } else {
            xCurrentPart.append("<Section N=\"Tabs\"><Row IX=\"0\">");
            xCurrentPart.append(String.format("<Cell N=\"Position0\" V=\"%s\"/><Cell N=\"Alignment0\" V=\"0\"/>", this.getTrueFloatValStr(VsdxWriter.mmToInch(paragraph.TabStopPosition) * xSchemeScale)));
            xCurrentPart.append("</Row></Section>");
        }
        xCurrentPart.append("<Section N=\"Paragraph\">");
        int counter = 0;
        int cnt = paragraph.Lines.size();
        for (int i2 = 0; i2 < cnt; ++i2) {
            RectTextLine rtl2;
            RectTextLine rtl = (RectTextLine)paragraph.Lines.get(i2);
            if (rtl.Text == null || rtl.Text.isEmpty() || i2 != 0 && rtl.samePL(rtl2 = (RectTextLine)paragraph.Lines.get(i2 - 1))) continue;
            if (rtl.paragraphLine == null) {
                String sectRowIX = "<Row IX=\"%d\"><Cell V=\"-%s\" N=\"SpLine\"/><Cell V=\"%d\" N=\"HorzAlign\"/></Row>";
                xCurrentPart.append(String.format(sectRowIX, counter, this.getTrueFloatValStr(Math.abs(paragraph.LineSpacing)), VsdxWriter.getVisioHAlign(paragraph.Align)));
            } else {
                RectTextLine.ParagraphLine pLine = rtl.paragraphLine;
                String sectRowIX = "<Row IX=\"%d\"><Cell N=\"SpLine\" V=\"-%s\"/><Cell N=\"HorzAlign\" V=\"%d\"/><Cell N=\"IndFirst\" V=\"%s\"/><Cell N=\"IndLeft\" V=\"%s\"/><Cell N=\"IndRight\" V=\"%s\"/><Cell N=\"SpBefore\" V=\"%s\"/><Cell N=\"SpAfter\" V=\"%s\"/></Row>";
                xCurrentPart.append(String.format(sectRowIX, counter, this.getTrueFloatValStr(Math.abs(pLine.lineSpacing)), VsdxWriter.getVisioHAlign(pLine.align), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.firstIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.leftIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.rightIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.spaceBefore) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.spaceAfter) * xSchemeScale)));
            }
            ++counter;
        }
        xCurrentPart.append("</Section>");
        counter = 0;
        if (!paragraph.isPart()) {
            xCurrentPart.append("<Text>");
            StringBuilder xText = new StringBuilder("");
            for (i = 0; i < paragraph.Lines.size(); ++i) {
                RectTextLine rtl = (RectTextLine)paragraph.Lines.get(i);
                if (rtl.Text == null || rtl.Text.isEmpty()) continue;
                String correctedText = VsdxWriter.correctText(rtl.Text);
                if (i == 0) {
                    xText = new StringBuilder(correctedText);
                } else {
                    if (rtl.paragraphLine != null) {
                        xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), 0, 0, counter++, xText));
                        xText = new StringBuilder("");
                    }
                    xText.append(correctedText);
                }
                xText.append("\n");
            }
            xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), 0, 0, counter, xText));
            xCurrentPart.append("</Text>");
        } else {
            RectTextLine.PartTextLine part;
            int j;
            xCurrentPart.append("<Section N=\"Character\">");
            int idx = 0;
            for (i = 0; i < paragraph.Lines.size(); ++i) {
                line = (RectTextLine)paragraph.Lines.get(i);
                if (line == null) continue;
                for (j = 0; j < line.Parts.size(); ++j) {
                    part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    String xFontName = VsdxWriter.repairFontName(part.fontName);
                    String xFontColor = this.getColorCode(part.fontColor);
                    xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(part.fontHeight) * xSchemeScale);
                    int xBuffInt = 0;
                    if ((part.fontStyle & 1) != 0) {
                        xBuffInt |= 1;
                    }
                    if ((part.fontStyle & 2) != 0) {
                        xBuffInt |= 2;
                    }
                    if ((part.fontStyle & 4) != 0) {
                        xBuffInt |= 4;
                    }
                    String xFontStyle = String.valueOf(xBuffInt);
                    String xFontStrikethru = "0";
                    if ((part.fontStyle & 8) != 0) {
                        xFontStrikethru = "1";
                    }
                    String xFontScale = this.getTrueFloatValStr(paragraph.WidthScale);
                    int pos = 0;
                    if (part.ssScript == 1) {
                        pos = 2;
                    }
                    if (part.ssScript == 2) {
                        pos = 1;
                    }
                    Color fontColor = part.fontColor;
                    xCurrentPart.append(String.format(this.getAttribChrSectnTemplate(), idx, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, pos, this.getTrueFloatValStr((double)paragraph.TransparentText / 255.0)));
                    ++idx;
                }
            }
            xCurrentPart.append("</Section>");
            xCurrentPart.append("<Text>");
            idx = 0;
            for (i = 0; i < paragraph.Lines.size(); ++i) {
                line = (RectTextLine)paragraph.Lines.get(i);
                if (line == null) continue;
                if (i > 0) {
                    xCurrentPart.append("\n");
                }
                for (j = 0; j < line.Parts.size(); ++j) {
                    part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), idx, 0, i, VsdxWriter.correctText(part.text)));
                    ++idx;
                }
            }
            xCurrentPart.append("</Text>");
        }
        xCurrentPart.append("</Shape>");
        if (angle != 0.0) {
            paragraph.TransProps.Angle = angle;
        }
    }

    private void writeTextShape(BaseGraphic textShape, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        StringBuilder xCurrentPart;
        double shapeAngle;
        if (!(textShape instanceof GraphicBlock)) {
            parentWidth = 0.0;
            parentHeight = 0.0;
        }
        assert (textShape != null);
        EmbeddedText paragraph = textShape.EmbeddedText;
        assert (paragraph != null);
        if (this._relationshipTestMode) {
            if (paragraph.ContainerID != 0.0) {
                this._relationshipHashTable.put(paragraph.ID, this._shapeCount);
            }
            return;
        }
        double xSchemeScale = this._schemeScale * 25.4;
        if (this._useMasterPart) {
            xSchemeScale = 1.0;
        }
        if (paragraph.Lines == null || paragraph.Lines.isEmpty()) {
            return;
        }
        RectTextLine line = (RectTextLine)paragraph.Lines.get(0);
        if (line.FontName.equalsIgnoreCase("symbol")) {
            return;
        }
        int xLayerIndex = this.getLayerIndex(paragraph);
        ShapeStyle xShapeStyle = new ShapeStyle();
        String xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(paragraph.lfHeight < 1.0E-12 ? 2.0 * line.SideY / 3.0 / (double)paragraph.Lines.size() : paragraph.lfHeight) * xSchemeScale);
        double angle = paragraph.TransProps == null ? 0.0 : paragraph.TransProps.Angle;
        this.fillShapeStyle(paragraph, xShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle, null);
        ShapeStyle xTextShapeStyle = new ShapeStyle();
        double d = shapeAngle = textShape.TransProps == null ? 0.0 : textShape.TransProps.Angle;
        if (textShape instanceof BaseShape) {
            this.fillShapeStyle((BaseShape)textShape, xTextShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, shapeAngle, null);
        }
        if (this._curInsert != null && this._usePageMasterDefMode) {
            return;
        }
        if (!paragraph.ShowBackground) {
            xShapeStyle.fillPattern = "0";
            xShapeStyle.linePattern = "0";
        }
        if (this._useMasterPart) {
            xCurrentPart = this._visioMastersMasterPart;
            xLayerIndex = 0;
        } else {
            xCurrentPart = this._curInsert != null && this._usePageMasterDefMode ? this._pageMasterDef : this._visioPagesPage1Part;
        }
        double scaleX = 1.0;
        double scaleY = 1.0;
        double pinX = xShapeStyle.pinXN;
        double pinY = xShapeStyle.pinYN;
        if (textShape.TransProps != null) {
            scaleX = textShape.TransProps.ScaleX;
            scaleY = textShape.TransProps.ScaleY;
            if (!SchemeUtils.isEqual(textShape.TransProps.SkewX, 0.0)) {
                pinX -= xShapeStyle.pinYN * Math.tan(textShape.TransProps.SkewX * Math.PI / 180.0);
            }
            if (!SchemeUtils.isEqual(textShape.TransProps.SkewY, 0.0)) {
                pinY -= xShapeStyle.pinXN * Math.tan(textShape.TransProps.SkewY * Math.PI / 180.0);
            }
        }
        pinX = pinX * scaleX + xTextShapeStyle.widthN / 2.0;
        pinY = pinY * scaleY + xTextShapeStyle.heightN / 2.0;
        String xTxtWidthFStr = SchemeUtils.isEqual(xTextShapeStyle.widthN, 0.0) ? "" : " F=\"Width*" + this.getTrueFloatValStr(xShapeStyle.widthN / xTextShapeStyle.widthN) + "\"";
        String xTxtHeightFStr = SchemeUtils.isEqual(xTextShapeStyle.heightN, 0.0) ? "" : " F=\"Height*" + this.getTrueFloatValStr(xShapeStyle.heightN / xTextShapeStyle.heightN) + "\"";
        String xTxtPinXFStr = SchemeUtils.isEqual(xTextShapeStyle.widthN, 0.0) ? "" : " F=\"Width*" + this.getTrueFloatValStr(pinX / xTextShapeStyle.widthN) + "\"";
        String xTxtPinYFStr = SchemeUtils.isEqual(xTextShapeStyle.heightN, 0.0) ? "" : " F=\"Height*" + this.getTrueFloatValStr(pinY / xTextShapeStyle.heightN) + "\"";
        String xTxtLocPinXFStr = SchemeUtils.isEqual(xShapeStyle.widthN, 0.0) ? "" : " F=\"TxtWidth*" + this.getTrueFloatValStr(xShapeStyle.locPinXN / xShapeStyle.widthN) + "\"";
        String xTxtLocPinYFStr = SchemeUtils.isEqual(xShapeStyle.heightN, 0.0) ? "" : " F=\"TxtHeight*" + this.getTrueFloatValStr(xShapeStyle.locPinYN / xShapeStyle.heightN) + "\"";
        xCurrentPart.append(String.format(this.getShapeTextBlockTemplate(), this.getTrueFloatValStr(pinX), xTxtPinXFStr, this.getTrueFloatValStr(pinY), xTxtPinYFStr, xShapeStyle.width, xTxtWidthFStr, xShapeStyle.height, xTxtHeightFStr, xShapeStyle.locPinX, xTxtLocPinXFStr, xShapeStyle.locPinY, xTxtLocPinYFStr, xShapeStyle.angle));
        xCurrentPart.append(String.format(this.getMargnsTemplate(), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.LeftMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.RightMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.TopMargin) * xSchemeScale), this.getTrueFloatValStr(SchemeUtils.mmToInch(paragraph.BottomMargin) * xSchemeScale)));
        if (!this._useMasterPart) {
            if (!(paragraph instanceof Attribute) || !paragraph.Inscribe || !paragraph.AutoSize || paragraph.ParentGB == null || SchemeObjectsTypes.ObjTypeIsLayer(paragraph.ParentGB.shapeType())) {
                xCurrentPart.append(String.format("<Cell V=\"%d\" N=\"VerticalAlign\"/>", VsdxWriter.getVisioVAlign(paragraph.VertAlign)));
            }
            xCurrentPart.append(this.getShapeRelationshipContent(paragraph));
        }
        if (this._isHidden) {
            xCurrentPart.append(HIDE_TEXT_TEMPLATE);
        }
        if (paragraph.isPart() && paragraph.isFontBgColorSetted && paragraph.fontBgColor != null) {
            xCurrentPart.append(String.format(TXTBGND_COLOR_TEMPLATE, this.getColorCode(paragraph.fontBgColor)));
        }
        if (!this._useMasterPart && !this._usePageMasterDefMode && parentId != 0) {
            xCurrentPart.append(DBL_CLICK_EVENT_TEMPLATE);
        }
        if (!paragraph.isPart()) {
            String xFontName = VsdxWriter.repairFontName(line.FontName);
            String xFontColor = xShapeStyle.fontColor;
            int xBuffInt = 0;
            if ((line.FontStyle & 1) != 0) {
                xBuffInt |= 1;
            }
            if ((line.FontStyle & 2) != 0) {
                xBuffInt |= 2;
            }
            if ((line.FontStyle & 4) != 0) {
                xBuffInt |= 4;
            }
            String xFontStyle = String.valueOf(xBuffInt);
            String xFontStrikethru = "0";
            if ((line.FontStyle & 8) != 0) {
                xFontStrikethru = "1";
            }
            String xFontScale = this.getTrueFloatValStr(paragraph.WidthScale);
            Color fontColor = line.FontColor;
            xCurrentPart.append("<Section N=\"Tabs\"><Row IX=\"0\"/></Section>");
            xCurrentPart.append("<Section N=\"Character\">").append(String.format(this.getAttribChrSectnTemplate(), 0, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, 0, this.getTrueFloatValStr((double)paragraph.TransparentText / 255.0))).append("</Section>");
            xCurrentPart.append(String.format("<Section N=\"Paragraph\"><Row IX=\"0\"><Cell V=\"-%s\" N=\"SpLine\"/><Cell V=\"%d\" N=\"HorzAlign\"/></Row></Section>", this.getTrueFloatValStr(Math.abs(paragraph.LineSpacing)), VsdxWriter.getVisioHAlign(paragraph.Align)));
            xCurrentPart.append("<Text>");
            Object xText = "";
            if (paragraph.Lines.size() > 1) {
                for (int i = 0; i < paragraph.Lines.size(); ++i) {
                    xText = i == 0 ? VsdxWriter.correctText(((RectTextLine)paragraph.Lines.get((int)i)).Text) : (String)xText + "\n" + VsdxWriter.correctText(((RectTextLine)paragraph.Lines.get((int)i)).Text);
                }
            } else {
                xText = VsdxWriter.correctText(((RectTextLine)paragraph.Lines.get((int)0)).Text);
            }
            xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), 0, 0, 0, xText));
            xCurrentPart.append("</Text>");
        } else {
            RectTextLine.PartTextLine part;
            int j;
            int i;
            RectTextLine.ParagraphLine pLine;
            xCurrentPart.append("<Section N=\"Tabs\"><Row IX=\"0\">");
            xCurrentPart.append(String.format("<Cell N=\"Position0\" V=\"%s\"/><Cell N=\"Alignment0\" V=\"0\"/>", this.getTrueFloatValStr(VsdxWriter.mmToInch(paragraph.TabStopPosition) * xSchemeScale)));
            xCurrentPart.append("</Row></Section>");
            xCurrentPart.append(String.format("<Section N=\"Paragraph\"><Row IX=\"0\"><Cell V=\"-%s\" N=\"SpLine\"/><Cell V=\"%d\" N=\"HorzAlign\"/>", this.getTrueFloatValStr(Math.abs(paragraph.LineSpacing)), VsdxWriter.getVisioHAlign(paragraph.Align)));
            if (!paragraph.Lines.isEmpty() && (line = (RectTextLine)paragraph.Lines.get(0)) != null && (pLine = line.paragraphLine) != null) {
                xCurrentPart.append(String.format("<Cell N=\"IndFirst\" V=\"%s\"/><Cell N=\"IndLeft\" V=\"%s\"/><Cell N=\"IndRight\" V=\"%s\"/><Cell N=\"SpBefore\" V=\"%s\"/><Cell N=\"SpAfter\" V=\"%s\"/>", this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.firstIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.leftIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.rightIndent) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.spaceBefore) * xSchemeScale), this.getTrueFloatValStr(VsdxWriter.mmToInch(pLine.spaceAfter) * xSchemeScale)));
            }
            xCurrentPart.append("</Row>");
            xCurrentPart.append("</Section>");
            xCurrentPart.append("<Section N=\"Character\">");
            int idx = 0;
            for (i = 0; i < paragraph.Lines.size(); ++i) {
                line = (RectTextLine)paragraph.Lines.get(i);
                if (line == null) continue;
                for (j = 0; j < line.Parts.size(); ++j) {
                    part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    String xFontName = VsdxWriter.repairFontName(part.fontName);
                    String xFontColor = this.getColorCode(part.fontColor);
                    xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(part.fontHeight) * xSchemeScale);
                    int xBuffInt = 0;
                    if ((part.fontStyle & 1) != 0) {
                        xBuffInt |= 1;
                    }
                    if ((part.fontStyle & 2) != 0) {
                        xBuffInt |= 2;
                    }
                    if ((part.fontStyle & 4) != 0) {
                        xBuffInt |= 4;
                    }
                    String xFontStyle = String.valueOf(xBuffInt);
                    String xFontStrikethru = "0";
                    if ((part.fontStyle & 8) != 0) {
                        xFontStrikethru = "1";
                    }
                    String xFontScale = this.getTrueFloatValStr(paragraph.WidthScale);
                    int pos = 0;
                    if (part.ssScript == 1) {
                        pos = 2;
                    }
                    if (part.ssScript == 2) {
                        pos = 1;
                    }
                    Color fontColor = part.fontColor;
                    xCurrentPart.append(String.format(this.getAttribChrSectnTemplate(), idx, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, pos, this.getTrueFloatValStr((double)paragraph.TransparentText / 255.0)));
                    ++idx;
                }
            }
            xCurrentPart.append("</Section>");
            xCurrentPart.append("<Text>");
            idx = 0;
            for (i = 0; i < paragraph.Lines.size(); ++i) {
                line = (RectTextLine)paragraph.Lines.get(i);
                if (line == null) continue;
                if (i > 0) {
                    xCurrentPart.append("\n");
                }
                for (j = 0; j < line.Parts.size(); ++j) {
                    part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), idx, 0, 0, VsdxWriter.correctText(part.text)));
                    ++idx;
                }
            }
            xCurrentPart.append("</Text>");
        }
    }

    private String getRelationshipMediaTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Relationship Id=\"rId%d\"").append(" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\"").append(" Target=\"../media/%s\"/>");
        return template.toString();
    }

    private int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    private void writeImage(Image shape, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) throws Exception {
        StringBuilder xCurrentPart;
        boolean isContent;
        if (this._relationshipTestMode) {
            if (shape.ContainerID != 0.0) {
                this._relationshipHashTable.put(shape.ID, this._shapeCount);
            }
            return;
        }
        if (this._useMasterPart) {
            return;
        }
        if (this._curInsert != null && this._usePageMasterDefMode) {
            return;
        }
        byte[] content = shape instanceof PhxImage ? ((PhxImage)shape).Content : shape.Bmp;
        boolean bl = isContent = content != null && content.length > 0;
        if (!isContent) {
            this.writeRectangle(shape, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object ext = ".BMP";
        String compressionTypeStr = "";
        if (!ii.check()) {
            ByteArrayInputStream bis;
            List images;
            boolean isIco = false;
            int idReserved = this.getShortLittleEndian(content, 0);
            int idType = this.getShortLittleEndian(content, 2);
            if (idReserved == 0 && idType == 1 && !(images = ICODecoder.readExt((InputStream)(bis = new ByteArrayInputStream(content)))).isEmpty()) {
                ICOImage img = (ICOImage)images.get(0);
                if (!img.isPngCompressed()) {
                    img.setPngCompressed(true);
                }
                ImageIO.write((RenderedImage)img.getImage(), "png", out);
                isIco = true;
                ext = ".PNG";
                compressionTypeStr = " CompressionType=\"PNG\"";
            }
            if (!isIco) {
                shape.saveBitmapToStream(out);
            }
        } else {
            out.write(content);
            ext = "." + ii.getFormatName();
            if (ii.getFormat() != 3) {
                compressionTypeStr = String.format(" CompressionType=\"%s\"", ii.getFormatName());
            }
        }
        int xLayerIndex = this.getLayerIndex(shape);
        VSDXItem xFileStream = this.addVsdxItem(this._mediaList, "image", (String)ext);
        xFileStream._bytes = out.toByteArray();
        int xRelIndex = 100000 + this._mediaList.size();
        this._visioPagesRelsPage1XmlRelsPart.append(String.format(this.getRelationshipMediaTemplate(), xRelIndex, xFileStream._name));
        double xAngle = shape.TransProps == null ? 0.0 : -SchemeEngine.NormAngle(shape.TransProps.Angle) * Math.PI / 180.0;
        double xCenterX = shape.TransProps == null ? 0.0 : shape.TransProps.CenterX;
        double xCenterY = shape.TransProps == null ? 0.0 : shape.TransProps.CenterY;
        double xScaleX = shape.TransProps == null ? 1.0 : shape.TransProps.ScaleX;
        double xScaleY = shape.TransProps == null ? 1.0 : shape.TransProps.ScaleY;
        double xLocPinXOffset = VsdxWriter.mmToInch(xCenterX) * parentWidthCoeff * Math.abs(xScaleX);
        double xLocPinYOffset = VsdxWriter.mmToInch(xCenterY) * parentHeightCoeff * Math.abs(xScaleY);
        double xWidth = Math.abs(VsdxWriter.mmToInch(shape.SideX)) * parentWidthCoeff * Math.abs(xScaleX);
        double xHeight = Math.abs(VsdxWriter.mmToInch(shape.SideY)) * parentHeightCoeff * Math.abs(xScaleY);
        double xLocPinX = xWidth / 2.0 - xLocPinXOffset;
        double xLocPinY = xHeight / 2.0 + xLocPinYOffset;
        double xPinX = VsdxWriter.mmToInch(shape.OrgX) * parentWidthCoeff + parentWidth / 2.0;
        double xPinY = VsdxWriter.mmToInch(-shape.OrgY) * parentHeightCoeff + parentHeight / 2.0;
        double xImgWidth = xWidth;
        double xImgHeight = xHeight;
        double xImgOffsetX = 0.0;
        double xImgOffsetY = 0.0;
        String xCustomTagsContent = this.getGluePointsContent(shape, xPinX, xPinY, xLocPinX, xLocPinY) + this.getShapeRelationshipContent(shape);
        if (this._useMasterPart) {
            xCurrentPart = this._visioMastersMasterPart;
            xLayerIndex = 0;
        } else {
            xCurrentPart = this._visioPagesPage1Part;
        }
        String xPinXFStr = "";
        String xPinYFStr = "";
        String xWidthFStr = "";
        String xHeightFStr = "";
        String xImgWidthFStr = " F=\"Width*1\"";
        String xImgHeightFStr = " F=\"Height*1\"";
        String xImgOffsetXFStr = " F=\"ImgWidth*0\"";
        String xImgOffsetYFStr = " F=\"ImgWidth*0\"";
        if (SchemeUtils.hasCrop(shape)) {
            double xImgWidthCoeff = 1.0 + shape.LeftCropPercentage + shape.RightCropPercentage;
            double xImgHeightCoeff = 1.0 + shape.TopCropPercentage + shape.BottomCropPercentage;
            xImgWidthFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xImgWidthCoeff));
            xImgHeightFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xImgHeightCoeff));
            if (xImgWidthCoeff != 2.0) {
                xImgWidth = xWidth / (2.0 - xImgWidthCoeff);
            }
            if (xImgHeightCoeff != 2.0) {
                xImgHeight = xHeight / (2.0 - xImgHeightCoeff);
            }
            double xImgOffsetXCoeff = -shape.LeftCropPercentage;
            double xImgOffsetYCoeff = -shape.BottomCropPercentage;
            xImgOffsetXFStr = String.format(" F=\"ImgWidth*%s\"", this.getTrueFloatValStr(xImgOffsetXCoeff));
            xImgOffsetYFStr = String.format(" F=\"ImgHeight*%s\"", this.getTrueFloatValStr(xImgOffsetYCoeff));
            xImgOffsetX = xImgWidth * xImgOffsetXCoeff;
            xImgOffsetY = xImgHeight * xImgOffsetYCoeff;
        }
        String xLocPinXFStr = " F=\"Width*0.5\"";
        String xLocPinYFStr = " F=\"Height*0.5\"";
        if (Math.abs(xLocPinXOffset) > BaseGraphic.FloatTolerance && xWidth > 1.0E-5) {
            xLocPinXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xLocPinX / xWidth));
        }
        if (Math.abs(xLocPinYOffset) > BaseGraphic.FloatTolerance && xHeight > 1.0E-5) {
            xLocPinYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xLocPinY / xHeight));
        }
        if (parentId != 0) {
            if (parentWidth > 1.0E-5) {
                xPinXFStr = String.format(" F=\"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xPinX / parentWidth));
                xWidthFStr = String.format(" F=\"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentWidth));
            }
            if (parentHeight > 1.0E-5) {
                xPinYFStr = String.format(" F=\"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xPinY / parentHeight));
                xHeightFStr = String.format(" F=\"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentHeight));
            }
        }
        if (this.getConnPointDef(shape, -1)) {
            xPinXFStr = this._pinXStrDef;
            xPinYFStr = this._pinYStrDef;
            xCustomTagsContent = xCustomTagsContent + this._beginXYEndXYDef;
        }
        String transparent = "";
        if (shape.Transparent != 0) {
            String transpVal = this.getTrueFloatValStr((double)shape.Transparent / 255.0);
            transparent = String.format("   <Cell V=\"%s\" N=\"Transparency\"/>", transpVal);
        }
        if (shape instanceof PhxImage) {
            PhxImage image = (PhxImage)shape;
            if (image.Contrast != 50.0) {
                xCustomTagsContent = xCustomTagsContent + String.format("<Cell N=\"Contrast\" V=\"%s\"/>", image.Contrast / 100.0);
            }
            if (image.Brightness != 50.0) {
                xCustomTagsContent = xCustomTagsContent + String.format("<Cell N=\"Brightness\" V=\"%s\"/>", image.Brightness / 100.0);
            }
            if (image.Gamma != 1.0) {
                xCustomTagsContent = xCustomTagsContent + String.format("<Cell N=\"Gamma\" V=\"%s\"/>", image.Gamma);
            }
        }
        if (shape.emText() && shape.EmbeddedText.Inscribe) {
            StringBuilder sb = new StringBuilder();
            this.fillEmStyle(shape.EmbeddedText, sb);
            this.addEm(shape.EmbeddedText, sb);
            xCustomTagsContent = xCustomTagsContent + sb;
        }
        xCurrentPart.append(String.format(this.getVisioPagesPageImageTemplate(), this._shapeCount, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, this.getTrueFloatValStr(xImgOffsetX), xImgOffsetXFStr, this.getTrueFloatValStr(xImgOffsetY), xImgOffsetYFStr, this.getTrueFloatValStr(xImgWidth), xImgWidthFStr, this.getTrueFloatValStr(xImgHeight), xImgHeightFStr, this.getTrueFloatValStr(xAngle), xLayerIndex, xCustomTagsContent, transparent, compressionTypeStr, xRelIndex));
    }

    private void writeRectangle(Rectangle rectangle, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        double angle;
        if (this._relationshipTestMode) {
            if (rectangle.ContainerID != 0.0) {
                this._relationshipHashTable.put(rectangle.ID, this._shapeCount);
            }
            return;
        }
        double[] points = rectangle.getRectPoints();
        double d = angle = rectangle.TransProps == null ? 0.0 : rectangle.TransProps.Angle;
        if (angle != 0.0) {
            rectangle.TransProps.Angle = 0.0;
        }
        double[] pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(rectangle), points);
        for (int i = 1; i < pts.length; i += 2) {
            pts[i] = -pts[i];
        }
        this.writeAsPolygon(rectangle, pts, null, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle);
        if (angle != 0.0) {
            rectangle.TransProps.Angle = angle;
        }
    }

    private void writeGuide(Guide shape, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) {
        if (this._relationshipTestMode) {
            return;
        }
        if (this._useMasterPart) {
            return;
        }
        if (this._curInsert != null && this._usePageMasterDefMode) {
            return;
        }
        double angle = shape.Direct == 1 ? 1.5707963267948966 : 0.0;
        String strWidth = "" + this._pageWidth;
        String strHalfWidth = "" + this._pageWidth / 2.0;
        int xLayerIndex = this.getLayerIndex(shape);
        ShapeStyle xShapeStyle = new ShapeStyle();
        StringBuilder xCurrentPart = this._visioPagesPage1Part;
        this.fillShapeStyle(shape, xShapeStyle, parentId, parentWidth, parentHeight, parentWidthCoeff, parentHeightCoeff, angle, null);
        xCurrentPart.append(String.format(this.getShapePageGuideTemplate(), this._shapeCount, xShapeStyle.pinX, xShapeStyle.pinY, strWidth, strHalfWidth, angle, xLayerIndex, xShapeStyle.pColor, xShapeStyle.lineWeight, xShapeStyle.linePattern, "0", xShapeStyle.transparentBorder, strWidth));
    }

    private String getMastersXmlContent(PhxGraphicInsert shape, int relIdx) {
        Object xName;
        String xBaseId = UUID.randomUUID().toString();
        String xUniqueId = UUID.randomUUID().toString();
        Object object = xName = shape.StringProps == null || shape.StringProps.Caption == null || shape.StringProps.Caption.isEmpty() ? shape.SourceName : shape.StringProps.Caption;
        if (Strings.isVoid((String)xName)) {
            xName = "\u041f\u0440\u0438\u043c\u0438\u0442\u0438\u0432" + relIdx;
        }
        xName = VsdxWriter.correctText((String)xName);
        String xNameU = "Element" + relIdx;
        return String.format(this.getMasterTemplate(), xBaseId, xUniqueId, xName, xNameU, relIdx, relIdx);
    }

    private void writeGraphicInsert(PhxGraphicInsert graphic, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) throws Exception {
        ArrayList<BaseGraphic> Attributes2;
        if (this._relationshipTestMode && graphic.ContainerID != 0.0) {
            this._relationshipHashTable.put(graphic.ID, this._shapeCount);
        }
        StringBuilder xRelationshipMasterTemplate = new StringBuilder();
        if (!this._relationshipTestMode) {
            xRelationshipMasterTemplate.append("<Relationship Id=\"rId%d\"").append(" Type=\"http://schemas.microsoft.com/visio/2010/relationships/master\"").append(" Target=\"%s\"/>");
        }
        StringBuilder xContentTypeMastersPartTemplate = new StringBuilder();
        if (!this._relationshipTestMode) {
            xContentTypeMastersPartTemplate.append("<Override ContentType=\"application/vnd.ms-visio.masters+xml\"").append(" PartName=\"/visio/masters/masters.xml\"/>");
        }
        StringBuilder xVisioRelsDocumentXmlRelsMasterPartTemplate = new StringBuilder();
        if (!this._relationshipTestMode) {
            xVisioRelsDocumentXmlRelsMasterPartTemplate.append("<Relationship Id=\"rId4\"").append(" Type=\"http://schemas.microsoft.com/visio/2010/relationships/masters\"").append(" Target=\"masters/masters.xml\"/>");
        }
        StringBuilder xShapeTemplate = new StringBuilder();
        if (!this._relationshipTestMode) {
            xShapeTemplate.append("<Shape ID=\"%d\" Type=\"Group\" Master=\"%d\">").append(" <Cell N=\"PinX\" V=\"%s\"%s/>").append(" <Cell N=\"PinY\" V=\"%s\"%s/>").append(" <Cell N=\"Width\" V=\"%s\"%s/>").append(" <Cell N=\"Height\" V=\"%s\"%s/>").append(" <Cell N=\"LocPinX\" V=\"%s\"%s/>").append(" <Cell N=\"LocPinY\" V=\"%s\"%s/>").append(" <Cell N=\"Angle\" V=\"%s\"/>").append(" <Cell N=\"LayerMember\" V=\"%d\"/>").append(" <Cell N=\"FlipX\" V=\"%s\"/>").append(" <Cell N=\"FlipY\" V=\"%s\"/>").append("%s%s%s%s").append("</Shape>");
        }
        int xLayerIndex = this.getLayerIndex(graphic);
        this._curInsert = graphic;
        this._visioMastersMasterPart = new StringBuilder();
        int xShapeID = this._shapeCount;
        Primitive prim = this._scheme.findPrimInLibsById(this._curInsert.SourceID, this._curInsert.LibID);
        if (prim == null || prim.BG == null) {
            return;
        }
        this._primBlock = (GraphicBlock)prim.BG;
        if (this._curInsert.getInternalPrimGraphicBlock() != null) {
            this._primBlock = this._curInsert.getInternalPrimGraphicBlock();
        }
        if (this._primBlock == null || this._primBlock.Objects == null || this._primBlock.Objects.isEmpty()) {
            return;
        }
        if (this._primBlock.BlockParams.size() == 0) {
            this._primBlock.BlockParams = prim.PrimParams;
        }
        MasterHashEntry xMasterHashEntry = null;
        if (this._primBlock.BlockParams.size() == 0) {
            xMasterHashEntry = this._hashTable.get(this._curInsert.SourceID);
        }
        if (xMasterHashEntry == null) {
            this._useMasterPart = true;
            boolean oldIsHidden = this._isHidden;
            this._isHidden = false;
            this.writeShape(this._primBlock, 0, 0.0, 0.0, 1.0, 1.0);
            this._isHidden = oldIsHidden;
            this._useMasterPart = false;
            if (!this._relationshipTestMode) {
                if (this._masterList.isEmpty()) {
                    this._contentTypeMastersPart.append((CharSequence)xContentTypeMastersPartTemplate);
                    this._visioRelsDocumentXmlRelsMastersPart.append((CharSequence)xVisioRelsDocumentXmlRelsMasterPartTemplate);
                }
                VSDXItem xFileStream = this.addVsdxItem(this._masterList, "master", ".xml");
                xFileStream._bytes = String.format(this._visioMastersMasterTemplate.toString(), this._visioMastersMasterPart.toString()).getBytes(StandardCharsets.UTF_8);
                this._contentTypeMastersPart.append(String.format("<Override ContentType=\"application/vnd.ms-visio.master+xml\" PartName=\"/visio/masters/%s\"/>", xFileStream._name));
                int xRelIndex = 0 + this._masterList.size();
                this._visioMastersRelsMastersXmlRelsPart.append(String.format(xRelationshipMasterTemplate.toString(), xRelIndex, xFileStream._name));
                this._visioMastersMastersPart.append(this.getMastersXmlContent(this._curInsert, xRelIndex));
                xMasterHashEntry = new MasterHashEntry(this._masterList.size(), xShapeID, xRelIndex, xFileStream._name);
                this._hashTable.put(this._curInsert.SourceID, xMasterHashEntry);
            }
        }
        if (!this._relationshipTestMode && !xMasterHashEntry._used) {
            this._visioPagesRelsPage1XmlRelsPart.append(String.format(xRelationshipMasterTemplate.toString(), xMasterHashEntry._relIndex, xMasterHashEntry._targetName));
            xMasterHashEntry._used = true;
        }
        double xAngle = 0.0;
        double xScaleX = 0.0;
        double xScaleY = 0.0;
        double xLocPinXOffset = 0.0;
        double xLocPinYOffset = 0.0;
        double xWidth = 0.0;
        double xHeight = 0.0;
        double xLocPinX = 0.0;
        double xLocPinY = 0.0;
        double xPinX = 0.0;
        double xPinY = 0.0;
        String xFlipXStr = null;
        String xFlipYStr = null;
        if (!this._relationshipTestMode) {
            xAngle = -SchemeEngine.NormAngle(this._curInsert.TransProps == null ? 0.0 : this._curInsert.TransProps.Angle) * Math.PI / 180.0;
            double xCenterX = this._curInsert.TransProps == null ? 0.0 : this._curInsert.TransProps.CenterX;
            double xCenterY = this._curInsert.TransProps == null ? 0.0 : this._curInsert.TransProps.CenterY;
            xScaleX = this._curInsert.TransProps == null ? 1.0 : this._curInsert.TransProps.ScaleX;
            xScaleY = this._curInsert.TransProps == null ? 1.0 : this._curInsert.TransProps.ScaleY;
            double xSizeX = Math.abs(this._primBlock.MaxPtX - this._primBlock.MinPtX);
            double xSizeY = Math.abs(this._primBlock.MaxPtY - this._primBlock.MinPtY);
            xLocPinXOffset = VsdxWriter.mmToInch(xCenterX) * parentWidthCoeff * Math.abs(xScaleX);
            xLocPinYOffset = VsdxWriter.mmToInch(xCenterY) * parentHeightCoeff * Math.abs(xScaleY);
            xWidth = Math.abs(VsdxWriter.mmToInch(xSizeX)) * parentWidthCoeff * Math.abs(xScaleX);
            xHeight = Math.abs(VsdxWriter.mmToInch(xSizeY)) * parentHeightCoeff * Math.abs(xScaleY);
            xLocPinX = xWidth / 2.0 - xLocPinXOffset;
            xLocPinY = xHeight / 2.0 + xLocPinYOffset;
            xPinX = VsdxWriter.mmToInch(this._curInsert.OrgX) * parentWidthCoeff + parentWidth / 2.0;
            xPinY = VsdxWriter.mmToInch(-this._curInsert.OrgY) * parentHeightCoeff + parentHeight / 2.0;
            xFlipXStr = xScaleX < 0.0 ? "1" : "0";
            xFlipYStr = xScaleY < 0.0 ? "1" : "0";
        }
        this._usePageMasterDefMode = true;
        this._pageMasterDef = new StringBuilder();
        if (!this._relationshipTestMode) {
            this._pageMasterDefID = xMasterHashEntry._masterIdStart;
            this._pageMasterDef.append("<Shapes>");
        }
        if (this._primBlock != null) {
            this.writeShape(this._primBlock, xShapeID, xWidth, xHeight, parentWidthCoeff * Math.abs(xScaleX), parentHeightCoeff * Math.abs(xScaleY));
        }
        if ((Attributes2 = this._curInsert.Attributes) != null && !Attributes2.isEmpty()) {
            for (BaseGraphic attribute : Attributes2) {
                Attribute attr = (Attribute)attribute;
                if (attr.invisible() || attr.getText().isEmpty()) continue;
                RectTextLine line = (RectTextLine)attr.Lines.get(0);
                if (line.FontName.equalsIgnoreCase("symbol")) continue;
                if (attr.Inscribe && this._primBlock != null) {
                    if (attr.getEngine() == null) {
                        attr.setEngine(this._engine);
                    }
                    attr.setInscribeExt(this._primBlock, true, true, false);
                }
                this.writeShape(attr, xShapeID, xWidth, xHeight, parentWidthCoeff * Math.abs(xScaleX), parentHeightCoeff * Math.abs(xScaleY));
            }
        }
        this._usePageMasterDefMode = false;
        if (!this._relationshipTestMode) {
            this._pageMasterDef.append("</Shapes>");
            String xPinXFStr = "";
            String xPinYFStr = "";
            String xWidthFStr = "";
            String xHeightFStr = "";
            String xLocPinXFStr = " F=\"Width*0.5\"";
            String xLocPinYFStr = " F=\"Height*0.5\"";
            if (Math.abs(xLocPinXOffset) > BaseGraphic.FloatTolerance && xWidth > 1.0E-5) {
                xLocPinXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xLocPinX / xWidth));
            }
            if (Math.abs(xLocPinYOffset) > BaseGraphic.FloatTolerance && xHeight > 1.0E-5) {
                xLocPinYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xLocPinY / xHeight));
            }
            if (parentId != 0) {
                if (parentWidth > 1.0E-5) {
                    xPinXFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xPinX / parentWidth));
                    xWidthFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentWidth));
                }
                if (parentHeight > 1.0E-5) {
                    xPinYFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xPinY / parentHeight));
                    xHeightFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentHeight));
                }
            }
            Object xCustomTagsContent = this.getGluePointsContent(graphic, xPinX, xPinY, xLocPinX, xLocPinY);
            if (this.getConnPointDef(graphic, xShapeID)) {
                xPinXFStr = this._pinXStrDef;
                xPinYFStr = this._pinYStrDef;
                xCustomTagsContent = (String)xCustomTagsContent + this._beginXYEndXYDef;
            }
            int xMasterID = xMasterHashEntry._masterId;
            this._visioPagesPage1Part.append(String.format(xShapeTemplate.toString(), xShapeID, xMasterID, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, this.getTrueFloatValStr(xAngle), xLayerIndex, xFlipXStr, xFlipYStr, this.getShapePropertySectionContent(graphic), this.getShapeRelationshipContent(graphic), xCustomTagsContent, this._pageMasterDef.toString()));
        }
        this._curInsert = null;
    }

    private boolean checkUseGroup(GraphicBlock block) {
        int xIsGroupPresent = 0;
        boolean xIsNotGroupPresent = false;
        GraphicBlock xParentBlock = block == this._primBlock ? this._primBlock : (GraphicBlock)block.ParentGB;
        if (xParentBlock == null) {
            return true;
        }
        if (block == this._primBlock) {
            return false;
        }
        for (int j = 0; j < xParentBlock.Objects.size(); ++j) {
            if (xParentBlock.Objects.get(j) instanceof AttributeRef && xParentBlock != this._primBlock || xParentBlock.Objects.get(j) instanceof AttributeDef && xParentBlock != this._primBlock && (((AttributeDef)xParentBlock.Objects.get(j)).invisible() || ((AttributeDef)xParentBlock.Objects.get(j)).getText().isEmpty())) continue;
            if (xParentBlock.Objects.get(j) instanceof GraphicBlock) {
                ++xIsGroupPresent;
                continue;
            }
            xIsNotGroupPresent = true;
        }
        if (xIsGroupPresent > 1) {
            return true;
        }
        return xIsGroupPresent == 1 && xIsNotGroupPresent;
    }

    private void fillLayerMemberStr(GraphicBlock group, HashSet<Integer> hash, StringBuilder layerMemberStr) {
        if (group == null || group.Objects == null || hash == null || layerMemberStr == null) {
            return;
        }
        for (int m = 0; m < group.Objects.size(); ++m) {
            if (group.Objects.get(m) instanceof AttributeRef || group.Objects.get(m) instanceof AttributeDef) continue;
            int xLayerIndex = this.getLayerIndex(group.Objects.get(m));
            if (hash.add(xLayerIndex)) {
                layerMemberStr.append(";").append(xLayerIndex);
            }
            if (!(group.Objects.get(m) instanceof GraphicBlock)) continue;
            this.fillLayerMemberStr((GraphicBlock)group.Objects.get(m), hash, layerMemberStr);
        }
    }

    private void writeGraphicBlock(GraphicBlock block, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) throws Exception {
        SchemeObject xObj;
        if (this._relationshipTestMode && block.ContainerID != 0.0) {
            this._relationshipHashTable.put(block.ID, this._shapeCount);
        }
        if (block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        HashSet<Integer> xHash = new HashSet<Integer>();
        int xLayerIndex = this.getLayerIndex(block);
        StringBuilder xLayerMemberStr = new StringBuilder();
        if (!this._relationshipTestMode) {
            xLayerMemberStr.append(xLayerIndex);
        }
        if ((xObj = this._scheme.layerById(block.LayerID)) == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
            if (!this._relationshipTestMode) {
                Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0438\u0433\u0443\u0440\u044b: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439");
            }
            return;
        }
        BaseGraphic xBG = xObj.BG;
        if (!this._relationshipTestMode && !this._useMasterPart && xBG instanceof PhxLayer) {
            xHash.add(xLayerIndex);
            this.fillLayerMemberStr(block, xHash, xLayerMemberStr);
        }
        Object xCustomTagsContent = "";
        double xWidth = 0.0;
        double xHeight = 0.0;
        double xLocPinX = 0.0;
        double xLocPinY = 0.0;
        double xPinX = 0.0;
        double xPinY = 0.0;
        String xPinXFStr = "";
        String xPinYFStr = "";
        String xWidthFStr = "";
        String xHeightFStr = "";
        String xLocPinXFStr = " F=\"Width*0.5\"";
        String xLocPinYFStr = " F=\"Height*0.5\"";
        double xAngle = 0.0;
        double xScaleX = 0.0;
        double xScaleY = 0.0;
        String xFlipXStr = null;
        String xFlipYStr = null;
        double parentWC = parentWidthCoeff;
        double parentHC = parentHeightCoeff;
        boolean heading90 = false;
        if (!this._relationshipTestMode) {
            xAngle = -SchemeEngine.NormAngle(block.TransProps == null ? 0.0 : block.TransProps.Angle) * Math.PI / 180.0;
            double xCenterX = block.TransProps == null ? 0.0 : block.TransProps.CenterX;
            double xCenterY = block.TransProps == null ? 0.0 : block.TransProps.CenterY;
            xScaleX = block.TransProps == null ? 1.0 : block.TransProps.ScaleX;
            xScaleY = block.TransProps == null ? 1.0 : block.TransProps.ScaleY;
            double xSizeX = Math.abs(block.MaxPtX - block.MinPtX);
            double xSizeY = Math.abs(block.MaxPtY - block.MinPtY);
            if (this._useMasterPart && block == this._primBlock) {
                xCustomTagsContent = String.format(this.getMargnsTemplate(), "0", "0", "0", "0");
            } else {
                xCustomTagsContent = this.getShapeRelationshipContent(block);
                if (block.ID == this._currentHeadingId) {
                    xCustomTagsContent = (String)xCustomTagsContent + this.getContainerHeadingContent(this._currentHeadingEdge);
                }
            }
            double xLocPinXOffset = VsdxWriter.mmToInch(xCenterX) * parentWC * Math.abs(xScaleX);
            double xLocPinYOffset = VsdxWriter.mmToInch(xCenterY) * parentHC * Math.abs(xScaleY);
            xWidth = Math.abs(VsdxWriter.mmToInch(xSizeX)) * parentWC * Math.abs(xScaleX);
            xHeight = Math.abs(VsdxWriter.mmToInch(xSizeY)) * parentHC * Math.abs(xScaleY);
            boolean bl = heading90 = parentId != 0 && block.ID == this._currentHeadingId && this._currentHeadingEdge != 2 && this._currentHeadingEdge != 3 && block.TransProps != null && SchemeUtils.isEqual(block.TransProps.Angle, 270.0);
            if (heading90) {
                xLocPinXOffset = VsdxWriter.mmToInch(xCenterX) * parentHC * Math.abs(xScaleX);
                xLocPinYOffset = VsdxWriter.mmToInch(xCenterY) * parentWC * Math.abs(xScaleY);
                xWidth = Math.abs(VsdxWriter.mmToInch(xSizeX)) * parentHC * Math.abs(xScaleX);
                xHeight = Math.abs(VsdxWriter.mmToInch(xSizeY)) * parentWC * Math.abs(xScaleY);
            }
            xLocPinX = xWidth / 2.0 - xLocPinXOffset;
            xLocPinY = xHeight / 2.0 + xLocPinYOffset;
            xPinX = VsdxWriter.mmToInch(block.OrgX) * parentWidthCoeff + parentWidth / 2.0;
            xPinY = VsdxWriter.mmToInch(-block.OrgY) * parentHeightCoeff + parentHeight / 2.0;
            if (this._useMasterPart && block == this._primBlock) {
                xPinX = 0.0;
                xPinY = 0.0;
            }
            if (Math.abs(xLocPinXOffset) > BaseGraphic.FloatTolerance && xWidth > 1.0E-5) {
                xLocPinXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xLocPinX / xWidth));
            }
            if (Math.abs(xLocPinYOffset) > BaseGraphic.FloatTolerance && xHeight > 1.0E-5) {
                xLocPinYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xLocPinY / xHeight));
            }
            xFlipXStr = xScaleX < 0.0 ? "1" : "0";
            String string = xFlipYStr = xScaleY < 0.0 ? "1" : "0";
            if (parentId != 0) {
                if (parentWidth > 1.0E-5) {
                    xPinXFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xPinX / parentWidth));
                    xWidthFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentWidth));
                }
                if (parentHeight > 1.0E-5) {
                    xPinYFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xPinY / parentHeight));
                    xHeightFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentHeight));
                }
                if (heading90) {
                    if (parentHeight > 1.0E-5) {
                        xWidthFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentHeight));
                    }
                    if (parentWidth > 1.0E-5) {
                        xHeightFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentWidth));
                    }
                }
            }
            if (this.getConnPointDef(block, -1)) {
                xPinXFStr = this._pinXStrDef;
                xPinYFStr = this._pinYStrDef;
                xCustomTagsContent = (String)xCustomTagsContent + this._beginXYEndXYDef;
            }
        }
        if (this._curInsert != null && this._usePageMasterDefMode) {
            int xActualParentId = parentId;
            boolean xUseGroup = false;
            if (!this._relationshipTestMode) {
                xUseGroup = this.checkUseGroup(block);
                if (xUseGroup) {
                    xActualParentId = this._shapeCount;
                }
                if (xUseGroup) {
                    this._pageMasterDef.append(String.format(this.getShapeMasterGroupHeaderTemplate(), this._shapeCount, this._pageMasterDefID, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, xCustomTagsContent));
                }
            }
            for (int i = 0; i < block.Objects.size(); ++i) {
                if (block.Objects.get(i) instanceof AttributeRef || block.Objects.get(i) instanceof AttributeDef) continue;
                this.writeShape(block.Objects.get(i), xActualParentId, xWidth, xHeight, parentWC * Math.abs(xScaleX), parentHC * Math.abs(xScaleY));
            }
            if (!this._relationshipTestMode && xUseGroup) {
                this._pageMasterDef.append(SHAPE_MASTER_GROUP_FOOTER_TEMPLATE);
            }
            return;
        }
        Primitive prim = this._scheme.findPrimInLibsById(block.SourceID, block.LibID);
        if (prim != null && !prim.PrimParams.isEmpty()) {
            block.BlockParams = prim.PrimParams;
        }
        if (!this._relationshipTestMode) {
            xCustomTagsContent = (String)xCustomTagsContent + this.getGluePointsContent(block, xPinX, xPinY, xLocPinX, xLocPinY);
        }
        StringBuilder xCurrentPart = null;
        if (!this._relationshipTestMode) {
            if (this._useMasterPart) {
                xCurrentPart = this._visioMastersMasterPart;
                xLayerMemberStr = new StringBuilder();
                xLayerMemberStr.append("0");
            } else {
                xCurrentPart = this._visioPagesPage1Part;
            }
            xCurrentPart.append(String.format(this.getVisioPagesPageGroupMainTemplate(), this._shapeCount, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, xFlipXStr, xFlipYStr, this.getTrueFloatValStr(xAngle), xLayerMemberStr, xCustomTagsContent, this.getMasterPropertySectionContent(block)));
            if (block.emText()) {
                if (block.EmbeddedText.Inscribe) {
                    this.fillEmStyle(block.EmbeddedText, xCurrentPart);
                    this.addEm(block.EmbeddedText, xCurrentPart);
                } else {
                    this.writeTextShape(block, parentId, Math.abs(block.MaxPtX - block.MinPtX) / 25.4, Math.abs(block.MaxPtY - block.MinPtY) / 25.4, parentWidthCoeff, parentHeightCoeff);
                }
            }
            xCurrentPart.append("<Shapes>");
        }
        int xParentId = this._shapeCount;
        for (int i = 0; i < block.Objects.size(); ++i) {
            if (block.Objects.get(i) instanceof AttributeRef || block.Objects.get(i) instanceof AttributeDef) continue;
            if (heading90) {
                this.writeShape(block.Objects.get(i), xParentId, xWidth, xHeight, parentHC * Math.abs(xScaleX), parentWC * Math.abs(xScaleY));
                continue;
            }
            this.writeShape(block.Objects.get(i), xParentId, xWidth, xHeight, parentWC * Math.abs(xScaleX), parentHC * Math.abs(xScaleY));
        }
        if (block.Objects != null && !block.Objects.isEmpty()) {
            int count = block.Objects.size();
            for (int i = 0; i < count; ++i) {
                Attribute attr;
                BaseGraphic bg = block.Objects.get(i);
                if (bg == null || !(bg instanceof AttributeDef) || this._useMasterPart || (attr = (Attribute)bg).invisible() || attr.getText().isEmpty()) continue;
                RectTextLine line = (RectTextLine)attr.Lines.get(0);
                if (line.FontName.equalsIgnoreCase("symbol")) continue;
                if (attr.Inscribe && !attr.AutoSize) {
                    if (attr.getEngine() == null) {
                        attr.setEngine(this._engine);
                    }
                    attr.setInscribeExt(block, true, true, false);
                }
                double scaleX = !this._relationshipTestMode && !attr.Inscribe && xScaleX < 1.0 ? 1.0 : xScaleX;
                double scaleY = !this._relationshipTestMode && !attr.Inscribe && xScaleY < 1.0 ? 1.0 : xScaleY;
                this.writeShape(attr, xParentId, xWidth, xHeight, parentWC * Math.abs(scaleX), parentHC * Math.abs(scaleY));
            }
        }
        if (!this._relationshipTestMode && xCurrentPart != null) {
            xCurrentPart.append("</Shapes>");
            xCurrentPart.append("</Shape>");
        }
    }

    private void writeContainer(Container container, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff) throws Exception {
        SchemeObject xObj;
        if (this._relationshipTestMode) {
            this._relationshipHashTable.put(container.ID, this._shapeCount);
        }
        if (container.Objects == null || container.Objects.isEmpty()) {
            return;
        }
        HashSet<Integer> xHash = new HashSet<Integer>();
        int xLayerIndex = this.getLayerIndex(container);
        StringBuilder xLayerMemberStr = new StringBuilder();
        if (!this._relationshipTestMode) {
            xLayerMemberStr.append(xLayerIndex);
        }
        if ((xObj = this._scheme.layerById(container.LayerID)) == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
            if (!this._relationshipTestMode) {
                Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0438\u0433\u0443\u0440\u044b: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439");
            }
            return;
        }
        BaseGraphic xBG = xObj.BG;
        if (!this._relationshipTestMode && !this._useMasterPart && xBG instanceof PhxLayer) {
            xHash.add(xLayerIndex);
            this.fillLayerMemberStr(container, xHash, xLayerMemberStr);
        }
        double xAngle = 0.0;
        double xScaleX = 0.0;
        double xScaleY = 0.0;
        Object xCustomTagsContent = null;
        double xWidth = 0.0;
        double xHeight = 0.0;
        double xLocPinX = 0.0;
        double xLocPinY = 0.0;
        double xPinX = 0.0;
        double xPinY = 0.0;
        String xPinXFStr = null;
        String xPinYFStr = null;
        String xWidthFStr = null;
        String xHeightFStr = null;
        String xLocPinXFStr = null;
        String xLocPinYFStr = null;
        String xFlipXStr = null;
        String xFlipYStr = null;
        if (!this._relationshipTestMode) {
            xAngle = -SchemeEngine.NormAngle(container.TransProps == null ? 0.0 : container.TransProps.Angle) * Math.PI / 180.0;
            double xCenterX = container.TransProps == null ? 0.0 : container.TransProps.CenterX;
            double xCenterY = container.TransProps == null ? 0.0 : container.TransProps.CenterY;
            xScaleX = container.TransProps == null ? 1.0 : container.TransProps.ScaleX;
            xScaleY = container.TransProps == null ? 1.0 : container.TransProps.ScaleY;
            double xSizeX = Math.abs(container.MaxPtX - container.MinPtX);
            double xSizeY = Math.abs(container.MaxPtY - container.MinPtY);
            StringBuilder containerRelationship = new StringBuilder();
            containerRelationship.append("<Cell V=\"15\" N=\"ShapePlaceStyle\"/>");
            if (container.AsList) {
                containerRelationship.append("<Cell V=\"0\" N=\"Relationships\" F=\"SUM(DEPENDSON(2");
            } else {
                containerRelationship.append("<Cell V=\"0\" N=\"Relationships\" F=\"SUM(DEPENDSON(1");
            }
            boolean isRelationship = false;
            for (DoubleIntegerMap.Cursor cursor : this._relationshipHashTable) {
                SchemeObject obj = this._scheme.getObjectSilent(cursor.key);
                if (obj == null || obj.BG == null || obj.BG.ContainerID != container.ID) continue;
                isRelationship = true;
                containerRelationship.append(String.format(",Sheet.%d!SheetRef()", cursor.value));
            }
            String containerContent = container.AsList ? String.format(this.getListTemplate(), this.getTrueFloatValStr(VsdxWriter.mmToInch(container.Margin)), container.AutomaticResize, container.Locked ? 1 : 0, container.ListAlignment, container.ListDirection, Strings.isVoid(container.Categories) ? "ContainerStyleDefaults" : container.Categories.replace(",", ";"), Strings.isVoid(container.ListRequiredCategories) ? "0" : container.ListRequiredCategories.replace(",", ";"), Strings.isVoid(container.ListExcludedCategories) ? "DoNotContain" : container.ListExcludedCategories.replace(",", ";")) : String.format(this.getContainerTemplate(), this.getTrueFloatValStr(VsdxWriter.mmToInch(container.Margin)), container.AutomaticResize, container.Locked ? 1 : 0, Strings.isVoid(container.Categories) ? "ContainerStyleDefaults" : container.Categories.replace(",", ";"), Strings.isVoid(container.RequiredCategories) ? "0" : container.RequiredCategories.replace(",", ";"), Strings.isVoid(container.ExcludedCategories) ? "DoNotContain" : container.ExcludedCategories.replace(",", ";"));
            containerRelationship.append("))\"/>");
            if (isRelationship) {
                containerRelationship.append(containerContent);
                xCustomTagsContent = containerRelationship.toString();
            } else {
                xCustomTagsContent = containerContent;
            }
            double xLocPinXOffset = VsdxWriter.mmToInch(xCenterX) * parentWidthCoeff * Math.abs(xScaleX);
            double xLocPinYOffset = VsdxWriter.mmToInch(xCenterY) * parentHeightCoeff * Math.abs(xScaleY);
            xWidth = Math.abs(VsdxWriter.mmToInch(xSizeX)) * parentWidthCoeff * Math.abs(xScaleX);
            xHeight = Math.abs(VsdxWriter.mmToInch(xSizeY)) * parentHeightCoeff * Math.abs(xScaleY);
            xLocPinX = xWidth / 2.0 - xLocPinXOffset;
            xLocPinY = xHeight / 2.0 + xLocPinYOffset;
            xPinX = VsdxWriter.mmToInch(container.OrgX) * parentWidthCoeff + parentWidth / 2.0;
            xPinY = VsdxWriter.mmToInch(-container.OrgY) * parentHeightCoeff + parentHeight / 2.0;
            xPinXFStr = "";
            xPinYFStr = "";
            xWidthFStr = "";
            xHeightFStr = "";
            xLocPinXFStr = " F=\"Width*0.5\"";
            xLocPinYFStr = " F=\"Height*0.5\"";
            if (Math.abs(xLocPinXOffset) > BaseGraphic.FloatTolerance && xWidth > 1.0E-5) {
                xLocPinXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xLocPinX / xWidth));
            }
            if (Math.abs(xLocPinYOffset) > BaseGraphic.FloatTolerance && xHeight > 1.0E-5) {
                xLocPinYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xLocPinY / xHeight));
            }
            xFlipXStr = xScaleX < 0.0 ? "1" : "0";
            String string = xFlipYStr = xScaleY < 0.0 ? "1" : "0";
            if (parentId != 0) {
                if (parentWidth > 1.0E-5) {
                    xPinXFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xPinX / parentWidth));
                    xWidthFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentWidth));
                }
                if (parentHeight > 1.0E-5) {
                    xPinYFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xPinY / parentHeight));
                    xHeightFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentHeight));
                }
            }
        }
        if (this._curInsert != null && this._usePageMasterDefMode) {
            int xActualParentId = 0;
            boolean xUseGroup = false;
            if (!this._relationshipTestMode) {
                xActualParentId = parentId;
                xUseGroup = this.checkUseGroup(container);
                if (xUseGroup) {
                    xActualParentId = this._shapeCount;
                }
                if (xUseGroup) {
                    this._pageMasterDef.append(String.format(this.getShapeMasterGroupHeaderTemplate(), this._shapeCount, this._pageMasterDefID, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, xCustomTagsContent));
                }
            }
            for (int i = 0; i < container.Objects.size(); ++i) {
                if (container.Objects.get(i) instanceof AttributeRef || container.Objects.get(i) instanceof AttributeDef) continue;
                this.writeShape((BaseGraphic)container.Objects.get(i), xActualParentId, xWidth, xHeight, parentWidthCoeff * Math.abs(xScaleX), parentHeightCoeff * Math.abs(xScaleY));
            }
            if (xUseGroup && !this._relationshipTestMode) {
                this._pageMasterDef.append(SHAPE_MASTER_GROUP_FOOTER_TEMPLATE);
            }
            return;
        }
        StringBuilder xCurrentPart = null;
        if (!this._relationshipTestMode) {
            if (this._useMasterPart) {
                xCurrentPart = this._visioMastersMasterPart;
                xLayerMemberStr = new StringBuilder();
                xLayerMemberStr.append("0");
            } else {
                xCurrentPart = this._visioPagesPage1Part;
                xCustomTagsContent = xCustomTagsContent + this.getShapeRelationshipContent(container);
            }
            xCurrentPart.append(String.format(this.getVisioPagesPageGroupMainTemplate(), this._shapeCount, this.getTrueFloatValStr(xPinX), xPinXFStr, this.getTrueFloatValStr(xPinY), xPinYFStr, this.getTrueFloatValStr(xWidth), xWidthFStr, this.getTrueFloatValStr(xHeight), xHeightFStr, this.getTrueFloatValStr(xLocPinX), xLocPinXFStr, this.getTrueFloatValStr(xLocPinY), xLocPinYFStr, xFlipXStr, xFlipYStr, this.getTrueFloatValStr(xAngle), xLayerMemberStr, xCustomTagsContent, this.getMasterPropertySectionContent(container)));
            xCurrentPart.append("<Shapes>");
        }
        int xParentId = this._shapeCount;
        this._currentHeadingId = container.getHeadingId();
        this._currentHeadingEdge = container.getHeadingEdge();
        for (int i = 0; i < container.Objects.size(); ++i) {
            if (container.Objects.get(i) instanceof AttributeRef || container.Objects.get(i) instanceof AttributeDef) continue;
            this.writeShape((BaseGraphic)container.Objects.get(i), xParentId, xWidth, xHeight, parentWidthCoeff * Math.abs(xScaleX), parentHeightCoeff * Math.abs(xScaleY));
        }
        if (container.Objects != null && !container.Objects.isEmpty()) {
            int count = container.Objects.size();
            for (int i = 0; i < count; ++i) {
                Attribute attr;
                BaseGraphic bg = (BaseGraphic)container.Objects.get(i);
                if (bg == null || !(bg instanceof AttributeDef) || this._useMasterPart || (attr = (Attribute)bg).invisible() || attr.getText().isEmpty()) continue;
                RectTextLine line = (RectTextLine)attr.Lines.get(0);
                if (line.FontName.equalsIgnoreCase("symbol")) continue;
                this.writeShape(attr, xParentId, xWidth, xHeight, parentWidthCoeff * Math.abs(xScaleX), parentHeightCoeff * Math.abs(xScaleY));
            }
        }
        this._currentHeadingId = 0.0;
        if (!this._relationshipTestMode) {
            xCurrentPart.append("</Shapes>");
            xCurrentPart.append("</Shape>");
        }
    }

    private void prepareVSDXFile() throws Exception {
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043f\u043e\u0434\u0433\u043e\u0442\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f VSDX-\u0444\u0430\u0439\u043b");
        this._zipOutputStream.putNextEntry(new ZipEntry("docProps/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("docProps/core.xml"));
        this._zipOutputStream.write(this._docPropsCoreTemplate.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("docProps/app.xml"));
        this._zipOutputStream.write(this._docPropsAppTemplate.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("docProps/custom.xml"));
        this._zipOutputStream.write(this._docPropsCustomTemplate.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("_rels/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("_rels/.rels"));
        this._zipOutputStream.write(this._relsRelsTemplate.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/document.xml"));
        this._zipOutputStream.write(this._visioDocumentTemplate.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/_rels/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/_rels/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/media/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/masters/"));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/masters/_rels/"));
    }

    private void finishVSDXFile() throws Exception {
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/comments.xml"));
        this._zipOutputStream.write(String.format(this._visioCommentsTemplate.toString(), this._visioAuthorEntryPart, this._visioCommentEntryPart).getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/windows.xml"));
        String buffStr = String.format(this._visioWindowsTemplate.toString(), this.getTrueFloatValStr(this._posPageXFirst), this.getTrueFloatValStr(this._posPageYFirst), this._scheme.showGrid ? 1 : 0);
        this._zipOutputStream.write(buffStr.getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("[Content_Types].xml"));
        buffStr = String.format(this._contentTypesTemplate.toString(), this._contentTypeMastersPart, this._contentTypePagePart);
        this._zipOutputStream.write(buffStr.getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/_rels/document.xml.rels"));
        buffStr = String.format(this._visioRelsDocumentXmlRelsTemplate.toString(), this._visioRelsDocumentXmlRelsMastersPart);
        this._zipOutputStream.write(buffStr.getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/pages.xml"));
        this._zipOutputStream.write(this._visioPagesPagesPart.toString().getBytes(StandardCharsets.UTF_8));
        this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/_rels/pages.xml.rels"));
        this._zipOutputStream.write(this._visioPagesRelsPagesXmlRelsPart.toString().getBytes(StandardCharsets.UTF_8));
        for (VSDXItem vsdxItem : this._pageXmlRelsList) {
            this._zipOutputStream.putNextEntry(new ZipEntry("visio/pages/_rels/" + vsdxItem._name));
            this._zipOutputStream.write(vsdxItem._bytes);
        }
        if (this._mediaList.size() > 0) {
            for (VSDXItem vsdxItem : this._mediaList) {
                this._zipOutputStream.putNextEntry(new ZipEntry("visio/media/" + vsdxItem._name));
                this._zipOutputStream.write(vsdxItem._bytes);
            }
        }
        if (this._masterList.size() > 0) {
            for (VSDXItem vsdxItem : this._masterList) {
                this._zipOutputStream.putNextEntry(new ZipEntry("visio/masters/" + vsdxItem._name));
                this._zipOutputStream.write(vsdxItem._bytes);
            }
            this._zipOutputStream.putNextEntry(new ZipEntry("visio/masters/masters.xml"));
            buffStr = String.format(this._visioMastersMastersTemplate.toString(), this._visioMastersMastersPart);
            this._zipOutputStream.write(buffStr.getBytes(StandardCharsets.UTF_8));
            this._zipOutputStream.putNextEntry(new ZipEntry("visio/masters/_rels/masters.xml.rels"));
            buffStr = String.format(this._visioMastersRelsMastersXmlRelsTemplate.toString(), this._visioMastersRelsMastersXmlRelsPart);
            this._zipOutputStream.write(buffStr.getBytes(StandardCharsets.UTF_8));
        }
        this._zipOutputStream.finish();
        this.putStateProgressPosition(this._scheme.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: VSDX-\u0444\u0430\u0439\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    private String getColorCode(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String getTrueFloatValStr(double v) {
        return String.valueOf(v).replace(",", ".");
    }

    private void fillDocPropsTemplates() {
        this._docPropsCustomTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties\" xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">").append("\t<property fmtid=\"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}\" pid=\"2\" name=\"_VPID_ALTERNATENAMES\">").append("\t\t<vt:lpwstr></vt:lpwstr>").append("\t</property>").append("\t<property fmtid=\"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}\" pid=\"3\" name=\"BuildNumberCreated\">").append("\t\t<vt:i4>1008341465</vt:i4>").append("\t</property>").append("\t<property fmtid=\"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}\" pid=\"4\" name=\"BuildNumberEdited\">").append("\t\t<vt:i4>1008341465</vt:i4>").append("\t</property>").append("\t<property fmtid=\"{D5CDD505-2E9C-101B-9397-08002B2CF9AE}\" pid=\"5\" name=\"IsMetric\">").append("\t\t<vt:bool>true</vt:bool>").append("\t</property>").append("</Properties>");
        this._docPropsCoreTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:dcmitype=\"http://purl.org/dc/dcmitype/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">").append("\t<dc:title></dc:title>").append("\t<dc:subject></dc:subject>").append("\t<dc:creator> </dc:creator>").append("\t<cp:keywords></cp:keywords>").append("\t<dc:description></dc:description>").append("\t<cp:lastModifiedBy></cp:lastModifiedBy>").append("\t<cp:category></cp:category>").append("\t<dc:language>ru-RU</dc:language>").append("</cp:coreProperties>");
        this._docPropsAppTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\" xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">").append("\t<Template></Template>").append("\t<Application>Microsoft Visio</Application>").append("\t<ScaleCrop>false</ScaleCrop>").append("\t<HeadingPairs>").append("\t\t<vt:vector size=\"2\" baseType=\"variant\">").append("\t\t\t<vt:variant>").append("\t\t\t\t<vt:lpstr>\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u044b</vt:lpstr>").append("\t\t\t</vt:variant>").append("\t\t\t<vt:variant>").append("\t\t\t\t<vt:i4>1</vt:i4>").append("\t\t\t</vt:variant>").append("\t\t</vt:vector>").append("\t</HeadingPairs>").append("\t<TitlesOfParts>").append("\t\t<vt:vector size=\"1\" baseType=\"lpstr\">").append("\t\t\t<vt:lpstr>\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430-1</vt:lpstr>").append("\t\t</vt:vector>").append("\t</TitlesOfParts>").append("\t<Manager></Manager>").append("\t<Company></Company>").append("\t<LinksUpToDate>false</LinksUpToDate>").append("\t<SharedDoc>false</SharedDoc>").append("\t<HyperlinkBase></HyperlinkBase>").append("\t<HyperlinksChanged>false</HyperlinksChanged>").append("\t<AppVersion>15.0000</AppVersion>").append("</Properties>");
    }

    private void fillContentTypesTemplate() {
        this._contentTypesTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">").append("\t<Default ContentType=\"image/bmp\" Extension=\"bmp\"/>").append("   <Default ContentType=\"image/png\" Extension=\"png\"/>").append("   <Default ContentType=\"image/jpeg\" Extension=\"jpeg\"/>").append("\t<Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/>").append("\t<Default Extension=\"xml\" ContentType=\"application/xml\"/>").append("\t<Override PartName=\"/visio/document.xml\" ContentType=\"application/vnd.ms-visio.drawing.main+xml\"/>").append("\t<Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/>").append("\t<Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/>").append("\t<Override PartName=\"/docProps/custom.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.custom-properties+xml\"/>").append("   %s").append("\t<Override PartName=\"/visio/pages/pages.xml\" ContentType=\"application/vnd.ms-visio.pages+xml\"/>").append("        %s").append("\t<Override PartName=\"/visio/windows.xml\" ContentType=\"application/vnd.ms-visio.windows+xml\"/>").append("   <Override PartName=\"/visio/comments.xml\" ContentType=\"application/vnd.ms-visio.comments+xml\"/>").append("</Types>");
    }

    private void fillRelsRelsTemplate() {
        this._relsRelsTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">").append("\t<Relationship Id=\"rId3\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\" Target=\"docProps/app.xml\"/>").append("\t<Relationship Id=\"rId2\" Type=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\" Target=\"docProps/core.xml\"/>").append("\t<Relationship Id=\"rId1\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/document\" Target=\"visio/document.xml\"/>").append("\t<Relationship Id=\"rId4\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties\" Target=\"docProps/custom.xml\"/>").append("</Relationships>");
    }

    private void fillVisioCommentsTemplate() {
        this._visioCommentsTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>").append("<Comments xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ShowCommentTags=\"1\" xml:space=\"preserve\">").append("   <AuthorList>%s</AuthorList>").append("   <CommentList>%s</CommentList>").append("</Comments>");
    }

    private void fillVisioWindowsTemplate() {
        this._visioWindowsTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>").append("<Windows ClientWidth=\"1280\" ClientHeight=\"819\" xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xml:space=\"preserve\">").append("   <Window ID=\"0\" WindowType=\"Drawing\" WindowState=\"1073741824\"").append("           WindowLeft=\"-8\" WindowTop=\"-31\" WindowWidth=\"1292\" WindowHeight=\"858\"").append("           ContainerType=\"Page\" Page=\"0\"").append("           ViewScale=\"1\" ViewCenterX=\"%s\" ViewCenterY=\"%s\">").append("       <ShowRulers>1</ShowRulers>").append("       <ShowGrid>%d</ShowGrid>").append("       <ShowPageBreaks>1</ShowPageBreaks>").append("       <ShowGuides>1</ShowGuides>").append("       <ShowConnectionPoints>1</ShowConnectionPoints>").append("       <GlueSettings>9</GlueSettings>").append("       <SnapSettings>65847</SnapSettings>").append("       <SnapExtensions>34</SnapExtensions>").append("       <SnapAngles/>").append("       <DynamicGridEnabled>1</DynamicGridEnabled>").append("       <TabSplitterPos>0.5</TabSplitterPos>").append("\t</Window>").append("</Windows>");
    }

    private void fillVisioDocumentTemplate() {
        this._visioDocumentTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append("<VisioDocument xml:space=\"preserve\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\">").append("\t<DocumentSettings DefaultGuideStyle=\"4\" DefaultFillStyle=\"3\" DefaultLineStyle=\"3\" DefaultTextStyle=\"3\" TopPage=\"0\">").append("       <GlueSettings>9</GlueSettings>").append("       <SnapSettings>65847</SnapSettings>").append("       <SnapExtensions>34</SnapExtensions>").append("       <SnapAngles/>").append("       <DynamicGridEnabled>1</DynamicGridEnabled>").append("       <ProtectStyles>0</ProtectStyles>").append("       <ProtectShapes>0</ProtectShapes>").append("       <ProtectMasters>0</ProtectMasters>").append("       <ProtectBkgnds>0</ProtectBkgnds>").append("   </DocumentSettings>").append("   <DocumentSheet NameU=\"TheDoc\" IsCustomName=\"1\" Name=\"TheDoc\" IsCustomNameU=\"1\" TextStyle=\"0\" FillStyle=\"0\" LineStyle=\"0\">").append("       <Cell V=\"0\" N=\"OutputFormat\"/>").append("       <Cell V=\"0\" N=\"LockPreview\"/>").append("       <Cell V=\"0\" N=\"AddMarkup\"/>").append("       <Cell V=\"0\" N=\"ViewMarkup\"/>").append("       <Cell V=\"0\" N=\"DocLockReplace\" U=\"BOOL\"/>").append("       <Cell V=\"0\" N=\"NoCoauth\" U=\"BOOL\"/>").append("       <Cell V=\"0\" N=\"DocLockDuplicatePage\" U=\"BOOL\"/>").append("       <Cell V=\"0\" N=\"PreviewQuality\"/>").append("       <Cell V=\"1\" N=\"PreviewScope\"/>").append("       <Cell V=\"ru-RU\" N=\"DocLangID\"/>").append("       <Section N=\"User\">").append("           <Row N=\"msvNoAutoConnect\">").append("               <Cell V=\"1\" N=\"Value\"/>").append("               <Cell V=\"\" N=\"Prompt\" F=\"No Formula\"/>").append("           </Row>").append("       </Section>").append("   </DocumentSheet>").append("</VisioDocument>");
    }

    private void fillVisioRelsDocumentXmlRelsTemplate() {
        this._visioRelsDocumentXmlRelsTemplate.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">").append("   <Relationship Id=\"rId3\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/comments\" Target=\"comments.xml\"/>").append("   <Relationship Id=\"rId2\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/windows\" Target=\"windows.xml\"/>").append("   <Relationship Id=\"rId1\" Type=\"http://schemas.microsoft.com/visio/2010/relationships/pages\" Target=\"pages/pages.xml\"/>").append("   %s").append("</Relationships> ");
    }

    private void fillVisioMastersRelsMastersXmlRelsTemplate() {
        this._visioMastersRelsMastersXmlRelsTemplate.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>").append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">").append("%s").append("</Relationships>");
    }

    private void fillVisioMastersMastersTemplate() {
        this._visioMastersMastersTemplate.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<Masters xml:space=\"preserve\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ").append("   xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\">").append("%s").append("</Masters> ");
    }

    private void fillVisioMastersMasterTemplate() {
        this._visioMastersMasterTemplate.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<MasterContents xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" ").append("\t\t  xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"").append("\t\t  xml:space=\"preserve\">").append("   <Shapes>").append("   %s").append("   </Shapes>").append("</MasterContents>");
    }

    private String getVisioMastersDynamicLineMasterTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"5\" OriginalID=\"0\" Type=\"Shape\" LineStyle=\"0\" FillStyle=\"0\" TextStyle=\"0\">").append("   <Cell N=\"PinX\" V=\"0.7874015866287351\" U=\"MM\" F=\"GUARD((BeginX+EndX)/2)\"/>").append("   <Cell N=\"PinY\" V=\"0\" U=\"MM\" F=\"GUARD((BeginY+EndY)/2)\"/>").append("   <Cell N=\"Width\" V=\"1.57480317325747\" U=\"MM\" F=\"GUARD(EndX-BeginX)\"/>").append("   <Cell N=\"Height\" V=\"0.1968503937007874\" F=\"GUARD(0.19685039370079DL)\"/>").append("   <Cell N=\"LocPinX\" V=\"0.7874015866287351\" U=\"MM\" F=\"GUARD(Width*0.5)\"/>").append("   <Cell N=\"LocPinY\" V=\"0.09842519685039369\" F=\"GUARD(Height*0.5)\"/>").append("   <Cell N=\"Angle\" V=\"0\" F=\"GUARD(0DA)\"/>").append("   <Cell N=\"FlipX\" V=\"0\" F=\"GUARD(FALSE)\"/>").append("   <Cell N=\"FlipY\" V=\"0\" F=\"GUARD(FALSE)\"/>").append("   <Cell N=\"ResizeMode\" V=\"0\"/>").append("   <Cell N=\"BeginX\" V=\"0\" U=\"MM\"/>").append("   <Cell N=\"BeginY\" V=\"0\" U=\"MM\"/>").append("   <Cell N=\"EndX\" V=\"1.57480317325747\"/>").append("   <Cell N=\"EndY\" V=\"0\" U=\"MM\"/>").append("   <Cell N=\"TxtPinX\" V=\"0.7874015569686889\" F=\"SETATREF(Controls.TextPosition)\"/>").append("   <Cell N=\"TxtPinY\" V=\"0.09842519462108612\" F=\"SETATREF(Controls.TextPosition.Y)\"/>").append("   <Cell N=\"TxtWidth\" V=\"0.8333333333333333\" F=\"MAX(TEXTWIDTH(TheText),5*Char.Size)\"/>").append("   <Cell N=\"TxtHeight\" V=\"0.2\" F=\"TEXTHEIGHT(TheText,TxtWidth)\"/>").append("   <Cell N=\"TxtLocPinX\" V=\"0.4166666666666666\" F=\"TxtWidth*0.5\"/>").append("   <Cell N=\"TxtLocPinY\" V=\"0.1\" F=\"TxtHeight*0.5\"/>").append("   <Cell N=\"TxtAngle\" V=\"0\"/>").append("   <Cell N=\"LockHeight\" V=\"1\"/>").append("   <Cell N=\"LockCalcWH\" V=\"1\"/>").append("   <Cell N=\"NoAlignBox\" V=\"1\"/>").append("   <Cell N=\"DynFeedback\" V=\"2\"/>").append("   <Cell N=\"GlueType\" V=\"2\"/>").append("   <Cell N=\"BegTrigger\" V=\"1\" F=\"_XFTRIGGER(EventXFMod)\"/>").append("   <Cell N=\"EndTrigger\" V=\"1\" F=\"_XFTRIGGER(EventXFMod)\"/>").append("   <Cell N=\"ObjType\" V=\"2\"/>").append("   <Cell N=\"NoLiveDynamics\" V=\"1\"/>").append("   <Cell N=\"ConFixedCode\" V=\"3\"/>").append("   <Cell N=\"ShapeSplittable\" V=\"1\"/>").append("   <Cell N=\"LayerMember\" V=\"0\"/>").append("   <Section N=\"Control\">").append("       <Row N=\"TextPosition\">").append("           <Cell N=\"X\" V=\"0.7874015569686889\"/>").append("           <Cell N=\"Y\" V=\"0.09842519462108612\"/>").append("           <Cell N=\"XDyn\" V=\"0.7874015569686889\" F=\"Controls.TextPosition\"/>").append("           <Cell N=\"YDyn\" V=\"0.09842519462108612\" F=\"Controls.TextPosition.Y\"/>").append("           <Cell N=\"XCon\" V=\"5\"/>").append("           <Cell N=\"YCon\" V=\"0\"/>").append("           <Cell N=\"CanGlue\" V=\"0\"/>").append("           <Cell N=\"Prompt\" V=\"Reposition Text\"/>").append("       </Row>").append("   </Section>").append("   <Section N=\"Geometry\" IX=\"0\">").append("       <Cell N=\"NoFill\" V=\"1\"/>").append("       <Cell N=\"NoLine\" V=\"0\"/>").append("       <Cell N=\"NoShow\" V=\"0\"/>").append("       <Cell N=\"NoSnap\" V=\"0\"/>").append("       <Cell N=\"NoQuickDrag\" V=\"0\"/>").append("       <Row T=\"MoveTo\" IX=\"1\">").append("           <Cell N=\"X\" V=\"0\"/>").append("           <Cell N=\"Y\" V=\"0.09842519685039369\"/>").append("       </Row>").append("       <Row T=\"LineTo\" IX=\"2\">").append("           <Cell N=\"X\" V=\"1.57480317325747\"/>").append("           <Cell N=\"Y\" V=\"0.09842519685039369\"/>").append("       </Row>").append("   </Section>").append("</Shape>");
        return template.toString();
    }

    private void fillVisioPagesPageTemplate() {
        this._visioPagesPageTemplate.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<PageContents xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" ").append("\t\t  xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"").append("\t\t  xml:space=\"preserve\">").append("   <Shapes>");
    }

    private String getVisioPagesPageImageTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape TextStyle=\"2\" FillStyle=\"2\" LineStyle=\"2\" Type=\"Foreign\" ID=\"%d\">").append("   <Cell N=\"PinX\" V=\"%s\"%s/>").append("   <Cell N=\"PinY\" V=\"%s\"%s/>").append("   <Cell N=\"Width\" V=\"%s\"%s/>").append("   <Cell N=\"Height\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinY\" V=\"%s\"%s/>").append("   <Cell N=\"ImgOffsetX\" V=\"%s\"%s/>").append("   <Cell N=\"ImgOffsetY\" V=\"%s\"%s/>").append("   <Cell N=\"ImgWidth\" V=\"%s\"%s/>").append("   <Cell N=\"ImgHeight\" V=\"%s\"%s/>").append("   <Cell N=\"Angle\" V=\"%s\"/>").append("   <Cell N=\"LayerMember\" V=\"%d\"/>").append("   %s%s").append("   <Section N=\"Geometry\" IX=\"0\">").append("       <Row IX=\"1\" T=\"RelMoveTo\">").append("           <Cell N=\"X\" V=\"0\"/>").append("           <Cell N=\"Y\" V=\"0\"/>").append("       </Row>").append("       <Row IX=\"2\" T=\"RelLineTo\">").append("           <Cell N=\"X\" V=\"1\"/>").append("           <Cell N=\"Y\" V=\"0\"/>").append("       </Row>").append("       <Row IX=\"3\" T=\"RelLineTo\">").append("           <Cell N=\"X\" V=\"1\"/>").append("           <Cell N=\"Y\" V=\"1\"/>").append("       </Row>").append("       <Row IX=\"4\" T=\"RelLineTo\">").append("           <Cell N=\"X\" V=\"0\"/>").append("           <Cell N=\"Y\" V=\"1\"/>").append("       </Row>").append("       <Row IX=\"5\" T=\"RelLineTo\">").append("           <Cell N=\"X\" V=\"0\"/>").append("           <Cell N=\"Y\" V=\"0\"/>").append("       </Row>").append("   </Section>").append("   <ForeignData%s ForeignType=\"Bitmap\">").append("   <Rel r:id=\"rId%d\"/>").append("   </ForeignData>").append("</Shape>");
        return template.toString();
    }

    private String getVisioPagesPageGroupMainTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" Type=\"Group\" LineStyle=\"3\" FillStyle=\"3\" TextStyle=\"3\">").append("   <Cell N=\"PinX\" V=\"%s\"%s/>").append("   <Cell N=\"PinY\" V=\"%s\"%s/>").append("   <Cell N=\"Width\" V=\"%s\"%s/>").append("   <Cell N=\"Height\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinY\" V=\"%s\"%s/>").append("   <Cell N=\"FlipX\" V=\"%s\"/>").append("   <Cell N=\"FlipY\" V=\"%s\"/>").append("   <Cell N=\"ResizeMode\" V=\"0\"/>").append("   <Cell N=\"Angle\" V=\"%s\"/>").append("   <Cell N=\"LayerMember\" V=\"%s\"/>").append("   %s").append("   %s");
        return template.toString();
    }

    private String getShapeFillGradientPartTempalte() {
        StringBuilder template = new StringBuilder();
        template.append("<Cell N=\"FillGradientEnabled\" V=\"1\"/>").append("<Cell N=\"FillGradientDir\" V=\"%s\"/>").append("<Cell N=\"FillGradientAngle\" V=\"%s\" U=\"DEG\"/>").append("<Section N=\"FillGradient\">").append("   <Row IX=\"0\">").append("       <Cell N=\"GradientStopColor\" V=\"%s\"/>").append("   </Row>").append("   <Row IX=\"1\">").append("       <Cell N=\"GradientStopColor\" V=\"%s\"/>").append("       <Cell N=\"GradientStopColorTrans\" V=\"0\"/>").append("       <Cell N=\"GradientStopPosition\" V=\"%s\"/>").append("   </Row>").append("   <Row IX=\"2\">").append("       <Cell V=\"%s\" N=\"GradientStopColor\"/>").append("       <Cell V=\"0\" N=\"GradientStopColorTrans\"/>").append("       <Cell V=\"1\" N=\"GradientStopPosition\"/>").append("   </Row>").append("</Section>");
        return template.toString();
    }

    private String getShapeLineGradientPartTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Cell N=\"LineGradientEnabled\" V=\"1\"/>").append("<Cell N=\"LineGradientDir\" V=\"%s\"/>").append("<Cell N=\"LineGradientAngle\" V=\"%s\" U=\"DEG\"/>").append("<Section N=\"LineGradient\">").append("   <Row IX=\"0\">").append("       <Cell N=\"GradientStopColor\" V=\"%s\"/>").append("   </Row>").append("   <Row IX=\"1\">").append("       <Cell N=\"GradientStopColor\" V=\"%s\"/>").append("       <Cell N=\"GradientStopColorTrans\" V=\"0\"/>").append("       <Cell N=\"GradientStopPosition\" V=\"%s\"/>").append("   </Row>").append("   <Row IX=\"2\">").append("       <Cell V=\"%s\" N=\"GradientStopColor\"/>").append("       <Cell V=\"0\" N=\"GradientStopColorTrans\"/>").append("       <Cell V=\"1\" N=\"GradientStopPosition\"/>").append("   </Row>").append("</Section>");
        return template.toString();
    }

    private String getShapePageShapeBaseTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" Type=\"Shape\" LineStyle=\"3\" FillStyle=\"3\" TextStyle=\"3\">").append("   <Cell N=\"PinX\" V=\"%s\"%s/>").append("   <Cell N=\"PinY\" V=\"%s\"%s/>").append("   <Cell N=\"Width\" V=\"%s\"%s/>").append("   <Cell N=\"Height\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinY\" V=\"%s\"%s/>").append("   <Cell N=\"Angle\" V=\"%s\"/>").append("   <Cell N=\"FlipX\" V=\"0\"/>").append("   <Cell N=\"FlipY\" V=\"0\"/>").append("   <Cell N=\"ResizeMode\" V=\"0\"/>").append("   <Cell N=\"LayerMember\" V=\"%d\"/>").append("   <Cell N=\"FillForegnd\" V=\"%s\"/>").append("   <Cell N=\"FillBkgnd\" V=\"%s\"/>").append("   <Cell N=\"LineColor\" V=\"%s\"/>").append("   <Cell N=\"LineWeight\" V=\"%s\" U=\"MM\"/>").append("   <Cell N=\"LinePattern\" V=\"%s\"/>").append("   <Cell N=\"LineCap\" V=\"%d\"/>").append("   <Cell N=\"FillPattern\" V=\"%s\"/>").append("%s%s");
        return template.toString();
    }

    private String getShapeTextBlockTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("   <Cell N=\"TxtPinX\" V=\"%s\"%s/>").append("   <Cell N=\"TxtPinY\" V=\"%s\"%s/>").append("   <Cell N=\"TxtWidth\" V=\"%s\"%s/>").append("   <Cell N=\"TxtHeight\" V=\"%s\"%s/>").append("   <Cell N=\"TxtLocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"TxtLocPinY\" V=\"%s\"%s/>").append("   <Cell N=\"TxtAngle\" V=\"%s\"/>");
        return template.toString();
    }

    private String getShapePageGuideTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" Type=\"Guide\" LineStyle=\"4\" FillStyle=\"4\" TextStyle=\"4\">\n").append("   <Cell N=\"PinX\" V=\"%s\"/>\n").append("   <Cell N=\"PinY\" V=\"%s\"/>\n").append("   <Cell N=\"Width\" V=\"%s\"/>\n").append("   <Cell N=\"Height\" V=\"0\"/>\n").append("   <Cell N=\"LocPinX\" V=\"%s\" F=\"Width*0.5\"/>\n").append("   <Cell N=\"LocPinY\" V=\"0\" F=\"Height*0.5\"/>\n").append("   <Cell N=\"Angle\" V=\"%s\"/>\n").append("   <Cell N=\"FlipX\" V=\"0\"/>\n").append("   <Cell N=\"FlipY\" V=\"0\"/>\n").append("   <Cell N=\"ResizeMode\" V=\"0\"/>\n").append("   <Cell N=\"LayerMember\" V=\"%d\"/>\n").append("   <Cell N=\"LineColor\" V=\"%s\"/>\n").append("   <Cell N=\"LineWeight\" V=\"%s\"/>").append("   Cell N=\"LinePattern\" V=\"%s\"/>").append("   <Cell N=\"LineCap\" V=\"%s\"/>").append("%s").append("   <Section N=\"Geometry\" IX=\"0\">\n").append("      <Cell N=\"NoFill\" V=\"1\"/>\n").append("      <Cell N=\"NoLine\" V=\"0\"/>\n").append("      <Cell N=\"NoShow\" V=\"0\"/>\n").append("      <Cell N=\"NoSnap\" V=\"0\"/>\n").append("      <Cell N=\"NoQuickDrag\" V=\"0\"/>\n").append("      <Row T=\"InfiniteLine\" IX=\"1\">\n").append("         <Cell N=\"X\" V=\"0\" F=\"Width*0\"/>\n").append("         <Cell N=\"Y\" V=\"0\" F=\"Height*0.5\"/>\n").append("         <Cell N=\"A\" V=\"%s\" U=\"DL\" F=\"IF(Width>0,Width,0.039370078740157DL)\"/>\n").append("         <Cell N=\"B\" V=\"0\" U=\"DL\" F=\"Height*0.5\"/>\n").append("      </Row>\n").append("   </Section>\n").append("</Shape>\n");
        return template.toString();
    }

    private String getVisioPagesPageBackgroundTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<PageContents xmlns=\"http://schemas.microsoft.com/office/visio/2012/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xml:space=\"preserve\">").append("   <Shapes>").append("       <Shape ID=\"1\" Type=\"Shape\" LineStyle=\"3\" FillStyle=\"3\" TextStyle=\"3\">").append("           <Cell N=\"PinX\" V=\"%s\" U=\"MM\"/>").append("           <Cell N=\"PinY\" V=\"%s\" U=\"MM\"/>").append("           <Cell N=\"Width\" V=\"%s\" U=\"MM\"/>").append("           <Cell N=\"Height\" V=\"%s\" U=\"MM\"/>").append("           <Cell N=\"LocPinX\" V=\"%s\" U=\"MM\" F=\"Width*0.5\"/>").append("           <Cell N=\"LocPinY\" V=\"%s\" U=\"MM\" F=\"Height*0.5\"/>").append("           <Cell N=\"Angle\" V=\"0\"/>").append("           <Cell N=\"FlipX\" V=\"0\"/>").append("           <Cell N=\"FlipY\" V=\"0\"/>").append("           <Cell N=\"ResizeMode\" V=\"0\"/>").append("           <Cell N=\"FillForegnd\" V=\"%s\"/>").append("           <Cell N=\"FillGradientEnabled\" V=\"0\"/>").append("           <Section N=\"Geometry\" IX=\"0\">").append("               <Cell N=\"NoFill\" V=\"0\"/>").append("               <Cell N=\"NoLine\" V=\"0\"/>").append("               <Cell N=\"NoShow\" V=\"0\"/>").append("               <Cell N=\"NoSnap\" V=\"0\"/>").append("               <Cell N=\"NoQuickDrag\" V=\"0\"/>").append("               <Row T=\"RelMoveTo\" IX=\"1\">").append("                   <Cell N=\"X\" V=\"0\"/>").append("                   <Cell N=\"Y\" V=\"0\"/>").append("               </Row>").append("               <Row T=\"RelLineTo\" IX=\"2\">").append("                   <Cell N=\"X\" V=\"1\"/>").append("                   <Cell N=\"Y\" V=\"0\"/>").append("               </Row>").append("               <Row T=\"RelLineTo\" IX=\"3\">").append("                   <Cell N=\"X\" V=\"1\"/>").append("                   <Cell N=\"Y\" V=\"1\"/>").append("               </Row>").append("               <Row T=\"RelLineTo\" IX=\"4\">").append("                   <Cell N=\"X\" V=\"0\"/>").append("                   <Cell N=\"Y\" V=\"1\"/>").append("               </Row>").append("               <Row T=\"RelLineTo\" IX=\"5\">").append("                   <Cell N=\"X\" V=\"0\"/>").append("                   <Cell N=\"Y\" V=\"0\"/>").append("               </Row>").append("           </Section>").append("       </Shape>").append("   </Shapes>").append("</PageContents>");
        return template.toString();
    }

    private String getShapePageShapeGeometryHeaderTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Section N=\"Geometry\" IX=\"%d\">").append("   <Cell N=\"NoFill\" V=\"%s\"/>").append("   <Cell N=\"NoLine\" V=\"0\"/>").append("   <Cell N=\"NoShow\" V=\"%d\"/>").append("   <Cell N=\"NoSnap\" V=\"0\"/>").append("   <Cell N=\"NoQuickDrag\" V=\"0\"/>");
        return template.toString();
    }

    private String getShapePageShapeParagraphHeaderTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Section N=\"Paragraph\">").append("   <Row IX=\"0\">").append("       <Cell N=\"SpLine\" V=\"-%s\"/>").append("       <Cell N=\"HorzAlign\" V=\"%d\"/>").append("   </Row>").append("</Section>");
        return template.toString();
    }

    private String getShapeMasterShapeBaseTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" Type=\"Shape\" MasterShape=\"%d\">").append("<Cell N=\"PinX\" V=\"%s\"%s/>").append("<Cell N=\"PinY\" V=\"%s\"%s/>").append("<Cell N=\"Width\" V=\"%s\"%s/>").append("<Cell N=\"Height\" V=\"%s\"%s/>").append("<Cell N=\"LocPinX\" V=\"%s\"%s/>").append("<Cell N=\"LocPinY\" V=\"%s\"%s/>").append("<Cell N=\"FillForegnd\" V=\"%s\"/>").append("<Cell N=\"FillBkgnd\" V=\"%s\"/>").append("<Cell N=\"LineColor\" V=\"%s\"/>").append("<Cell N=\"LineWeight\" V=\"%s\" U=\"MM\"/>").append("<Cell N=\"LinePattern\" V=\"%s\"/>").append("<Cell N=\"LineCap\" V=\"%d\"/>").append("<Cell N=\"FillPattern\" V=\"%s\"/>").append("%s%s");
        return template.toString();
    }

    private String getShapeMasterGroupHeaderTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Shape ID=\"%d\" Type=\"Group\" MasterShape=\"%d\">").append("   <Cell N=\"PinX\" V=\"%s\"%s/>").append("   <Cell N=\"PinY\" V=\"%s\"%s/>").append("   <Cell N=\"Width\" V=\"%s\"%s/>").append("   <Cell N=\"Height\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinX\" V=\"%s\"%s/>").append("   <Cell N=\"LocPinY\" V=\"%s\"%s/>").append("   %s").append("   <Shapes>");
        return template.toString();
    }

    private String getAttribTextCellTemplate() {
        return "<cp IX=\"%d\"/><tp IX=\"%d\"/><pp IX=\"%d\"/>%s";
    }

    private String getAttribChrSectnTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Row IX=\"%d\">").append("   <Cell V=\"%s\" N=\"Font\"/>").append("   <Cell V=\"%s\" N=\"Color\" F=\"%s\"/>").append("   <Cell V=\"%s\" N=\"Style\"/>").append("   <Cell V=\"%s\" N=\"Size\"/>").append("   <Cell V=\"%s\" N=\"Strikethru\"/>").append("   <Cell V=\"%s\" N=\"FontScale\"/>").append("   <Cell V=\"0\" N=\"Case\"/>").append("   <Cell V=\"%d\" N=\"Pos\"/>").append("   <Cell N=\"ColorTrans\" V=\"%s\"/>").append("</Row>");
        return template.toString();
    }

    private String getThemeGuard(Color color) {
        if (color == null) {
            return "THEMEGUARD(RGB(0,0,0))";
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return String.format("THEMEGUARD(RGB(%d,%d,%d))", red, green, blue);
    }

    private String getContainerTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Section N=\"User\">").append("   <Row N=\"msvStructureType\">").append("       <Cell N=\"Value\" V=\"Container\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerMargin\">").append("       <Cell N=\"Value\" V=\"%s\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerResize\">").append("       <Cell N=\"Value\" V=\"%d\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerLocked\">").append("       <Cell N=\"Value\" V=\"%d\" U=\"BOOL\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvShapeCategories\">").append("       <Cell N=\"Value\" V=\"%s\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerRequiredCategories\">").append("       <Cell N=\"Value\" V=\"%s\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerExcludedCategories\">").append("       <Cell N=\"Value\" V=\"%s\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("</Section> ");
        return template.toString();
    }

    private String getListTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Section N=\"User\">").append("   <Row N=\"msvStructureType\">").append("       <Cell N=\"Value\" V=\"List\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerMargin\">").append("       <Cell N=\"Value\" V=\"%s\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerResize\">").append("       <Cell N=\"Value\" V=\"%d\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDContainerLocked\">").append("       <Cell N=\"Value\" V=\"%d\" U=\"BOOL\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDListAlignment\">").append("       <Cell N=\"Value\" V=\"%d\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDListDirection\">").append("       <Cell N=\"Value\" V=\"%d\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvShapeCategories\">").append("       <Cell N=\"Value\" V=\"%s\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDListRequiredCategories\">").append("       <Cell N=\"Value\" V=\"%s\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("   <Row N=\"msvSDListExcludedCategories\">").append("       <Cell N=\"Value\" V=\"%s\" U=\"STR\"/>").append("       <Cell N=\"Prompt\" V=\"\"/>").append("   </Row>").append("</Section> ");
        return template.toString();
    }

    private String getGPTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Row IX=\"%d\">").append("<Cell V=\"%s\" N=\"X\"%s/>").append("<Cell V=\"%s\" N=\"Y\"%s/>").append("<Cell V=\"0\" N=\"Type\"/>").append("<Cell V=\"0\" N=\"DirX\"/><Cell V=\"1\" N=\"DirY\"/><Cell V=\"0\" N=\"AutoGen\"/>").append("</Row>");
        return template.toString();
    }

    private String getMasterTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Master MasterType=\"2\" PatternFlags=\"0\" BaseID=\"%s\" UniqueID=\"%s\" ").append("Name=\"%s\" NameU=\"%s\" ID=\"%d\" MatchByName=\"0\" AlignName=\"2\">").append("   <PageSheet TextStyle=\"0\" FillStyle=\"0\" LineStyle=\"0\">").append("       <Cell V=\"2\" N=\"PageWidth\"/>").append("       <Cell V=\"1\" N=\"PageHeight\"/>").append("       <Cell V=\"1\" N=\"PageScale\"/>").append("       <Cell V=\"1\" N=\"DrawingScale\"/>").append("       <Section N=\"Layer\">").append("           <Row IX=\"0\">").append("               <Cell V=\"\u041a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439\" N=\"Name\"/>").append("               <Cell V=\"255\" N=\"Color\"/>").append("               <Cell V=\"0\" N=\"Status\"/>").append("               <Cell V=\"1\" N=\"Visible\"/>").append("               <Cell V=\"1\" N=\"Print\"/>").append("               <Cell V=\"0\" N=\"Active\"/>").append("               <Cell V=\"0\" N=\"Lock\"/>").append("               <Cell V=\"1\" N=\"Snap\"/>").append("               <Cell V=\"1\" N=\"Glue\"/>").append("               <Cell V=\"\u041a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439\" N=\"NameUniv\"/>").append("               <Cell V=\"0\" N=\"ColorTrans\"/>").append("           </Row>").append("       </Section>").append("   </PageSheet>").append("   <Rel r:id=\"rId%d\"/>").append("</Master>");
        return template.toString();
    }

    private String getEllipseGeomTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Section N=\"Geometry\" IX=\"0\">").append("   <Row T=\"Ellipse\" IX=\"1\">").append("       <Cell N=\"X\" V=\"%s\" F=\"Width*0.5\"/>").append("       <Cell N=\"Y\" V=\"%s\" F=\"Height*0.5\"/>").append("       <Cell N=\"A\" V=\"%s\" F=\"Width*1\" U=\"DL\"/>").append("       <Cell N=\"B\" V=\"%s\" F=\"Height*0.5\" U=\"DL\"/>").append("       <Cell N=\"C\" V=\"%s\" F=\"Width*0.5\" U=\"DL\"/>").append("       <Cell N=\"D\" V=\"%s\" F=\"Height*1\" U=\"DL\"/>").append("   </Row>").append("</Section>");
        return template.toString();
    }

    private String getMargnsTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Cell V=\"%s\" N=\"LeftMargin\" U=\"MM\"/>").append("<Cell V=\"%s\" N=\"RightMargin\" U=\"MM\"/>").append("<Cell V=\"%s\" N=\"TopMargin\" U=\"MM\"/>").append("<Cell V=\"%s\" N=\"BottomMargin\" U=\"MM\"/>");
        return template.toString();
    }

    private String getPagesLayerTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Row IX=\"%d\">").append("   <Cell V=\"%s\" N=\"Name\"/>").append("   <Cell V=\"255\" N=\"Color\"/>").append("   <Cell V=\"0\" N=\"Status\"/>").append("   <Cell V=\"%d\" N=\"Visible\"/>").append("   <Cell V=\"1\" N=\"Print\"/>").append("   <Cell V=\"%d\" N=\"Lock\"/>").append("   <Cell V=\"1\" N=\"Snap\"/>").append("   <Cell V=\"1\" N=\"Glue\"/>").append("   <Cell V=\"%s\" N=\"NameUniv\"/>").append("   <Cell V=\"0\" N=\"ColorTrans\"/>").append("</Row>");
        return template.toString();
    }

    private String getPageBackgroundHeaderFooterTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Page ID=\"%d\" Name=\"\u041f\u043e\u0434\u043b\u043e\u0436\u043a\u0430\" Background=\"1\" ViewCenterX=\"%s\" ViewCenterY=\"%s\" ViewScale=\"1\">").append("   <PageSheet LineStyle=\"0\" FillStyle=\"0\" TextStyle=\"0\">").append("       <Cell N=\"PageWidth\" V=\"%s\"/>").append("       <Cell N=\"PageHeight\" V=\"%s\"/>").append("       <Trigger N=\"RecalcColor\">").append("           <RefBy T=\"Page\" ID=\"%d\"/>").append("       </Trigger>").append("       %s").append("       <Cell N=\"ShdwOffsetX\" V=\"0.1181102362204724\"/>").append("       <Cell N=\"ShdwOffsetY\" V=\"-0.1181102362204724\"/>").append("       <Cell N=\"PageScale\" V=\"%s\" U=\"MM\"/>").append("       <Cell N=\"DrawingScale\" V=\"0.03937007874015748\"/>").append("       <Cell N=\"DrawingSizeType\" V=\"0\"/>").append("       <Cell N=\"DrawingScaleType\" V=\"0\"/>").append("       <Cell N=\"InhibitSnap\" V=\"0\"/>").append("       <Cell N=\"PageLockReplace\" V=\"0\" U=\"BOOL\"/>").append("       <Cell N=\"PageLockDuplicate\" V=\"0\" U=\"BOOL\"/>").append("       <Cell N=\"UIVisibility\" V=\"0\"/>").append("       <Cell N=\"ShdwType\" V=\"0\"/>").append("       <Cell N=\"ShdwObliqueAngle\" V=\"0\"/>").append("       <Cell N=\"ShdwScaleFactor\" V=\"1\"/>").append("       <Cell N=\"DrawingResizeType\" V=\"1\"/>").append("       <Cell N=\"PageShapeSplit\" V=\"1\"/>").append("   </PageSheet>").append("   <Rel r:id=\"rId%d\"/>").append("</Page>");
        return template.toString();
    }

    private String getPageAuthorTemplate() {
        return "<AuthorEntry Name=\"%s\" Initials=\"%s\" ResolutionID=\"&lt;resolutionId provider=&quot;None&quot;&gt;&lt;localId name=&quot;%s&quot;/&gt;&lt;/resolutionId&gt;\" ID=\"%s\"/>";
    }

    private String getPageCommentTemplate() {
        return "<CommentEntry AuthorID=\"%s\" PageID=\"%s\" Date=\"%s\" EditDate=\"%s\" CommentID=\"%s\" AutoCommentType=\"0\">%s</CommentEntry>";
    }

    private String getShapeCommentTemplate() {
        return "<CommentEntry AuthorID=\"%s\" PageID=\"%s\" ShapeID=\"%s\" Date=\"%s\" EditDate=\"%s\" CommentID=\"%s\" AutoCommentType=\"0\">%s</CommentEntry>";
    }

    private String getPageHeaderTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Page ID=\"%d\" Name=\"%s\" Background=\"%d\" ViewScale=\"1\" ViewCenterX=\"%s\" ViewCenterY=\"%s\" %s>").append("   <PageSheet LineStyle=\"0\" FillStyle=\"0\" TextStyle=\"0\">").append("       <Cell N=\"PageWidth\" V=\"%s\"/>").append("       <Cell N=\"PageHeight\" V=\"%s\"/>").append("       <Cell N=\"ShdwOffsetX\" V=\"0.1181102362204724\"/>").append("       <Cell N=\"ShdwOffsetY\" V=\"-0.1181102362204724\"/>").append("       <Cell N=\"PageScale\" V=\"%s\" U=\"MM\"/>").append("       <Cell N=\"DrawingScale\" V=\"0.03937007874015748\" U=\"MM\"/>").append("       <Cell N=\"DrawingSizeType\" V=\"0\"/>").append("       <Cell N=\"DrawingScaleType\" V=\"0\"/>").append("       <Cell N=\"InhibitSnap\" V=\"0\"/>").append("       <Cell N=\"PageLockReplace\" V=\"0\" U=\"BOOL\"/>").append("       <Cell N=\"PageLockDuplicate\" V=\"0\" U=\"BOOL\"/>").append("       <Cell N=\"UIVisibility\" V=\"0\"/>").append("       <Cell N=\"ShdwType\" V=\"0\"/>").append("       <Cell N=\"ShdwObliqueAngle\" V=\"0\"/>").append("       <Cell N=\"ShdwScaleFactor\" V=\"1\"/>").append("       <Cell N=\"DrawingResizeType\" V=\"1\"/>").append("       %s").append("       <Cell N=\"LineJumpCode\" V=\"%d\"/>").append("       <Cell N=\"LineJumpStyle\" V=\"%d\"/>").append("       <Cell N=\"LineToLineX\" V=\"%s\" U=\"MM\"/>").append("       <Cell N=\"LineToLineY\" V=\"%s\" U=\"MM\"/>").append("       <Cell N=\"LineJumpFactorX\" V=\"%s\"/>").append("       <Cell N=\"LineJumpFactorY\" V=\"%s\"/>").append("       <Cell N=\"PageShapeSplit\" V=\"1\"/>");
        return template.toString();
    }

    private String getPageFooterTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("   </PageSheet>").append("   <Rel r:id=\"rId%d\"/>").append("</Page>");
        return template.toString();
    }

    private String getPageXmlRelsTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">").append("%s").append("</Relationships>");
        return template.toString();
    }

    private String getPrintSettingsTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Cell U=\"MM\" V=\"%s\" N=\"PageLeftMargin\"/>").append("<Cell U=\"MM\" V=\"%s\" N=\"PageRightMargin\"/>").append("<Cell U=\"MM\" V=\"%s\" N=\"PageTopMargin\"/>").append("<Cell U=\"MM\" V=\"%s\" N=\"PageBottomMargin\"/>").append("<Cell V=\"%d\" N=\"PagesX\"/>").append("<Cell V=\"%d\" N=\"PagesY\"/>").append("<Cell V=\"1\" N=\"OnPage\"/>").append("<Cell V=\"%d\" N=\"PrintPageOrientation\"/>").append("<Cell V=\"%d\" N=\"PaperKind\"/>").append("<Cell V=\"15\" N=\"PaperSource\"/>");
        return template.toString();
    }

    private String getPrintSettingsLiteTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<Cell N=\"PageLeftMargin\" V=\"%s\" U=\"MM\"/>").append("<Cell N=\"PageRightMargin\" V=\"%s\" U=\"MM\"/>").append("<Cell N=\"PageTopMargin\" V=\"%s\" U=\"MM\"/>").append("<Cell N=\"PageBottomMargin\" V=\"%s\" U=\"MM\"/>").append("<Cell N=\"PrintPageOrientation\" V=\"%d\"/>").append("<Cell N=\"PaperKind\" V=\"%d\"/>").append("<Cell N=\"PaperSource\" V=\"15\"/>");
        return template.toString();
    }

    private int getBrushPattern(BaseShape shape) {
        if (shape.BrushPattern == -1) {
            if (this._useMasterPart && this._primBlock != null) {
                SchemeObject xObj = this._scheme.layerById(this._primBlock.LayerID);
                if (xObj == null) {
                    xObj = this._scheme.layerById(this._curInsert.LayerID);
                }
                return ((PhxLayer)xObj.BG).BrushPattern;
            }
            if (this._usePageMasterDefMode && this._curInsert != null) {
                return ((PhxLayer)this._scheme.layerById((double)this._curInsert.LayerID).BG).BrushPattern;
            }
            SchemeObject xObj = this._scheme.layerById(shape.LayerID);
            if (xObj == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
                return 0;
            }
            return ((PhxLayer)xObj.BG).BrushPattern;
        }
        return shape.BrushPattern;
    }

    private int getPenPattern(BaseShape shape) {
        if (shape.PenPattern == -1) {
            if (this._useMasterPart && this._primBlock != null) {
                SchemeObject xObj = this._scheme.layerById(this._primBlock.LayerID);
                if (xObj == null) {
                    xObj = this._scheme.layerById(this._curInsert.LayerID);
                }
                return ((PhxLayer)xObj.BG).PenPattern;
            }
            if (this._usePageMasterDefMode && this._curInsert != null) {
                return ((PhxLayer)this._scheme.layerById((double)this._curInsert.LayerID).BG).PenPattern;
            }
            SchemeObject xObj = this._scheme.layerById(shape.LayerID);
            if (xObj == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
                return 0;
            }
            return ((PhxLayer)xObj.BG).PenPattern;
        }
        return shape.PenPattern;
    }

    private int convertLineCap(int lineCap) {
        switch (lineCap) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    private void addEm(EmbeddedText et, StringBuilder xCurrentPart) {
        if (et.Lines == null || et.Lines.isEmpty()) {
            return;
        }
        xCurrentPart.append("<Text>");
        int idx = 0;
        if (et.isPart()) {
            int cnt = et.Lines.size();
            for (int i = 0; i < cnt; ++i) {
                RectTextLine line = (RectTextLine)et.Lines.get(i);
                if (line == null) continue;
                if (i > 0) {
                    xCurrentPart.append("\n");
                }
                int cntj = line.Parts.size();
                for (int j = 0; j < cntj; ++j) {
                    RectTextLine.PartTextLine part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), idx, 0, 0, VsdxWriter.correctText(part.text)));
                    ++idx;
                }
            }
        } else {
            StringBuilder xText = new StringBuilder("");
            int count = et.Lines.size();
            if (count > 1) {
                for (int i = 0; i < count; ++i) {
                    RectTextLine line = (RectTextLine)et.Lines.get(i);
                    String text = VsdxWriter.correctText(line.Text);
                    if (i == 0) {
                        xText = new StringBuilder(text);
                        continue;
                    }
                    xText.append("\n").append(text);
                }
            } else {
                RectTextLine line = (RectTextLine)et.Lines.get(0);
                String text = VsdxWriter.correctText(line.Text);
                xText = new StringBuilder(text);
            }
            xCurrentPart.append(String.format(this.getAttribTextCellTemplate(), 0, 0, 0, xText));
        }
        xCurrentPart.append("</Text>");
    }

    private void fillEmStyle(EmbeddedText et, StringBuilder xCurrentPart) {
        if (et.Lines == null || et.Lines.isEmpty()) {
            return;
        }
        RectTextLine firstLine = (RectTextLine)et.Lines.get(0);
        if (firstLine.FontName.equalsIgnoreCase("symbol")) {
            return;
        }
        double xSchemeScale = this._schemeScale * 25.4;
        if (this._useMasterPart) {
            xSchemeScale = 1.0;
        }
        switch (et.VertAlign) {
            case 0: 
            case 1: 
            case 2: {
                String va = "<Cell N=\"VerticalAlign\" V=\"%d\"/>";
                xCurrentPart.append(String.format(va, VsdxWriter.getVisioVAlign(et.VertAlign)));
                break;
            }
        }
        String paragraphTemplate = this.getShapePageShapeParagraphHeaderTemplate();
        xCurrentPart.append(String.format(paragraphTemplate, this.getTrueFloatValStr(Math.abs(et.LineSpacing)), VsdxWriter.getVisioHAlign(et.Align)));
        xCurrentPart.append("<Section N=\"Character\">");
        if (et.isPart()) {
            int idx = 0;
            int cnt = et.Lines.size();
            for (int i = 0; i < cnt; ++i) {
                RectTextLine line = (RectTextLine)et.Lines.get(i);
                if (line == null) continue;
                int cntj = line.Parts.size();
                for (int j = 0; j < cntj; ++j) {
                    RectTextLine.PartTextLine part = line.Parts.get(j);
                    if (part == null || Strings.isVoid(part.text)) continue;
                    String xFontName = VsdxWriter.repairFontName(part.fontName);
                    String xFontColor = this.getColorCode(part.fontColor);
                    String xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(part.fontHeight) * xSchemeScale);
                    int xBuffInt = 0;
                    if ((part.fontStyle & 1) != 0) {
                        xBuffInt |= 1;
                    }
                    if ((part.fontStyle & 2) != 0) {
                        xBuffInt |= 2;
                    }
                    if ((part.fontStyle & 4) != 0) {
                        xBuffInt |= 4;
                    }
                    String xFontStyle = String.valueOf(xBuffInt);
                    String xFontStrikethru = "0";
                    if ((part.fontStyle & 8) != 0) {
                        xFontStrikethru = "1";
                    }
                    String xFontScale = this.getTrueFloatValStr(et.WidthScale);
                    int pos = 0;
                    if (part.ssScript == 1) {
                        pos = 2;
                    }
                    if (part.ssScript == 2) {
                        pos = 1;
                    }
                    Color fontColor = part.fontColor;
                    xCurrentPart.append(String.format(this.getAttribChrSectnTemplate(), idx, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, pos, this.getTrueFloatValStr((double)et.TransparentText / 255.0)));
                    ++idx;
                }
            }
        } else {
            String xFontName = VsdxWriter.repairFontName(firstLine.FontName);
            String xFontColor = this.getColorCode(firstLine.FontColor);
            String xFontSize = this.getTrueFloatValStr(VsdxWriter.mmToInch(et.lfHeight < 1.0E-12 ? 2.0 * firstLine.SideY / 3.0 / (double)et.Lines.size() : et.lfHeight) * xSchemeScale);
            int xBuffInt = 0;
            if ((firstLine.FontStyle & 1) != 0) {
                xBuffInt |= 1;
            }
            if ((firstLine.FontStyle & 2) != 0) {
                xBuffInt |= 2;
            }
            if ((firstLine.FontStyle & 4) != 0) {
                xBuffInt |= 4;
            }
            String xFontStyle = String.valueOf(xBuffInt);
            String xFontStrikethru = "0";
            if ((firstLine.FontStyle & 8) != 0) {
                xFontStrikethru = "1";
            }
            String xFontScale = this.getTrueFloatValStr(et.WidthScale);
            Color fontColor = firstLine.FontColor;
            xCurrentPart.append(String.format(this.getAttribChrSectnTemplate(), 0, xFontName, xFontColor, this.getThemeGuard(fontColor), xFontStyle, xFontSize, xFontStrikethru, xFontScale, 0, this.getTrueFloatValStr((double)et.TransparentText / 255.0)));
        }
        xCurrentPart.append("</Section>");
    }

    private void fillShapeStyle(BaseShape shape, ShapeStyle shapeStyle, int parentId, double parentWidth, double parentHeight, double parentWidthCoeff, double parentHeightCoeff, double orgAngle, double[] pts) {
        double xHeight;
        double xWidth;
        String xStopPositionIX1;
        Color xColorRowIX2;
        Color xColorRowIX1;
        Color xColorRowIX0;
        String transpVal;
        double transparent;
        Color xBkColor;
        Color xColor;
        PhxLayer xLayer;
        SchemeObject xObj;
        double xSchemeScale = this._schemeScale * 25.4;
        if (this._useMasterPart) {
            xSchemeScale = 1.0;
        }
        if (this._useMasterPart || this._usePageMasterDefMode) {
            if (this._useMasterPart) {
                xObj = this._scheme.layerById(this._primBlock.LayerID);
                if (xObj == null) {
                    xObj = this._scheme.layerById(this._curInsert.LayerID);
                }
                xLayer = (PhxLayer)xObj.BG;
            } else {
                xLayer = (PhxLayer)this._scheme.layerById((double)this._curInsert.LayerID).BG;
            }
        } else {
            xObj = this._scheme.layerById(shape.LayerID);
            if (xObj == null && (xObj = this._curInsert != null ? this._scheme.layerById(this._curInsert.LayerID) : this.getCosmeticLayer()) == null) {
                Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0438\u0433\u0443\u0440\u044b: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439");
                return;
            }
            xLayer = (PhxLayer)xObj.BG;
        }
        Color xPColor = shape.pColor == null ? xLayer.pColor : shape.pColor;
        int xBrushPattern = this.getBrushPattern(shape);
        int xNoFill = 0;
        if ((!(shape instanceof Polyline) || shape instanceof Region || shape instanceof Polygon) && xBrushPattern != 1) {
            xColor = shape.bColor == null ? xLayer.bColor : shape.bColor;
            xBkColor = shape.BkColor == null ? xLayer.BkColor : shape.BkColor;
        } else if (shape.BrushPattern == -1) {
            xColor = xLayer.bColor;
            xBkColor = xLayer.BkColor;
        } else {
            xColor = shape.bColor;
            xBkColor = shape.BkColor;
        }
        if (xColor == null) {
            xColor = Color.WHITE;
        }
        if (xBkColor == null) {
            xBkColor = Color.WHITE;
        }
        Color xFontColor = Color.BLACK;
        if (shape instanceof Paragraph && (xFontColor = ((Paragraph)shape).getFontColor()) == null) {
            xFontColor = xLayer.FontColor;
        }
        if (shape instanceof Pie && ((Pie)shape).PieType == 0 || shape instanceof Polyline && !(shape instanceof Polygon) && !(shape instanceof Region)) {
            xNoFill = 1;
        }
        int xLinePattern = VsdxWriter.convertLinePattern(this.getPenPattern(shape));
        int xLineCap = this.convertLineCap(shape.LineCap);
        shapeStyle.transparent = "";
        if (shape.Transparent != 0 || shape.TransparentByLayer && xLayer.Transparent != 0) {
            transparent = shape.TransparentByLayer ? (double)xLayer.Transparent : (double)shape.Transparent;
            transpVal = this.getTrueFloatValStr(transparent / 255.0);
            shapeStyle.transparent = String.format("   <Cell N=\"FillForegndTrans\" V=\"%s\"/><Cell N=\"FillBkgndTrans\" V=\"%s\"/>", transpVal, transpVal);
        }
        shapeStyle.transparentBorder = "";
        if (shape.TransparentBorder != 0 || shape.TransparentBorderByLayer && xLayer.TransparentBorder != 0) {
            transparent = shape.TransparentBorderByLayer ? (double)xLayer.TransparentBorder : (double)shape.TransparentBorder;
            transpVal = this.getTrueFloatValStr(transparent / 255.0);
            shapeStyle.transparentBorder = String.format("  <Cell N=\"LineColorTrans\" V=\"%s\"/>", transpVal);
        }
        int xFillPattern = this.convertFillPattern(xBrushPattern);
        int xFillGradientDir = this._fillGradientDir;
        double xFillGradientAngle = this._fillGradientAngle;
        int xFillGradientEnabled = 0;
        if (xBrushPattern > 1000) {
            xFillGradientEnabled = 1;
        }
        switch (xBrushPattern) {
            case 10011: 
            case 10013: 
            case 10015: 
            case 10017: {
                xColorRowIX0 = xBkColor;
                xColorRowIX1 = xColor;
                xColorRowIX2 = xBkColor;
                xStopPositionIX1 = "0.5";
                break;
            }
            case 10012: 
            case 10014: 
            case 10016: 
            case 10018: {
                xColorRowIX0 = xColor;
                xColorRowIX1 = xBkColor;
                xColorRowIX2 = xColor;
                xStopPositionIX1 = "0.5";
                break;
            }
            case 10020: {
                xColorRowIX0 = xBkColor;
                xColorRowIX1 = xColor;
                xColorRowIX2 = xColor;
                xStopPositionIX1 = "1";
                break;
            }
            default: {
                xColorRowIX0 = xColor;
                xColorRowIX1 = xBkColor;
                xColorRowIX2 = xBkColor;
                xStopPositionIX1 = "1";
            }
        }
        double xLineWeight = shape.lWidth == -1.0 ? VsdxWriter.mmToInch(xLayer.lWidth) : VsdxWriter.mmToInch(shape.lWidth);
        xLineWeight *= xSchemeScale;
        double xPropCenterX = shape.TransProps == null ? 0.0 : shape.TransProps.CenterX;
        double xPropCenterY = shape.TransProps == null ? 0.0 : shape.TransProps.CenterY;
        double xPropScaleX = shape.TransProps == null ? 1.0 : shape.TransProps.ScaleX;
        double xPropScaleY = shape.TransProps == null ? 1.0 : shape.TransProps.ScaleY;
        double xAngle = -SchemeEngine.NormAngle(orgAngle) * Math.PI / 180.0;
        double xLocPinXOffset = VsdxWriter.mmToInch(xPropCenterX) * parentWidthCoeff * Math.abs(xPropScaleX);
        double xLocPinYOffset = VsdxWriter.mmToInch(xPropCenterY) * parentHeightCoeff * Math.abs(xPropScaleY);
        if (shape instanceof Rectangle) {
            double sideX = ((Rectangle)shape).SideX;
            if (shape instanceof Paragraph) {
                Paragraph para = (Paragraph)shape;
                sideX = Math.max(sideX, para.exportSidesX);
            }
            xWidth = sideX * Math.abs(xPropScaleX);
            xHeight = ((Rectangle)shape).SideY * Math.abs(xPropScaleY);
        } else {
            Sides sides = new Sides(pts);
            xWidth = sides.SideX;
            xHeight = sides.SideY;
        }
        if (SchemeUtils.isEqual(xWidth, 0.0) && SchemeUtils.isEqual(xHeight, 0.0)) {
            xWidth = shape.Left > shape.Right ? shape.Left - shape.Right : shape.Right - shape.Left;
            xHeight = shape.Top > shape.Bottom ? shape.Top - shape.Bottom : shape.Bottom - shape.Top;
        }
        xWidth = Math.abs(VsdxWriter.mmToInch(xWidth)) * parentWidthCoeff;
        xHeight = Math.abs(VsdxWriter.mmToInch(xHeight)) * parentHeightCoeff;
        double xLocPinX = xWidth / 2.0 - xLocPinXOffset;
        double xLocPinY = xHeight / 2.0 + xLocPinYOffset;
        double xPinX = VsdxWriter.mmToInch(shape.OrgX) * parentWidthCoeff + parentWidth / 2.0;
        double xPinY = VsdxWriter.mmToInch(-shape.OrgY) * parentHeightCoeff + parentHeight / 2.0;
        if (shape instanceof Polyline && !(shape instanceof Region) && !(shape instanceof Polygon) && shape.ParentGB instanceof Dimension && (((Dimension)shape.ParentGB).DimType == 0 || ((Dimension)shape.ParentGB).DimType == 1)) {
            double xDimOrgX = (pts[0] + pts[2]) / 2.0;
            double xDimOrgY = (pts[1] + pts[3]) / 2.0;
            xPinX = VsdxWriter.mmToInch(xDimOrgX) * parentWidthCoeff + parentWidth / 2.0;
            xPinY = VsdxWriter.mmToInch(xDimOrgY) * parentHeightCoeff + parentHeight / 2.0;
        }
        if (shape instanceof Attribute) {
            Attribute att = (Attribute)shape;
            if (att.Inscribe && parentId != 0) {
                xLocPinX = xPinX;
                xLocPinY = xPinY;
                xLocPinXOffset = 0.0;
                xLocPinYOffset = 0.0;
                xWidth = parentWidth;
                xHeight = parentHeight;
            }
        }
        shapeStyle.locPinXOffsetN = xLocPinXOffset;
        shapeStyle.locPinYOffsetN = xLocPinYOffset;
        shapeStyle.pinXFStr = "";
        shapeStyle.pinYFStr = "";
        shapeStyle.widthFStr = "";
        shapeStyle.heightFStr = "";
        shapeStyle.locPinXFStr = " F=\"Width*0.5\"";
        shapeStyle.locPinYFStr = " F=\"Height*0.5\"";
        if (Math.abs(xLocPinXOffset) > 1.0E-12 && xWidth > 1.0E-5) {
            shapeStyle.locPinXFStr = String.format(" F=\"Width*%s\"", this.getTrueFloatValStr(xLocPinX / xWidth));
        }
        if (Math.abs(xLocPinYOffset) > 1.0E-12 && xHeight > 1.0E-5) {
            shapeStyle.locPinYFStr = String.format(" F=\"Height*%s\"", this.getTrueFloatValStr(xLocPinY / xHeight));
        }
        if (parentId != 0) {
            if (parentWidth > 1.0E-5) {
                shapeStyle.pinXFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xPinX / parentWidth));
                shapeStyle.widthFStr = String.format(" F = \"Sheet.%d!Width*%s\"", parentId, this.getTrueFloatValStr(xWidth / parentWidth));
            }
            if (parentHeight > 1.0E-5) {
                shapeStyle.pinYFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xPinY / parentHeight));
                shapeStyle.heightFStr = String.format(" F = \"Sheet.%d!Height*%s\"", parentId, this.getTrueFloatValStr(xHeight / parentHeight));
            }
        }
        if (this.getConnPointDef(shape, -1)) {
            shapeStyle.pinXFStr = this._pinXStrDef;
            shapeStyle.pinYFStr = this._pinYStrDef;
            if (this._isDynamicLine) {
                shapeStyle.locPinXFStr = "";
                shapeStyle.locPinYFStr = "";
            }
            shapeStyle.widthFStr = this._widthStrDef;
            shapeStyle.heightFStr = this._heightStrDef;
        } else if (this._isDynamicLine) {
            shapeStyle.locPinXFStr = "";
            shapeStyle.locPinYFStr = "";
        }
        shapeStyle.pinXN = xPinX;
        shapeStyle.pinYN = xPinY;
        shapeStyle.locPinXN = xLocPinX;
        shapeStyle.locPinYN = xLocPinY;
        shapeStyle.widthN = xWidth;
        shapeStyle.heightN = xHeight;
        shapeStyle.pinX = this.getTrueFloatValStr(xPinX);
        shapeStyle.pinY = this.getTrueFloatValStr(xPinY);
        shapeStyle.width = this.getTrueFloatValStr(xWidth);
        shapeStyle.height = this.getTrueFloatValStr(xHeight);
        shapeStyle.locPinX = this.getTrueFloatValStr(xLocPinX);
        shapeStyle.locPinY = this.getTrueFloatValStr(xLocPinY);
        shapeStyle.angle = this.getTrueFloatValStr(xAngle);
        shapeStyle.color = this.getColorCode(xColor);
        shapeStyle.bkColor = this.getColorCode(xBkColor);
        shapeStyle.pColor = this.getColorCode(xPColor);
        shapeStyle.fontColor = this.getColorCode(xFontColor);
        shapeStyle.lineWeight = this.getTrueFloatValStr(xLineWeight);
        shapeStyle.linePattern = String.valueOf(xLinePattern);
        shapeStyle.lineCap = xLineCap;
        shapeStyle.fillPattern = String.valueOf(xFillPattern);
        shapeStyle.fillGradientDir = String.valueOf(xFillGradientDir);
        shapeStyle.fillGradientAngle = this.getTrueFloatValStr(xFillGradientAngle);
        shapeStyle.fillGradientEnabled = String.valueOf(xFillGradientEnabled);
        shapeStyle.colorRowIX0 = this.getColorCode(xColorRowIX0);
        shapeStyle.colorRowIX1 = this.getColorCode(xColorRowIX1);
        shapeStyle.stopPositionIX1 = xStopPositionIX1;
        shapeStyle.colorRowIX2 = this.getColorCode(xColorRowIX2);
        shapeStyle.noFill = String.valueOf(xNoFill);
    }

    private int convertFillPattern(int fillPattern) {
        this._fillGradientDir = 0;
        this._fillGradientAngle = 0.0;
        switch (fillPattern) {
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 6;
            }
            case 16: {
                return 6;
            }
            case 17: {
                return 19;
            }
            case 18: {
                return 13;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 7;
            }
            case 21: {
                return 7;
            }
            case 22: {
                return 20;
            }
            case 23: {
                return 14;
            }
            case 24: {
                return 14;
            }
            case 25: {
                return 2;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 22;
            }
            case 28: {
                return 16;
            }
            case 29: {
                return 16;
            }
            case 30: {
                return 5;
            }
            case 31: {
                return 5;
            }
            case 32: {
                return 21;
            }
            case 33: {
                return 15;
            }
            case 34: {
                return 15;
            }
            case 35: {
                return 3;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return 23;
            }
            case 38: {
                return 23;
            }
            case 39: {
                return 23;
            }
            case 40: {
                return 24;
            }
            case 41: {
                return 24;
            }
            case 42: {
                return 24;
            }
            case 43: {
                return 17;
            }
            case 44: {
                return 17;
            }
            case 45: {
                return 17;
            }
            case 46: {
                return 17;
            }
            case 47: {
                return 4;
            }
            case 48: {
                return 12;
            }
            case 49: {
                return 12;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 4;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 4;
            }
            case 54: {
                return 23;
            }
            case 55: {
                return 18;
            }
            case 56: {
                return 23;
            }
            case 57: {
                return 4;
            }
            case 58: {
                return 4;
            }
            case 59: {
                return 12;
            }
            case 60: {
                return 4;
            }
            case 61: {
                return 4;
            }
            case 62: {
                return 4;
            }
            case 63: {
                return 4;
            }
            case 64: {
                return 4;
            }
            case 65: {
                return 4;
            }
            case 66: {
                return 12;
            }
            case 67: {
                return 3;
            }
            case 10002: {
                this._fillGradientAngle = Math.PI;
                return 1;
            }
            case 10003: 
            case 10013: 
            case 10014: {
                this._fillGradientAngle = 1.5707963267948966;
                return 1;
            }
            case 10004: {
                this._fillGradientAngle = 4.71238898038469;
                return 1;
            }
            case 10005: {
                this._fillGradientAngle = 2.356194490192345;
                return 1;
            }
            case 10006: 
            case 10015: 
            case 10016: {
                this._fillGradientAngle = 5.497787143782138;
                return 1;
            }
            case 10007: {
                this._fillGradientAngle = 3.9269908169872414;
                return 1;
            }
            case 10008: 
            case 10017: 
            case 10018: {
                this._fillGradientAngle = 0.7853981633974483;
                return 1;
            }
            case 10019: 
            case 10020: {
                this._fillGradientDir = 10;
                return 1;
            }
        }
        return 1;
    }

    private static int convertLinePattern(int linePattern) {
        switch (linePattern) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 12;
            }
        }
        if (linePattern > 1000) {
            return 1;
        }
        return 0;
    }

    private static double mmToInch(double mm) {
        return mm / 25.4;
    }

    private void resetAllUsedMasterHashEntries() {
        for (Map.Entry<Double, MasterHashEntry> entry : this._hashTable.entrySet()) {
            MasterHashEntry value = entry.getValue();
            value._used = false;
        }
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateInstruction(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateInstruction(value);
    }

    private void putStateLog(String value) {
        if (this.stateHost == null) {
            return;
        }
        try {
            this.stateHost.putRequestStateLog(value);
        }
        catch (Exception ex) {
            Core.logger.error("", ex);
        }
    }

    private void putStateProgressMin(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMin(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    private static class ShapeStyle {
        double pinXN = 0.0;
        double pinYN = 0.0;
        double locPinXN = 0.0;
        double locPinYN = 0.0;
        double locPinXOffsetN = 0.0;
        double locPinYOffsetN = 0.0;
        double widthN = 0.0;
        double heightN = 0.0;
        String pinX = null;
        String pinY = null;
        String width = null;
        String height = null;
        String locPinX = null;
        String locPinY = null;
        String angle = null;
        String pColor = null;
        String bkColor = null;
        String color = null;
        String fontColor = null;
        String lineWeight = null;
        String linePattern = null;
        int lineCap = 0;
        String fillPattern = null;
        String transparent = null;
        String transparentBorder = null;
        String fillGradientDir = null;
        String fillGradientAngle = null;
        String fillGradientEnabled = null;
        String colorRowIX0 = null;
        String colorRowIX1 = null;
        String colorRowIX2 = null;
        String stopPositionIX1 = null;
        String noFill = null;
        String pinXFStr = null;
        String pinYFStr = null;
        String widthFStr = null;
        String heightFStr = null;
        String locPinXFStr = null;
        String locPinYFStr = null;
    }

    private static class VSDXItem {
        public String _name = null;
        public byte[] _bytes = null;
    }

    private static class MasterHashEntry {
        public int _masterId;
        public int _masterIdStart;
        public boolean _used;
        public int _relIndex;
        public String _targetName;

        public MasterHashEntry(int masterId, int masterIdStart, int relIndex, String targetName) {
            this._masterId = masterId;
            this._masterIdStart = masterIdStart;
            this._used = false;
            this._relIndex = relIndex;
            this._targetName = targetName;
        }
    }

    private static class ConnPointHashEntry {
        public int _shapeId;
        public int _connectionId;

        public ConnPointHashEntry(int shapeId, int connectionId) {
            this._shapeId = shapeId;
            this._connectionId = connectionId;
        }
    }

    private static class Sides {
        double SideX;
        double SideY;

        public Sides(double[] Points) {
            if (Points == null) {
                this.SideX = 0.0;
                this.SideY = 0.0;
                return;
            }
            if (Points.length / 2 < 2) {
                this.SideX = 0.0;
                this.SideY = 0.0;
                return;
            }
            double xmin = Points[0];
            double ymin = Points[1];
            double xmax = Points[0];
            double ymax = Points[1];
            for (int i = 0; i < Points.length; i += 2) {
                if (xmin > Points[i]) {
                    xmin = Points[i];
                }
                if (xmax < Points[i]) {
                    xmax = Points[i];
                }
                if (ymin > Points[i + 1]) {
                    ymin = Points[i + 1];
                }
                if (!(ymax < Points[i + 1])) continue;
                ymax = Points[i + 1];
            }
            this.SideX = xmax - xmin;
            this.SideY = ymin - ymax;
        }
    }
}

