/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgFrame;
import inform.agent.schemes.converters.odg.content.OdgText;
import java.util.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgImage
extends OdgFrame {
    private final String fileName;
    private byte[] decodedBytes;
    private String drawMimeType;

    public OdgImage(Element element) {
        String xlinkHred = element.getAttribute("xlink:href");
        int slashIndex = xlinkHred.lastIndexOf("/");
        this.fileName = xlinkHred.substring(slashIndex + 1);
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                String tagName = el.getTagName();
                if (element.hasAttribute("draw:mime-type")) {
                    this.drawMimeType = element.getAttribute("draw:mime-type");
                }
                if (tagName.equals("text:p") && el.getTextContent().length() != 0) {
                    this.text = new OdgText(element);
                }
                if (!tagName.equals("office:binary-data")) continue;
                String base64String = el.getTextContent().replaceAll("\\s+", "");
                this.decodedBytes = Base64.getDecoder().decode(base64String);
            }
        }
    }

    public String getType() {
        if (this.drawMimeType == null) {
            return null;
        }
        int index = this.drawMimeType.indexOf(47);
        if (index == -1) {
            return null;
        }
        return this.drawMimeType.substring(index + 1);
    }

    public byte[] binaryData() {
        return this.decodedBytes;
    }

    public String getFileName() {
        return this.fileName;
    }
}

