/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.Paragraph;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Table;
import inform.agent.schemes.converters.odg.content.OdgParentStyle;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgStyleParagraphProperties
extends OdgProperties {
    public OdgStyleParagraphProperties(Table table, double scale) {
        CharSequence[] attr = new String[3];
        attr[0] = OdgUtils.asStringWithPoint(table.lWidth * scale);
        switch (table.PenPattern) {
            case 1: {
                attr[1] = "dashed";
                break;
            }
            case 2: {
                attr[1] = "dotted";
                break;
            }
            case 3: {
                attr[1] = "dash-dot";
                break;
            }
            case 4: {
                attr[1] = "dash-dot-dot";
                break;
            }
            default: {
                attr[1] = "solid";
            }
        }
        attr[2] = OdgUtils.getColor(table.pColor);
        String foBorder = String.join((CharSequence)" ", attr);
        this.styles.put("fo:border", foBorder);
    }

    public OdgStyleParagraphProperties(RectTextLine rtl, double schemeScale) {
        if (rtl.parentParagraph != null) {
            Paragraph paragraph = rtl.parentParagraph;
            double value = paragraph.TabStopPosition * schemeScale;
            this.styles.put("style:position", OdgUtils.asStringWithCentimeter(value));
            this.styles.put("loext:tab-stop-distance", "0cm");
            this.checkAlign(paragraph.Align);
        }
        if (rtl.paragraphLine == null) {
            return;
        }
        RectTextLine.ParagraphLine pl = rtl.paragraphLine;
        if (pl.leftIndent != 0.0) {
            this.styles.put("fo:margin-left", OdgUtils.asStringWithCentimeter(pl.leftIndent * schemeScale));
        }
        if (pl.rightIndent != 0.0) {
            this.styles.put("fo:margin-right", OdgUtils.asStringWithCentimeter(pl.rightIndent * schemeScale));
        }
        if (pl.spaceAfter != 0.0) {
            this.styles.put("fo:margin-bottom", OdgUtils.asStringWithCentimeter(pl.spaceAfter * schemeScale));
        }
        if (pl.spaceBefore != 0.0) {
            this.styles.put("fo:margin-top", OdgUtils.asStringWithCentimeter(pl.spaceBefore * schemeScale));
        }
        if (pl.firstIndent != 0.0) {
            this.styles.put("fo:text-indent", OdgUtils.asStringWithCentimeter(pl.firstIndent * schemeScale));
        }
        if (pl.lineSpacing != 1.0) {
            double lfHeight = Math.abs(pl.lineSpacing);
            this.styles.put("fo:line-height", lfHeight * 100.0 + "%");
        }
        this.checkAlign(pl.align);
    }

    public OdgStyleParagraphProperties(Paragraph paragraph) {
        this.styles.put("fo:line-height", "100%");
        if (paragraph.lfHeight != 1.0) {
            double lfHeight = Math.abs(paragraph.LineSpacing);
            this.styles.put("fo:line-height", lfHeight * 100.0 + "%");
        }
        if (paragraph.TabStopPosition != 15.0) {
            double value = paragraph.TabStopPosition;
            this.styles.put("style:position", OdgUtils.asStringWithCentimeter(value));
            this.styles.put("loext:tab-stop-distance", "0cm");
        }
        this.checkAlign(paragraph.Align);
    }

    public OdgStyleParagraphProperties(Element element, OdgParentStyle parentStyle) {
        String value;
        Set<String> parentAttrs = null;
        if (parentStyle != null && parentStyle.style != null) {
            OdgProperties properties = parentStyle.style.getStyleProperty();
            parentAttrs = properties.styles.keySet();
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:line-height")) {
            this.styles.put("fo:line-height", "1");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:margin-left")) {
            this.styles.put("fo:margin-left", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:margin-right")) {
            this.styles.put("fo:margin-right", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:margin-top")) {
            this.styles.put("fo:margin-top", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:margin-bottom")) {
            this.styles.put("fo:margin-bottom", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:text-indent")) {
            this.styles.put("fo:text-indent", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("style:tab-stop")) {
            this.styles.put("style:tab-stop", "15");
        }
        if (element.hasAttribute("fo:text-align")) {
            value = element.getAttribute("fo:text-align");
            int foTextAlign = 0;
            switch (value) {
                case "start": 
                case "left": {
                    break;
                }
                case "end": 
                case "right": {
                    foTextAlign = 1;
                    break;
                }
                case "center": {
                    foTextAlign = 2;
                }
            }
            this.styles.put("fo:text-align", String.valueOf(foTextAlign));
        }
        if (element.hasAttribute("fo:line-height")) {
            value = element.getAttribute("fo:line-height");
            double persent = OdgUtils.parsePercentValue(value);
            this.styles.put("fo:line-height", String.valueOf(persent / 100.0));
        }
        if (element.hasAttribute("fo:margin-left")) {
            value = element.getAttribute("fo:margin-left");
            this.styles.put("fo:margin-left", this.convertText(value));
        }
        if (element.hasAttribute("fo:margin-right")) {
            value = element.getAttribute("fo:margin-right");
            this.styles.put("fo:margin-right", this.convertText(value));
        }
        if (element.hasAttribute("fo:margin-top")) {
            value = element.getAttribute("fo:margin-top");
            this.styles.put("fo:margin-top", this.convertText(value));
        }
        if (element.hasAttribute("fo:margin-bottom")) {
            value = element.getAttribute("fo:margin-bottom");
            this.styles.put("fo:margin-bottom", this.convertText(value));
        }
        if (element.hasAttribute("fo:text-indent")) {
            value = element.getAttribute("fo:text-indent");
            this.styles.put("fo:text-indent", this.convertText(value));
        }
        if (element.hasAttribute("fo:border")) {
            value = element.getAttribute("fo:border");
            String[] values = value.split(" ");
            if (values.length == 1) {
                this.styles.put("fo:border", "0 5 #000000");
            } else {
                double foFontSize = OdgUtils.parseParagraphValue(values[0]) * 0.62240969;
                int pattern = -1;
                switch (values[1]) {
                    case "dashed": {
                        pattern = 1;
                        break;
                    }
                    case "dotted": {
                        pattern = 2;
                        break;
                    }
                    case "dash-dot": {
                        pattern = 3;
                        break;
                    }
                    case "dash-dot-dot": {
                        pattern = 4;
                        break;
                    }
                }
                String strokeWidth = String.valueOf(foFontSize);
                String drawStroke = String.valueOf(pattern);
                String strokeColor = values[2];
                String foBorderTemplate = "%s %s %s";
                this.styles.put("fo:border", String.format(foBorderTemplate, strokeWidth, drawStroke, strokeColor));
            }
        }
        if (element.hasChildNodes()) {
            this.getTabNodes(element);
        }
    }

    private String convertText(String text) {
        double value = OdgUtils.parseSizeValue(text);
        double valueMm = OdgUtils.asMillimeters(value);
        return String.valueOf(valueMm);
    }

    private void getTabNodes(Element element) {
        NodeList nl = element.getChildNodes();
        if (nl.getLength() > 0) {
            Node el = nl.item(0);
            if (el.getNodeType() != 1) {
                return;
            }
            NodeList list = el.getChildNodes();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) {
                    return;
                }
                Element tab = (Element)node;
                String position = tab.getAttribute("style:position");
                double stylePosition = OdgUtils.parseSizeValue(position);
                if (i != 0) continue;
                double value = OdgUtils.asMillimeters(stylePosition);
                this.styles.put("style:tab-stop", String.valueOf(value));
            }
        }
    }

    private void checkAlign(int value) {
        switch (value) {
            default: {
                this.styles.put("fo:text-align", "start");
                break;
            }
            case 1: {
                this.styles.put("fo:text-align", "end");
                break;
            }
            case 2: {
                this.styles.put("fo:text-align", "center");
            }
        }
    }
}

