/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.converters.odg.content.OdgParentStyle;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleGraphicsProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleParagraphProperties;
import inform.agent.schemes.converters.odg.content.OdgStyleTextProperties;
import inform.agent.schemes.converters.odg.content.OdgTable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgStyleStyle {
    private String styleName;
    private String styleFamily;
    private String styleParentStyleName;
    private OdgParentStyle parentStyle;
    private final OdgProperties styleProperties = new OdgProperties();
    private boolean hasGraphic;
    private boolean hasText;
    private boolean hasParagraph;

    public OdgStyleStyle() {
    }

    public OdgStyleStyle(Element element) {
        this();
        if (element.hasAttribute("style:name")) {
            this.styleName = element.getAttribute("style:name");
        }
        if (element.hasAttribute("style:family")) {
            this.styleFamily = element.getAttribute("style:family");
        }
        if (element.hasAttribute("style:parent-style-name")) {
            this.styleParentStyleName = element.getAttribute("style:parent-style-name");
            this.parentStyle = new OdgParentStyle(this.styleParentStyleName);
        }
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            block19: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                switch (el.getTagName()) {
                    case "loext:graphic-properties": 
                    case "style:graphic-properties": {
                        OdgStyleGraphicsProperties graphicsProperties = new OdgStyleGraphicsProperties(el, this.parentStyle);
                        this.styleProperties.styles.putAll(graphicsProperties.styles);
                        this.hasGraphic = true;
                        continue block19;
                    }
                    case "loext:text-properties": 
                    case "style:text-properties": {
                        OdgStyleTextProperties textProperties = new OdgStyleTextProperties(el, this.parentStyle);
                        this.styleProperties.styles.putAll(textProperties.styles);
                        this.hasText = true;
                        continue block19;
                    }
                    case "loext:paragraph-properties": 
                    case "style:paragraph-properties": {
                        OdgStyleParagraphProperties paragraphProperties = new OdgStyleParagraphProperties(el, this.parentStyle);
                        this.styleProperties.styles.putAll(paragraphProperties.styles);
                        this.hasParagraph = true;
                        continue block19;
                    }
                    case "loext:table-column-properties": 
                    case "style:table-column-properties": {
                        OdgTable.OdgStyleTableColumnProperties tableColumnProperties = new OdgTable.OdgStyleTableColumnProperties(el);
                        this.styleProperties.styles.putAll(tableColumnProperties.styles);
                        continue block19;
                    }
                    case "loext:table-row-properties": 
                    case "style:table-row-properties": {
                        OdgTable.OdgStyleTableRowProperties tableRowProperties = new OdgTable.OdgStyleTableRowProperties(el);
                        this.styleProperties.styles.putAll(tableRowProperties.styles);
                    }
                }
            }
        }
    }

    public OdgParentStyle getParentStyle() {
        return this.parentStyle;
    }

    public void setParentStyle(OdgParentStyle parentStyle) {
        this.parentStyle = parentStyle;
    }

    public String getStyleParentStyleName() {
        return this.styleParentStyleName;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getStyleFamily() {
        return this.styleFamily;
    }

    public OdgProperties getStyleProperty() {
        if (this.parentStyle != null) {
            return this.parentStyle.getClone(this.styleProperties);
        }
        return this.styleProperties;
    }

    public boolean hasGraphic() {
        return this.hasGraphic;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public boolean hasParagraph() {
        return this.hasParagraph;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public void setHasParagraph(boolean hasParagraph) {
        this.hasParagraph = hasParagraph;
    }
}

