/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.styles;

import inform.agent.schemes.converters.odg.content.OdgUtils;
import org.w3c.dom.Element;

public class OdgStylePageLayoutProperties {
    private double foMarginTop;
    private double foMarginBottom;
    private double foMarginLeft;
    private double foMarginRight;
    private double foPageWidth;
    private double foPageHeight;
    private String printOrientation;

    public OdgStylePageLayoutProperties(Element element) {
        String value;
        if (element.hasAttribute("fo:margin-top")) {
            value = element.getAttribute("fo:margin-top");
            this.foMarginTop = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("fo:margin-bottom")) {
            value = element.getAttribute("fo:margin-bottom");
            this.foMarginBottom = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("fo:margin-left")) {
            value = element.getAttribute("fo:margin-left");
            this.foMarginLeft = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("fo:margin-right")) {
            value = element.getAttribute("fo:margin-right");
            this.foMarginRight = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("fo:page-width")) {
            value = element.getAttribute("fo:page-width");
            this.foPageWidth = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("fo:page-height")) {
            value = element.getAttribute("fo:page-height");
            this.foPageHeight = OdgUtils.parseSizeValue(value);
        }
        if (element.hasAttribute("style:print-orientation")) {
            this.printOrientation = element.getAttribute("style:print-orientation");
        }
    }

    public double getFoMarginTop() {
        return this.foMarginTop * 10.0;
    }

    public double getFoMarginBottom() {
        return this.foMarginBottom * 10.0;
    }

    public double getFoMarginLeft() {
        return this.foMarginLeft * 10.0;
    }

    public double getFoMarginRight() {
        return this.foMarginRight * 10.0;
    }

    public double getFoPageWidth() {
        return this.foPageWidth * 10.0;
    }

    public double getFoPageHeight() {
        return this.foPageHeight * 10.0;
    }

    public String getPrintOrientation() {
        return this.printOrientation;
    }
}

