/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.adt.DateTime;
import inform.agent.Core;
import inform.agent.schemes.converters.vsdx.VsdxComment;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VsdxCommentsParser {
    private final VsdxParser vsdxParser;
    private final Document document;

    public VsdxCommentsParser(VsdxParser vsdxParser, Document document) {
        this.vsdxParser = vsdxParser;
        this.document = document;
    }

    public List<VsdxComment> parseComments() {
        List<Element> commentList;
        HashMap<String, String> autors = new HashMap<String, String>();
        List<Element> autorList = VsdxParser.getElementsByLocalName(this.document.getDocumentElement(), "AuthorList");
        if (autorList != null && !autorList.isEmpty()) {
            for (Element autor : autorList) {
                List<Element> authorEntryList = VsdxParser.getElementsByLocalName(autor, "AuthorEntry");
                if (authorEntryList == null || authorEntryList.isEmpty()) continue;
                for (Element autorEntry : authorEntryList) {
                    if (!autorEntry.hasAttribute("Name") || !autorEntry.hasAttribute("ID")) continue;
                    autors.put(autorEntry.getAttribute("ID"), autorEntry.getAttribute("Name"));
                }
            }
        }
        if ((commentList = VsdxParser.getElementsByLocalName(this.document.getDocumentElement(), "CommentList")) != null && !commentList.isEmpty()) {
            ArrayList<VsdxComment> result = new ArrayList<VsdxComment>();
            for (Element comment : commentList) {
                List<Element> commentEntryList = VsdxParser.getElementsByLocalName(comment, "CommentEntry");
                if (commentEntryList == null || commentEntryList.isEmpty()) continue;
                for (Element commentEntry : commentEntryList) {
                    String editDate;
                    VsdxComment vsdxComment = new VsdxComment();
                    vsdxComment.PageID = commentEntry.getAttribute("PageID");
                    vsdxComment.ShapeID = commentEntry.getAttribute("ShapeID");
                    vsdxComment.Text = commentEntry.getTextContent();
                    String autorID = commentEntry.getAttribute("AuthorID");
                    if (autorID != null) {
                        vsdxComment.Autor = (String)autors.get(autorID);
                    }
                    if ((editDate = commentEntry.getAttribute("EditDate")) != null && !editDate.isEmpty()) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        try {
                            Date d = format.parse(editDate);
                            if (d != null) {
                                vsdxComment.EditDate = DateTime.fromUnixTime(d.getTime());
                            }
                        }
                        catch (ParseException ex) {
                            Core.logger.warn("Parse comments.xml", ex);
                        }
                    }
                    result.add(vsdxComment);
                }
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }
}

