/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxControlPoint;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxControlParser
extends VsdxRowsSectionParser {
    VsdxControlParser(VsdxParser vsdxParser, Element controlNode) {
        super(vsdxParser, controlNode);
    }

    void parse(VsdxShape shape) {
        if (shape == null) {
            return;
        }
        if (shape.ControlPoints == null) {
            shape.ControlPoints = new ArrayList<VsdxControlPoint>();
        }
        boolean empty = shape.ControlPoints.isEmpty();
        Element controlSection = this.getSectionNode();
        NodeList controlRows = controlSection.getChildNodes();
        for (int controlRowId = 0; controlRowId < controlRows.getLength(); ++controlRowId) {
            VsdxControlPoint p;
            if (controlRows.item(controlRowId).getNodeType() != 1) continue;
            Element controlRow = (Element)controlRows.item(controlRowId);
            VsdxControlPoint parsedControl = new VsdxControlPoint();
            parsedControl.Name = controlRow.getAttribute("N");
            if (controlRow.hasAttribute("Del")) {
                parsedControl.Del = controlRow.getAttribute("Del");
            }
            NodeList controlCells = controlRow.getChildNodes();
            block20: for (int cellId = 0; cellId < controlCells.getLength(); ++cellId) {
                Element propertyCell;
                if (controlCells.item(cellId).getNodeType() != 1 || !(propertyCell = (Element)controlCells.item(cellId)).hasAttribute("V")) continue;
                String cellValue = propertyCell.getAttribute("V");
                switch (propertyCell.getAttribute("N")) {
                    case "X": {
                        parsedControl.X = cellValue;
                        continue block20;
                    }
                    case "Y": {
                        parsedControl.Y = cellValue;
                        continue block20;
                    }
                    case "Prompt": {
                        parsedControl.Prompt = cellValue;
                        continue block20;
                    }
                    case "XDyn": {
                        continue block20;
                    }
                    case "YDyn": {
                        continue block20;
                    }
                    case "XCon": {
                        parsedControl.XCon = cellValue;
                        continue block20;
                    }
                    case "YCon": {
                        parsedControl.YCon = cellValue;
                        continue block20;
                    }
                }
            }
            VsdxControlPoint vsdxControlPoint = p = empty ? null : shape.findControlPointByName(parsedControl.Name);
            if (p == null) {
                shape.ControlPoints.add(parsedControl);
                continue;
            }
            p.applyProperties(parsedControl);
        }
    }
}

