/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VsdxDocumentParser {
    private final VsdxParser vsdxParser;
    private final Document document;
    private Map<String, String> colorEntries;
    private Map<String, VsdxStyle> styles;

    public VsdxDocumentParser(VsdxParser vsdxParser, Document document) {
        this.vsdxParser = vsdxParser;
        this.document = document;
    }

    public Map<String, String> getColorEntries() {
        if (this.colorEntries != null) {
            return this.colorEntries;
        }
        assert (this.document != null);
        this.colorEntries = new HashMap<String, String>();
        List<Element> colors = VsdxParser.getElementsByLocalName(this.document.getDocumentElement(), "Colors");
        if (colors != null && !colors.isEmpty()) {
            assert (colors.size() == 1);
            List<Element> entries = VsdxParser.getElementsByLocalName(colors.get(0), "ColorEntry");
            this.colorEntries = this.getCellValues(null, entries, "IX", "RGB");
        }
        return this.colorEntries;
    }

    public Map<String, VsdxStyle> getStyles() {
        if (this.styles == null) {
            this.parseStyles();
        }
        return this.styles;
    }

    public void parseStyles() {
        assert (this.document != null);
        this.styles = new HashMap<String, VsdxStyle>();
        this.colorEntries = new HashMap<String, String>();
        List<Element> styleSheetsNodes = VsdxParser.getElementsByLocalName(this.document.getDocumentElement(), "StyleSheets");
        if (styleSheetsNodes != null && !styleSheetsNodes.isEmpty()) {
            assert (styleSheetsNodes.size() == 1);
            List<Element> styleSheetNodes = VsdxParser.getElementsByLocalName(styleSheetsNodes.get(0), "StyleSheet");
            if (styleSheetNodes != null) {
                for (Element styleSheet : styleSheetNodes) {
                    if (!styleSheet.hasAttribute("ID")) continue;
                    VsdxStyle style = new VsdxStyle();
                    if (styleSheet.hasAttribute("NameU")) {
                        style.Name = styleSheet.getAttribute("NameU");
                    }
                    if (styleSheet.hasAttribute("LineStyle")) {
                        style.LineStyleID = styleSheet.getAttribute("LineStyle");
                    }
                    if (styleSheet.hasAttribute("FillStyle")) {
                        style.FillStyleID = styleSheet.getAttribute("FillStyle");
                    }
                    if (styleSheet.hasAttribute("TextStyle")) {
                        style.TextStyleID = styleSheet.getAttribute("TextStyle");
                    }
                    List<Element> cellNodes = VsdxParser.getElementsByLocalName(styleSheet, "Cell");
                    style.cellValues = this.getCellValues(styleSheet, cellNodes, "N", "V");
                    List<Element> sectionNodes = VsdxParser.getElementsByLocalName(styleSheet, "Section");
                    if (sectionNodes != null) {
                        for (Element sectionNode : sectionNodes) {
                            String sectionType;
                            switch (sectionType = sectionNode.getAttribute("N")) {
                                case "Character": {
                                    style.characterValues = this.getRowsValues(sectionNode).get(0);
                                    break;
                                }
                                case "Paragraph": {
                                    style.paragraphValues = this.getRowsValues(sectionNode).get(0);
                                    break;
                                }
                                case "LineGradient": {
                                    style.lineGradientValues = this.getRowsValues(sectionNode);
                                    break;
                                }
                                case "FillGradient": {
                                    style.fillGradientValues = this.getRowsValues(sectionNode);
                                }
                            }
                        }
                    }
                    style.ID = styleSheet.getAttribute("ID");
                    this.styles.put(style.ID, style);
                }
            }
        }
    }

    private List<Map<String, String>> getRowsValues(Element sectionNode) {
        List<Element> rowNodes = VsdxParser.getElementsByLocalName(sectionNode, "Row");
        ArrayList<Map<String, String>> rowsValues = new ArrayList<Map<String, String>>();
        if (rowNodes != null && !rowNodes.isEmpty()) {
            for (Element row : rowNodes) {
                List<Element> cells = VsdxParser.getElementsByLocalName(row, "Cell");
                rowsValues.add(this.getCellValues(row, cells, "N", "V"));
            }
        }
        return rowsValues;
    }

    private Map<String, String> getCellValues(Element rowNode, List<Element> cellNodes, String attribute1, String attribute2) {
        HashMap<String, String> nodesValues = new HashMap<String, String>();
        if (rowNode != null) {
            if (rowNode.hasAttribute("IX")) {
                nodesValues.put("IX", rowNode.getAttribute("IX"));
            }
            if (rowNode.hasAttribute("Del")) {
                nodesValues.put("Del", rowNode.getAttribute("Del"));
            }
        }
        if (cellNodes != null) {
            for (Element cellNode : cellNodes) {
                if (!cellNode.hasAttribute(attribute1) || !cellNode.hasAttribute(attribute2)) continue;
                nodesValues.put(cellNode.getAttribute(attribute1), cellNode.getAttribute(attribute2));
            }
        }
        return nodesValues;
    }
}

