/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.adt.InformException;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.converters.vsdx.VsdxGeometryRow;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VsdxGeometry {
    public String ID = "";
    public String NoFill;
    public String NoLine;
    public String NoShow;
    public List<VsdxGeometryRow> rows;
    private List<RowPoint> rowPoints;
    private BaseGraphic.RealPoints points;
    private IntegerList moveArr;
    private IntegerList lineArr;
    private IntegerList arcArr;
    private IntegerList splineArr;
    private IntegerList ellipseArr;
    private BaseGraphic.RealPoints ellipsePoints;
    private IntegerList ellipseMoveArr;
    private IntegerList rowMoves;
    private IntegerList duplicates;
    private int closed;
    private boolean disableBezier;
    private List<BezierData> bezierData;
    private final VsdxShape shape;

    public VsdxGeometry(VsdxShape shape) {
        this.shape = shape;
    }

    void applyProperties(VsdxGeometry props) {
        if (props == null) {
            return;
        }
        if (props.NoFill != null) {
            this.NoFill = props.NoFill;
        }
        if (props.NoLine != null) {
            this.NoLine = props.NoLine;
        }
        if (props.NoShow != null) {
            this.NoShow = props.NoShow;
        }
        if (props.rows != null && !props.rows.isEmpty()) {
            if (this.rows == null) {
                this.rows = new ArrayList<VsdxGeometryRow>();
            }
            boolean isEmpty = this.rows.isEmpty();
            for (VsdxGeometryRow row : props.rows) {
                VsdxGeometryRow r;
                VsdxGeometryRow vsdxGeometryRow = r = isEmpty ? null : this.findRowById(row.ID);
                if (r == null) {
                    r = new VsdxGeometryRow();
                    r.ID = row.ID;
                    this.rows.add(r);
                }
                r.applyProperties(row);
            }
        }
    }

    public VsdxGeometryRow findRowById(String id) {
        if (id != null && this.rows != null) {
            for (VsdxGeometryRow r : this.rows) {
                if (!id.equals(r.ID)) continue;
                return r;
            }
        }
        return null;
    }

    public boolean isNoFill() {
        return "1".equals(this.NoFill);
    }

    public boolean isNoLine() {
        return "1".equals(this.NoLine);
    }

    public boolean isNoShow() {
        return "1".equals(this.NoShow);
    }

    public int getClosed() {
        this.initInfo();
        return this.closed;
    }

    private boolean isInitInfo() {
        return this.points != null;
    }

    private void initInfo() {
        if (this.isInitInfo()) {
            return;
        }
        assert (this.shape != null);
        this.rowPoints = new ArrayList<RowPoint>();
        this.points = new BaseGraphic.RealPoints();
        this.moveArr = new IntegerList(2);
        this.lineArr = new IntegerList(2);
        this.arcArr = new IntegerList(2);
        this.splineArr = new IntegerList(2);
        this.duplicates = new IntegerList(2);
        this.rowMoves = new IntegerList(2);
        if (this.rows == null || this.rows.isEmpty()) {
            return;
        }
        String moveX = null;
        String moveY = null;
        boolean linePoint = false;
        String lastT = "";
        String lastX = "";
        String lastY = "";
        BaseGraphic.RealPoint shapeSize = this.shape.getShapeSize();
        String lineJumpFuncion = null;
        if (this.shape.isLineRoute() && !this.shape.isCurveLineRoute() && this.shape.page != null && this.shape.page.getLineJumpCode() > 0) {
            switch (this.shape.page.getLineJumpType()) {
                case 0: {
                    lineJumpFuncion = "MoveTo";
                    break;
                }
                case 1: {
                    lineJumpFuncion = "ArcTo";
                    break;
                }
                default: {
                    lineJumpFuncion = "PolylineTo";
                }
            }
        }
        this.rows = this.rows.stream().filter(r -> !r.isDel()).collect(Collectors.toList());
        int cnt = this.rows.size();
        for (int r2 = 0; r2 < cnt; ++r2) {
            int j;
            VsdxGeometryRow row = this.rows.get(r2);
            assert (row != null);
            if (lastT == null || lastX == null || lastY == null) continue;
            if (r2 > 0 && lastT.equals(row.T) && lastX.equals(row.X) && lastY.equals(row.Y)) {
                this.duplicates.add(r2);
            }
            if (r2 > 0 && this.isRedundantMove(row, lastX, lastY)) continue;
            if (lineJumpFuncion != null && VsdxUtils.isLineRow(row.T) && r2 + 1 < cnt) {
                VsdxGeometryRow nextRow = this.rows.get(r2 + 1);
                if (lineJumpFuncion.equals(nextRow.T)) {
                    ++r2;
                    continue;
                }
            }
            lastT = row.T;
            lastX = row.X;
            lastY = row.Y;
            RowPoint rowPoint = new RowPoint();
            rowPoint.T = row.T;
            rowPoint.X = this.convertDouble(row.X);
            rowPoint.Y = this.convertDouble(row.Y);
            if (VsdxUtils.isArcRow(row.T) || VsdxUtils.isRelQuadBezToRow(row.T) || VsdxUtils.isRelCubBezToRow(row.T) || VsdxUtils.isEllipse(row.T) || VsdxUtils.isNURBSToRow(row.T) || VsdxUtils.isSplineStartRow(row.T)) {
                rowPoint.A = this.convertDouble(row.A);
                rowPoint.B = this.convertDouble(row.B);
                rowPoint.C = this.convertDouble(row.C);
                rowPoint.D = this.convertDouble(row.D);
            }
            this.rowPoints.add(rowPoint);
            if (VsdxUtils.isRelRow(row.T)) {
                rowPoint.X *= shapeSize.X;
                rowPoint.Y *= shapeSize.Y;
                if (VsdxUtils.isArcRow(row.T) || VsdxUtils.isRelQuadBezToRow(row.T)) {
                    rowPoint.A *= shapeSize.X;
                    rowPoint.B *= shapeSize.Y;
                } else if (VsdxUtils.isRelCubBezToRow(row.T)) {
                    rowPoint.A *= shapeSize.X;
                    rowPoint.B *= shapeSize.Y;
                    rowPoint.C *= shapeSize.X;
                    rowPoint.D *= shapeSize.Y;
                }
            }
            if (VsdxUtils.isEllipse(row.T)) {
                this.disableBezier = true;
                this.bezierData = null;
                if (this.ellipseArr == null) {
                    this.ellipseArr = new IntegerList(2);
                }
                this.ellipseArr.add(r2);
                ++this.closed;
                continue;
            }
            if (VsdxUtils.isMoveToRow(row.T)) {
                int size = this.points.size();
                this.moveArr.add(size);
                moveX = row.X;
                moveY = row.Y;
                linePoint = false;
                this.points.add(new BaseGraphic.RealPoint(rowPoint.X, rowPoint.Y));
                this.rowMoves.add(r2);
                continue;
            }
            if (moveX != null && moveY != null) {
                if (moveX.equals(row.X) && moveY.equals(row.Y)) {
                    if (linePoint) {
                        ++this.closed;
                    }
                } else {
                    linePoint = true;
                }
            }
            if (VsdxUtils.isLineRow(row.T)) {
                this.lineArr.add(r2);
                if ("PolylineTo".equals(row.T) && row.A != null) {
                    String[] arr;
                    String s = row.A.trim().toUpperCase();
                    if (!s.startsWith("POLYLINE")) continue;
                    double shapeSizeX = this.convertDouble(this.shape.Width);
                    double shapeSizeY = this.convertDouble(this.shape.Height);
                    int idx1 = s.indexOf("(");
                    int idx2 = s.indexOf(")");
                    if (idx1 < 0 || idx2 < 0 || (arr = s.substring(idx1 + 1, idx2).split(",")) == null || arr.length <= 2) continue;
                    boolean relX = "0".equals(arr[0].trim());
                    boolean relY = "0".equals(arr[1].trim());
                    BaseGraphic.RealPoints linePoints = new BaseGraphic.RealPoints();
                    int j2 = 2;
                    for (int i = arr.length / 2 - 1; i > 0; --i) {
                        double x = this.convertDouble(arr[j2++]);
                        double y = this.convertDouble(arr[j2++]);
                        if (relX) {
                            x *= shapeSizeX;
                        }
                        if (relY) {
                            y *= shapeSizeY;
                        }
                        linePoints.add(new BaseGraphic.RealPoint(x, y));
                    }
                    linePoints.add(new BaseGraphic.RealPoint(rowPoint.X, rowPoint.Y));
                    if (this.closed == 0 && linePoints.size() > 2) {
                        int lastM;
                        BaseGraphic.RealPoint p0 = (BaseGraphic.RealPoint)linePoints.get(0);
                        double x0 = p0.X;
                        double y0 = p0.Y;
                        int n = lastM = this.moveArr.empty() ? -1 : this.moveArr.get(this.moveArr.size() - 1);
                        if (lastM >= 0 && lastM < this.rowPoints.size()) {
                            RowPoint rp0 = this.rowPoints.get(lastM);
                            x0 = rp0.X;
                            y0 = rp0.Y;
                        }
                        int cntl = linePoints.size();
                        for (int l = 1; l < cntl; ++l) {
                            BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)linePoints.get(l);
                            if (!SchemeUtils.isEqual(x0, p.X) || !SchemeUtils.isEqual(y0, p.Y)) continue;
                            ++this.closed;
                            break;
                        }
                    }
                    this.points.addAll(linePoints);
                    continue;
                }
                this.points.add(new BaseGraphic.RealPoint(rowPoint.X, rowPoint.Y));
                continue;
            }
            if (VsdxUtils.isArcRow(row.T)) {
                BaseGraphic.RealPoint center;
                this.disableBezier = true;
                this.bezierData = null;
                this.arcArr.add(r2);
                VsdxGeometryRow arcRow = this.rows.get(r2);
                assert (r2 > 0);
                int lastRP = this.rowPoints.size() - 1;
                RowPoint moveP = this.rowPoints.get(lastRP - 1);
                RowPoint arcP = this.rowPoints.get(lastRP);
                BaseGraphic.RealPoint p1 = new BaseGraphic.RealPoint(moveP.X, moveP.Y);
                BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(arcP.X, arcP.Y);
                if (SchemeUtils.isEqual(p1, p2)) {
                    if (VsdxUtils.isEllipticalArcRow(row.T)) {
                        BaseGraphic.RealPoint controlPoint = new BaseGraphic.RealPoint(arcP.A, arcP.B);
                        this.points.add(controlPoint);
                    }
                    this.points.add(p2);
                    continue;
                }
                if (VsdxUtils.isEllipticalArcRow(row.T)) {
                    BaseGraphic.RealPoint raduis;
                    BaseGraphic.RealPoint center2;
                    BaseGraphic.RealPoint controlPoint = new BaseGraphic.RealPoint(arcP.A, arcP.B);
                    double angle = this.convertDouble(arcRow.C);
                    double D = this.convertDouble(arcRow.D);
                    if (SchemeUtils.calcEllipse(p1, controlPoint, p2, D, angle, center2 = new BaseGraphic.RealPoint(), raduis = new BaseGraphic.RealPoint())) {
                        int cntPoints = 90;
                        BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToEllipseArc(center2, p1, p2, controlPoint, raduis, angle, cntPoints);
                        for (int i = 0; i < 10 && sidesToArc.size() < 8; ++i) {
                            sidesToArc = SchemeUtils.sidesToEllipseArc(center2, p1, p2, controlPoint, raduis, angle, cntPoints *= 2);
                        }
                        if (sidesToArc.isEmpty()) {
                            this.points.add(controlPoint);
                            this.points.add(p2);
                            continue;
                        }
                        this.points.addAll(sidesToArc);
                        continue;
                    }
                    this.points.add(p2);
                    continue;
                }
                double A = this.convertDouble(arcRow.A);
                if (SchemeUtils.calcCircle(p1, p2, A, center = new BaseGraphic.RealPoint())) {
                    int cntPoints = 90;
                    BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToArc(center, p1, p2, A < 0.0, cntPoints);
                    for (int i = 0; i < 10 && sidesToArc.size() < 8; ++i) {
                        sidesToArc = SchemeUtils.sidesToArc(center, p1, p2, A < 0.0, cntPoints *= 2);
                    }
                    if (sidesToArc.isEmpty()) {
                        this.points.add(p2);
                        continue;
                    }
                    this.points.addAll(sidesToArc);
                    continue;
                }
                this.points.add(p2);
                continue;
            }
            if (VsdxUtils.isRelQuadBezToRow(row.T)) {
                double d3;
                double d2;
                this.arcArr.add(r2);
                VsdxGeometryRow arcRow = this.rows.get(r2);
                assert (r2 > 0);
                int lastRP = this.rowPoints.size() - 1;
                RowPoint moveP = this.rowPoints.get(lastRP - 1);
                RowPoint arcP = this.rowPoints.get(lastRP);
                BaseGraphic.RealPoint p1 = new BaseGraphic.RealPoint(moveP.X, moveP.Y);
                BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(arcP.A, arcP.B);
                BaseGraphic.RealPoint p3 = new BaseGraphic.RealPoint(arcP.X, arcP.Y);
                double d1 = SchemeUtils.distance(p1, p2);
                if (!(d1 + (d2 = SchemeUtils.distance(p2, p3)) + (d3 = SchemeUtils.distance(p1, p3)) > BaseGraphic.FloatTolerance)) continue;
                int sides = (int)(90.0 / (d1 + d2 + d3) * d3);
                BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToQuadBezArc(p1, p2, p3, sides);
                double cx1 = p1.X + 2.0 * (p2.X - p1.X) / 3.0;
                double cy1 = p1.Y + 2.0 * (p2.Y - p1.Y) / 3.0;
                double cx2 = p3.X + 2.0 * (p2.X - p3.X) / 3.0;
                double cy2 = p3.Y + 2.0 * (p2.Y - p3.Y) / 3.0;
                this.addBezierPoints(cx1, cy1, cx2, cy2, p3.X, p3.Y, this.points.size(), sidesToArc.size());
                this.points.addAll(sidesToArc);
                continue;
            }
            if (VsdxUtils.isRelCubBezToRow(row.T)) {
                this.arcArr.add(r2);
                assert (r2 > 0);
                int lastRP = this.rowPoints.size() - 1;
                RowPoint moveP = this.rowPoints.get(lastRP - 1);
                RowPoint arcP = this.rowPoints.get(lastRP);
                BaseGraphic.RealPoint p1 = new BaseGraphic.RealPoint(moveP.X, moveP.Y);
                BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(arcP.A, arcP.B);
                BaseGraphic.RealPoint p3 = new BaseGraphic.RealPoint(arcP.C, arcP.D);
                BaseGraphic.RealPoint p4 = new BaseGraphic.RealPoint(arcP.X, arcP.Y);
                double d1 = SchemeUtils.distance(p1, p2);
                double d2 = SchemeUtils.distance(p2, p3);
                double d3 = SchemeUtils.distance(p3, p4);
                double d4 = SchemeUtils.distance(p1, p4);
                if (!(d1 + d2 + d3 > BaseGraphic.FloatTolerance)) continue;
                int sides = (int)(90.0 / (d1 + d2 + d3 + d4) * (d2 + d4));
                BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToCubeBezArc(p1, p2, p3, p4, sides);
                this.addBezierPoints(p2.X, p2.Y, p3.X, p3.Y, p4.X, p4.Y, this.points.size(), sidesToArc.size());
                this.points.addAll(sidesToArc);
                continue;
            }
            if (VsdxUtils.isNURBSToRow(row.T) && row.E != null) {
                String s = row.E.trim().toUpperCase();
                if (!s.startsWith("NURBS")) continue;
                int idx1 = s.indexOf("(");
                int idx2 = s.indexOf(")");
                if (idx1 < 0 || idx2 < 0) continue;
                assert (r2 > 0);
                this.splineArr.add(r2);
                int lastRP = this.rowPoints.size() - 1;
                RowPoint moveP = this.rowPoints.get(lastRP - 1);
                RowPoint arcP = this.rowPoints.get(lastRP);
                String[] arr = s.substring(idx1 + 1, idx2).split(",");
                if (arr == null || arr.length <= 4) continue;
                double lastKnot = this.convertDouble(arr[0]);
                int degree = SchemeUtils.convertInt(arr[1]);
                boolean relX = "0".equals(arr[2].trim());
                boolean relY = "0".equals(arr[3].trim());
                int lastIdx = arr.length / 4;
                if (lastIdx < degree && this.shape.vsdx.isFromOldFormat()) {
                    degree = lastIdx;
                }
                DoubleList X = new DoubleList(0);
                DoubleList Y = new DoubleList(0);
                DoubleList Knot = new DoubleList(0);
                DoubleList Weigth = new DoubleList(0);
                X.add(moveP.X);
                Y.add(moveP.Y);
                Knot.add(arcP.C);
                Weigth.add(arcP.D);
                int j3 = 4;
                for (int i = 1; i < lastIdx; ++i) {
                    double x = this.convertDouble(arr[j3++]);
                    double y = this.convertDouble(arr[j3++]);
                    if (relX) {
                        x *= shapeSize.X;
                    }
                    if (relY) {
                        y *= shapeSize.Y;
                    }
                    X.add(x);
                    Y.add(y);
                    Knot.add(this.convertDouble(arr[j3++]));
                    Weigth.add(this.convertDouble(arr[j3++]));
                }
                X.add(arcP.X);
                Y.add(arcP.Y);
                Knot.add(arcP.A);
                Weigth.add(arcP.B);
                Knot = this.repairKnots(Knot, lastKnot, X.size() + degree + 1);
                BaseGraphic.RealPoints nurbsPoints = this.calcNURBSPoints(X, Y, Knot, Weigth, degree, 0.01);
                this.addNurbsAsBezier(X, Y, Weigth, Knot, degree, this.points.size(), nurbsPoints);
                this.points.addAll(nurbsPoints);
                continue;
            }
            if (!VsdxUtils.isSplineStartRow(row.T)) continue;
            assert (r2 > 0);
            this.splineArr.add(r2);
            DoubleList X = new DoubleList(0);
            DoubleList Y = new DoubleList(0);
            DoubleList Knot = new DoubleList(0);
            DoubleList Weigth = new DoubleList(0);
            int lastRP = this.rowPoints.size() - 1;
            RowPoint moveP = this.rowPoints.get(lastRP - 1);
            RowPoint arcP = this.rowPoints.get(lastRP);
            int degree = (int)arcP.D;
            double lastKnot = arcP.C;
            X.add(moveP.X);
            Y.add(moveP.Y);
            Knot.add(arcP.B);
            X.add(arcP.X);
            Y.add(arcP.Y);
            Knot.add(arcP.A);
            for (j = r2 + 1; j < cnt; ++j) {
                VsdxGeometryRow splineRow = this.rows.get(j);
                if (!VsdxUtils.isSplineKnotRow(splineRow.T)) break;
                RowPoint splinePoint = new RowPoint();
                splinePoint.T = splineRow.T;
                splinePoint.X = this.convertDouble(splineRow.X);
                splinePoint.Y = this.convertDouble(splineRow.Y);
                splinePoint.A = this.convertDouble(splineRow.A);
                this.rowPoints.add(splinePoint);
                X.add(splinePoint.X);
                Y.add(splinePoint.Y);
                Knot.add(splinePoint.A);
                ++r2;
            }
            for (j = X.size(); j > 0; --j) {
                Weigth.add(1.0);
            }
            Knot = this.repairKnots(Knot, lastKnot, X.size() + degree + 1);
            BaseGraphic.RealPoints nurbsPoints = this.calcNURBSPoints(X, Y, Knot, Weigth, degree, 0.01);
            this.addNurbsAsBezier(X, Y, Weigth, Knot, degree, this.points.size(), nurbsPoints);
            this.points.addAll(nurbsPoints);
        }
        this.checkFillClosed();
    }

    private boolean isRedundantMove(VsdxGeometryRow row, String lastX, String lastY) {
        return VsdxUtils.isMoveToRow(row.T) && lastX.equals(row.X) && lastY.equals(row.Y);
    }

    private void initEllipsePoints() {
        if (this.ellipsePoints != null) {
            return;
        }
        this.ellipsePoints = new BaseGraphic.RealPoints();
        this.ellipseMoveArr = new IntegerList(2);
        if (this.ellipseArr != null && this.rows.size() > 0) {
            int cnt = this.ellipseArr.size();
            for (int i = 0; i < cnt; ++i) {
                double ellipseSizeY;
                double ellipseSizeX;
                double deltaMinorX;
                VsdxGeometryRow row = this.rows.get(this.ellipseArr.get(i));
                double ellipseCenterX = this.inchToMM(row.X);
                double ellipseCenterY = this.inchToMM(row.Y);
                double ellipseMajorX = this.inchToMM(row.A);
                double ellipseMajorY = this.inchToMM(row.B);
                double ellipseMinorX = this.inchToMM(row.C);
                double ellipseMinorY = this.inchToMM(row.D);
                double deltaMajorX = Math.abs(ellipseMajorX - ellipseCenterX);
                if (deltaMajorX > (deltaMinorX = Math.abs(ellipseMinorX - ellipseCenterX))) {
                    ellipseSizeX = 2.0 * deltaMajorX;
                    ellipseSizeY = 2.0 * Math.abs(ellipseMinorY - ellipseCenterY);
                } else {
                    ellipseSizeX = 2.0 * deltaMinorX;
                    ellipseSizeY = 2.0 * Math.abs(ellipseMajorY - ellipseCenterY);
                }
                BaseGraphic.RealPoints sidesToEllipse = SchemeUtils.sidesToEllipse(ellipseSizeX, ellipseSizeY, 60);
                sidesToEllipse.add(new BaseGraphic.RealPoint((BaseGraphic.RealPoint)sidesToEllipse.get(0)));
                sidesToEllipse.forEach(p -> {
                    p.X += ellipseCenterX;
                    p.Y -= ellipseCenterY;
                });
                this.ellipseMoveArr.add(this.ellipsePoints.size());
                this.ellipsePoints.addAll(sidesToEllipse);
            }
        }
    }

    public BaseGraphic.RealPoints getPoints(boolean local, boolean asBezier) {
        return this.getPoints(local, asBezier, false, false);
    }

    public BaseGraphic.RealPoints getPoints(boolean local, boolean asBezier, boolean flipX, boolean flipY) {
        this.initInfo();
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        this.initEllipsePoints();
        if (local) {
            BaseGraphic.RealPoints srcPoints = asBezier ? this.pointsAsBezier(this.points, this.moveArr, this.bezierData) : this.points;
            for (BaseGraphic.RealPoint p : srcPoints) {
                result.add(new BaseGraphic.RealPoint(SchemeUtils.inchToMM(p.X), SchemeUtils.inchToMM(-p.Y)));
            }
            if (this.ellipsePoints != null && !this.ellipsePoints.isEmpty()) {
                result.addAll(asBezier ? this.pointsAsBezier(this.ellipsePoints, this.ellipseMoveArr, null) : this.ellipsePoints);
            }
            if (!asBezier) {
                this.fixLastPoint(result);
            }
            return result;
        }
        BaseGraphic.RealPoint pin = this.shape.getPin();
        BaseGraphic.RealPoint locPin = this.shape.getLocPin();
        double deltaX = pin.X - locPin.X;
        double deltaY = locPin.Y - pin.Y;
        double angle = this.shape.getAngle();
        boolean hasAngle = Math.abs(angle) > BaseGraphic.FloatTolerance;
        double cos = 1.0;
        double sin = 0.0;
        if (hasAngle) {
            cos = Math.cos(angle);
            sin = Math.sin(angle);
        }
        BaseGraphic.RealPoints arrPoints = new BaseGraphic.RealPoints();
        arrPoints.addAll(asBezier ? this.pointsAsBezier(this.points, this.moveArr, this.bezierData) : this.points);
        if (hasAngle || flipX || flipY) {
            for (BaseGraphic.RealPoint p : arrPoints) {
                double dx = flipX ? locPin.X - p.X : p.X - locPin.X;
                double dy = flipY ? locPin.Y - p.Y : p.Y - locPin.Y;
                double x = locPin.X + dx * cos - dy * sin;
                double y = locPin.Y + dx * sin + dy * cos;
                x = deltaX + x;
                y = deltaY - y;
                result.add(new BaseGraphic.RealPoint(SchemeUtils.inchToMM(x), SchemeUtils.inchToMM(y)));
            }
        } else {
            for (BaseGraphic.RealPoint p : arrPoints) {
                double x = deltaX + p.X;
                double y = deltaY - p.Y;
                result.add(new BaseGraphic.RealPoint(SchemeUtils.inchToMM(x), SchemeUtils.inchToMM(y)));
            }
        }
        if (this.ellipsePoints != null && !this.ellipsePoints.isEmpty()) {
            BaseGraphic.RealPoint pt = new BaseGraphic.RealPoint();
            VsdxUtils.VsdxTransformProps props = VsdxUtils.getTransformPropsMM(this.shape, pt, pt, false);
            AffineTransform TM = props.genTransform(true, true, true, true);
            BaseGraphic.RealPoints srcPoints = asBezier ? this.pointsAsBezier(this.ellipsePoints, this.ellipseMoveArr, null) : this.ellipsePoints;
            int cnt = srcPoints.size();
            for (int i = 0; i < cnt; ++i) {
                double[] point = ((BaseGraphic.RealPoint)srcPoints.get(i)).getPoint();
                point = SchemeEngine.MulPointsTM(TM, point);
                result.add(new BaseGraphic.RealPoint(point[0], point[1]));
            }
        }
        if (!asBezier) {
            this.fixLastPoint(result);
        }
        return result;
    }

    private BaseGraphic.RealPoints fixLastPoint(BaseGraphic.RealPoints arrPoints) {
        if (arrPoints != null && arrPoints.size() > 2 && this.closed > 0 && this.moveArr != null && this.moveArr.size() == 1) {
            int last = arrPoints.size() - 1;
            if (SchemeUtils.isEqual((BaseGraphic.RealPoint)arrPoints.get(0), (BaseGraphic.RealPoint)arrPoints.get(last))) {
                arrPoints.remove(last);
            }
        }
        return arrPoints;
    }

    private BaseGraphic.RealPoints pointsAsBezier(BaseGraphic.RealPoints srcPoints, IntegerList srcMoveArr, List<BezierData> beziers) {
        assert (beziers == null || !beziers.isEmpty());
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        assert (!srcMoveArr.empty());
        int moveIdx = 0;
        int movePoint = srcMoveArr.get(moveIdx);
        int idxBezier = 0;
        BezierData bezier = beziers == null || beziers.isEmpty() ? null : beziers.get(idxBezier);
        BaseGraphic.RealPoint lastP = null;
        boolean isMove = false;
        int i = 0;
        int cnt = srcPoints.size();
        while (i < cnt) {
            BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)srcPoints.get(i);
            if (i == movePoint) {
                if (!isMove) {
                    result.add(p);
                } else if (!result.isEmpty()) {
                    result.set(result.size() - 1, p);
                }
                if (++moveIdx < srcMoveArr.size()) {
                    movePoint = srcMoveArr.get(moveIdx);
                }
                isMove = true;
            } else {
                if (bezier != null && i == bezier.idx) {
                    for (BezierPoints bezierPoints : bezier.bezierPoints) {
                        result.add(new BaseGraphic.RealPoint(bezierPoints.X1, bezierPoints.Y1));
                        result.add(new BaseGraphic.RealPoint(bezierPoints.X2, bezierPoints.Y2));
                        lastP = new BaseGraphic.RealPoint(bezierPoints.X, bezierPoints.Y);
                        result.add(lastP);
                    }
                    i += bezier.cnt;
                    bezier = beziers != null && idxBezier < beziers.size() ? beziers.get(++idxBezier) : null;
                    isMove = false;
                    continue;
                }
                assert (lastP != null);
                result.add(lastP);
                result.add(p);
                result.add(p);
                isMove = false;
            }
            lastP = p;
            ++i;
        }
        return result;
    }

    public IntegerList getMoveArr(boolean asBezier) {
        IntegerList result;
        int cntMove;
        this.initInfo();
        int index = 0;
        if (asBezier && !this.moveArr.empty()) {
            cntMove = this.moveArr.size();
            IntegerList endMove = new IntegerList(cntMove);
            for (int i = 1; i < cntMove; ++i) {
                endMove.add(this.moveArr.get(i));
            }
            endMove.add(this.points.size());
            result = new IntegerList(cntMove);
            int idxBezier = 0;
            BezierData bezier = this.bezierData == null ? null : this.bezierData.get(idxBezier);
            int cnt = this.moveArr.size();
            for (int i = 0; i < cnt; ++i) {
                int move = this.moveArr.get(i);
                int endmove = endMove.get(i);
                if (endmove - move < 2) continue;
                result.add(index);
                int cntBz = 0;
                int cntPointsBz = 0;
                int sumPointsBz = 0;
                while (bezier != null && move < bezier.idx && bezier.idx < endmove) {
                    ++cntBz;
                    cntPointsBz += bezier.cnt;
                    sumPointsBz += bezier.bezierPoints.size();
                    bezier = ++idxBezier < this.bezierData.size() ? this.bezierData.get(idxBezier) : null;
                }
                index += 1 + (endmove - move - cntPointsBz - 1 + sumPointsBz) * 3;
            }
        } else {
            result = new IntegerList(this.moveArr);
        }
        this.initEllipsePoints();
        if (this.ellipseMoveArr != null && !this.ellipseMoveArr.empty()) {
            cntMove = asBezier ? index : this.points.size();
            int cnt = this.ellipseMoveArr.size();
            for (int i = 0; i < cnt; ++i) {
                result.add(cntMove + this.ellipseMoveArr.get(i));
            }
        }
        return result;
    }

    public IntegerList getArcArr() {
        this.initInfo();
        return this.arcArr;
    }

    public boolean isEllipse() {
        this.initInfo();
        if (this.rows == null) {
            return false;
        }
        if (this.rows.size() == 1) {
            return VsdxUtils.isEllipse(this.rows.get((int)0).T);
        }
        if (this.arcArr.size() == 2 && this.lineArr.empty() && this.splineArr.empty()) {
            BaseGraphic.RealPoint size = this.shape.getShapeSize();
            if (size.X <= 0.0 || size.Y <= 0.0) {
                return false;
            }
            VsdxGeometryRow row1 = this.rows.get(this.arcArr.get(0));
            String rowType1 = row1.T;
            double sx1 = this.convertDouble(row1.X);
            double sy1 = this.convertDouble(row1.Y);
            double sbow1 = this.convertDouble(row1.A);
            double scx1 = this.convertDouble(row1.A);
            double scy1 = this.convertDouble(row1.B);
            double sd1 = this.convertDouble(row1.D);
            VsdxGeometryRow row2 = this.rows.get(this.arcArr.get(1));
            String rowType2 = row2.T;
            double sx2 = this.convertDouble(row2.X);
            double sy2 = this.convertDouble(row2.Y);
            double sbow2 = this.convertDouble(row2.A);
            double scx2 = this.convertDouble(row2.A);
            double scy2 = this.convertDouble(row2.B);
            double sd2 = this.convertDouble(row2.D);
            if (rowType1 == null || !rowType1.equals(rowType2)) {
                return false;
            }
            if ("EllipticalArcTo".equals(rowType1)) {
                if (sd1 <= 0.0 || sd2 <= 0.0) {
                    return false;
                }
                double dy = Math.abs(sy1 - scy1);
                if (dy == 0.0) {
                    return false;
                }
                if (sy1 != scy1 && !SchemeUtils.isEqual(Math.abs(sx1 - scx1) / dy, sd1)) {
                    return false;
                }
                dy = Math.abs(sy2 - scy2);
                if (dy == 0.0) {
                    return false;
                }
                if (sy2 != scy2 && !SchemeUtils.isEqual(Math.abs(sx2 - scx2) / dy, sd2)) {
                    return false;
                }
            }
            boolean result = false;
            if (SchemeUtils.isEqual(sx1, sx2)) {
                result = "ArcTo".equals(rowType1) ? !SchemeUtils.isEqual(sy1, sy2) && SchemeUtils.isEqual(sx1 - sbow1, sx1 - sbow2) && SchemeUtils.isEqual(sy1 - sbow1, -1.0 * (sy2 - sbow1)) && SchemeUtils.isEqual(sy1 - sbow2, -1.0 * (sy2 - sbow2)) : !SchemeUtils.isEqual(sy1, sy2) && SchemeUtils.isEqual(scy1, scy2) && !SchemeUtils.isEqual(scx1, scx2) && SchemeUtils.isEqual(scx1 - sx1, -1.0 * (scx2 - sx1));
            } else if (SchemeUtils.isEqual(sy1, sy2)) {
                if ("TagArcTo".equals(rowType1)) {
                    result = !SchemeUtils.isEqual(sx1, sx2) && SchemeUtils.isEqual(sy1 - sbow1, sy1 - sbow2) && SchemeUtils.isEqual(sx1 - sbow1, -1.0 * (sx2 - sbow1)) && SchemeUtils.isEqual(sx1 - sbow2, -1.0 * (sx2 - sbow2));
                } else {
                    boolean bl = result = !SchemeUtils.isEqual(sx1, sx2) && SchemeUtils.isEqual(scx1, scx2) && !SchemeUtils.isEqual(scy1, scy2) && SchemeUtils.isEqual(scy1 - sy1, -1.0 * (scy2 - sy1));
                }
            }
            if (result) {
                double newSizeY;
                double newSizeX;
                if (SchemeUtils.isEqual(sx1, sx2)) {
                    newSizeX = "ArcTo".equals(rowType1) ? 2.0 * sbow1 : Math.abs(scx2 - scx1);
                    newSizeY = Math.abs(sy2 - sy1);
                } else {
                    newSizeX = Math.abs(sx2 - sx1);
                    double d = newSizeY = "ArcTo".equals(rowType1) ? 2.0 * sbow1 : Math.abs(scy2 - scy1);
                }
                if (!SchemeUtils.isEqual(size.X, newSizeX) || !SchemeUtils.isEqual(size.Y, newSizeY)) {
                    result = false;
                }
            }
            return result;
        }
        return false;
    }

    public boolean isRect() {
        int cntj;
        this.initInfo();
        if (this.moveArr.size() != 1 || this.moveArr.get(0) != 0 || this.ellipsePoints != null && !this.ellipsePoints.isEmpty() || this.arcArr != null && !this.arcArr.empty()) {
            return false;
        }
        BaseGraphic.RealPoints pts = new BaseGraphic.RealPoints();
        pts.add((BaseGraphic.RealPoint)this.points.get(0));
        int cnti = this.lineArr.size();
        int j = 0;
        int n = cntj = this.duplicates == null ? 0 : this.duplicates.size();
        for (int i = 0; i < cnti; ++i) {
            int idx = this.lineArr.get(i);
            if (j < cntj && idx == this.duplicates.get(j)) {
                ++j;
                continue;
            }
            if (idx < 0 || idx >= this.points.size()) {
                return false;
            }
            pts.add((BaseGraphic.RealPoint)this.points.get(idx));
        }
        return SchemeUtils.isRect(pts, this.shape.getShapeSize());
    }

    private BaseGraphic.RealPoints calcNURBSPoints(DoubleList X, DoubleList Y, DoubleList Knot, DoubleList Weight, int degree, double dt) {
        assert (X != null);
        assert (Y != null);
        assert (Weight != null);
        assert (Knot != null);
        assert (X.size() == Y.size());
        assert (X.size() == Weight.size());
        BiFunction<Integer, Double, Double> Nip = (i, t) -> {
            double[] N = new double[degree + 1];
            int m = Knot.size() - 1;
            if (i == 0 && t.doubleValue() == Knot.get(0) || i == m - degree - 1 && t.doubleValue() == Knot.get(m)) {
                return 1.0;
            }
            if (t < Knot.get((int)i) || t >= Knot.get(i + degree + 1)) {
                return 0.0;
            }
            for (int j = 0; j <= degree; ++j) {
                N[j] = t >= Knot.get(i + j) && t < Knot.get(i + j + 1) ? 1.0 : 0.0;
            }
            for (int k = 1; k <= degree; ++k) {
                double saved = N[0] == 0.0 ? 0.0 : (t - Knot.get((int)i)) * N[0] / (Knot.get(i + k) - Knot.get((int)i));
                for (int j = 0; j < degree - k + 1; ++j) {
                    double Uleft = Knot.get(i + j + 1);
                    double Uright = Knot.get(i + j + k + 1);
                    if (N[j + 1] == 0.0) {
                        N[j] = saved;
                        saved = 0.0;
                        continue;
                    }
                    double kf = Uright != Uleft ? Uright - Uleft : 1.0;
                    double temp = N[j + 1] / kf;
                    N[j] = saved + (Uright - t) * temp;
                    saved = (t - Uleft) * temp;
                }
            }
            return N[0];
        };
        Function<Double, BaseGraphic.RealPoint> CalcPoint = t -> {
            int i;
            double x = 0.0;
            double y = 0.0;
            double rationalWeight = 0.0;
            int cnt = X.size();
            for (i = 0; i < cnt; ++i) {
                Double nip = (Double)Nip.apply(i, (Double)t);
                double nipdbl = nip == null ? 0.0 : nip;
                double temp = nipdbl * Weight.get(i);
                rationalWeight += temp;
            }
            if (rationalWeight == 0.0) {
                rationalWeight = 1.0;
            }
            for (i = 0; i < cnt; ++i) {
                Double temp = (Double)Nip.apply(i, (Double)t);
                double tempdbl = temp == null ? 0.0 : temp;
                double koef = Weight.get(i) * tempdbl / rationalWeight;
                x += X.get(i) * koef;
                y += Y.get(i) * koef;
            }
            return new BaseGraphic.RealPoint(x, y);
        };
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        for (double t2 = 0.0; t2 <= 1.0; t2 += dt) {
            BaseGraphic.RealPoint p = CalcPoint.apply(t2);
            if (Double.isInfinite(p.X) || Double.isInfinite(p.Y) || Double.isNaN(p.X) || Double.isNaN(p.Y)) continue;
            result.add(p);
        }
        return result;
    }

    private void reverseX(BaseGraphic.RealPoints points) {
        if (points == null || points.isEmpty()) {
            return;
        }
        double pX = this.shape.getLocPin().X;
        points.forEach(p -> {
            p.X = pX - p.X;
        });
    }

    private void reverseY(BaseGraphic.RealPoints points) {
        if (points == null) {
            return;
        }
        double dy = 2.0 * this.convertDouble(this.shape.LocPinY);
        points.forEach(p -> {
            p.Y = dy - p.Y;
        });
    }

    private double getPathTolerance(int partIdx) {
        int idx;
        assert (this.rowMoves != null);
        assert (this.rowPoints != null);
        int n = idx = partIdx > 0 && partIdx < this.rowMoves.size() ? this.rowMoves.get(partIdx) : this.rowPoints.size();
        if (idx > 0 && idx <= this.rowPoints.size()) {
            RowPoint row = this.rowPoints.get(idx - 1);
            if (VsdxUtils.isNURBSToRow(row.T)) {
                return 0.002;
            }
        }
        return 0.001;
    }

    private void checkFillClosed() {
        if (this.closed > 0) {
            return;
        }
        int size = this.rowPoints.size();
        if (size < 3) {
            return;
        }
        if (this.points == null || this.moveArr == null) {
            return;
        }
        int lastPoint = this.points.size() - 1;
        int cntMoves = this.moveArr.size();
        if (lastPoint < 3 || cntMoves < 1) {
            return;
        }
        int idx1 = this.moveArr.get(0);
        int idx2 = 0;
        for (int i = 1; i < cntMoves; ++i) {
            int idx = this.moveArr.get(i);
            idx2 = idx - 1;
            if (idx1 < idx2 && SchemeUtils.distance((BaseGraphic.RealPoint)this.points.get(idx1), (BaseGraphic.RealPoint)this.points.get(idx2)) < this.getPathTolerance(i)) {
                ++this.closed;
                return;
            }
            idx1 = idx;
        }
        if (idx1 <= lastPoint) {
            if (SchemeUtils.distance((BaseGraphic.RealPoint)this.points.get(idx1), (BaseGraphic.RealPoint)this.points.get(lastPoint)) < this.getPathTolerance(cntMoves)) {
                ++this.closed;
            }
            if (!this.isNoFill() && !this.shape.checkEmptyFill() && (this.isNoLine() || this.shape.checkEmptyLine())) {
                int idx;
                this.points.add(new BaseGraphic.RealPoint((BaseGraphic.RealPoint)this.points.get(lastPoint)));
                ++this.closed;
                while (cntMoves > 1 && (idx = this.moveArr.get(--cntMoves)) >= lastPoint) {
                    this.moveArr.remove(cntMoves);
                    --lastPoint;
                }
            }
        }
    }

    private double convertDouble(String s) {
        return VsdxUtils.convertDouble(s, this.shape);
    }

    private double inchToMM(String value) {
        return VsdxReader.inchToMM(value, this.shape);
    }

    public int countBezier() {
        if (this.disableBezier) {
            return -1;
        }
        return this.bezierData == null ? 0 : this.bezierData.size();
    }

    private BezierData addBezier(int idx, int cnt) {
        if (this.disableBezier || cnt < 2) {
            return null;
        }
        if (this.bezierData == null) {
            this.bezierData = new ArrayList<BezierData>();
        }
        BezierData bezier = new BezierData();
        bezier.idx = idx;
        bezier.cnt = cnt;
        this.bezierData.add(bezier);
        return bezier;
    }

    private void addBezierPoints(double cx1, double cy1, double cx2, double cy2, double x, double y, int idx, int cnt) {
        if (this.disableBezier || cnt < 2) {
            return;
        }
        if (this.bezierData == null) {
            this.bezierData = new ArrayList<BezierData>();
        }
        BezierData bezier = new BezierData();
        bezier.addPoints(cx1, cy1, cx2, cy2, x, y);
        bezier.idx = idx;
        bezier.cnt = cnt;
        this.bezierData.add(bezier);
    }

    private DoubleList repairKnots(DoubleList knot, double lastKnot, int cntKnot) {
        int i;
        DoubleList knotVector = new DoubleList(knot);
        for (i = knot.size(); i < cntKnot; ++i) {
            knotVector.add(lastKnot);
        }
        for (i = 1; i < cntKnot; ++i) {
            if (!(knotVector.get(i) < knotVector.get(i - 1))) continue;
            knotVector.set(i, knotVector.get(i - 1));
        }
        double firstKnot = knotVector.get(0);
        lastKnot = knotVector.get(knotVector.size() - 1) - firstKnot;
        if (SchemeUtils.isEqual(lastKnot, 0.0, 1.0E-6)) {
            lastKnot = 1.0E-6;
        }
        for (int i2 = 0; i2 < cntKnot; ++i2) {
            double v = knotVector.get(i2);
            v -= firstKnot;
            knotVector.set(i2, v /= lastKnot);
        }
        return knotVector;
    }

    private void addNurbsAsBezier(DoubleList x, DoubleList y, DoubleList weigth, DoubleList knot, int degree, int idx, BaseGraphic.RealPoints linePoints) {
        int cntLinePoints = linePoints.size();
        if (this.disableBezier || cntLinePoints < 2) {
            return;
        }
        BaseGraphic.RealPoint p0 = null;
        if (this.closed == 0 && cntLinePoints > 3) {
            p0 = (BaseGraphic.RealPoint)linePoints.get(0);
            BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)linePoints.get(linePoints.size() - 1);
            if (SchemeUtils.isEqual(p0.X, p.X) && SchemeUtils.isEqual(p0.Y, p.Y)) {
                ++this.closed;
            }
        }
        if (degree > 3) {
            this.disableBezier = true;
        } else {
            assert (weigth != null && !weigth.empty());
            double w = weigth.get(0);
            int cnti = weigth.size();
            for (int i = 0; i < cnti; ++i) {
                if (SchemeUtils.isEqual(w, weigth.get(i))) continue;
                this.disableBezier = true;
                break;
            }
        }
        if (this.disableBezier) {
            this.bezierData = null;
        } else {
            int maxi;
            int i;
            if (degree < 2) {
                return;
            }
            BezierData bezier = this.addBezier(idx, cntLinePoints);
            if (bezier == null) {
                return;
            }
            assert (x != null);
            assert (y != null);
            assert (x.size() == y.size());
            BiConsumer<DoubleList, DoubleList> Swap = (list1, list2) -> {
                assert (list1 != null);
                assert (list2 != null);
                assert (list1.size() == list2.size());
                int cntli = list1.size();
                for (int li = 0; li < cntli; ++li) {
                    double v = list1.get(li);
                    list1.set(li, list2.get(li));
                    list2.set(li, v);
                }
            };
            int a = degree;
            int b = degree + 1;
            int m = x.size() - 1 + degree + 1;
            if (m > knot.size() - 1) {
                m = knot.size() - 1;
            }
            DoubleList pX = new DoubleList(0);
            DoubleList pY = new DoubleList(0);
            DoubleList nextX = new DoubleList(0);
            DoubleList nextY = new DoubleList(0);
            for (i = 0; i < b; ++i) {
                pX.add(0.0);
                pY.add(0.0);
                nextX.add(0.0);
                nextY.add(0.0);
            }
            int n = maxi = x.size() <= degree ? x.size() - 1 : degree;
            for (i = 0; i <= maxi; ++i) {
                pX.set(i, x.get(i));
                pY.set(i, y.get(i));
            }
            while (b < m) {
                i = b;
                while (b < m && SchemeUtils.isEqual(knot.get(b + 1), knot.get(i))) {
                    ++b;
                }
                int mult = b - i + 1;
                if (mult > degree) {
                    mult = degree;
                }
                if (mult < degree) {
                    int j;
                    double numer = knot.get(b) - knot.get(a);
                    DoubleList alphas = new DoubleList(degree - 1);
                    for (j = degree; j > mult && j < knot.size() - a; --j) {
                        alphas.set(j - mult - 1, numer / (knot.get(a + j) - knot.get(a)));
                    }
                    int r = degree - mult;
                    for (j = 1; j <= r; ++j) {
                        int save = r - j;
                        int s = mult + j;
                        for (int k = degree; k >= s; --k) {
                            double alpha = alphas.get(k - s);
                            pX.set(k, alpha * pX.get(k) + (1.0 - alpha) * pX.get(k - 1));
                            pY.set(k, alpha * pY.get(k) + (1.0 - alpha) * pY.get(k - 1));
                        }
                        if (b >= knot.size() - 1) continue;
                        nextX.set(save, pX.get(degree));
                        nextY.set(save, pY.get(degree));
                    }
                }
                switch (degree) {
                    case 2: {
                        if (pX.size() <= 2 || pY.size() <= 2) {
                            throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043a\u0440\u0438\u0432\u044b\u0445 \u0434\u043b\u044f NURBS 2 \u0441\u0442\u0435\u043f\u0435\u043d\u0438 ");
                        }
                        double x1 = pX.get(0);
                        double y1 = pY.get(0);
                        double x2 = pX.get(1);
                        double y2 = pY.get(1);
                        double x3 = pX.get(2);
                        double y3 = pY.get(2);
                        double cx1 = x1 + 2.0 * (x2 - x1) / 3.0;
                        double cy1 = y1 + 2.0 * (y2 - y1) / 3.0;
                        double cx2 = x3 + 2.0 * (x2 - x3) / 3.0;
                        double cy2 = y3 + 2.0 * (y2 - y3) / 3.0;
                        bezier.addPoints(cx1, cy1, cx2, cy2, x3, y3);
                        break;
                    }
                    case 3: {
                        if (pX.size() <= 3 || pY.size() <= 3) {
                            throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043a\u0440\u0438\u0432\u044b\u0445 \u0434\u043b\u044f NURBS 3 \u0441\u0442\u0435\u043f\u0435\u043d\u0438 ");
                        }
                        bezier.addPoints(pX.get(1), pY.get(1), pX.get(2), pY.get(2), pX.get(3), pY.get(3));
                    }
                }
                Swap.accept(pX, nextX);
                Swap.accept(pY, nextY);
                if (b >= m) continue;
                for (i = degree - mult; i <= degree && b - degree + i < x.size(); ++i) {
                    pX.set(i, x.get(b - degree + i));
                    pY.set(i, y.get(b - degree + i));
                }
                a = b++;
            }
            if (this.closed == 0 && bezier.bezierPoints != null && !bezier.bezierPoints.isEmpty()) {
                assert (p0 != null);
                BezierPoints p = bezier.bezierPoints.get(bezier.bezierPoints.size() - 1);
                if (SchemeUtils.isEqual(p0.X, p.X) && SchemeUtils.isEqual(p0.Y, p.Y)) {
                    ++this.closed;
                    linePoints.add(new BaseGraphic.RealPoint(p.X, p.Y));
                    ++bezier.cnt;
                }
            }
        }
    }

    public static VsdxGeometry createBorderGeometry(VsdxShape shape, double x, double y, double w, double h) {
        VsdxGeometry geom = new VsdxGeometry(shape);
        geom.points = new BaseGraphic.RealPoints();
        geom.points.add(new BaseGraphic.RealPoint(x, y));
        geom.points.add(new BaseGraphic.RealPoint(x, h));
        geom.points.add(new BaseGraphic.RealPoint(w, h));
        geom.points.add(new BaseGraphic.RealPoint(w, y));
        geom.points.add(new BaseGraphic.RealPoint(x, y));
        geom.moveArr = new IntegerList(1);
        geom.moveArr.add(0);
        geom.lineArr = new IntegerList(4);
        geom.lineArr.add(1);
        geom.lineArr.add(2);
        geom.lineArr.add(3);
        geom.lineArr.add(4);
        geom.NoFill = "1";
        geom.closed = 1;
        return geom;
    }

    private static class BezierData {
        public List<BezierPoints> bezierPoints = new ArrayList<BezierPoints>();
        public int idx;
        public int cnt;

        private BezierData() {
        }

        void addPoints(double x1, double y1, double x2, double y2, double x, double y) {
            BezierPoints points = new BezierPoints();
            points.X1 = x1;
            points.Y1 = y1;
            points.X2 = x2;
            points.Y2 = y2;
            points.X = x;
            points.Y = y;
            this.bezierPoints.add(points);
        }
    }

    private static class BezierPoints {
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;
        public double X;
        public double Y;

        private BezierPoints() {
        }
    }

    private static class RowPoint {
        public String T;
        public double X;
        public double Y;
        public double A;
        public double B;
        public double C;
        public double D;

        private RowPoint() {
        }
    }
}

