/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxConnect;
import inform.agent.schemes.converters.vsdx.VsdxLayer;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxShapeParser;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VsdxPageParser {
    private final VsdxParser vsdxParser;
    private final Element pageNode;
    private final Map<String, String> rels;
    private Element pageSheet;
    private List<Element> pageLayers;
    private List<String> pageLayerIdxs;
    private List<Element> shapes;
    private List<Element> connects;

    VsdxPageParser(VsdxParser vsdxParser, Element pageNode, Document page, Map<String, String> rels) {
        List<Element> nodes;
        this.vsdxParser = vsdxParser;
        this.pageNode = pageNode;
        this.rels = rels;
        if (pageNode != null && !(nodes = VsdxParser.getElementsByLocalName(pageNode, "PageSheet")).isEmpty()) {
            assert (nodes.size() == 1);
            this.pageLayers = new ArrayList<Element>();
            this.pageLayerIdxs = new ArrayList<String>();
            this.pageSheet = nodes.get(0);
            List<Element> sections = VsdxParser.getElementsByLocalName(this.pageSheet, "Section");
            for (Element e : sections) {
                if (!"Layer".equals(e.getAttribute("N"))) continue;
                List<Element> rows = VsdxParser.getElementsByLocalName(e, "Row");
                for (Element layer : rows) {
                    assert (layer != null);
                    this.pageLayerIdxs.add(layer.getAttribute("IX"));
                    this.pageLayers.add(layer);
                }
            }
        }
        if (page != null) {
            List<Element> connectsNodes;
            nodes = VsdxParser.getElementsByLocalName(page.getDocumentElement(), "Shapes");
            if (!nodes.isEmpty()) {
                assert (nodes.size() == 1);
                this.shapes = VsdxParser.getElementsByLocalName(nodes.get(0), "Shape");
            }
            if (!(connectsNodes = VsdxParser.getElementsByLocalName(page.getDocumentElement(), "Connects")).isEmpty()) {
                assert (connectsNodes.size() == 1);
                this.connects = VsdxParser.getElementsByLocalName(connectsNodes.get(0), "Connect");
            }
        }
    }

    private String getPageAttribute(String name) {
        assert (this.pageNode != null);
        return this.pageNode.getAttribute(name);
    }

    private boolean hasPageAttribute(String name) {
        assert (this.pageNode != null);
        return this.pageNode.hasAttribute(name);
    }

    private boolean hasPageSheetAttribute(String name) {
        assert (this.pageSheet != null);
        return this.pageSheet.hasAttribute(name);
    }

    private String getPageSheetAttribute(String name) {
        assert (this.pageSheet != null);
        return this.pageSheet.getAttribute(name);
    }

    private String getPageSheetCellValue(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.getCellValue(this.pageSheet, name);
    }

    private double getPageSheetCellNumberValue(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.getCellNumberValue(this.pageSheet, name);
    }

    private boolean hasPageSheetCell(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.hasCellAttribute(this.pageSheet, name);
    }

    public int countLayers() {
        assert (this.pageLayers != null);
        return this.pageLayers.size();
    }

    private String getLayerCellValue(int layerIndex, String cellName) {
        assert (this.pageLayers != null);
        if (layerIndex < 0 || layerIndex >= this.pageLayers.size()) {
            return "";
        }
        return this.vsdxParser.getCellValue(this.pageLayers.get(layerIndex), cellName);
    }

    private double getLayerCellNumberValue(int layerIndex, String cellName) {
        String s = this.getLayerCellValue(layerIndex, cellName);
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    private String getLayerId(int layerIndex) {
        if (layerIndex < 0 || this.pageLayerIdxs == null || layerIndex >= this.pageLayerIdxs.size()) {
            return "";
        }
        return this.pageLayerIdxs.get(layerIndex);
    }

    public int countShapes() {
        return this.shapes == null ? 0 : this.shapes.size();
    }

    public VsdxShapeParser getShapeParser(int index) {
        if (this.shapes == null || index < 0 || index >= this.shapes.size()) {
            return null;
        }
        return new VsdxShapeParser(this.vsdxParser, this.shapes.get(index), this.rels);
    }

    public int countConnects() {
        return this.connects == null ? 0 : this.connects.size();
    }

    public VsdxConnect getConnect(int index) {
        if (this.connects == null || index < 0 || index >= this.connects.size()) {
            return null;
        }
        Element node = this.connects.get(index);
        if (node == null) {
            return null;
        }
        VsdxConnect result = new VsdxConnect();
        result.FromSheet = node.getAttribute("FromSheet");
        result.FromPart = node.getAttribute("FromPart");
        result.ToSheet = node.getAttribute("ToSheet");
        result.ToCell = node.getAttribute("ToCell");
        result.ToPart = node.getAttribute("ToPart");
        return result;
    }

    public String getPageSheetCellUnit(String name) {
        assert (this.pageSheet != null);
        return this.vsdxParser.getCellUnit(this.pageSheet, name);
    }

    public VsdxPage parsePage(Vsdx vsdx) {
        VsdxPage vsdxPage = new VsdxPage(vsdx);
        vsdxPage.ID = this.getPageAttribute("ID");
        vsdxPage.Name = this.getPageAttribute("Name");
        if (this.hasPageAttribute("Background")) {
            vsdxPage.Background = this.getPageAttribute("Background");
        }
        if (this.hasPageAttribute("BackPage")) {
            vsdxPage.BackPage = this.getPageAttribute("BackPage");
        }
        if (this.hasPageSheetAttribute("LineStyle")) {
            vsdxPage.LineStyle = this.getPageSheetAttribute("LineStyle");
        }
        if (this.hasPageSheetAttribute("FillStyle")) {
            vsdxPage.FillStyle = this.getPageSheetAttribute("FillStyle");
        }
        if (this.hasPageSheetAttribute("TextStyle")) {
            vsdxPage.TextStyle = this.getPageSheetAttribute("TextStyle");
        }
        if (this.hasPageSheetCell("PageScale")) {
            vsdxPage.PageScale = this.getPageSheetCellValue("PageScale");
        }
        if (this.hasPageSheetCell("DrawingScale")) {
            vsdxPage.DrawingScale = this.getPageSheetCellValue("DrawingScale");
            vsdxPage.PageMeasureUnits = this.getPageSheetCellUnit("DrawingScale");
        }
        String pageWidth = this.hasPageSheetCell("PageWidth") ? this.getPageSheetCellValue("PageWidth") : null;
        String pageHeight = this.hasPageSheetCell("PageHeight") ? this.getPageSheetCellValue("PageHeight") : null;
        vsdxPage.isLandscape = VsdxUtils.convertDouble(pageWidth, null) > VsdxUtils.convertDouble(pageHeight, null);
        vsdxPage.PageWidth = pageWidth;
        vsdxPage.PageHeight = pageHeight;
        if (this.hasPageSheetCell("PageLeftMargin")) {
            vsdxPage.PageLeftMargin = this.getPageSheetCellValue("PageLeftMargin");
        }
        if (this.hasPageSheetCell("PageRightMargin")) {
            vsdxPage.PageRightMargin = this.getPageSheetCellValue("PageRightMargin");
        }
        if (this.hasPageSheetCell("PageTopMargin")) {
            vsdxPage.PageTopMargin = this.getPageSheetCellValue("PageTopMargin");
        }
        if (this.hasPageSheetCell("PageBottomMargin")) {
            vsdxPage.PageBottomMargin = this.getPageSheetCellValue("PageBottomMargin");
        }
        if (this.hasPageSheetCell("XRulerOrigin")) {
            vsdxPage.XRulerOrigin = this.getPageSheetCellValue("XRulerOrigin");
        }
        if (this.hasPageSheetCell("YRulerOrigin")) {
            vsdxPage.YRulerOrigin = this.getPageSheetCellValue("YRulerOrigin");
        }
        if (this.hasPageSheetCell("ThemeIndex")) {
            vsdxPage.ThemeIndex = this.getPageSheetCellValue("ThemeIndex");
        }
        if (this.hasPageSheetCell("ColorSchemeIndex")) {
            vsdxPage.ColorSchemeIndex = this.getPageSheetCellValue("ColorSchemeIndex");
        }
        if (this.hasPageSheetCell("EffectSchemeIndex")) {
            vsdxPage.EffectSchemeIndex = this.getPageSheetCellValue("EffectSchemeIndex");
        }
        if (this.hasPageSheetCell("ConnectorSchemeIndex")) {
            vsdxPage.ConnectorSchemeIndex = this.getPageSheetCellValue("ConnectorSchemeIndex");
        }
        if (this.hasPageSheetCell("FontSchemeIndex")) {
            vsdxPage.FontSchemeIndex = this.getPageSheetCellValue("FontSchemeIndex");
        }
        if (this.hasPageSheetCell("VariationColorIndex")) {
            vsdxPage.VariationColorIndex = this.getPageSheetCellValue("VariationColorIndex");
        }
        if (this.hasPageSheetCell("LineJumpCode")) {
            vsdxPage.LineJumpCode = this.getPageSheetCellValue("LineJumpCode");
        }
        if (this.hasPageSheetCell("LineJumpStyle")) {
            vsdxPage.LineJumpStyle = this.getPageSheetCellValue("LineJumpStyle");
        }
        if (this.hasPageSheetCell("LineJumpFactorX")) {
            vsdxPage.LineJumpFactorX = this.getPageSheetCellValue("LineJumpFactorX");
        }
        if (this.hasPageSheetCell("LineJumpFactorY")) {
            vsdxPage.LineJumpFactorY = this.getPageSheetCellValue("LineJumpFactorY");
        }
        if (this.hasPageSheetCell("LineToNodeX")) {
            vsdxPage.LineToNodeX = this.getPageSheetCellValue("LineToNodeX");
        }
        if (this.hasPageSheetCell("LineToNodeY")) {
            vsdxPage.LineToNodeY = this.getPageSheetCellValue("LineToNodeY");
        }
        return vsdxPage;
    }

    public VsdxLayer parseLayer(int id) {
        VsdxLayer vsdxLayer = new VsdxLayer();
        vsdxLayer.ID = this.getLayerId(id);
        vsdxLayer.Name = this.getLayerCellValue(id, "Name");
        vsdxLayer.NameUniv = this.getLayerCellValue(id, "NameUniv");
        vsdxLayer.Color = this.getLayerCellValue(id, "Color");
        vsdxLayer.ColorTrans = this.getLayerCellValue(id, "ColorTrans");
        vsdxLayer.Visible = this.getLayerCellNumberValue(id, "Visible") != 0.0;
        vsdxLayer.Lock = this.getLayerCellNumberValue(id, "Lock") != 0.0;
        return vsdxLayer;
    }
}

