/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxParagraph;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxParagraphParser
extends VsdxRowsSectionParser {
    VsdxParagraphParser(VsdxParser vsdxParser, Element paragraphNode) {
        super(vsdxParser, paragraphNode);
    }

    void parse(VsdxShape shape) {
        if (shape == null) {
            return;
        }
        Element paragraphSection = this.getSectionNode();
        if (paragraphSection == null) {
            return;
        }
        NodeList childNodes = paragraphSection.getChildNodes();
        if (childNodes == null) {
            return;
        }
        int cnt = childNodes.getLength();
        if (cnt == 0) {
            return;
        }
        if (shape.Paragraphs == null) {
            shape.Paragraphs = new ArrayList<VsdxParagraph>();
        }
        for (int i = 0; i < cnt; ++i) {
            NodeList cells;
            Node item = childNodes.item(i);
            if (item == null || item.getNodeType() != 1 || (cells = item.getChildNodes()) == null) continue;
            String IX = ((Element)item).getAttribute("IX");
            VsdxParagraph row = shape.findParagraphById(IX);
            if (row == null) {
                row = new VsdxParagraph();
                row.IX = IX;
                shape.Paragraphs.add(row);
                if (shape.Paragraph != null) {
                    row.applyProperties(shape.Paragraph);
                }
            }
            int cntj = cells.getLength();
            block31: for (int j = 0; j < cntj; ++j) {
                if (cells.item(j).getNodeType() != 1) continue;
                Element cell = (Element)cells.item(j);
                String cellValue = cell.getAttribute("V");
                switch (cell.getAttribute("N")) {
                    case "IndFirst": {
                        row.IndFirst = cellValue;
                        continue block31;
                    }
                    case "IndLeft": {
                        row.IndLeft = cellValue;
                        continue block31;
                    }
                    case "IndRight": {
                        row.IndRight = cellValue;
                        continue block31;
                    }
                    case "SpLine": {
                        row.SpLine = cellValue;
                        continue block31;
                    }
                    case "SpBefore": {
                        row.SpBefore = cellValue;
                        continue block31;
                    }
                    case "SpAfter": {
                        row.SpAfter = cellValue;
                        continue block31;
                    }
                    case "HorzAlign": {
                        row.HorzAlign = cellValue;
                        continue block31;
                    }
                    case "Bullet": {
                        row.Bullet = cellValue;
                        continue block31;
                    }
                    case "BulletStr": {
                        row.BulletStr = cellValue;
                        continue block31;
                    }
                    case "BulletFont": {
                        row.BulletFont = cellValue;
                        continue block31;
                    }
                    case "BulletFontSize": {
                        row.BulletFontSize = cellValue;
                        continue block31;
                    }
                    case "TextPosAfterBullet": {
                        row.TextPosAfterBullet = cellValue;
                        continue block31;
                    }
                    case "Flags": {
                        row.Flags = cellValue;
                    }
                }
            }
        }
    }
}

