/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxProperty;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxPropertyParser
extends VsdxRowsSectionParser {
    VsdxPropertyParser(VsdxParser vsdxParser, Element paragraphNode) {
        super(vsdxParser, paragraphNode);
    }

    void parse(VsdxShape shape) {
        if (shape == null) {
            return;
        }
        if (shape.Properties == null) {
            shape.Properties = new ArrayList<VsdxProperty>();
        }
        boolean empty = shape.Properties.isEmpty();
        Element propertySection = this.getSectionNode();
        NodeList propertyRows = propertySection.getChildNodes();
        for (int propertyRowId = 0; propertyRowId < propertyRows.getLength(); ++propertyRowId) {
            VsdxProperty p;
            if (propertyRows.item(propertyRowId).getNodeType() != 1) continue;
            Element propertyRow = (Element)propertyRows.item(propertyRowId);
            VsdxProperty parsedProperty = new VsdxProperty();
            parsedProperty.setName(propertyRow.getAttribute("N"));
            if (propertyRow.hasAttribute("Del")) {
                parsedProperty.setDel(propertyRow.getAttribute("Del"));
            }
            NodeList propertyCells = propertyRow.getChildNodes();
            block26: for (int cellId = 0; cellId < propertyCells.getLength(); ++cellId) {
                Element propertyCell;
                if (propertyCells.item(cellId).getNodeType() != 1 || !(propertyCell = (Element)propertyCells.item(cellId)).hasAttribute("V")) continue;
                String cellValue = propertyCell.getAttribute("V");
                switch (propertyCell.getAttribute("N")) {
                    case "Value": {
                        parsedProperty.setValue(cellValue);
                        parsedProperty.setUnits(propertyCell.getAttribute("U"));
                        continue block26;
                    }
                    case "Prompt": {
                        continue block26;
                    }
                    case "Label": {
                        parsedProperty.setLabel(cellValue);
                        continue block26;
                    }
                    case "Format": {
                        parsedProperty.setFormat(cellValue);
                        continue block26;
                    }
                    case "SortKey": {
                        continue block26;
                    }
                    case "Type": {
                        parsedProperty.setTypeFromId(cellValue);
                        continue block26;
                    }
                    case "Invisible": {
                        parsedProperty.setInvisible(cellValue);
                        continue block26;
                    }
                    case "Verify": {
                        continue block26;
                    }
                    case "DataLinked": {
                        continue block26;
                    }
                    case "LangID": {
                        continue block26;
                    }
                }
            }
            VsdxProperty vsdxProperty = p = empty ? null : shape.findPropertyByName(parsedProperty.getName());
            if (p == null) {
                shape.Properties.add(parsedProperty);
                continue;
            }
            p.applyProperties(parsedProperty);
        }
    }
}

