/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxParser;
import java.util.List;
import org.w3c.dom.Element;

public class VsdxRowsSectionParser {
    private final VsdxParser vsdxParser;
    private final Element sectionNode;
    private final List<Element> rows;

    VsdxRowsSectionParser(VsdxParser vsdxParser, Element sectionNode) {
        this.vsdxParser = vsdxParser;
        this.sectionNode = sectionNode;
        this.rows = sectionNode == null ? null : vsdxParser.getElements(sectionNode, "Row", null, null);
    }

    public VsdxParser getVsdxParser() {
        return this.vsdxParser;
    }

    public Element getSectionNode() {
        return this.sectionNode;
    }

    public List<Element> getRows() {
        return this.rows;
    }

    public String getAttribute(String name) {
        assert (this.sectionNode != null);
        return this.sectionNode.getAttribute(name);
    }

    public boolean hasAttribute(String name) {
        assert (this.sectionNode != null);
        return this.sectionNode.hasAttribute(name);
    }

    public String getCellValue(String name) {
        assert (this.sectionNode != null);
        return this.vsdxParser.getCellValue(this.sectionNode, name);
    }

    public double getCellNumberValue(String name) {
        assert (this.sectionNode != null);
        return this.vsdxParser.getCellNumberValue(this.sectionNode, name);
    }

    public boolean hasCell(String name) {
        assert (this.sectionNode != null);
        return this.vsdxParser.hasCellAttribute(this.sectionNode, name);
    }

    public int countRows() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public boolean hasRowAttribute(int rowIndex, String name) {
        if (rowIndex < 0 || rowIndex >= this.countRows()) {
            return false;
        }
        Element row = this.rows.get(rowIndex);
        assert (row != null);
        return row.hasAttribute(name);
    }

    public String getRowAttribute(int rowIndex, String name) {
        if (rowIndex < 0 || rowIndex >= this.countRows()) {
            return "";
        }
        Element row = this.rows.get(rowIndex);
        assert (row != null);
        return row.getAttribute(name);
    }

    public boolean hasRowCell(int rowIndex, String cellName) {
        if (rowIndex < 0 || rowIndex >= this.countRows()) {
            return false;
        }
        return this.vsdxParser.hasCellAttribute(this.rows.get(rowIndex), cellName);
    }

    public String getRowCellValue(int rowIndex, String cellName) {
        if (rowIndex < 0 || rowIndex >= this.countRows()) {
            return "";
        }
        return this.vsdxParser.getCellValue(this.rows.get(rowIndex), cellName);
    }

    public String getRowCellFunction(int rowIndex, String cellName) {
        if (rowIndex < 0 || rowIndex >= this.countRows()) {
            return "";
        }
        return this.vsdxParser.getCellFunction(this.rows.get(rowIndex), cellName);
    }

    public double getRowCellNumberValue(int rowIndex, String cellName) {
        String s = this.getRowCellValue(rowIndex, cellName);
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    public Element getRowByIndex(int index) {
        if (index < 0 || index >= this.rows.size()) {
            return null;
        }
        return this.rows.get(index);
    }
}

