/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxTextParser {
    private final VsdxParser vsdxParser;
    private final Element textNode;

    public VsdxTextParser(VsdxParser vsdxParser, Element textNode) {
        this.vsdxParser = vsdxParser;
        this.textNode = textNode;
    }

    public VsdxParser getVsdxParser() {
        return this.vsdxParser;
    }

    public Element getTextNode() {
        return this.textNode;
    }

    public void parse(VsdxShape shape) {
        shape.TextInfo = null;
        if (this.textNode == null) {
            return;
        }
        NodeList childNodes = this.textNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        shape.TextInfo = new ArrayList<VsdxShape.VsdxTextInfo>();
        int cnt = childNodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node item = childNodes.item(i);
            if (item == null) continue;
            VsdxShape.VsdxTextInfo info = new VsdxShape.VsdxTextInfo();
            info.nodeType = item.getNodeType();
            info.name = item.getNodeName();
            info.content = SchemeUtils.correctText(item.getTextContent());
            NamedNodeMap attributes = item.getAttributes();
            if (attributes != null) {
                int cntj = attributes.getLength();
                for (int j = 0; j < cntj; ++j) {
                    String attValue;
                    String attName;
                    info.attributes = new HashMap<String, String>();
                    Node att = attributes.item(j);
                    if (att == null || att.getNodeType() != 2 || (attName = att.getNodeName()) == null || attName.isEmpty() || (attValue = att.getNodeValue()) == null || attValue.isEmpty()) continue;
                    info.attributes.put(attName, attValue);
                }
            }
            shape.TextInfo.add(info);
        }
    }
}

