/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.evaluator;

import inform.agent.Core;
import inform.agent.schemes.converters.vsdx.evaluator.resolvers.VariableResolver;
import inform.agent.schemes.converters.vsdx.evaluator.resolvers.VsdxFunctionResolver;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSyntaxTreeNode {
    public abstract double evaluate();

    public static class AstFunctionCallNode
    extends AbstractSyntaxTreeNode {
        private final String functionName;
        private final List<AbstractSyntaxTreeNode> arguments;

        public AstFunctionCallNode(String functionName, List<AbstractSyntaxTreeNode> arguments) {
            this.functionName = functionName;
            this.arguments = arguments;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public List<AbstractSyntaxTreeNode> getArguments() {
            return this.arguments;
        }

        @Override
        public double evaluate() {
            ArrayList<Double> arguments = new ArrayList<Double>();
            for (AbstractSyntaxTreeNode node : this.arguments) {
                arguments.add(node.evaluate());
            }
            return VsdxFunctionResolver.resolveFunction(this.functionName, arguments);
        }
    }

    public static class AstElementaryOperationNode
    extends AbstractSyntaxTreeNode {
        private final char operation;
        private final AbstractSyntaxTreeNode left;
        private final AbstractSyntaxTreeNode right;

        public AstElementaryOperationNode(char operation, AbstractSyntaxTreeNode left, AbstractSyntaxTreeNode right) {
            this.operation = operation;
            this.left = left;
            this.right = right;
        }

        @Override
        public double evaluate() {
            double left = this.left.evaluate();
            double right = this.right.evaluate();
            switch (this.operation) {
                case '+': {
                    return left + right;
                }
                case '-': {
                    return left - right;
                }
                case '*': {
                    return left * right;
                }
                case '/': {
                    return left / right;
                }
            }
            return 0.0;
        }
    }

    public static class AstNumberNode
    extends AbstractSyntaxTreeNode {
        private final double number;

        public AstNumberNode(double number) {
            this.number = number;
        }

        @Override
        public double evaluate() {
            return this.number;
        }
    }

    public static class AstVariableNode
    extends AbstractSyntaxTreeNode {
        public final String variableName;
        private final VariableResolver resolver;

        public AstVariableNode(String variableName, VariableResolver resolver) {
            this.variableName = variableName;
            this.resolver = resolver;
        }

        @Override
        public double evaluate() {
            try {
                return this.resolver.resolve(this.variableName);
            }
            catch (Exception e) {
                Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0432\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", e);
                return 1.0;
            }
        }
    }
}

