/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.ServerSideHost;
import inform.common.SmartScriptableObject;
import java.lang.invoke.StringConcatFactory;
import org.mozilla.javascript.Scriptable;

public class ColorsLibrary
extends SmartScriptableObject {
    private final ServerSideHost ssHost;
    private static final String[] availJSFunctionsNames = new String[]{"blend", "colorName", "fromString", "fromRgb"};

    ColorsLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        for (Colors e : Colors.values()) {
            ColorsLibrary.putConstProperty(this, e.name(), e.id);
        }
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "Colors";
    }

    public int blend(int Color1, int Color2, int A) {
        int c1 = Color1 & 0xFFFFFF;
        int c2 = Color2 & 0xFFFFFF;
        int v1 = c1 & 0xFF;
        int v2 = c2 & 0xFF;
        int r = A * (v1 - v2) / 256 + v2;
        v1 = c1 >>> 8 & 0xFF;
        v2 = c2 >>> 8 & 0xFF;
        int g = A * (v1 - v2) / 256 + v2;
        v1 = c1 >>> 16 & 0xFF;
        v2 = c2 >>> 16 & 0xFF;
        int b = A * (v1 - v2) / 256 + v2;
        return (b << 16) + (g << 8) + r;
    }

    public String colorName(int Color2) {
        for (Colors c : Colors.values()) {
            if (c.id != Color2) continue;
            return c.toString();
        }
        return "";
    }

    public int fromString(String Color2) {
        try {
            return Colors.valueOf((String)Color2).id;
        }
        catch (IllegalArgumentException e0) {
            try {
                return Colors.valueOf((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Web\u0001"}, (String)Color2))).id;
            }
            catch (IllegalArgumentException e1) {
                return -1;
            }
        }
    }

    public int fromRgb(int r, int g, int b) {
        return r | g << 8 | b << 16;
    }

    public static enum Colors {
        Black(0),
        Maroon(128),
        Green(32768),
        Olive(32896),
        Navy(0x800000),
        Purple(0x800080),
        Teal(0x808000),
        Gray(0x808080),
        Silver(0xC0C0C0),
        Red(255),
        Lime(65280),
        Yellow(65535),
        Blue(0xFF0000),
        Fuchsia(0xFF00FF),
        Aqua(0xFFFF00),
        LtGray(0xC0C0C0),
        DkGray(0x808080),
        White(0xFFFFFF),
        MoneyGreen(0xC0DCC0),
        SkyBlue(15780518),
        Cream(0xF0FBFF),
        MedGray(0xA4A0A0),
        None(0x1FFFFFFF),
        Default(0x20000000),
        WebSnow(0xFAFAFF),
        WebFloralWhite(0xF0FAFF),
        WebLavenderBlush(0xF5F0FF),
        WebOldLace(15136253),
        WebIvory(0xF0FFFF),
        WebCornSilk(14481663),
        WebBeige(14480885),
        WebAntiqueWhite(14150650),
        WebWheat(11788021),
        WebAliceBlue(0xFFF8F0),
        WebGhostWhite(0xFFF8F8),
        WebLavender(16443110),
        WebSeashell(0xEEF5FF),
        WebLightYellow(0xE0FFFF),
        WebPapayaWhip(14020607),
        WebNavajoWhite(11394815),
        WebMoccasin(11920639),
        WebBurlywood(8894686),
        WebAzure(0xFFFFF0),
        WebMintcream(0xFAFFF5),
        WebHoneydew(0xF0FFF0),
        WebLinen(15134970),
        WebLemonChiffon(13499135),
        WebBlanchedAlmond(13495295),
        WebBisque(12903679),
        WebPeachPuff(12180223),
        WebTan(9221330),
        WebYellow(65535),
        WebDarkOrange(36095),
        WebRed(255),
        WebDarkRed(139),
        WebMaroon(128),
        WebIndianRed(0x5C5CCD),
        WebSalmon(7504122),
        WebCoral(5275647),
        WebGold(55295),
        WebTomato(4678655),
        WebCrimson(3937500),
        WebBrown(0x2A2AA5),
        WebChocolate(1993170),
        WebSandyBrown(6333684),
        WebLightSalmon(8036607),
        WebLightCoral(0x8080F0),
        WebOrange(42495),
        WebOrangeRed(17919),
        WebFirebrick(0x2222B2),
        WebSaddleBrown(1262987),
        WebSienna(2970272),
        WebPeru(4163021),
        WebDarkSalmon(8034025),
        WebRosyBrown(9408444),
        WebPaleGoldenrod(0xAAE8EE),
        WebLightGoldenrodYellow(13826810),
        WebOlive(32896),
        WebForestGreen(0x228B22),
        WebGreenYellow(3145645),
        WebChartreuse(65407),
        WebLightGreen(0x90EE90),
        WebAquamarine(13959039),
        WebSeaGreen(5737262),
        WebGoldenRod(2139610),
        WebKhaki(9234160),
        WebOliveDrab(2330219),
        WebGreen(32768),
        WebYellowGreen(3329434),
        WebLawnGreen(64636),
        WebPaleGreen(10025880),
        WebMediumAquamarine(11193702),
        WebMediumSeaGreen(7451452),
        WebDarkGoldenRod(755384),
        WebDarkKhaki(7059389),
        WebDarkOliveGreen(3107669),
        WebDarkgreen(25600),
        WebLimeGreen(3329330),
        WebLime(65280),
        WebSpringGreen(0x7FFF00),
        WebMediumSpringGreen(10156544),
        WebDarkSeaGreen(9419919),
        WebLightSeaGreen(11186720),
        WebPaleTurquoise(0xEEEEAF),
        WebLightCyan(0xFFFFE0),
        WebLightBlue(15128749),
        WebLightSkyBlue(16436871),
        WebCornFlowerBlue(15570276),
        WebDarkBlue(0x8B0000),
        WebIndigo(8519755),
        WebMediumTurquoise(13422920),
        WebTurquoise(13688896),
        WebCyan(0xFFFF00),
        WebAqua(0xFFFF00),
        WebPowderBlue(15130800),
        WebSkyBlue(15453831),
        WebRoyalBlue(14772545),
        WebMediumBlue(0xCD0000),
        WebMidnightBlue(7346457),
        WebDarkTurquoise(13749760),
        WebCadetBlue(10526303),
        WebDarkCyan(0x8B8B00),
        WebTeal(0x808000),
        WebDeepskyBlue(0xFFBF00),
        WebDodgerBlue(16748574),
        WebBlue(0xFF0000),
        WebNavy(0x800000),
        WebDarkViolet(13828244),
        WebDarkOrchid(13382297),
        WebMagenta(0xFF00FF),
        WebFuchsia(0xFF00FF),
        WebDarkMagenta(0x8B008B),
        WebMediumVioletRed(8721863),
        WebPaleVioletRed(9662683),
        WebBlueViolet(14822282),
        WebMediumOrchid(13850042),
        WebMediumPurple(14381203),
        WebPurple(0x800080),
        WebDeepPink(9639167),
        WebLightPink(12695295),
        WebViolet(0xEE82EE),
        WebOrchid(14053594),
        WebPlum(0xDDA0DD),
        WebThistle(14204888),
        WebHotPink(11823615),
        WebPink(13353215),
        WebLightSteelBlue(14599344),
        WebMediumSlateBlue(15624315),
        WebLightSlateGray(0x998877),
        WebWhite(0xFFFFFF),
        WebLightgrey(0xD3D3D3),
        WebGray(0x808080),
        WebSteelBlue(11829830),
        WebSlateBlue(13458026),
        WebSlateGray(9470064),
        WebWhiteSmoke(0xF5F5F5),
        WebSilver(0xC0C0C0),
        WebDimGray(0x696969),
        WebMistyRose(14804223),
        WebDarkSlateBlue(9125192),
        WebDarkSlategray(0x4F4F2F),
        WebGainsboro(0xDCDCDC),
        WebDarkGray(0xA9A9A9),
        WebBlack(0);

        public final int id;

        private Colors(int id) {
            this.id = id;
        }
    }
}

