/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.collections.DoubleHash;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.CallableStatement;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.Task;
import java.sql.SQLException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Database
extends ScriptableObject
implements DoubleHash.Entry {
    private Task task;
    private final double nodeId;
    private boolean isActualDatabaseProps = false;
    private int databaseType;
    private String scheme;
    private String auditScheme;
    private static final String[] availableJSMethods = new String[]{"createSqlStatement", "createCallableStatement"};

    public Database(Task task, double dbId) {
        this.task = task;
        this.nodeId = dbId;
        Database.putConstProperty(this, "id", this.nodeId);
        this.defineProperty("type", this.getClass(), 0);
        this.defineProperty("scheme", this.getClass(), 0);
        this.defineProperty("auditScheme", this.getClass(), 0);
        this.defineFunctionProperties(availableJSMethods, Database.class, 0);
    }

    @Override
    public String getClassName() {
        return "Database";
    }

    public Scriptable createSqlStatement() throws SQLException {
        return new SqlStatement(this.task, this.nodeId);
    }

    public Scriptable createCallableStatement() throws SQLException {
        return new CallableStatement(this.task, this.nodeId);
    }

    private void updateDatabaseProps() {
        if (!this.isActualDatabaseProps) {
            DatabaseDescriptor descriptor;
            this.databaseType = -1;
            this.scheme = null;
            this.auditScheme = null;
            this.isActualDatabaseProps = true;
            if (this.nodeId == 0.0) {
                return;
            }
            if (this.nodeId == 2.0) {
                descriptor = DatabaseDescriptor.getMetabase();
            } else {
                Node node = MtdEngine.getNode(this.nodeId);
                if (node == null) {
                    return;
                }
                if (!(node instanceof DatabaseNode)) {
                    return;
                }
                descriptor = ((DatabaseNode)node).getDescriptor();
            }
            if (descriptor == null) {
                return;
            }
            this.scheme = descriptor.getScheme();
            this.auditScheme = descriptor.getAuditScheme();
            DatabaseType dt = descriptor.getDatabaseType();
            if (dt == DatabaseType.ORACLE_ODBC) {
                dt = DatabaseType.ORACLE;
            }
            this.databaseType = dt.ordinal();
        }
    }

    public int getType() {
        this.updateDatabaseProps();
        return this.databaseType;
    }

    public String getScheme() {
        this.updateDatabaseProps();
        return this.scheme;
    }

    public String getAuditScheme() {
        this.updateDatabaseProps();
        return this.auditScheme;
    }

    @Override
    public double key() {
        return this.nodeId;
    }
}

