/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.ServerSideHost;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DocumentsLibrary;
import inform.agent.scripts.MailMessage;
import inform.agent.scripts.MailRecipient;
import inform.agent.scripts.MailRecipientAddress;
import inform.agent.scripts.POP3Connection;
import inform.agent.scripts.SMTPConnection;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class MailLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"createMessage", "loadMessageFromBinary", "createMessageFromDocument", "createSmtpConnection", "createPop3Connection", "encodeText", "decodeText", "parseAddress"};
    private final ServerSideHost ssHost;
    public static final String CHARSET = "windows-1251";
    private static final String NO_ARGS_ERROR = "\u0414\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 %s \u0442\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0443\u043d\u043a\u0446\u0438\u0438.";
    private static final String INCORRECT_STRING_CAST_ERROR = "%d-\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 %s \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u043e\u0439.";
    private static final String INCORRECT_STRING_NULL_CAST_ERROR = "%d-\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 %s \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0438\u043b\u0438 null.";
    private static Session emptySession = null;

    MailLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    private static Session getEmptySession() {
        if (emptySession == null) {
            emptySession = Session.getInstance(new Properties());
        }
        return emptySession;
    }

    @Override
    public String getClassName() {
        return "MailLibrary";
    }

    public static Object createMessage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return new MailMessage(null);
    }

    public MailMessage loadMessageFromBinary(BinaryObject bin) throws Exception {
        InputStream source = BinaryObject.toInputStream(bin);
        MimeMessage inMsg = new MimeMessage(MailLibrary.getEmptySession(), source);
        MailMessage result = new MailMessage(inMsg);
        MailMessage.dumpEnvelope(inMsg, result);
        return result;
    }

    public Object createMessageFromDocument(BinaryObject document) throws IOException {
        return DocumentsLibrary.convertToMailMessage(document);
    }

    public static Object createSmtpConnection(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return new SMTPConnection();
    }

    public static Object createPop3Connection(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return new POP3Connection();
    }

    public static Object encodeText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws UnsupportedEncodingException {
        if (args.length == 0) {
            throw new InformException(String.format(NO_ARGS_ERROR, "encodeText"));
        }
        if (!(args[0] instanceof String) && !(args[0] instanceof ConsString)) {
            throw new InformException(String.format(INCORRECT_STRING_CAST_ERROR, 1, "encodeText"));
        }
        String text = args[0].toString();
        if (text == null || text.isEmpty()) {
            return text;
        }
        String charset = CHARSET;
        String encoding = null;
        if (args.length > 1 && args[1] != null) {
            if (!(args[1] instanceof String) && !(args[1] instanceof ConsString)) {
                throw new InformException(String.format(INCORRECT_STRING_NULL_CAST_ERROR, 2, "encodeText"));
            }
            charset = args[1].toString();
        }
        if (args.length > 2 && args[2] != null) {
            if (!(args[2] instanceof String) && !(args[2] instanceof ConsString)) {
                throw new InformException(String.format(INCORRECT_STRING_NULL_CAST_ERROR, 3, "encodeText"));
            }
            encoding = args[2].toString();
        }
        return MimeUtility.encodeText(text, charset, encoding);
    }

    public static Object decodeText(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws UnsupportedEncodingException {
        if (args.length == 0) {
            throw new InformException(String.format(NO_ARGS_ERROR, "decodeText"));
        }
        if (!(args[0] instanceof String) && !(args[0] instanceof ConsString)) {
            throw new InformException(String.format(INCORRECT_STRING_CAST_ERROR, 1, "decodeText"));
        }
        String text = args[0].toString();
        if (text == null || text.isEmpty()) {
            return text;
        }
        return MimeUtility.decodeText(text);
    }

    public Object parseAddress(MailRecipient recipient) {
        return new MailRecipientAddress(recipient);
    }
}

