/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.ObjectSizer;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.RequestHeader;
import inform.agent.net.ClientLoginInfo;
import inform.agent.sched.JobSSSHost;
import inform.agent.web.Session;
import java.io.IOException;

public abstract class SSContext {
    public static final int TAG_SSCONTEXT_REQUEST_NO = 1;
    public static final int TAG_SSCONTEXT_REQUEST_TYPE = 2;
    public static final int TAG_SSCONTEXT_REQUEST_SESSION_ID = 3;
    public static final int TAG_SSCONTEXT_REQUEST_OWNER_ID = 4;
    public static final int TAG_SSCONTEXT_REQUEST_UID = 5;
    public static final int TAG_SSCONTEXT_REQUEST_CREATE_TIME = 6;
    public static final int TAG_SSCONTEXT_REQUEST_NODE_ID = 7;
    public static final int TAG_SSCONTEXT_REQUEST_USER_ID = 8;
    public static final int TAG_SSCONTEXT_CHILD_CONTEXT = 9;
    public static final int TAG_SSCONTEXT_CHILD_CONTEXT_ID = 10;
    public static final int TAG_SSCONTEXT_CHILD_CONTEXT_NODE = 11;
    public static final int TAG_SSCONTEXT_REPLICA_CHANEL_ID = 12;
    public static final int TAG_SSCONTEXT_REPLICA_TYPE = 13;
    public static final int TAG_SSCONTEXT_CHILD_TABLE_ID = 14;
    public static final int TAG_SSCONTEXT_CHILD_SCRIPT = 15;
    public static final int TAG_SSCONTEXT_TYPE = 16;
    public static final int LABEL = 1;
    public static final int CALLABLE_STATEMENT = 2;
    public static final int SQL_STATEMENT = 3;
    public static final int DATASOURCE = 4;
    public static final int DATASOURCE_CURSOR = 5;
    public static final int REPLICA = 6;
    public static final int SCRIPT = 7;
    public static final int DIR_FIELD = 8;
    public static final int COMMIT_DATASOURCE = 9;
    public static final int DSL_RUNTIME = 10;
    public static final int CONTEXT_TYPE_REQUEST = 0;
    public static final int CONTEXT_TYPE_DEFAULT = 1;
    public static final int CONTEXT_TYPE_JOB = 2;
    public static final int CONTEXT_TYPE_CLIENT = 3;
    public static final int CONTEXT_TYPE_WEB = 4;
    @ObjectSizer.HintShared
    public final SSContext parent;
    public double nodeId;

    private SSContext(SSContext parent) {
        this.parent = parent;
    }

    public abstract void store(TaggedWriter var1) throws IOException;

    public final void storeAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(data);
        this.store(writer);
        writer.flush();
        if (data.size() == 0) {
            return;
        }
        out.putRaw(tag, data.internalBuffer(), data.size());
    }

    public Request requestContext() {
        if (this instanceof Request) {
            return (Request)this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.requestContext();
    }

    public WebRequest webContext() {
        if (this instanceof WebRequest) {
            return (WebRequest)this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.webContext();
    }

    public static SSContext getContext(SSContext ssContext) {
        if (ssContext == null) {
            LogContext logContext = LogContext.CURRENT.get();
            if (logContext != null) {
                ssContext = logContext.getSSContext();
            }
            if (ssContext == null) {
                ssContext = Core.defaultContext;
            }
        }
        return ssContext;
    }

    public static class Component
    extends SSContext {
        public final int type;
        public int id;
        public double tableId;
        public String script;

        public Component(SSContext parent, int type) {
            super(parent);
            this.type = type;
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            if (this.parent != null) {
                this.parent.store(out);
            }
            out.putInt32(9, this.type);
            out.putInt32(10, this.id);
            out.putDouble(11, this.nodeId);
            if (this.tableId != 0.0) {
                out.putDouble(14, this.tableId);
            }
            if (!Strings.isVoid(this.script)) {
                out.putString(15, this.script);
            }
        }
    }

    public static class CommitDatasource
    extends SSContext {
        public final int uid;
        public final double tableId;

        private CommitDatasource(SSContext parent, double ownerId, int uid, double tableId) {
            super(parent);
            this.nodeId = ownerId;
            this.uid = uid;
            this.tableId = tableId;
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            if (this.parent != null) {
                this.parent.store(out);
            }
            out.putInt32(9, 9);
            out.putInt32(10, this.uid);
            out.putDouble(11, this.nodeId);
            out.putDouble(14, this.tableId);
        }

        public static CommitDatasource getContext(SSContext parent, double ownerId, int uid, double tableId, CommitDatasource context) {
            if (context != null && context.uid == uid && context.nodeId == ownerId && context.tableId == tableId) {
                return context;
            }
            return new CommitDatasource(parent, ownerId, uid, tableId);
        }
    }

    public static class WebRequest
    extends SSContext {
        public final int requestNo;
        public final int requestType;
        public final double sessionId;
        public final double userId;
        public final double createTime;
        public double ownerId;
        public int uid;
        public String script;

        public WebRequest(int requestNo, int requestType, Session session) {
            super(null);
            this.requestNo = requestNo;
            this.requestType = requestType;
            this.sessionId = session.getSessionId();
            this.userId = session.getUserId();
            this.createTime = DateTime.currentDateTime();
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            out.putInt32(16, 4);
            out.putInt32(1, this.requestNo);
            out.putInt32(2, this.requestType);
            out.putDouble(3, this.sessionId);
            out.putDouble(4, this.ownerId);
            out.putInt32(5, this.uid);
            out.putDouble(6, this.createTime);
            out.putDouble(7, this.nodeId);
            out.putDouble(8, this.userId);
            if (!Strings.isVoid(this.script)) {
                out.putInt32(9, 4);
                out.putInt32(10, this.uid);
                out.putString(15, this.script);
            }
        }
    }

    public static class Request
    extends SSContext {
        public final int requestNo;
        public final int requestType;
        public final double sessionId;
        public final double userId;
        public final double createTime;
        public double ownerId;
        public int uid;

        public Request(RequestHeader rq) {
            super(null);
            this.nodeId = rq.nodeId;
            this.requestNo = rq.id;
            this.requestType = rq.request;
            this.sessionId = rq.client.getSessionId();
            this.userId = rq.client.getUserId();
            this.createTime = DateTime.currentDateTime();
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            out.putInt32(16, 0);
            out.putInt32(1, this.requestNo);
            out.putInt32(2, this.requestType);
            out.putDouble(3, this.sessionId);
            out.putDouble(4, this.ownerId);
            out.putInt32(5, this.uid);
            out.putDouble(6, this.createTime);
            out.putDouble(7, this.nodeId);
            out.putDouble(8, this.userId);
        }
    }

    public static class ClientContext
    extends SSContext {
        public final double sessionId;
        public volatile double userId;
        public final double createTime;

        public ClientContext(ClientLoginInfo loginInfo) {
            super(null);
            this.sessionId = loginInfo.sessionId;
            this.userId = loginInfo.userId;
            this.createTime = DateTime.currentDateTime();
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            out.putInt32(16, 3);
            out.putDouble(3, this.sessionId);
            out.putDouble(6, this.createTime);
            out.putDouble(8, this.userId);
        }
    }

    public static class JobContext
    extends SSContext {
        public final double userId;
        public final double createTime;

        public JobContext(JobSSSHost host) {
            super(null);
            this.nodeId = host.getNodeID();
            this.userId = host.getUserID();
            this.createTime = DateTime.currentDateTime();
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            out.putInt32(16, 2);
            out.putDouble(6, this.createTime);
            out.putDouble(7, this.nodeId);
            out.putDouble(8, this.userId);
        }
    }

    public static class DefaultContext
    extends SSContext {
        public final double createTime = DateTime.currentDateTime();

        public DefaultContext() {
            super(null);
        }

        @Override
        public void store(TaggedWriter out) throws IOException {
            out.putInt32(16, 1);
            out.putDouble(6, this.createTime);
        }
    }
}

