/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.collections.DoubleHash;
import inform.agent.sched.Job;
import inform.agent.sched.JobLauncher;
import inform.agent.sched.Sched;
import inform.common.SmartScriptableObject;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.mozilla.javascript.FunctionObject;

public class ScriptWorker
extends SmartScriptableObject
implements DoubleHash.Entry {
    private static final AtomicLong _idGenerator = new AtomicLong(0L);
    private final double workerId;
    private final Job job;
    private JobLauncher jobLauncher;
    private boolean standalone = false;

    public ScriptWorker(double workerId, double userId, double ownerId, String logInfo, double runNodeId, byte[] parameters) throws NoSuchMethodException {
        FunctionObject f;
        Method mCancel = null;
        Method mWait = null;
        for (Method m : ScriptWorker.class.getDeclaredMethods()) {
            String mName = m.getName();
            if (mCancel == null && "scriptCancel".equals(mName)) {
                mCancel = m;
            }
            if (mWait != null || !"scriptWait".equals(mName)) continue;
            mWait = m;
        }
        if (mCancel != null) {
            f = new FunctionObject("cancel", mCancel, this);
            this.defineProperty("cancel", (Object)f, 0);
        }
        if (mWait != null) {
            f = new FunctionObject("wait", mWait, this);
            this.defineProperty("wait", (Object)f, 0);
        }
        this.workerId = workerId;
        this.job = new Job(_idGenerator.decrementAndGet(), userId, ownerId, logInfo, runNodeId, parameters);
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public double key() {
        return this.workerId;
    }

    public ScriptWorker launch() throws InterruptedException {
        this.jobLauncher = Sched.runWorker(this.job);
        return this;
    }

    @SmartScriptableObject.PropertyTag
    public double getId() {
        return this.workerId;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsDone() {
        return this.jobLauncher == null || !this.jobLauncher.isRunning();
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsCanceled() {
        return this.jobLauncher != null && this.jobLauncher.isCancelled();
    }

    @SmartScriptableObject.PropertyTag
    public String getError() {
        return this.jobLauncher != null ? this.jobLauncher.lastError() : null;
    }

    @SmartScriptableObject.PropertyTag
    public Object getResult() {
        return this.jobLauncher != null ? this.jobLauncher.lastResult() : null;
    }

    @SmartScriptableObject.PropertyTag
    public Object getProgressState() {
        return this.jobLauncher != null ? this.jobLauncher.lastScriptRequestState() : null;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIsStandalone() {
        return this.standalone;
    }

    public void scriptCancel() {
        Sched.explicitStop(this.job.nodeId);
    }

    public boolean scriptWait(double timeout) throws InterruptedException {
        return this.jobLauncher == null || this.jobLauncher.waitRun((long)timeout);
    }
}

