/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptableTaggedReader
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"getSignature", "containsSignature", "getBoolean", "getInt", "getDouble", "getString", "getAnsiString", "getUnicodeString", "getBinary", "next"};
    private static final String[] jsProperties = new String[]{"tag", "tagSize"};
    private byte[] data;
    private TaggedReader reader;

    public ScriptableTaggedReader(Scriptable scope, byte[] data, int size) {
        this.setParentScope(scope);
        this.data = data;
        this.reader = size == 0 ? null : new TaggedReader(new ByteArrayInputStream(data, 0, size), size);
        this.defineFunctionProperties(jsMethods, ScriptableTaggedReader.class, 0);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, ScriptableTaggedReader.class, 1);
        }
    }

    public int getTag() {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getCurrentTag();
    }

    public int getTagSize() {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getCurrentTagSize();
    }

    public void getSignature() throws TaggedReaderException, IOException {
        if (this.reader == null) {
            TaggedReader.throwInvalidFormat();
        }
        this.reader.getSignature();
    }

    public static Object getBoolean(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getBoolean(tag);
        }
        return self.reader.getBoolean();
    }

    public static Object getInt(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getInt(tag);
        }
        return self.reader.getInt();
    }

    public static Object getDouble(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getDouble(tag);
        }
        return self.reader.getDouble();
    }

    public static Object getString(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getString(tag);
        }
        return self.reader.getString();
    }

    public static Object getAnsiString(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getAnsi(tag);
        }
        return self.reader.getAnsi();
    }

    public static Object getUnicodeString(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            return self.reader.getUnicode(tag);
        }
        return self.reader.getUnicode();
    }

    public static Object getBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws TaggedReaderException, IOException, InformException {
        byte[] data;
        ScriptableTaggedReader self = (ScriptableTaggedReader)thisObj;
        if (self.reader == null) {
            TaggedReader.throwInvalidTagSize();
        }
        if (args.length == 1) {
            int tag = ValueCaster.toInt(args[0]);
            data = self.reader.getRaw(tag);
        } else {
            data = self.reader.getRaw();
        }
        return new BinaryObject(data);
    }

    public int next() throws IOException {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getNextTag();
    }

    public boolean containsSignature() {
        if (this.reader == null) {
            return false;
        }
        return TaggedReader.containsSignature(this.data);
    }

    @Override
    public String getClassName() {
        return "TaggedReader";
    }
}

