/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ScriptableTextFileWriter
extends SmartScriptableObject {
    private final OutputStreamWriter _writer;
    private final String _pathname;
    private String _delimiter = " ";
    private String _lineSeparator = "\n";

    ScriptableTextFileWriter(Scriptable scope, OutputStreamWriter writer, String pathname) {
        this.setParentScope(scope);
        this._writer = writer;
        this._pathname = pathname;
    }

    private void _write(String str, int size) throws IOException, InformException, Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(str);
        if (size > 0) {
            builder.setLength(size);
            if (size > str.length()) {
                builder.replace(str.length(), size, " ");
            }
        }
        this._writer.write(builder.toString());
    }

    private void _writeLine(Object[] args) throws IOException, InformException, Exception {
        boolean writeDelimiter = false;
        for (Object arg : args) {
            if (writeDelimiter) {
                this._writer.write(this._delimiter);
            }
            this._writer.write(arg.toString());
            writeDelimiter = true;
        }
        this._writer.write(this._lineSeparator);
    }

    @Override
    public String getClassName() {
        return "TextFileWriter";
    }

    @SmartScriptableObject.PropertyTag
    public String getfileName() {
        return this._pathname;
    }

    @SmartScriptableObject.PropertyTag
    public String getCodepage() {
        return this._writer.getEncoding().replace("-", "").toLowerCase().replace("unicodelittleunmarked", "utf16");
    }

    @SmartScriptableObject.PropertyTag
    public String getdelimiter() {
        return this._delimiter;
    }

    public void setdelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    @SmartScriptableObject.PropertyTag
    public String getlineSeparator() {
        return this._lineSeparator;
    }

    public void setlineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    @SmartScriptableObject.FunctionTag
    public static Object write(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, Exception {
        ScriptableTextFileWriter textFileWriter = (ScriptableTextFileWriter)thisObj;
        if (args.length < 2) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432!");
        }
        if (!(args[1] instanceof Integer)) {
            throw new InformException("\u0420\u0430\u0437\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c!");
        }
        textFileWriter._write(args[0].toString(), (Integer)args[1]);
        return Undefined.instance;
    }

    @SmartScriptableObject.FunctionTag
    public static Object writeLine(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, InformException, Exception {
        ScriptableTextFileWriter textFileWriter = (ScriptableTextFileWriter)thisObj;
        if (args.length == 0) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432!");
        }
        textFileWriter._writeLine(args);
        return Undefined.instance;
    }

    @SmartScriptableObject.FunctionTag
    public void flush() throws IOException {
        this._writer.flush();
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this._writer.close();
    }
}

