/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerTask;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class ServerScriptExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(SSContext ssContext, int sessionId, double nodeID, byte[] inputParametersContent, ServerSideHost ssHost) throws Throwable {
        Object result = Undefined.instance;
        Node ssNode = MtdEngine.getNode(nodeID);
        if (ssNode == null || ssNode.getType() != 47) {
            return result;
        }
        Context cx = Core.asmoJsContextFactory.enterContext();
        ConnectionManager dbManager = ConnectionManager.capture(sessionId, ssHost, "ServerScriptExecutor");
        try {
            ServerTask node = new ServerTask(ssContext, nodeID, ssHost, dbManager, null);
            ScriptableObject toplevelScope = ScriptableRequest.createTopLevelScope(cx, node, ssHost, dbManager);
            if (ssHost instanceof ScriptableHost) {
                ScriptableHost scriptableHost = (ScriptableHost)((Object)ssHost);
                scriptableHost.setTopLevelScope(toplevelScope);
            }
            try {
                node.setConstantsContent(new byte[0]);
                node.load();
                if (inputParametersContent != null) {
                    node.getParameters().loadParametersValues(null, new TaggedReader(inputParametersContent), ssHost);
                }
                node.setParentScope(toplevelScope);
                if (ssHost instanceof ScriptableHost) {
                    ((ScriptableHost)((Object)ssHost)).setConstants(node.getConstants());
                }
                node.executeScript(cx);
                if (node.getOnExecute() == null || node.getOnExecute().length() <= 0) {
                    throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onExecute \u0434\u043b\u044f %s", ssNode.toLogString()));
                }
                result = ScriptableObject.callMethod(node, node.getOnExecute(), null);
                if (dbManager.hasModifications()) {
                    StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                    message.append(ssNode.toLogString());
                    HashSet<Double> dsIds = new HashSet<Double>();
                    String delimiter = "";
                    for (Row r : dbManager.getModifiedRows()) {
                        dsIds.add(r.getTableDescriptor().getNodeId());
                    }
                    if (dsIds.size() > 1) {
                        message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                    } else {
                        message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                    }
                    for (Double dsId : dsIds) {
                        message.append(String.format("%s%s", delimiter, NumberConverter.doubleToString(dsId)));
                        delimiter = ", ";
                    }
                    throw new InformException(message.toString());
                }
                dbManager.commit();
            }
            finally {
                node.close();
            }
        }
        finally {
            try {
                ((AbstractConnectionManager)dbManager).release();
                Context.exit();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
        return result;
    }

    public static class Worker {
        private final SSContext ssContext;
        private final int sessionId;
        private final double nodeID;
        private final byte[] inputParametersContent;
        private final ServerSideHost ssHost;
        private final Node ssNode;
        private Context cx = null;
        private AbstractConnectionManager dbManager = null;
        private ServerTask node = null;
        private ScriptableObject toplevelScope = null;

        public Worker(SSContext ssContext, int sessionId, double nodeID, byte[] inputParametersContent, ServerSideHost ssHost) {
            this.ssContext = ssContext;
            this.sessionId = sessionId;
            this.nodeID = nodeID;
            this.inputParametersContent = inputParametersContent;
            this.ssHost = ssHost;
            this.ssNode = MtdEngine.getNode(nodeID);
        }

        public boolean init() {
            if (this.ssNode == null || this.ssNode.getType() != 47) {
                return false;
            }
            this.cx = Core.asmoJsContextFactory.enterContext();
            this.dbManager = ConnectionManager.capture(this.sessionId, this.ssHost, "ServerScriptExecutor");
            this.node = new ServerTask(this.ssContext, this.nodeID, this.ssHost, this.dbManager, null);
            this.toplevelScope = ScriptableRequest.createTopLevelScope(this.cx, this.node, this.ssHost, this.dbManager);
            if (this.ssHost instanceof ScriptableHost) {
                ScriptableHost scriptableHost = (ScriptableHost)((Object)this.ssHost);
                scriptableHost.setTopLevelScope(this.toplevelScope);
            }
            return true;
        }

        public Object execute() throws IOException, SQLException {
            Object result = Undefined.instance;
            this.node.setConstantsContent(new byte[0]);
            this.node.load();
            if (this.inputParametersContent != null) {
                this.node.getParameters().loadParametersValues(null, new TaggedReader(this.inputParametersContent), this.ssHost);
            }
            this.node.setParentScope(this.toplevelScope);
            if (this.ssHost instanceof ScriptableHost) {
                ((ScriptableHost)((Object)this.ssHost)).setConstants(this.node.getConstants());
            }
            this.node.executeScript(this.cx);
            if (this.node.getOnExecute() == null || this.node.getOnExecute().length() <= 0) {
                throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onExecute \u0434\u043b\u044f %s", this.ssNode.toLogString()));
            }
            result = ScriptableObject.callMethod(this.node, this.node.getOnExecute(), null);
            if (this.dbManager.hasModifications()) {
                StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                message.append(this.ssNode.toLogString());
                HashSet<Double> dsIds = new HashSet<Double>();
                String delimiter = "";
                for (Row r : this.dbManager.getModifiedRows()) {
                    dsIds.add(r.getTableDescriptor().getNodeId());
                }
                if (dsIds.size() > 1) {
                    message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                } else {
                    message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                }
                for (Double dsId : dsIds) {
                    message.append(String.format("%s%s", delimiter, NumberConverter.doubleToString(dsId)));
                    delimiter = ", ";
                }
                throw new InformException(message.toString());
            }
            this.dbManager.commit();
            return result;
        }

        public void close() {
            if (this.node != null) {
                this.node.close();
            }
            try {
                if (this.dbManager != null) {
                    this.dbManager.release();
                }
                Context.exit();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
    }
}

