/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.security.PublicKey;
import org.mozilla.javascript.Scriptable;

public class CryptoPublicKey
extends CryptoKey {
    private final PublicKey key;

    public CryptoPublicKey(Scriptable scope, PublicKey key) {
        super(scope, key);
        this.key = key;
    }

    @Override
    public String getClassName() {
        return "PublicKey";
    }

    @SmartScriptableObject.PropertyTag
    public String getFormat() {
        return this.key.getFormat();
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getAsBinary() {
        byte[] encoded = this.key.getEncoded();
        if (encoded == null) {
            return null;
        }
        return new BinaryObject(encoded);
    }

    @SmartScriptableObject.PropertyTag
    public String getAsHexString() {
        byte[] encoded = this.key.getEncoded();
        if (encoded == null) {
            return null;
        }
        return CryptoUtils.bytesToHex(encoded, ',');
    }

    @SmartScriptableObject.PropertyTag
    public String getAsBase64() {
        byte[] encoded = this.key.getEncoded();
        if (encoded == null) {
            return null;
        }
        return Base64BinString.Encode(encoded);
    }
}

