/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.DateTimeStrCase;
import inform.agent.scripts.format.Format;
import java.util.Calendar;

public class DateFormat
extends Format {
    private static final String[] nominativeMonths = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};
    private static final String[] genitiveMonths = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};
    private static final String[] prepositionalMonths = new String[]{"\u044f\u043d\u0432\u0430\u0440\u0435", "\u0444\u0435\u0432\u0440\u0430\u043b\u0435", "\u043c\u0430\u0440\u0442\u0435", "\u0430\u043f\u0440\u0435\u043b\u0435", "\u043c\u0430\u0435", "\u0438\u044e\u043d\u0435", "\u0438\u044e\u043b\u0435", "\u0430\u0432\u0433\u0443\u0441\u0442\u0435", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u0435", "\u043e\u043a\u0442\u044f\u0431\u0440\u0435", "\u043d\u043e\u044f\u0431\u0440\u0435", "\u0434\u0435\u043a\u0430\u0431\u0440\u0435"};

    protected DateFormat(int id) {
        super(id);
    }

    @Override
    public final String format(Object value) throws InformException {
        if (null == value) {
            return "";
        }
        return this.formatValue(ValueCaster.toDouble(value));
    }

    protected String getQuarterStringFromMonth(int Month) {
        if (Month < 3) {
            return "I \u043a\u0432.";
        }
        if (Month < 6) {
            return "II \u043a\u0432.";
        }
        if (Month < 9) {
            return "III \u043a\u0432.";
        }
        return "IV \u043a\u0432.";
    }

    protected String getStringFromMonth(int Month, DateTimeStrCase stringCase) {
        switch (stringCase) {
            case GENETIVE: {
                return genitiveMonths[Month];
            }
            case PREPOSITIONAL: {
                return prepositionalMonths[Month];
            }
        }
        return nominativeMonths[Month];
    }

    protected String toStringWithFormat(Calendar cal) {
        int Year = cal.get(1);
        int Month = cal.get(2);
        int Day = cal.get(5);
        int Hour = cal.get(11);
        int Minute = cal.get(12);
        int Second = cal.get(13);
        switch (this.id) {
            case 401: {
                return String.format("%02d.%02d.%04d", Day, Month + 1, Year);
            }
            case 402: {
                return String.format("%02d.%04d", Month + 1, Year);
            }
            case 403: {
                return String.format("%04d", Year);
            }
            case 404: {
                return String.format("%02d:%02d", Hour, Minute);
            }
            case 405: {
                return String.format("%02d:%02d:%02d", Hour, Minute, Second);
            }
            case 406: {
                return String.format("%02d.%02d.%04d %02d:%02d", Day, Month + 1, Year, Hour, Minute);
            }
            case 407: {
                return String.format("%02d", Hour);
            }
            case 408: {
                return String.format("%02d", Day);
            }
            case 409: {
                return String.format("%02d.%02d", Day, Month + 1);
            }
            case 410: {
                return String.format("%02d.%02d.%04d %02d:%02d:%02d", Day, Month + 1, Year, Hour, Minute, Second);
            }
            case 411: {
                return String.format("%s %04d", this.getQuarterStringFromMonth(Month), Year);
            }
            case 412: {
                return String.format("%04d.%02d.%02d", Year, Month + 1, Day);
            }
        }
        return "";
    }

    protected String formatValue(double value) throws InformException {
        return this.toStringWithFormat(DateTime.toCalendar(value));
    }

    @Override
    public DataType getDataType() {
        return DataType.DATE_TIME;
    }
}

