/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.scripts.format.Format;

public class MetatreeNodeFormat
extends Format {
    private static final int TAG_NODE_USER_FIO = 1;

    protected MetatreeNodeFormat(int id) {
        super(id);
    }

    @Override
    public final String format(Object value) throws InformException {
        if (null == value) {
            return "";
        }
        return this.formatValue(ValueCaster.toDouble(value));
    }

    private String getFIO(UserNode node) throws InformException {
        try {
            TaggedReader content = new TaggedReader(node.getContent());
            while (content.getNextTag() != 0) {
                switch (content.getCurrentTag()) {
                    case 7: {
                        TaggedReader props = content.getStreamReader();
                        while (props.getNextTag() != 0) {
                            switch (props.getCurrentTag()) {
                                case 1: {
                                    return props.getAnsi();
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
        return "";
    }

    private String trunkFIO(String fio) {
        String[] p = fio.split("\\s");
        if (3 == p.length) {
            return p[0] + " " + p[1].substring(0, 1) + "." + p[2].substring(0, 1) + ".";
        }
        return fio;
    }

    protected String formatValue(double value) throws InformException {
        String fio;
        Node node = MtdEngine.getNode(value);
        if (null == node) {
            return "";
        }
        if (node instanceof UserNode && 0 != this.id && null != (fio = this.getFIO((UserNode)node)) && !fio.equals("")) {
            switch (this.id) {
                case 1001: {
                    return this.trunkFIO(fio);
                }
                case 1002: {
                    return fio;
                }
            }
        }
        return node.getName();
    }

    @Override
    public DataType getDataType() {
        return DataType.METATREE_NODE;
    }
}

