/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.CurrencyFormat;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;
import java.io.IOException;

public class SpellMoneyFormat
extends Format {
    public static final int TAG_DF_CURRENCY = 55;
    public static final int TAG_DF_SHOW_CENTS = 56;
    int currency = 1;
    boolean show_cents = false;

    @SmartScriptableObject.PropertyTag
    public int getCurrency() {
        return this.currency;
    }

    public void setCurrency(int value) {
        this.currency = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getShowCents() {
        return this.show_cents;
    }

    public void setShowCents(boolean value) {
        this.show_cents = value;
    }

    protected void decodeOptions(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 55: {
                    this.currency = reader.getInt();
                    break;
                }
                case 56: {
                    this.show_cents = true;
                }
            }
        }
    }

    protected SpellMoneyFormat(int id, byte[] options) throws IOException, TaggedReaderException {
        super(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    @Override
    public final String format(Object value) throws InformException {
        Double num = ValueCaster.toDouble(value);
        return CurrencyFormat.NumberToMoneyString(num, this.show_cents, this.currency);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public FormatAligment getAlignment() {
        return FormatAligment.RIGHT;
    }
}

