/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.agent.scripts.libs.Triangulator;
import inform.common.SmartScriptableObject;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GeoLibrary
extends SmartScriptableObject {
    private static final int MAX_POINTS = 500000;
    private static final Triangulator.Coordinater<Scriptable> COORDINATER = new Triangulator.Coordinater<Scriptable>(){

        @Override
        public double x(Scriptable p) {
            return ((Number)p.get("x", p)).doubleValue();
        }

        @Override
        public double y(Scriptable p) {
            return ((Number)p.get("y", p)).doubleValue();
        }
    };

    @SmartScriptableObject.FunctionTag
    public static void triangulatePoints(final Context cx, final Scriptable thisObj, Object[] args, Function funObj) throws InterruptedException {
        NativeArray points = (NativeArray)args[0];
        final Function factory = (Function)args[1];
        final Function progress = args.length > 2 ? (Function)args[2] : null;
        int l = (int)points.getLength();
        if (l > 500000) {
            throw new IllegalArgumentException("l=" + l + ">500000");
        }
        ArrayList<Scriptable> pnts = new ArrayList<Scriptable>(l + 4);
        for (int i = 0; i < l; ++i) {
            pnts.add((Scriptable)points.get(i, (Scriptable)points));
        }
        double minx = Double.MAX_VALUE;
        double maxx = -minx;
        double miny = minx;
        double maxy = maxx;
        for (Scriptable p : pnts) {
            double x = COORDINATER.x(p);
            double y = COORDINATER.y(p);
            minx = Math.min(minx, x);
            miny = Math.min(miny, y);
            maxx = Math.max(maxx, x);
            maxy = Math.max(maxy, y);
        }
        pnts.add(new P(minx - 1.0, miny - 1.0, 0.0));
        pnts.add(new P(maxx + 1.0, miny - 1.0, 0.0));
        pnts.add(new P(maxx + 1.0, maxy + 1.0, 0.0));
        pnts.add(new P(minx - 1.0, maxy + 1.0, 0.0));
        Triangulator.Progress tprogress = progress == null ? null : new Triangulator.Progress(){
            final Object[] args = new Object[1];

            @Override
            public void progress(double percent) {
                this.args[0] = percent;
                progress.call(cx, thisObj, thisObj, this.args);
            }
        };
        Triangulator.triangulate(pnts.iterator(), new Triangulator.TriangleListener<Scriptable>(){
            final Object[] args = new Object[3];

            @Override
            public void triangle(Scriptable a, Scriptable b, Scriptable c) {
                if (a instanceof P) {
                    return;
                }
                if (b instanceof P) {
                    return;
                }
                if (c instanceof P) {
                    return;
                }
                this.args[0] = a;
                this.args[1] = b;
                this.args[2] = c;
                factory.call(cx, thisObj, thisObj, this.args);
            }
        }, COORDINATER, minx - 1.0, miny - 1.0, maxx + 1.0, maxy + 1.0, tprogress);
    }

    public GeoLibrary(Scriptable scope) {
        this.setParentScope(scope);
    }

    private static class P
    extends ScriptableObject {
        public P(double x, double y, double z) {
            this.defineProperty("x", (Object)x, 5);
            this.defineProperty("y", (Object)y, 5);
        }

        @Override
        public String getClassName() {
            return this.getClass().getSimpleName();
        }
    }
}

