/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.agent.Core;
import inform.agent.Ini;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.impl.AsmoLogger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;

public class SnmpLogFactory
extends LogFactory {
    private static final String MSG = "SNMP: ";
    private static final String MSGF = "SNMP: {}";

    protected LogAdapter createLogger(Class c) {
        return this.getRootLogger();
    }

    protected LogAdapter createLogger(String className) {
        return this.getRootLogger();
    }

    public LogAdapter getRootLogger() {
        return AsmoLogAdapter.INSTANCE;
    }

    private static class AsmoLogAdapter
    implements LogAdapter {
        static final AsmoLogAdapter INSTANCE = new AsmoLogAdapter();
        static final AsmoLogger logger = Core.logger;

        private AsmoLogAdapter() {
        }

        public boolean isDebugEnabled() {
            return logger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return logger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return logger.isWarnEnabled();
        }

        public void debug(Serializable message) {
            logger.debug(SnmpLogFactory.MSGF, message);
        }

        public void info(CharSequence message) {
            logger.info(SnmpLogFactory.MSGF, (Object)message);
        }

        public void warn(Serializable message) {
            logger.warn(SnmpLogFactory.MSGF, (Object)message);
        }

        public void error(Serializable message) {
            logger.error(SnmpLogFactory.MSGF, message);
        }

        public void error(CharSequence message, Throwable throwable) {
            logger.error(SnmpLogFactory.MSG + message, throwable);
        }

        public void fatal(Object message) {
            this.error((Serializable)((Object)message.toString()));
        }

        public void fatal(CharSequence message, Throwable throwable) {
            this.error(message, throwable);
        }

        public void setLogLevel(LogLevel level) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogLevel getLogLevel() {
            if (Ini.ConsoleDialog || !Ini.DisableLog) {
                return LogLevel.OFF;
            }
            return Ini.verbose ? LogLevel.ALL : LogLevel.INFO;
        }

        public LogLevel getEffectiveLogLevel() {
            return this.getLogLevel();
        }

        public String getName() {
            return "AsmoLogger";
        }

        public Iterator getLogHandler() {
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

