/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.soap.SoapName;
import inform.agent.scripts.soap.SoapNamespaces;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SoapElement
extends SmartScriptableObject {
    protected final SOAPElement element;
    protected final Scriptable scope;
    private SoapNamespaces namespaces = null;
    private SoapName elementName = null;
    private SoapElement parentElement = null;

    public SoapElement(Scriptable scope, SOAPElement element) {
        this.setParentScope(scope);
        this.scope = scope;
        this.element = element;
    }

    @SmartScriptableObject.PropertyTag
    public String getValue() {
        return this.element.getValue();
    }

    public void setValue(String data) {
        this.element.setValue(data);
    }

    @SmartScriptableObject.PropertyTag
    public String getAsString() throws TransformerConfigurationException, TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new DOMSource((Node)this.element), new StreamResult(sw));
        return sw.toString();
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement parentElement() {
        SOAPElement parent;
        if (this.parentElement == null && (parent = this.element.getParentElement()) != null) {
            this.parentElement = new SoapElement(this.scope, parent);
        }
        return this.parentElement;
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement element(Object path) throws SOAPException {
        ArrayList<SoapElement> results = new ArrayList<SoapElement>();
        if (!this.findElements(path, true, results)) {
            return null;
        }
        return (SoapElement)results.get(0);
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement[] elements(Object path) throws SOAPException {
        ArrayList<SoapElement> results = new ArrayList<SoapElement>();
        if (!this.findElements(path, false, results)) {
            return null;
        }
        return results.toArray(new SoapElement[0]);
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement addElement(Object child, Object prefix, Object uri) throws SOAPException {
        if (child instanceof SoapName) {
            return new SoapElement(this.scope, this.element.addChildElement(((SoapName)child).name));
        }
        if (child instanceof SoapElement) {
            SoapElement e = (SoapElement)child;
            this.element.addChildElement(e.element);
            return e;
        }
        if (child instanceof String) {
            String n = (String)child;
            if (n.isEmpty()) {
                return null;
            }
            SOAPEnvelope envelope = this.getEnvelope();
            if (envelope == null) {
                return null;
            }
            String p = prefix instanceof String ? (String)prefix : null;
            String u = uri instanceof String ? (String)uri : null;
            return new SoapElement(this.scope, this.element.addChildElement(envelope.createName(n, p, u)));
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement addXml(Object data, Object codepage) throws Exception {
        byte[] v = CryptoUtils.dataAsBytes(data, codepage);
        if (v != null && v.length > 0) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document doc = documentBuilder.parse(new ByteArrayInputStream(v));
            Node firstChild = doc.getFirstChild();
            Node n = this.element.getOwnerDocument().importNode(firstChild, true);
            this.element.appendChild(n);
            if (n instanceof SOAPElement) {
                return new SoapElement(this.scope, (SOAPElement)n);
            }
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement text(Object data) throws Exception {
        if (data != null) {
            this.element.addTextNode(data.toString());
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement cdata(Object data) throws Exception {
        if (data != null) {
            String str = data.toString();
            str = str.replace("]]", "]]]]><![CDATA[>");
            this.element.addTextNode("<![CDATA[" + str + "]]>");
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public void detach() {
        this.parentElement = null;
        this.element.detachNode();
    }

    @SmartScriptableObject.PropertyTag
    public SoapName getElementName() {
        if (this.elementName == null) {
            this.elementName = new SoapName(this.scope, this.element.getElementName());
        }
        return this.elementName;
    }

    @SmartScriptableObject.PropertyTag
    public String getLocalName() {
        return this.element.getElementName().getLocalName();
    }

    @SmartScriptableObject.FunctionTag
    public SoapElement addAttribute(String value, Object name, Object prefix, Object uri) throws SOAPException {
        if (name instanceof SoapName) {
            this.element.addAttribute(((SoapName)name).name, value);
        } else if (name instanceof String) {
            String n = (String)name;
            if (n.isEmpty()) {
                return this;
            }
            SOAPEnvelope envelope = this.getEnvelope();
            if (envelope == null) {
                return this;
            }
            String p = prefix instanceof String ? (String)prefix : null;
            String u = uri instanceof String ? (String)uri : null;
            this.element.addAttribute(envelope.createName(n, p, u), value);
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public boolean removeAttribute(Object name, Object prefix, Object uri) throws SOAPException {
        if (name instanceof SoapName) {
            return this.element.removeAttribute(((SoapName)name).name);
        }
        if (name instanceof String) {
            String n = (String)name;
            if (n.isEmpty()) {
                return false;
            }
            SOAPEnvelope envelope = this.getEnvelope();
            if (envelope == null) {
                return false;
            }
            String p = prefix instanceof String ? (String)prefix : null;
            String u = uri instanceof String ? (String)uri : null;
            return this.element.removeAttribute(envelope.createName(n, p, u));
        }
        return false;
    }

    @SmartScriptableObject.FunctionTag
    public SoapName[] attributeNames() {
        Iterator iterator = this.element.getAllAttributes();
        ArrayList<SoapName> list = new ArrayList<SoapName>();
        while (iterator.hasNext()) {
            list.add(new SoapName(this.scope, (Name)iterator.next()));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new SoapName[0]);
    }

    @SmartScriptableObject.FunctionTag
    public String attribute(Object name, Object prefix, Object uri) throws SOAPException {
        if (name instanceof SoapName) {
            return this.element.getAttributeValue(((SoapName)name).name);
        }
        if (name instanceof String) {
            String n = (String)name;
            if (n.isEmpty()) {
                return null;
            }
            SOAPEnvelope envelope = this.getEnvelope();
            if (envelope == null) {
                return null;
            }
            String p = prefix instanceof String ? (String)prefix : null;
            String u = uri instanceof String ? (String)uri : null;
            return this.element.getAttributeValue(envelope.createName(n, p, u));
        }
        return null;
    }

    @SmartScriptableObject.PropertyTag
    public SoapNamespaces getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new SoapNamespaces((Scriptable)this, this.element);
        }
        return this.namespaces;
    }

    @SmartScriptableObject.PropertyTag
    public String getEncodingStyle() {
        return this.element.getEncodingStyle();
    }

    public void setEncodingStyle(String style) throws SOAPException {
        this.element.setEncodingStyle(style);
    }

    protected SOAPEnvelope getEnvelope() {
        for (SOAPElement env = this.element; env != null; env = env.getParentElement()) {
            if (!(env instanceof SOAPEnvelope)) continue;
            return (SOAPEnvelope)env;
        }
        return null;
    }

    private boolean findElements(Object path, boolean first, List<SoapElement> results) throws SOAPException {
        ArrayList<Object> listNames = new ArrayList<Object>();
        if (path instanceof NativeArray) {
            SOAPEnvelope envelope = null;
            NativeArray arr = (NativeArray)path;
            int cnt = arr.size();
            for (int i = 0; i < cnt; ++i) {
                String u;
                Object item = arr.get(i);
                if (item instanceof String) {
                    listNames.add(item);
                    continue;
                }
                if (item instanceof SoapName) {
                    listNames.add(((SoapName)item).name);
                    continue;
                }
                if (!(item instanceof NativeArray)) continue;
                NativeArray narr = (NativeArray)item;
                int size = narr.size();
                if (size == 0) {
                    listNames.add("");
                    continue;
                }
                String n = (String)narr.get(0);
                String p = size > 1 ? (String)narr.get(1) : null;
                String string = u = size > 2 ? (String)narr.get(2) : null;
                if (envelope == null) {
                    envelope = this.getEnvelope();
                }
                if (envelope == null) continue;
                listNames.add(envelope.createName(n, p, u));
            }
        } else if (path instanceof SoapName) {
            listNames.add(((SoapName)path).name);
        } else if (path instanceof String) {
            listNames.add(path);
        }
        if (listNames.isEmpty()) {
            listNames.add("");
        }
        return this.findAllElements(this.element, listNames, 0, results, first);
    }

    private boolean findAllElements(SOAPElement current, List paths, int level, List<SoapElement> results, boolean first) {
        boolean lastLevel = level == paths.size() - 1;
        Object filter = paths.get(level);
        Iterator iterator = null;
        String localFilter = null;
        if (filter instanceof Name) {
            iterator = current.getChildElements((Name)filter);
        } else if (filter instanceof String) {
            localFilter = (String)filter;
            iterator = current.getChildElements();
        } else {
            iterator = current.getChildElements();
        }
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof SOAPElement) {
                SOAPElement e = (SOAPElement)next;
                if (localFilter == null || localFilter.isEmpty() || localFilter.equals(e.getElementName().getLocalName())) {
                    if (lastLevel) {
                        results.add(new SoapElement(this.scope, e));
                    } else {
                        this.findAllElements(e, paths, level + 1, results, first);
                    }
                }
            }
            if (!first || results.isEmpty()) continue;
            break;
        }
        return !results.isEmpty();
    }
}

