/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.ods;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.spreadsheets.ods.OdsCellStyle;
import inform.agent.scripts.spreadsheets.ods.OdsFont;
import inform.agent.scripts.spreadsheets.ods.OdsWorkbookSheetCells;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.Color;
import org.w3c.dom.Element;

public class OdsWorkbook
extends SmartScriptableObject {
    private static final String MESSAGE_BADFIELDTYPE_WRITE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c Ods-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043f\u043e\u043b\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_EMPTYBINARY = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Ods-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u0431\u0438\u043d\u0430\u0440\u043d\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
    private static final String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c Ods-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_MISSINGFILE = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0444\u0430\u0439\u043b '%s'. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u0438 \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.";
    private static final String MESSAGE_EMPTYFIELD = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Ods-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u0443\u0441\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
    private static final String MESSAGE_BADFIELDTYPE_READ = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Ods-\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043f\u043e\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 c \u0442\u0438\u043f\u043e\u043c '%s'";
    private static final String MESSAGE_BADCOLOR = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0446\u0432\u0435\u0442\u0430: '%s'";
    static final String MESSAGE_BADFONT = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0444\u043e\u043d\u0430 \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    static final String MESSAGE_BADSTYLE = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0438\u043b\u044f \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    OdfSpreadsheetDocument document;

    public OdsWorkbook(Scriptable scope) {
        this.setParentScope(scope);
    }

    public static OdsWorkbook createOdsWorkbook(Scriptable scope) throws Exception {
        OdsWorkbook workbook = new OdsWorkbook(scope);
        workbook.document = OdfSpreadsheetDocument.newSpreadsheetDocument();
        return workbook;
    }

    public static OdsWorkbook openOdsWorkbook(Scriptable scope, String fileName) throws Exception {
        OdsWorkbook book = new OdsWorkbook(scope);
        File file = Core.mountfs.resolve(new File(fileName));
        if (!file.exists()) {
            throw new InformException(String.format(MESSAGE_MISSINGFILE, fileName));
        }
        try (FileInputStream is = new FileInputStream(file);){
            book.document = OdfSpreadsheetDocument.loadDocument((InputStream)is);
            OdsWorkbook odsWorkbook = book;
            return odsWorkbook;
        }
    }

    public static OdsWorkbook openOdsWorkbook(Scriptable scope, BinaryObject binary) throws Exception {
        OdsWorkbook book = new OdsWorkbook(scope);
        if (binary.getSize() == 0) {
            throw new InformException(MESSAGE_EMPTYBINARY);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary.getInternalBuffer());){
            book.document = OdfSpreadsheetDocument.loadDocument((InputStream)is);
            OdsWorkbook odsWorkbook = book;
            return odsWorkbook;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdsWorkbook openOdsWorkbook(Scriptable scope, DatasourceField field) throws Exception {
        InputStream is;
        OdsWorkbook book = new OdsWorkbook(scope);
        if (field.getIsNull()) {
            throw new InformException(MESSAGE_EMPTYFIELD);
        }
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = field.getAsBinary();
                assert (binary != null);
                is = new ByteArrayInputStream(binary.getInternalBuffer());
                break;
            }
            case FILE: {
                is = ((BlobFileField)field).openFileStream();
                break;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_READ, new Object[]{field.getDataType()}));
            }
        }
        assert (is != null);
        try {
            book.document = OdfSpreadsheetDocument.loadDocument((InputStream)is);
            OdsWorkbook odsWorkbook = book;
            return odsWorkbook;
        }
        finally {
            is.close();
        }
    }

    @Override
    public String getClassName() {
        return "OdsWorkbook";
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.document.close();
    }

    @SmartScriptableObject.FunctionTag
    public OdsWorkbookSheetCells createSheet(String sheetName) {
        return OdsWorkbookSheetCells.createSheet(this, sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public OdsWorkbookSheetCells readSheet(Object sheetName) {
        return OdsWorkbookSheetCells.readSheet(this, sheetName);
    }

    @SmartScriptableObject.FunctionTag
    public void removeSheet(Object tableName) {
        int index = tableName instanceof Number ? ((Number)tableName).intValue() : this.indexOf(tableName.toString());
        OdfTable table = (OdfTable)this.document.getTableList().get(index);
        table.remove();
    }

    @SmartScriptableObject.FunctionTag
    public String sheetName(int sheetIndex) {
        return ((OdfTable)this.document.getTableList().get(sheetIndex)).getTableName();
    }

    @SmartScriptableObject.FunctionTag
    public void setSheetName(int sheetIndex, String sheetName) {
        OdfTable table = (OdfTable)this.document.getTableList().get(sheetIndex);
        table.setTableName(sheetName);
        this.document.getTableList().set(sheetIndex, table);
    }

    @SmartScriptableObject.FunctionTag
    public int indexOf(String sheetName) {
        OdfTable table = this.document.getTableByName(sheetName);
        return this.document.getTableList().indexOf(table);
    }

    @SmartScriptableObject.FunctionTag
    public void setSheetIndex(String sheetName, int order) {
        OdfTable table = this.document.getTableByName(sheetName);
        this.document.getTableList().set(order, table);
    }

    @SmartScriptableObject.FunctionTag
    public void saveToFile(String fileName) throws IOException {
        assert (this.document != null);
        try (FileOutputStream os = new FileOutputStream(Core.mountfs.resolve(new File(fileName)));){
            this.document.save((OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SmartScriptableObject.FunctionTag
    public void saveToBlob(Object dataSource) throws Exception {
        if (dataSource instanceof BinaryObject) {
            this.saveToBinaryObject((BinaryObject)dataSource);
        } else if (dataSource instanceof DatasourceField) {
            this.saveToDatasourceField((DatasourceField)dataSource);
        } else {
            throw new InformException(String.format(MESSAGE_BADTYPE, dataSource == null ? "null" : dataSource.getClass().getName()));
        }
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont createFont(Object cellFont) {
        if (cellFont == null || cellFont instanceof Undefined) {
            return new OdsFont(this);
        }
        if (cellFont instanceof OdsFont) {
            return new OdsFont(this, (OdsFont)cellFont);
        }
        if (cellFont instanceof Map) {
            return new OdsFont(this, (Map)cellFont);
        }
        throw new InformException(String.format(MESSAGE_BADFONT, cellFont));
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle createCellStyle(Object cellStyle) {
        if (cellStyle == null || cellStyle instanceof Undefined) {
            return new OdsCellStyle(this);
        }
        if (cellStyle instanceof OdsCellStyle) {
            return new OdsCellStyle(this, (OdsCellStyle)cellStyle);
        }
        if (cellStyle instanceof Map) {
            return new OdsCellStyle(this, (Map)cellStyle);
        }
        throw new InformException(String.format(MESSAGE_BADSTYLE, cellStyle));
    }

    @SmartScriptableObject.PropertyTag
    public int getCountSheets() {
        return this.document.getTableList().size();
    }

    @SmartScriptableObject.FunctionTag
    public void evaluateCells() {
        for (int i = 0; i < this.document.getTableList().size(); ++i) {
            for (OdfTableRow tableRow : ((OdfTable)this.document.getTableList().get(i)).getRowList()) {
                TableTableRowElement rowElement = tableRow.getOdfElement();
                int count = rowElement.getChildElementCount();
                for (int j = 0; j < count; ++j) {
                    Element element = (Element)rowElement.item(j);
                    if (!element.hasAttribute("table:formula")) continue;
                    OdfTableCell cell = tableRow.getCellByIndex(j);
                    cell.setFormula(cell.getFormula());
                }
            }
        }
    }

    public static Color parseColor(Object value) {
        if (value instanceof Number) {
            int c = ((Number)value).intValue();
            return new Color(new java.awt.Color(c));
        }
        throw new InformException(String.format(MESSAGE_BADCOLOR, value));
    }

    public OdfFileDom getDom() {
        try {
            return this.document.getContentDom();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveToBinaryObject(BinaryObject binary) throws Exception {
        assert (this.document != null);
        assert (binary != null);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.document.save((OutputStream)os);
            binary.clear();
            try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                binary.loadFromStream(is);
            }
        }
    }

    private void saveToDatasourceField(DatasourceField field) throws Exception {
        assert (this.document != null);
        assert (field != null);
        field.clear();
        switch (field.getDataType()) {
            case BLOB: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) {
                    throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, DataType.BLOB + "(" + field.getDescriptor().getBlobRawType() + ")"));
                }
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            case FILE: {
                BinaryObject binary = new BinaryObject();
                this.saveToBinaryObject(binary);
                field.setAsBinary(binary);
                break;
            }
            default: {
                throw new InformException(String.format(MESSAGE_BADFIELDTYPE_WRITE, new Object[]{field.getDataType()}));
            }
        }
    }
}

