/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.DataQueryNode;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryKind;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeKind;
import inform.agent.scripts.sql.UnionQueryNode;
import inform.agent.scripts.sql.expr.Condition;
import inform.agent.scripts.sql.expr.FieldExpression;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.ArrayList;

public class RootQueryNode
extends DataQueryNode {
    Condition where = null;
    Condition having = null;
    Condition hierarchy = null;
    Condition hierarchyRoot = null;
    IntegerHash<FieldExpression> fieldExpressions = null;
    int unionCount = 0;
    boolean distinct = false;
    DatabaseCaps databaseCaps = null;

    public RootQueryNode(Query query) {
        super(query, null);
        this.scriptName = "result";
    }

    protected RootQueryNode(Query query, GenericQueryNode parentNode) {
        super(query, parentNode);
    }

    @Override
    public boolean canExclude(DatasourceUsage usage) {
        return false;
    }

    @Override
    protected void enumFromTablesThis(ArrayList<QueryNode> joins, ArrayList<QueryNode> nonjoins) {
    }

    @Override
    public void writeGetTableRecordsRefsContent(TaggedWriter out) throws InformException, IOException {
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            super.writeGetTableRecordsRefsContent(out);
        } else {
            this.throwNodeError("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
    }

    @Override
    public void generateAlias(StringBuilder sql, boolean rootExpr) throws InformException {
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            super.generateAlias(sql, false);
        } else {
            this.throwNodeError("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0432\u043e \u0444\u0440\u0430\u0437\u0435 FROM \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
    }

    public void generateOrderByField(StringBuilder sql, int fieldId) throws InformException {
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            this.generateFieldAlias(sql, fieldId, false);
        }
    }

    @Override
    public void generateFieldAlias(StringBuilder sql, int fieldId, boolean rootExpr) throws InformException {
        if (rootExpr && this.fieldExpressions != null) {
            FieldExpression e = this.fieldExpressions.get(fieldId);
            if (e == null || Strings.isVoid(e.sqlCache)) {
                super.generateFieldAlias(sql, fieldId, rootExpr);
            } else {
                sql.append(e.sqlCache);
            }
        } else {
            super.generateFieldAlias(sql, fieldId, rootExpr);
        }
    }

    @Override
    public void generateRaw(StringBuilder sql, IntegerSet fieldsUsage, SqlBuilder.GenerateParams generateParams) throws Exception {
        if (this.query.getQueryKind() == QueryKind.SIMPLE) {
            super.generateRaw(sql, fieldsUsage, generateParams);
        } else {
            this.throwNodeError("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u044e\u0449\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0432\u043e \u0444\u0440\u0430\u0437\u0435 FROM \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
    }

    @Override
    public void generateChildAlias(StringBuilder sql, String itemName) throws InformException {
        FieldDescriptor field = this.getFieldByName(itemName);
        if (field == null) {
            this.throwNodeError("\u041f\u043e\u043b\u0435 '" + itemName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
        } else {
            sql.append(field.getRawName());
        }
    }

    @Override
    public QueryNodeKind getKind() {
        return QueryNodeKind.ROOT;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void load(TaggedReader reader) throws IOException, InformException {
        this.distinct = false;
        super.load(reader);
    }

    protected final void loadFieldExpressions(TaggedReader in) throws IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    int fieldId = in.getInt();
                    FieldExpression fieldExpression = new FieldExpression(this.query, fieldId);
                    fieldExpression.load(in.getSubStreamReader());
                    this.fieldExpressions.add(fieldExpression);
                }
            }
        }
    }

    @Override
    protected void loadTag(int tag, TaggedReader in) throws InformException, IOException {
        switch (tag) {
            case 7: {
                break;
            }
            case 27: {
                this.where = new Condition(this.query, false);
                in.skip();
                this.where.load(in.getSubStreamReader());
                break;
            }
            case 28: {
                this.having = new Condition(this.query, true);
                in.skip();
                this.having.load(in.getSubStreamReader());
                break;
            }
            case 30: {
                this.fieldExpressions = new IntegerHash();
                in.skip();
                this.loadFieldExpressions(in.getSubStreamReader());
                break;
            }
            case 31: {
                this.distinct = true;
                break;
            }
            case 32: {
                this.hierarchy = new Condition(this.query, false);
                in.skip();
                this.hierarchy.load(in.getSubStreamReader());
                break;
            }
            case 33: {
                this.hierarchyRoot = new Condition(this.query, false);
                in.skip();
                this.hierarchyRoot.load(in.getSubStreamReader());
                break;
            }
            default: {
                super.loadTag(tag, in);
            }
        }
    }

    public Condition getWhere() {
        return this.where;
    }

    public Condition getHierarchy() {
        if (this.query.isHierarchical()) {
            return this.hierarchy;
        }
        return null;
    }

    public Condition getHierarchyRoot() {
        if (this.query.isHierarchical()) {
            return this.hierarchyRoot;
        }
        return null;
    }

    public FieldExpression getFieldExpression(int fieldId) {
        if (this.fieldExpressions == null) {
            return null;
        }
        return this.fieldExpressions.get(fieldId);
    }

    public void prepareExpressions() {
        if (this.fieldExpressions != null) {
            for (FieldExpression fe : this.fieldExpressions) {
                fe.afterLoad();
            }
        }
        if (this.where != null) {
            this.where.afterLoad();
        }
        if (this.having != null) {
            this.having.afterLoad();
        }
        if (this.query.isHierarchical()) {
            if (this.hierarchyRoot != null) {
                this.hierarchyRoot.afterLoad();
            }
            if (this.hierarchy != null) {
                this.hierarchy.afterLoad();
            }
        }
    }

    public void unionCreated() {
        ++this.unionCount;
    }

    public int getUnionCount() {
        return this.unionCount;
    }

    public UnionQueryNode firstUnion() {
        for (GenericQueryNode node : this.children) {
            if (!(node instanceof UnionQueryNode)) continue;
            return (UnionQueryNode)node;
        }
        return null;
    }

    public ArrayList<UnionQueryNode> getUnions() {
        ArrayList<UnionQueryNode> list = null;
        for (GenericQueryNode node : this.children) {
            if (!(node instanceof UnionQueryNode)) continue;
            if (list == null) {
                list = new ArrayList<UnionQueryNode>();
            }
            list.add((UnionQueryNode)node);
        }
        return list;
    }

    @SmartScriptableObject.PropertyTag
    public Condition getCondition() {
        UnionQueryNode union = this.firstUnion();
        if (union != null) {
            return union.getCondition();
        }
        return this.where;
    }

    @SmartScriptableObject.PropertyTag
    public Condition getHaving() {
        UnionQueryNode union = this.firstUnion();
        if (union != null) {
            return union.getHaving();
        }
        return this.having;
    }

    @SmartScriptableObject.FunctionTag
    public QueryNode createDatasource(double nodeId) throws IOException {
        UnionQueryNode union = this.firstUnion();
        if (union != null) {
            return union.createDatasource(nodeId);
        }
        BasicNode node = MtdEngine.getValidTranslatedNode(nodeId);
        switch (node.getType()) {
            case 12: {
                QueryNode tableNode = new QueryNode(this.query, this, nodeId);
                tableNode.afterLoad();
                return tableNode;
            }
            case 19: 
            case 49: {
                DataQueryNode queryNode = new DataQueryNode(this.query, this);
                queryNode.afterLoad();
                return queryNode;
            }
        }
        throw new IllegalStateException();
    }

    public void setParameterizedTable(double tableId) throws IOException {
        this.datasourceNodeId = tableId;
        this.determineNode();
    }

    public void createParameterizedTable() throws IOException {
        this.where = new Condition(this.query, false);
        for (Parameter p : this.query.getInputParameters().values()) {
            this.where.addTableParam(this.getEntryId(), p.getId(), p.getId());
        }
    }

    public Condition createParameterizedTableCondition() {
        this.where = new Condition(this.query, false);
        return this.where;
    }

    @Override
    public DatabaseCaps getDatabaseCaps() {
        if (this.databaseCaps == null) {
            if (this.query.overriderDatabaseID != 0.0) {
                DatabaseDescriptor databaseDescriptor = this.query.overriderDatabaseID == 2.0 ? DatabaseDescriptor.getMetabase() : ((DatabaseNode)MtdEngine.getValidNode(this.query.overriderDatabaseID)).getDescriptor();
                this.databaseCaps = databaseDescriptor.getDatabaseType().caps();
            } else {
                this.databaseCaps = super.getDatabaseCaps();
            }
        }
        return this.databaseCaps;
    }

    public DatabaseType getDatabaseType() {
        if (this.query.overriderDatabaseID != 0.0) {
            DatabaseDescriptor databaseDescriptor = this.query.overriderDatabaseID == 2.0 ? DatabaseDescriptor.getMetabase() : ((DatabaseNode)MtdEngine.getValidNode(this.query.overriderDatabaseID)).getDescriptor();
            return databaseDescriptor.getDatabaseType();
        }
        return this.metadata.getDatabaseType();
    }
}

