/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.expr.Term;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.cnd.QuerySubjectEvaluator;
import inform.agent.scripts.sql.expr.cnd.QueryValueEvaluator;

public class BraceEvaluator
extends QueryEvaluator {
    private final QueryEvaluator evaluator;

    public BraceEvaluator(Term term, QueryEvaluator evaluator) {
        super(term);
        this.evaluator = evaluator;
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        sql.append('(');
        this.evaluator.generate(sql, query);
        sql.append(')');
    }

    @Override
    public boolean hasNull() {
        return this.evaluator.hasNull();
    }

    @Override
    public boolean isMultipleValue() {
        return this.evaluator.isMultipleValue();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.evaluator.isStringType();
    }

    @Override
    public QueryValueEvaluator getValue() {
        if (this.isIgnored()) {
            return null;
        }
        return this.evaluator.getValue();
    }

    @Override
    public QuerySubjectEvaluator getSubject() {
        if (this.isIgnored()) {
            return null;
        }
        return this.evaluator.getSubject();
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
        if (this.isIgnored()) {
            return;
        }
        this.evaluator.getDatasourceUsage(usage);
    }

    @Override
    public boolean isAggregative() {
        if (this.isIgnored()) {
            return false;
        }
        return this.evaluator.isAggregative();
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.evaluator.isIgnored();
    }
}

