/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.cnd;

import inform.agent.expr.OperationTerm;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.BinaryOperation;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;

public class NopEvaluator
extends BinaryOperation {
    public NopEvaluator(OperationTerm term, QueryEvaluator left, QueryEvaluator right) {
        super(term, left, right);
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        if (this.left != null && !this.left.isIgnored()) {
            this.left.generate(sql, query);
        }
        if (this.right != null && !this.right.isIgnored()) {
            this.right.generate(sql, query);
        }
    }

    @Override
    public boolean isIgnored() {
        if (this.term.isIgnored()) {
            return true;
        }
        if (this.left == null && this.right == null) {
            return true;
        }
        if (this.left != null && this.left.isIgnored()) {
            return true;
        }
        return this.right != null && this.right.isIgnored();
    }

    @Override
    public void getDatasourceUsage(DatasourceUsage usage) {
        if (this.isIgnored()) {
            return;
        }
        if (this.left != null) {
            this.left.getDatasourceUsage(usage);
        }
        if (this.right != null) {
            this.right.getDatasourceUsage(usage);
        }
    }

    @Override
    public boolean isAggregative() {
        if (this.isIgnored()) {
            return false;
        }
        return this.left != null && this.left.isAggregative() || this.right != null && this.right.isAggregative();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.left != null && this.left.isStringType() || this.right != null && this.right.isStringType();
    }
}

